/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dbimport.ImportDatabaseTableEditorWrapper;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportTablePreview;
import com.intellij.database.dbimport.ui.ImportSettingsPanel;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImportPanel
extends JPanel {
    @NotNull
    private final CsvFormatsSelectionUI myFormats;
    @NotNull
    private final ImportTablePreview myPreview;
    @NotNull
    private final ImportDatabaseTableEditorWrapper myEditor;
    @NotNull
    private final ImportSettingsPanel myImportSettingsPanel;
    @NotNull
    private final String myFileName;
    private final boolean myTableExists;

    ImportPanel(@NotNull CsvFormatsSelectionUI formats, @NotNull ImportTablePreview preview, @NotNull ImportDatabaseTableEditorWrapper tableEditor, @NotNull DatabaseDialect dialect, @NotNull DatabaseSystem system, @NotNull String fileName, boolean tableExists) {
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        if (preview == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preview", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        if (tableEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableEditor", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/dbimport/ImportPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myFormats = formats;
        this.myFileName = fileName;
        this.myPreview = preview;
        this.myEditor = tableEditor;
        this.myTableExists = tableExists;
        this.myImportSettingsPanel = new ImportSettingsPanel(FileUtil.getNameWithoutExtension((String)fileName), dialect, system, tableExists);
        tableEditor.addEditorListener(this::onEditorChanged);
    }

    @NotNull
    ImportInfo getInfo() throws IOException {
        DataGrid grid = this.myPreview.getGrid();
        String errorFilePath = ImportPanel.sanitize(this.myImportSettingsPanel.getErrorOutputFilePath());
        ImportInfo importInfo = new ImportInfo((CsvFormat)ObjectUtils.assertNotNull((Object)this.myFormats.getSelectedFormat()), (DeTable)((DatabaseTableEditor)ObjectUtils.assertNotNull((Object)this.myEditor.getEditor())).getTableModel().getObject(), grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(grid.getVisibleColumns()), this.myFileName, errorFilePath, errorFilePath == null ? null : new FileWriter(errorFilePath), this.myImportSettingsPanel.getModalityState(), this.myTableExists);
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportPanel", "getInfo"));
        }
        return importInfo;
    }

    void onEditorChanged(@Nullable DatabaseTableEditor old, @NotNull DatabaseTableEditor newEditor) {
        if (newEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEditor", "com/intellij/database/dbimport/ImportPanel", "onEditorChanged"));
        }
        this.fillPanel(newEditor);
    }

    private void fillPanel(@NotNull DatabaseTableEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/ImportPanel", "fillPanel"));
        }
        this.removeAll();
        JPanel right = new JPanel(new BorderLayout());
        OnePixelSplitter splitter = new OnePixelSplitter(true);
        splitter.setFirstComponent(editor.getComponent());
        splitter.setSecondComponent(this.myPreview.getComponent());
        right.add((Component)splitter, "Center");
        right.add((Component)this.myImportSettingsPanel, "South");
        this.add((Component)this.myFormats.getComponent(), "West");
        this.add((Component)right, "Center");
    }

    @Nullable
    private static String sanitize(@Nullable String path) {
        if (path == null) {
            return null;
        }
        String parent = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        String extension = FileUtilRt.getExtension((String)fileName);
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)fileName);
        return parent + File.separator + FileUtil.sanitizeFileName((String)nameWithoutExtension) + (StringUtil.isEmpty((String)extension) ? "" : "." + FileUtil.sanitizeFileName((String)extension));
    }
}

