/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettings {
    private static final String IMPORT_MODALITY = "import_modality_state";
    private static final String ERROR_DIRECTORY = "import_error_directory";
    private static final String WRITE_ERRORS = "import_write_errors";

    public static void store(@NotNull ImportInfo info, @NotNull DatabaseDialect dialect, @Nullable String version) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportSettings", "store"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportSettings", "store"));
        }
        PropertiesComponent props = PropertiesComponent.getInstance();
        boolean existingTable = info.isInExistingTable();
        ImportManager manager = ImportManager.of(dialect, version);
        if (existingTable && manager.isSupportFastMode()) {
            props.setValue(IMPORT_MODALITY, String.valueOf(info.shouldLockTable()));
        }
        if (info.hasErrorPath()) {
            props.setValue(ERROR_DIRECTORY, ImportSettings.getErrorDirectory((String)ObjectUtils.assertNotNull((Object)info.getErrorFilePath())));
        }
        props.setValue(WRITE_ERRORS, info.hasErrorPath());
    }

    @NotNull
    private static String getErrorDirectory(@NotNull String errorPath) {
        if (errorPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPath", "com/intellij/database/dbimport/ImportSettings", "getErrorDirectory"));
        }
        Path path = Paths.get(errorPath, new String[0]);
        Path dir = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
        String string = dir == null ? SystemProperties.getUserHome() : dir.toAbsolutePath().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportSettings", "getErrorDirectory"));
        }
        return string;
    }

    public static boolean getImportModality() {
        return ImportSettings.get(IMPORT_MODALITY);
    }

    public static boolean getWriteErrors() {
        return ImportSettings.get(WRITE_ERRORS);
    }

    @Nullable
    public static String getErrorDirectory() {
        return PropertiesComponent.getInstance().getValue(ERROR_DIRECTORY);
    }

    private static boolean get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dbimport/ImportSettings", "get"));
        }
        return Boolean.valueOf(PropertiesComponent.getInstance().getValue(key));
    }
}

