/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.QueryWithParameters;
import com.intellij.database.dbimport.TypeConverter;
import com.intellij.database.dbimport.state.TransactionStateHolder;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PreparedQuery
extends QueryWithParameters {
    PreparedQuery(@NotNull List<String[]> parameters, @NotNull PreparedStatement preparedStatement, @NotNull DatabaseDialect dialect, @NotNull Consumer<String[]> errorConsumer, @NotNull DatabaseSystem system, @NotNull ImportInfo info, @NotNull TransactionStateHolder holder, double fraction) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/dbimport/PreparedQuery", "<init>"));
        }
        if (preparedStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preparedStatement", "com/intellij/database/dbimport/PreparedQuery", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/PreparedQuery", "<init>"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/intellij/database/dbimport/PreparedQuery", "<init>"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/PreparedQuery", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/PreparedQuery", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/database/dbimport/PreparedQuery", "<init>"));
        }
        super(parameters, preparedStatement, dialect, errorConsumer, system, info, holder, fraction);
    }

    @Override
    protected void statementCompleted(@NotNull Connection connection, @NotNull ProgressIndicator progressIndicator) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/PreparedQuery", "statementCompleted"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dbimport/PreparedQuery", "statementCompleted"));
        }
        this.myPreparedStatement.executeUpdate();
        this.myHolder.executed(connection);
    }

    @Override
    protected void onError(@NotNull Connection connection, @NotNull ProgressIndicator indicator, @NotNull Exception e) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/PreparedQuery", "onError"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/PreparedQuery", "onError"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dbimport/PreparedQuery", "onError"));
        }
        if (!(e instanceof TypeConverter.ConverterException)) {
            this.myHolder.onExecuteError(connection);
        }
        this.executeWithoutMultiLines(connection, indicator);
    }
}

