/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.diff.GridScrollingModel;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.TableResultRowHeader;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.CellAttributesKey;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.diff.DiffContext;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableDiffEditor
extends TableEditorBase {
    private final DiffTablePanel myDataGrid;
    private final GridScrollingModel myScrollingModel;

    public TableDiffEditor(@NotNull DiffContext context, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableDiffEditor", "<init>"));
        }
        if (hookUp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/diff/TableDiffEditor", "<init>"));
        }
        super(context.getProject());
        this.myDataGrid = new DiffTablePanel(this, context, hookUp);
        this.myScrollingModel = new GridScrollingModel(this.getDataGrid());
        Disposer.register((Disposable)this, (Disposable)this.myDataGrid);
    }

    @Override
    @NotNull
    public DiffTablePanel getDataGrid() {
        DiffTablePanel diffTablePanel = this.myDataGrid;
        if (diffTablePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor", "getDataGrid"));
        }
        return diffTablePanel;
    }

    @NotNull
    public GridScrollingModel getScrollingModel() {
        GridScrollingModel gridScrollingModel = this.myScrollingModel;
        if (gridScrollingModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor", "getScrollingModel"));
        }
        return gridScrollingModel;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myDataGrid.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor", "getName"));
        }
        return string;
    }

    private static int[] range(int a, int b) {
        assert (a < b);
        int[] res = new int[b - a];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = i2 + a;
        }
        return res;
    }

    public static class DiffTablePanel
    extends TableResultPanel {
        public static final Function<ModelIndex<?>, Integer> MI_AS_INT = Index::asInteger;
        private final FileEditor myEditor;
        private Alarm myAlarm;
        private final List<GridMarkupModel.Highlighting> myHighlightings;
        private TIntObjectHashMap<InclusionState> myRowsInclusion;
        private TIntObjectHashMap<InclusionState> myColumnsInclusion;
        private static final AnAction[] ROW_ACTIONS = new AnAction[]{new GenericControlAction("Include selected", true, null, InclusionState.ACTIVE), new GenericControlAction("Exclude selected", true, null, InclusionState.INACTIVE), new GenericControlAction("Remove selected", true, null, InclusionState.REMOVED)};
        private static final AnAction[] COL_ACTIONS = new AnAction[]{new GenericControlAction("Include selected", null, true, InclusionState.ACTIVE), new GenericControlAction("Exclude selected", null, true, InclusionState.INACTIVE), new GenericControlAction("Remove selected", null, true, InclusionState.REMOVED)};
        private static final AnAction[] CROSS_ACTIONS = new AnAction[]{new GenericControlAction("Include selected", true, true, InclusionState.ACTIVE), new GenericControlAction("Exclude unselected", false, false, InclusionState.INACTIVE), new GenericControlAction("Remove unselected", false, false, InclusionState.REMOVED)};

        public DiffTablePanel(@NotNull FileEditor editor, @NotNull DiffContext context, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "<init>"));
            }
            if (hookUp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookUp", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "<init>"));
            }
            super((Project)ObjectUtils.assertNotNull((Object)context.getProject()), hookUp, DiffTablePanel.createTableActionGroup(), DiffTablePanel.createGutterActionGroup(), DiffTablePanel.createHeaderActionGroup(), null, false);
            this.myHighlightings = ContainerUtil.createConcurrentList();
            this.myRowsInclusion = new TIntObjectHashMap();
            this.myColumnsInclusion = new TIntObjectHashMap();
            this.myAlarm = new Alarm((Disposable)this);
            this.getTable().getTableHeader().setDefaultRenderer(new TableResultView.MyCellRenderer(this.getTable()){

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.strikeColumn(g, this.getNameRect(), this.getModelIdx());
                }
            });
            this.getTable().getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (myAlarm.cancelAllRequests() != 0) {
                        this.getTable().tableChanged(null);
                    }
                }
            });
            this.getTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

                @Override
                public void columnMoved(TableColumnModelEvent e) {
                    if (e.getFromIndex() == e.getToIndex()) {
                        return;
                    }
                    myAlarm.cancelAllRequests();
                    myAlarm.addRequest(() -> this.getTable().tableChanged(null), 1000);
                }

                @Override
                public void columnAdded(TableColumnModelEvent e) {
                }

                @Override
                public void columnRemoved(TableColumnModelEvent e) {
                }

                @Override
                public void columnMarginChanged(ChangeEvent e) {
                }

                @Override
                public void columnSelectionChanged(ListSelectionEvent e) {
                }
            });
            this.myEditor = editor;
        }

        private static Condition<Integer> skip(int[] vals) {
            TIntHashSet skip = new TIntHashSet(vals);
            return integer -> !skip.contains(integer.intValue());
        }

        private JBIterable<Integer> selectedColumns(boolean inverse) {
            if (!inverse) {
                return JBIterable.from(this.getSelectionModel().getSelectedColumns().asIterable()).transform(MI_AS_INT);
            }
            return JBIterable.from(this.getVisibleColumns().asIterable()).transform(MI_AS_INT).filter(DiffTablePanel.skip(this.getSelectionModel().getSelectedColumns().asArray()));
        }

        private JBIterable<Integer> selectedRows(boolean inverse) {
            if (!inverse) {
                return JBIterable.from(this.getSelectionModel().getSelectedRows().asIterable()).transform(MI_AS_INT);
            }
            return JBIterable.from(this.getVisibleRows().asIterable()).transform(MI_AS_INT).filter(DiffTablePanel.skip(this.getSelectionModel().getSelectedRows().asArray()));
        }

        private static ActionGroup createTableActionGroup() {
            DefaultActionGroup row = new DefaultActionGroup("Rows", true);
            row.addAll(ROW_ACTIONS);
            DefaultActionGroup column = new DefaultActionGroup("Columns", true);
            column.addAll(COL_ACTIONS);
            DefaultActionGroup cell = new DefaultActionGroup("Cells", true);
            cell.addAll(CROSS_ACTIONS);
            return new DefaultActionGroup(new AnAction[]{DataGridUtil.getGridPopupActions(), row, column, cell});
        }

        private static ActionGroup createGutterActionGroup() {
            return new DefaultActionGroup(JBIterable.of((Object)DataGridUtil.getGridPopupActions()).append((Object[])ROW_ACTIONS).toList());
        }

        private static ActionGroup createHeaderActionGroup() {
            return new DefaultActionGroup(COL_ACTIONS);
        }

        public int getRowHeight(int row) {
            return this.getTable().getRowHeight(row);
        }

        public void clearHighlighting() {
            this.getMarkupModel().removeAllHighlightings(this.myHighlightings);
            this.myHighlightings.clear();
        }

        public void highlightRowsOrCols(TIntArrayList ids, CellAttributesKey cellAttributes, boolean row) {
            for (int i2 = 0; i2 < ids.size(); ++i2) {
                int idx = ids.get(i2);
                this.highlightRowOrCol(idx, idx + 1, cellAttributes, row);
            }
        }

        public void highlightRowOrCol(int begin, int end, CellAttributesKey cellAttributes, boolean row) {
            if (this.isTransposed() == row) {
                this.highlightColumns(begin, end, cellAttributes);
            } else {
                this.highlightRows(begin, end, cellAttributes);
            }
        }

        public void highlightRows(int begin, int end, CellAttributesKey cellAttributes) {
            if (end == begin && end == 0) {
                return;
            }
            int[] range = TableDiffEditor.range(begin - (begin == end ? 1 : 0), end);
            ModelIndexSet<DataConsumer.Row> rows = ViewIndexSet.forRows(this, range).toModel(this);
            this.myHighlightings.add(this.getMarkupModel().highlightCells(rows, this.getVisibleColumns(), cellAttributes, 1));
            this.myHighlightings.add(this.getMarkupModel().highlightRowHeaders(rows, cellAttributes, 1));
        }

        public void highlightColumns(int begin, int end, CellAttributesKey cellAttributes) {
            if (end == begin && end == 0) {
                return;
            }
            ModelIndexSet<DataConsumer.Row> rows = this.getVisibleRows();
            int[] range = TableDiffEditor.range(begin - (begin == end ? 1 : 0), end);
            ModelIndexSet<DataConsumer.Column> cols = ViewIndexSet.forColumns(this, range).toModel(this);
            this.myHighlightings.add(this.getMarkupModel().highlightCells(rows, cols, cellAttributes, 1));
            this.myHighlightings.add(this.getMarkupModel().highlightColumnHeaders(cols, cellAttributes, 1));
        }

        public void highlightCell(int row, int col, CellAttributesKey key) {
            ModelIndexSet<DataConsumer.Row> rows = ViewIndexSet.forRows(this, this.isTransposed() ? col : row).toModel(this);
            ModelIndexSet<DataConsumer.Column> cols = ViewIndexSet.forColumns(this, this.isTransposed() ? row : col).toModel(this);
            this.myHighlightings.add(this.getMarkupModel().highlightCells(rows, cols, key, 1));
        }

        @NotNull
        public JBIterable<ModelIndex<DataConsumer.Row>> getInactiveRows() {
            JBIterable jBIterable = JBIterable.from(this.getVisibleRows().asList()).filter(index -> DiffTablePanel.get(this.myRowsInclusion, index.asInteger()) == InclusionState.INACTIVE);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "getInactiveRows"));
            }
            return jBIterable;
        }

        @NotNull
        public JBIterable<ModelIndex<DataConsumer.Column>> getInactiveCols() {
            JBIterable jBIterable = JBIterable.from(this.getVisibleColumns().asList()).filter(index -> DiffTablePanel.get(this.myColumnsInclusion, index.asInteger()) == InclusionState.INACTIVE);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "getInactiveCols"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected GridRowHeader createRowHeader(ActionGroup gutterPopupActionGroup) {
            TableResultRowHeader tableResultRowHeader = new TableResultRowHeader(this, gutterPopupActionGroup){

                @Override
                @NotNull
                protected TableResultRowHeader.RowHeaderCellComponentBase createRegularRenderer() {
                    TableResultRowHeader.RowNumberRowHeaderCellComponent rowNumberRowHeaderCellComponent = new TableResultRowHeader.RowNumberRowHeaderCellComponent(){

                        @Override
                        protected void drawEffects(Graphics g, Rectangle r) {
                            this.strikeRow(g, r, ViewIndex.forRow(this, this.getRow()).toModel(this).asInteger());
                        }
                    };
                    if (rowNumberRowHeaderCellComponent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$4", "createRegularRenderer"));
                    }
                    return rowNumberRowHeaderCellComponent;
                }

                @Override
                @NotNull
                protected TableResultRowHeader.RowHeaderCellComponentBase createTransposedRenderer() {
                    TableResultRowHeader.ColumnInfoRowHeaderCellComponent columnInfoRowHeaderCellComponent = new TableResultRowHeader.ColumnInfoRowHeaderCellComponent(){

                        @Override
                        protected void drawEffects(Graphics g, Rectangle r) {
                            this.strikeRow(g, r, ViewIndex.forColumn(this, this.getRow()).toModel(this).asInteger());
                        }
                    };
                    if (columnInfoRowHeaderCellComponent == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$4", "createTransposedRenderer"));
                    }
                    return columnInfoRowHeaderCellComponent;
                }
            };
            if (tableResultRowHeader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "createRowHeader"));
            }
            return tableResultRowHeader;
        }

        protected void strikeRow(Graphics g, Rectangle r, int row) {
            InclusionState state = DiffTablePanel.get(this.isTransposed() ? this.myColumnsInclusion : this.myRowsInclusion, row);
            if (state == InclusionState.INACTIVE) {
                this.strikeText(g, r);
            }
        }

        protected void strikeColumn(Graphics g, Rectangle r, int col) {
            InclusionState state = DiffTablePanel.get(!this.isTransposed() ? this.myColumnsInclusion : this.myRowsInclusion, col);
            if (state == InclusionState.INACTIVE) {
                this.strikeText(g, r);
            }
        }

        protected void strikeText(Graphics g, Rectangle r) {
            int y = r.y + r.height / 2;
            g.drawLine(r.x, y, r.x + r.width, y);
        }

        @Override
        @NotNull
        protected RowFilter<TableModel, Integer> createFilter() {
            final RowFilter<TableModel, Integer> filter = super.createFilter();
            if (this.isTransposed()) {
                RowFilter<TableModel, Integer> rowFilter = filter;
                if (rowFilter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "createFilter"));
                }
                return rowFilter;
            }
            RowFilter<TableModel, Integer> rowFilter = new RowFilter<TableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                    if (!filter.include(entry)) {
                        return false;
                    }
                    return DiffTablePanel.get((TIntObjectHashMap<InclusionState>)myRowsInclusion, entry.getIdentifier()) != InclusionState.REMOVED;
                }
            };
            if (rowFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "createFilter"));
            }
            return rowFilter;
        }

        @Override
        protected boolean isHeaderSelecting() {
            return true;
        }

        @Override
        protected boolean allowHeaderActionsInTransposeMode() {
            return true;
        }

        public void setState(int idx, boolean row, InclusionState state) {
            DiffTablePanel.set(row ? this.myRowsInclusion : this.myColumnsInclusion, idx, state);
            if (!row) {
                this.updateColumnState(idx, state);
            } else if (!this.isTransposed()) {
                this.searchSessionUpdated();
            } else {
                this.updateRowState(idx, state);
            }
        }

        public void updateStates() {
            int i2;
            GridModel<DataConsumer.Row, DataConsumer.Column> model = this.getDataModel(DataAccessType.DATABASE_DATA);
            for (i2 = 0; i2 < model.getRowCount(); ++i2) {
                this.updateRowState(i2, DiffTablePanel.get(this.myRowsInclusion, i2));
            }
            for (i2 = 0; i2 < model.getColumnCount(); ++i2) {
                this.updateColumnState(i2, DiffTablePanel.get(this.myColumnsInclusion, i2));
            }
            if (!this.isTransposed()) {
                this.searchSessionUpdated();
            }
        }

        private void updateColumnState(int idx, InclusionState state) {
            ModelIndex<DataConsumer.Column> index = ModelIndex.forColumn(this, idx);
            boolean shouldBeEnabled = state != InclusionState.REMOVED;
            boolean enabled = this.isColumnEnabled(index);
            if (enabled == shouldBeEnabled) {
                return;
            }
            this.setColumnEnabled(index, shouldBeEnabled);
        }

        private void updateRowState(int idx, InclusionState state) {
            if (this.isTransposed()) {
                ViewIndex<DataConsumer.Row> index = ModelIndex.forRow(this, idx).toView(this);
                boolean shouldBeEnabled = state != InclusionState.REMOVED;
                boolean enabled = index.isValid(this);
                if (enabled == shouldBeEnabled) {
                    return;
                }
                this.setColumnEnabled(idx, shouldBeEnabled);
            }
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public boolean isCellEditingAllowed() {
            return false;
        }

        @NotNull
        public Point getCellPosition(int row, int column) {
            boolean rowLess = row < this.getTable().getRowCount();
            boolean columnLess = column < this.getTable().getColumnCount();
            row = Math.min(Math.max(row, 0), this.getTable().getRowCount() - 1);
            column = Math.min(Math.max(column, 0), this.getTable().getColumnCount() - 1);
            Rectangle cellRect = this.getTable().getCellRect(row, column, true);
            Point point = new Point((int)(columnLess ? cellRect.getMinX() : cellRect.getMaxX()), (int)(rowLess ? cellRect.getMinY() : cellRect.getMaxY()));
            if (point == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "getCellPosition"));
            }
            return point;
        }

        public int getRowAtPosition(@NotNull Point position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "getRowAtPosition"));
            }
            return this.getTable().rowAtPoint(position);
        }

        public int getColumnAtPosition(@NotNull Point position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel", "getColumnAtPosition"));
            }
            return this.getTable().columnAtPoint(position);
        }

        public int getHeaderOffset() {
            return this.getTable().getTableHeader().getHeight();
        }

        @Override
        protected Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
                return this.myEditor;
            }
            return super.getData(dataId);
        }

        private static InclusionState get(TIntObjectHashMap<InclusionState> states, int num) {
            return states.contains(num) ? (InclusionState)((Object)states.get(num)) : InclusionState.ACTIVE;
        }

        private static void set(TIntObjectHashMap<InclusionState> states, int num, InclusionState state) {
            if (state == InclusionState.ACTIVE) {
                states.remove(num);
            } else {
                states.put(num, (Object)state);
            }
        }

        private static class GenericControlAction
        extends AnAction {
            private final Boolean myRowDir;
            private final Boolean myColDir;
            private final InclusionState myState;

            public GenericControlAction(@NotNull String name, @Nullable Boolean rowDir, @Nullable Boolean colDir, @NotNull InclusionState state) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction", "<init>"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction", "<init>"));
                }
                super(name, "", state.toIcon());
                this.myRowDir = rowDir;
                this.myColDir = colDir;
                this.myState = state;
            }

            public void update(AnActionEvent e) {
                boolean enabled = false;
                DiffTablePanel panel = (DiffTablePanel)ObjectUtils.tryCast((Object)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext()), DiffTablePanel.class);
                if (panel != null) {
                    for (Integer row : this.getSelectedRows(panel)) {
                        if (enabled) break;
                        enabled = DiffTablePanel.get((TIntObjectHashMap<InclusionState>)panel.myRowsInclusion, row) != this.myState;
                    }
                    for (Integer col : this.getSelectedColumns(panel)) {
                        if (enabled) break;
                        enabled = DiffTablePanel.get((TIntObjectHashMap<InclusionState>)panel.myColumnsInclusion, col) != this.myState;
                    }
                }
                e.getPresentation().setEnabledAndVisible(enabled);
            }

            private Iterable<Integer> getSelected(@NotNull DiffTablePanel panel, boolean row) {
                Boolean colDir;
                if (panel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction", "getSelected"));
                }
                Boolean rowDir = panel.isTransposed() ? this.myColDir : this.myRowDir;
                Boolean bl = colDir = !panel.isTransposed() ? this.myColDir : this.myRowDir;
                if (row && rowDir != null) {
                    return panel.selectedRows(rowDir == false);
                }
                if (!row && colDir != null) {
                    return panel.selectedColumns(colDir == false);
                }
                return JBIterable.empty();
            }

            private Iterable<Integer> getSelectedColumns(@NotNull DiffTablePanel panel) {
                if (panel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction", "getSelectedColumns"));
                }
                return this.getSelected(panel, false);
            }

            private Iterable<Integer> getSelectedRows(@NotNull DiffTablePanel panel) {
                if (panel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/diff/TableDiffEditor$DiffTablePanel$GenericControlAction", "getSelectedRows"));
                }
                return this.getSelected(panel, true);
            }

            public void actionPerformed(AnActionEvent e) {
                DiffTablePanel panel = (DiffTablePanel)ObjectUtils.tryCast((Object)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext()), DiffTablePanel.class);
                if (panel == null) {
                    return;
                }
                for (int idx : this.getSelectedColumns(panel)) {
                    panel.setState(idx, false, this.myState);
                }
                for (int idx : this.getSelectedRows(panel)) {
                    panel.setState(idx, true, this.myState);
                }
                panel.getTable().tableChanged(null);
            }
        }

        private static enum InclusionState {
            ACTIVE,
            INACTIVE,
            REMOVED;


            Icon toIcon() {
                if (this == ACTIVE) {
                    return AllIcons.General.Add;
                }
                if (this == INACTIVE) {
                    return AllIcons.Actions.Exclude;
                }
                return AllIcons.Actions.Delete;
            }
        }
    }
}

