/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.DumpArgumentGroup;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpComponent;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.LexemeIndicators;
import com.intellij.database.dump.dbdump.argument.DumpArgument;
import com.intellij.database.dump.dbdump.lexer.DumpToolHelpLexerAdapter;
import com.intellij.database.dump.dbdump.lexer.HelpTokenType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDumpUtil {
    private DbDumpUtil() {
    }

    @NotNull
    public static String cutParameter(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "cutParameter"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/DbDumpUtil", "cutParameter"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/DbDumpUtil", "cutParameter"));
        }
        String string = StringUtil.trim((String)text.substring(current.getEnd(), next.getStart()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "cutParameter"));
        }
        return string;
    }

    @NotNull
    public static List<DumpCommandLineLexeme> filteredLexemes(@NotNull String text, @NotNull DumpConfiguration configuration, @NotNull List<String> parameterizable) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "filteredLexemes"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DbDumpUtil", "filteredLexemes"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/dump/dbdump/DbDumpUtil", "filteredLexemes"));
        }
        List<DumpCommandLineLexeme> list = DbDumpUtil.filterLexemes(DbDumpUtil.rawLexemes(text), configuration, parameterizable);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "filteredLexemes"));
        }
        return list;
    }

    @NotNull
    public static List<Pair<DumpCommandLineLexeme, DumpCommandLineLexeme>> lexemePairs(@NotNull DumpContextDescriptor state, @NotNull List<DumpCommandLineLexeme> lexemes, @NotNull String text, @NotNull DumpComponent component) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemePairs"));
        }
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemePairs"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemePairs"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemePairs"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            DumpCommandLineLexeme next;
            DumpCommandLineLexeme current = lexemes.get(i2);
            DumpCommandLineLexeme dumpCommandLineLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbDumpUtil.getLastCharacterLexeme(text);
            if (!component.isMyLexeme(text, current, next, state)) continue;
            result.add(Pair.create((Object)current, (Object)next));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemePairs"));
        }
        return arrayList;
    }

    @NotNull
    public static String clearString(@NotNull String s, @NotNull Function<String, String> unquoter) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dump/dbdump/DbDumpUtil", "clearString"));
        }
        if (unquoter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquoter", "com/intellij/database/dump/dbdump/DbDumpUtil", "clearString"));
        }
        String string = DbDumpUtil.unescapeAll(unquoter.apply(s));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "clearString"));
        }
        return string;
    }

    @NotNull
    public static List<String> getCommandLineArguments(@NotNull DumpConfiguration configuration, @NotNull String command, @NotNull List<String> parameterizable) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DbDumpUtil", "getCommandLineArguments"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DbDumpUtil", "getCommandLineArguments"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/dump/dbdump/DbDumpUtil", "getCommandLineArguments"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.filteredLexemes(command, configuration, parameterizable);
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            DumpCommandLineLexeme next;
            DumpCommandLineLexeme current = lexemes.get(i2);
            DumpCommandLineLexeme dumpCommandLineLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbDumpUtil.getLastCharacterLexeme(command);
            if (current.isBad()) continue;
            result.add(DbDumpUtil.getArgument(command, current, next, configuration, parameterizable));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "getCommandLineArguments"));
        }
        return arrayList;
    }

    @NotNull
    public static Condition<? super DumpCommandLineLexeme> lexemeFinder(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemeFinder"));
        }
        Condition condition = lexeme -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$lexemeFinder$0"));
            }
            return StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)text);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemeFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<DumpArgument> argumentFinder(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "argumentFinder"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/DbDumpUtil", "argumentFinder"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/DbDumpUtil", "argumentFinder"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/DbDumpUtil", "argumentFinder"));
        }
        Condition condition = argument -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$argumentFinder$1"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$argumentFinder$1"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$argumentFinder$1"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$argumentFinder$1"));
            }
            return argument.isMyLexeme(text, current, next, cd);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "argumentFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<? super DumpCommandLineLexeme> lexemeWithParameterFinder(@NotNull List<DumpCommandLineLexeme> rawLexemes, @NotNull LexemeIndicators indicators) {
        if (rawLexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawLexemes", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemeWithParameterFinder"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemeWithParameterFinder"));
        }
        Condition condition = lexeme -> {
            if (indicators == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$lexemeWithParameterFinder$2"));
            }
            if (rawLexemes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawLexemes", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$lexemeWithParameterFinder$2"));
            }
            if (!lexeme.isArgument()) {
                return false;
            }
            String found = (String)ContainerUtil.find((Object[])indicators.getArgs(), DbDumpUtil.stringFinder(lexeme));
            if (found == null) {
                return false;
            }
            int index = ContainerUtil.indexOf((List)rawLexemes, (Object)lexeme);
            return index != -1 && index < rawLexemes.size() - 1 && DbDumpUtil.isIndicator(indicators, rawLexemes, index + 1);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemeWithParameterFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<? super DumpCommandLineLexeme> lexemeFinder(@NotNull String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemeFinder"));
        }
        Condition condition = lexeme -> {
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$lexemeFinder$3"));
            }
            return ContainerUtil.find((Object[])args, DbDumpUtil.stringFinder(lexeme)) != null;
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexemeFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<String> stringFinder(@NotNull DumpCommandLineLexeme lexeme) {
        if (lexeme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/dump/dbdump/DbDumpUtil", "stringFinder"));
        }
        Condition condition = s -> {
            if (lexeme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$stringFinder$4"));
            }
            return StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)s);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "stringFinder"));
        }
        return condition;
    }

    @NotNull
    public static List<String> fromElementsToSeparated(@NotNull Collection<DbElement> elements, @NotNull Condition<DbElement> condition) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DbDumpUtil", "fromElementsToSeparated"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/dump/dbdump/DbDumpUtil", "fromElementsToSeparated"));
        }
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(elements, condition), DasObject::getName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "fromElementsToSeparated"));
        }
        return list;
    }

    @NotNull
    public static List<String> getTablesNames(@NotNull Collection<DbElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DbDumpUtil", "getTablesNames"));
        }
        List list = JBIterable.from(elements).filter(DasUtil.byClass(DbTable.class)).map(element -> (DbTable)element).map(DbDumpUtil::getTableName).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "getTablesNames"));
        }
        return list;
    }

    private static String getTableName(@NotNull DbTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dump/dbdump/DbDumpUtil", "getTableName"));
        }
        DasObject parent = DasUtil.getParentOfKind((DasObject)table, (ObjectKind)ObjectKind.SCHEMA, (boolean)true);
        String parentName = parent == null ? "" : DbDumpUtil.quote(parent.getName()) + ".";
        return parentName + DbDumpUtil.quote(table.getName());
    }

    @NotNull
    public static List<DumpCommandLineLexeme> extractArguments(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "extractArguments"));
        }
        List<DumpCommandLineLexeme> list = DbDumpUtil.getLexemes(text, DbDumpUtil::index);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "extractArguments"));
        }
        return list;
    }

    @NotNull
    public static List<DumpCommandLineLexeme> rawLexemes(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "rawLexemes"));
        }
        List<DumpCommandLineLexeme> list = DbDumpUtil.getLexemes(text, (lexemes, lexer) -> lexemes.add(DbDumpUtil.lexeme(lexer)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "rawLexemes"));
        }
        return list;
    }

    @NotNull
    public static String prepareArgument(@NotNull DumpComponent component, @NotNull DumpContextDescriptor state) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DbDumpUtil", "prepareArgument"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dump/dbdump/DbDumpUtil", "prepareArgument"));
        }
        String string = DbDumpUtil.prepareArgument(component, state, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "prepareArgument"));
        }
        return string;
    }

    @NotNull
    public static String prepareArgument(@NotNull DumpComponent component, @NotNull DumpContextDescriptor state, boolean spaceAfter) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/dump/dbdump/DbDumpUtil", "prepareArgument"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dump/dbdump/DbDumpUtil", "prepareArgument"));
        }
        String result = " " + component.getFullArgument(state) + " ";
        String string = spaceAfter ? StringUtil.trimLeading((String)result) : StringUtil.trimTrailing((String)result);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "prepareArgument"));
        }
        return string;
    }

    @NotNull
    public static <T extends DumpArgument> List<DumpComponent> createComponents(@NotNull DumpArgumentGroup<T> group2, @NotNull Function<T, DumpComponent> constructor) {
        if (group2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/dump/dbdump/DbDumpUtil", "createComponents"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/database/dump/dbdump/DbDumpUtil", "createComponents"));
        }
        List<DumpComponent> list = Arrays.stream(group2.getArguments()).map(constructor).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "createComponents"));
        }
        return list;
    }

    @NotNull
    public static String extractParameterizable(String ... args) {
        String string = DbDumpUtil.extract((Condition<String>)((Condition)s -> StringUtil.endsWith((CharSequence)s, (CharSequence)"=")), args);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "extractParameterizable"));
        }
        return string;
    }

    @NotNull
    public static String extractNonParameterizable(String ... args) {
        String string = DbDumpUtil.extract((Condition<String>)((Condition)s -> !StringUtil.endsWith((CharSequence)s, (CharSequence)"=")), args);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "extractNonParameterizable"));
        }
        return string;
    }

    @NotNull
    private static String extract(@NotNull Condition<String> condition, String ... args) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/dump/dbdump/DbDumpUtil", "extract"));
        }
        if (args == null || args.length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "extract"));
            }
            return "";
        }
        String element = (String)ContainerUtil.find((Object[])args, condition);
        String string = (String)ObjectUtils.assertNotNull((Object)(element == null ? (String)ArrayUtil.getFirstElement((Object[])args) : element));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "extract"));
        }
        return string;
    }

    @NotNull
    public static String pgQuote(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dump/dbdump/DbDumpUtil", "pgQuote"));
        }
        String string = "'" + DbDumpUtil.quote(s) + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "pgQuote"));
        }
        return string;
    }

    @NotNull
    public static String quote(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dump/dbdump/DbDumpUtil", "quote"));
        }
        if (!DbDumpUtil.containsNonAlphaCharacters(s)) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "quote"));
            }
            return string;
        }
        String string = StringUtil.wrapWithDoubleQuote((String)DbDumpUtil.escapeAllQuotes(s));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "quote"));
        }
        return string;
    }

    @NotNull
    public static String unescapeAll(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dump/dbdump/DbDumpUtil", "unescapeAll"));
        }
        String string = StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)s, (char)'\"'), (char)'\''), (char)'\\');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "unescapeAll"));
        }
        return string;
    }

    @NotNull
    public static String fromListToArgument(@NotNull List<String> strings, @NotNull String prefix, @NotNull Function<String, String> processor) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/dump/dbdump/DbDumpUtil", "fromListToArgument"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/dump/dbdump/DbDumpUtil", "fromListToArgument"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dump/dbdump/DbDumpUtil", "fromListToArgument"));
        }
        String string = StringUtil.join((Collection)ContainerUtil.map(strings, s -> {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$fromListToArgument$9"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/dump/dbdump/DbDumpUtil", "lambda$fromListToArgument$9"));
            }
            return prefix + (String)processor.apply((String)s);
        }), (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "fromListToArgument"));
        }
        return string;
    }

    @Nullable
    public static String getArgumentValue(@NotNull String command, @NotNull DumpConfiguration configuration, @NotNull List<String> parameterizable, @NotNull String[] args) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentValue"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentValue"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentValue"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentValue"));
        }
        List<DumpCommandLineLexeme> lexemes = DbDumpUtil.filteredLexemes(command, configuration, parameterizable);
        int index = ContainerUtil.lastIndexOf(lexemes, DbDumpUtil.lexemeFinder(args));
        if (index == -1) {
            return null;
        }
        DumpCommandLineLexeme current = lexemes.get(index);
        DumpCommandLineLexeme next = index == lexemes.size() - 1 ? DbDumpUtil.getLastCharacterLexeme(command) : lexemes.get(index + 1);
        return DbDumpUtil.cutParameter(command, current, next);
    }

    @NotNull
    public static String[] withEquality(String ... strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/dump/dbdump/DbDumpUtil", "withEquality"));
        }
        String[] result = new String[strings.length + 1];
        System.arraycopy(strings, 0, result, 0, strings.length);
        String longArg = (String)ContainerUtil.find((Object[])strings, s -> StringUtil.startsWith((CharSequence)s, (CharSequence)"--"));
        result[result.length - 1] = longArg + "=";
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "withEquality"));
        }
        return result;
    }

    @NotNull
    static DumpCommandLineLexeme getLastCharacterLexeme(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "getLastCharacterLexeme"));
        }
        DumpCommandLineLexeme dumpCommandLineLexeme = new DumpCommandLineLexeme("", HelpTokenType.BAD, text.length(), text.length());
        if (dumpCommandLineLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "getLastCharacterLexeme"));
        }
        return dumpCommandLineLexeme;
    }

    @NotNull
    private static String getArgument(@NotNull String command, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpConfiguration configuration, @NotNull List<String> parameterizable) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgument"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgument"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgument"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgument"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgument"));
        }
        String string = DbDumpUtil.isParameterizable(current, configuration, parameterizable) ? DbDumpUtil.getArgumentWithParameter(command, current, next, configuration) : DbDumpUtil.unescapeAll(StringUtil.unquoteString((String)current.getText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgument"));
        }
        return string;
    }

    @NotNull
    private static String getArgumentWithParameter(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpConfiguration configuration) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentWithParameter"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentWithParameter"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentWithParameter"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentWithParameter"));
        }
        String parameter = DbDumpUtil.cutParameter(text, current, next);
        boolean needEquality = current.getType() == HelpTokenType.LONG_PARAMETER && !current.getText().endsWith("=");
        String string = current.getText() + (needEquality && !StringUtil.isEmpty((String)DbDumpUtil.unescapeAll(StringUtil.unquoteString((String)parameter))) ? "=" : "") + configuration.processParameter(current, parameter);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "getArgumentWithParameter"));
        }
        return string;
    }

    @NotNull
    private static String escapeAllQuotes(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dump/dbdump/DbDumpUtil", "escapeAllQuotes"));
        }
        String string = StringUtil.escapeChars((String)s, (char[])new char[]{'\\', '\"', '\''});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "escapeAllQuotes"));
        }
        return string;
    }

    private static boolean isIndicator(@NotNull LexemeIndicators indicators, @NotNull List<DumpCommandLineLexeme> lexemes, int nextIndex) {
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/dump/dbdump/DbDumpUtil", "isIndicator"));
        }
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DbDumpUtil", "isIndicator"));
        }
        if (!indicators.hasParameter()) {
            return true;
        }
        DumpCommandLineLexeme lexeme = lexemes.get(nextIndex);
        return lexeme.getType() == HelpTokenType.VALUE;
    }

    private static void index(@NotNull Collection<DumpCommandLineLexeme> lexemes, @NotNull Lexer lexer) {
        IElementType type;
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DbDumpUtil", "index"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/dump/dbdump/DbDumpUtil", "index"));
        }
        List toSkip = ContainerUtil.list((Object[])new IElementType[]{HelpTokenType.BAD, HelpTokenType.VALUE});
        if (ContainerUtil.containsIdentity((Iterable)toSkip, (Object)(type = (IElementType)ObjectUtils.assertNotNull((Object)lexer.getTokenType())))) {
            return;
        }
        lexemes.add(DbDumpUtil.lexeme(lexer));
    }

    @NotNull
    private static DumpCommandLineLexeme lexeme(@NotNull Lexer lexer) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexeme"));
        }
        DumpCommandLineLexeme dumpCommandLineLexeme = new DumpCommandLineLexeme(lexer.getTokenText(), (IElementType)ObjectUtils.assertNotNull((Object)lexer.getTokenType()), lexer.getTokenStart(), lexer.getTokenEnd());
        if (dumpCommandLineLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "lexeme"));
        }
        return dumpCommandLineLexeme;
    }

    private static boolean containsNonAlphaCharacters(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dump/dbdump/DbDumpUtil", "containsNonAlphaCharacters"));
        }
        for (int i2 = 0; i2 < value.length(); ++i2) {
            if (Character.isLetter(value.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<DumpCommandLineLexeme> getLexemes(@NotNull String text, @NotNull BiConsumer<List<DumpCommandLineLexeme>, Lexer> consumer) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/DbDumpUtil", "getLexemes"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dump/dbdump/DbDumpUtil", "getLexemes"));
        }
        ArrayList lexemes = ContainerUtil.newArrayList();
        DumpToolHelpLexerAdapter lexer = new DumpToolHelpLexerAdapter();
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            consumer.accept(lexemes, (Lexer)lexer);
            lexer.advance();
        }
        List list = ContainerUtil.sorted((Collection)lexemes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "getLexemes"));
        }
        return list;
    }

    @NotNull
    private static List<DumpCommandLineLexeme> filterLexemes(@NotNull List<DumpCommandLineLexeme> lexemes, @NotNull DumpConfiguration configuration, @NotNull List<String> parameterizable) {
        Pair<DumpCommandLineLexeme, Integer> lexemeOffset;
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/dump/dbdump/DbDumpUtil", "filterLexemes"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DbDumpUtil", "filterLexemes"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/dump/dbdump/DbDumpUtil", "filterLexemes"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < lexemes.size(); i2 += (Integer)lexemeOffset.getSecond() + 1) {
            lexemeOffset = DbDumpUtil.getCurrentLexemeWithOffset(lexemes, i2);
            DumpCommandLineLexeme current = (DumpCommandLineLexeme)lexemeOffset.getFirst();
            DumpCommandLineLexeme previous = i2 == 0 ? new DumpCommandLineLexeme("", HelpTokenType.BAD, 0, 0) : lexemes.get(i2 - 1);
            boolean isPrevParameterizable = DbDumpUtil.isParameterizable(previous, configuration, parameterizable);
            if (!current.isArgument() && isPrevParameterizable) continue;
            result.add(current);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "filterLexemes"));
        }
        return arrayList;
    }

    @NotNull
    private static Pair<DumpCommandLineLexeme, Integer> getCurrentLexemeWithOffset(List<DumpCommandLineLexeme> lexemes, int index) {
        int offset = 0;
        while (index < lexemes.size() - 1 && lexemes.get(index).isWhitespace()) {
            ++index;
            ++offset;
        }
        Pair pair = Pair.create((Object)lexemes.get(index), (Object)offset);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DbDumpUtil", "getCurrentLexemeWithOffset"));
        }
        return pair;
    }

    private static boolean isParameterizable(@NotNull DumpCommandLineLexeme lexeme, @NotNull DumpConfiguration configuration, @NotNull List<String> parameterizable) {
        if (lexeme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/dump/dbdump/DbDumpUtil", "isParameterizable"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DbDumpUtil", "isParameterizable"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/dump/dbdump/DbDumpUtil", "isParameterizable"));
        }
        return ContainerUtil.indexOf(configuration.getParameterizableArguments(), (Object)lexeme.getText()) != -1 || lexeme.isArgument() && (lexeme.getText().endsWith("=") || ContainerUtil.indexOf(parameterizable, (Object)lexeme.getText()) != -1);
    }
}

