/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.argument.DumpArgument;
import com.intellij.database.psi.DbElement;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpComponent {
    private final List<Consumer<DumpComponent>> myListeners = ContainerUtil.newArrayList();

    protected DumpComponent() {
    }

    public final void addListener(@NotNull Consumer<DumpComponent> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dump/dbdump/DumpComponent", "addListener"));
        }
        this.myListeners.add(listener);
    }

    protected final void fireComponentChanged() {
        this.myListeners.forEach(consumer -> consumer.consume((Object)this));
    }

    @NotNull
    public abstract String getFullArgument(@NotNull DumpContextDescriptor var1);

    @NotNull
    public abstract DumpArgument getArgument();

    @NotNull
    public abstract JComponent getComponent();

    @Nullable
    public abstract String getLabel();

    @NotNull
    public abstract String getName();

    public abstract boolean isMyLexeme(@NotNull String var1, @NotNull DumpCommandLineLexeme var2, @NotNull DumpCommandLineLexeme var3, @NotNull DumpContextDescriptor var4);

    public abstract void changeState(@NotNull String var1, @NotNull DumpCommandLineLexeme var2, @NotNull DumpCommandLineLexeme var3, @NotNull DumpContextDescriptor var4);

    public abstract void reset(@NotNull DumpContextDescriptor var1);

    public void configure(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/DumpComponent", "configure"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/DumpComponent", "configure"));
        }
    }

    public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/DumpComponent", "isAppendInTheEnd"));
        }
        return false;
    }
}

