/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.WeighedFileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvTableFileEditorProvider
extends WeighedFileEditorProvider {
    private static final String PROVIDER_ID = "csv-data-editor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/CsvTableFileEditorProvider", "accept"));
        }
        return this.getFormat(project, file) != null;
    }

    @NotNull
    public CsvTableFileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/CsvTableFileEditorProvider", "createEditor"));
        }
        CsvTableFileEditor csvTableFileEditor = new CsvTableFileEditor(project, file, (CsvFormat)ObjectUtils.assertNotNull((Object)this.getFormat(project, file)));
        if (csvTableFileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/CsvTableFileEditorProvider", "createEditor"));
        }
        return csvTableFileEditor;
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/database/editor/CsvTableFileEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/CsvTableFileEditorProvider", "readState"));
        }
        FileEditorState state = null;
        try {
            state = (FileEditorState)XmlSerializer.deserialize((Element)sourceElement, CsvTableFileEditor.State.class);
        }
        catch (XmlSerializationException xmlSerializationException) {
            // empty catch block
        }
        FileEditorState fileEditorState = (FileEditorState)ObjectUtils.notNull((Object)state, (Object)FileEditorState.INSTANCE);
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/CsvTableFileEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/editor/CsvTableFileEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/database/editor/CsvTableFileEditorProvider", "writeState"));
        }
        if (state instanceof CsvTableFileEditor.State) {
            XmlSerializer.serializeInto((Object)state, (Element)targetElement, (SerializationFilter)new SkipDefaultsSerializationFilter());
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (PROVIDER_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/CsvTableFileEditorProvider", "getEditorTypeId"));
        }
        return PROVIDER_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/CsvTableFileEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }

    @Nullable
    private CsvFormat getFormat(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditorProvider", "getFormat"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/CsvTableFileEditorProvider", "getFormat"));
        }
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance((Project)project);
        return editorHistoryManager != null ? CsvTableFileEditor.readCsvFormat(editorHistoryManager.getState(file, (FileEditorProvider)this)) : null;
    }

    public static void openEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull CsvFormat format) {
        EditorWithProviderComposite composite;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/CsvTableFileEditorProvider", "openEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/CsvTableFileEditorProvider", "openEditor"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/editor/CsvTableFileEditorProvider", "openEditor"));
        }
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        EditorWindow editorWindow = fileEditorManagerEx.getSplitters().getCurrentWindow();
        EditorWithProviderComposite editorWithProviderComposite = composite = editorWindow == null ? null : editorWindow.findFileComposite(file);
        if (composite != null) {
            CsvTableFileEditor tableEditor = (CsvTableFileEditor)((Object)ContainerUtil.findInstance((Object[])composite.getEditors(), CsvTableFileEditor.class));
            if (tableEditor != null) {
                tableEditor.setFormat(format);
            } else {
                FileEditorProvider provider = FileEditorProviderManager.getInstance().getProvider(PROVIDER_ID);
                composite.addEditor((FileEditor)new CsvTableFileEditor(project, file, format), provider);
            }
            fileEditorManagerEx.setSelectedEditor(file, PROVIDER_ID);
        }
    }
}

