/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.google.common.collect.Iterables;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnUpdateData;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseOpenFileDescriptor
extends OpenFileDescriptor {
    private final String[] myColumnNames;
    private final Object[] myValues;
    private final boolean mySelectedOnly;
    private final String myDescription;

    public DatabaseOpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, int offset) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "<init>"));
        }
        super(project, file, offset);
        this.myColumnNames = null;
        this.myValues = null;
        this.mySelectedOnly = false;
        this.myDescription = null;
    }

    public DatabaseOpenFileDescriptor(@NotNull Project project, @NotNull VirtualFile file, String[] columnNames, Object[] values, boolean selectedOnly, String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "<init>"));
        }
        super(project, file);
        this.myColumnNames = columnNames;
        this.myValues = values;
        this.mySelectedOnly = selectedOnly;
        this.myDescription = description;
    }

    public boolean navigateInEditor(@NotNull Project project, boolean requestFocus) {
        JComponent component;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "navigateInEditor"));
        }
        List editors = FileEditorManager.getInstance((Project)project).openEditor((OpenFileDescriptor)this, requestFocus);
        FileEditor editor = (FileEditor)ContainerUtil.getFirstItem((List)editors);
        JComponent jComponent = component = editor != null ? editor.getPreferredFocusedComponent() : null;
        if (component != null) {
            IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)component, true);
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void navigateTo(@NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultPanel", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "navigateTo"));
        }
        if (this.myColumnNames == null || this.myValues == null) {
            return;
        }
        if (this.mySelectedOnly) {
            this.navigateToSelectedOnly(resultPanel);
        } else {
            this.navigateToFirstMatched(resultPanel);
        }
    }

    public static int calcTargetOffset(@NotNull Project project, @NotNull VirtualFile file, final @NotNull DasObject template) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "calcTargetOffset"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "calcTargetOffset"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "calcTargetOffset"));
        }
        ObjectKind kind = template.getKind();
        if (kind == ObjectKind.BODY) {
            kind = ObjectKind.PACKAGE;
        } else if (kind == ObjectKind.PACKAGE) {
            kind = ObjectKind.BODY;
        }
        String name = template.getName();
        Condition condition = Conditions.and2((Condition)DasUtil.byKind((ObjectKind)kind), (Condition)DasUtil.byName((String)name));
        if (kind == ObjectKind.ROUTINE) {
            condition = Conditions.and2((Condition)condition, (Condition)new Condition<DasObject>(){

                public boolean value(DasObject object) {
                    Iterator it1 = this.getRoutineArgs(template).iterator();
                    Iterator it2 = this.getRoutineArgs(object).iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        DasTypedObject o1 = (DasTypedObject)it1.next();
                        DasTypedObject o2 = (DasTypedObject)it2.next();
                        if (o1.getKind() != o2.getKind()) {
                            return false;
                        }
                        if (!Comparing.equal((String)o1.getName(), (String)o2.getName(), (boolean)false)) {
                            return false;
                        }
                        if (Comparing.equal((String)o1.getDataType().getSpecification(), (String)o2.getDataType().getSpecification(), (boolean)false)) continue;
                        return false;
                    }
                    return it1.hasNext() == it2.hasNext();
                }

                JBIterable<DasTypedObject> getRoutineArgs(DasObject template2) {
                    if (!(template2 instanceof DasRoutine)) {
                        return JBIterable.empty();
                    }
                    DasRoutine r = (DasRoutine)template2;
                    return JBIterable.from((Iterable)DasUtil.getParameters((DasRoutine)r)).append((Object)r.getReturnArgument()).filter(DasTypedObject.class);
                }
            });
        }
        return DatabaseOpenFileDescriptor.calcTargetOffset(project, file, (Condition<? super DasObject>)condition);
    }

    public static int calcTargetOffset(@NotNull Project project, @NotNull VirtualFile file, @NotNull Condition<? super DasObject> equality) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "calcTargetOffset"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "calcTargetOffset"));
        }
        if (equality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equality", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "calcTargetOffset"));
        }
        return (Integer)ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "lambda$calcTargetOffset$0"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "lambda$calcTargetOffset$0"));
            }
            if (equality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "equality", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "lambda$calcTargetOffset$0"));
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof SqlFile)) {
                return -1;
            }
            DasObject first = (DasObject)((SqlFile)psiFile).traverser().traverse().filter(equality).first();
            return first instanceof SqlDefinition ? ((SqlDefinition)first).getTextOffset() : -1;
        });
    }

    private void navigateToSelectedOnly(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataGrid", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "navigateToSelectedOnly"));
        }
        List<DataConsumer.Column> columns = this.getColumns(dataGrid);
        if (columns == null) {
            return;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)DataGridUtil.getDatabaseTable(dataGrid));
        DbImplUtil.composeWhereCondition(builder, columns, ContainerUtil.list((Object[])this.myValues), dialect, null);
        String whereCondition = builder.getStatement();
        dataGrid.setFilterText(whereCondition, -1);
        dataGrid.applyFilter();
    }

    private void navigateToFirstMatched(final @NotNull EditorTableResultPanel resultPanel) {
        if (resultPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultPanel", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "navigateToFirstMatched"));
        }
        final QueryWithParameters existsQuery = this.buildSelectQuery(resultPanel);
        final QueryWithParameters countQuery = this.buildCountQuery(resultPanel);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(resultPanel);
        if (existsQuery == null || countQuery == null || hookup == null) {
            return;
        }
        DasTable table = DataGridUtil.getDatabaseTable(resultPanel);
        DasTableKey primaryKey = DasUtil.getPrimaryKey((DasTable)table);
        LinkedHashSet orderBy = ContainerUtil.newLinkedHashSet();
        Collections.addAll(orderBy, this.myColumnNames);
        if (primaryKey != null) {
            Iterables.addAll((Collection)orderBy, (Iterable)primaryKey.getColumnsRef().names());
        }
        ArrayList ordering = ContainerUtil.newArrayListWithCapacity((int)orderBy.size());
        for (String columnName : orderBy) {
            ModelIndex<DataConsumer.Column> column = DataGridUtil.findColumn(resultPanel, columnName);
            if (!column.isValid(resultPanel)) {
                return;
            }
            ordering.add(RowSortOrder.asc(column));
        }
        resultPanel.setOrdering(ordering);
        resultPanel.setFilterText("", -1);
        resultPanel.setSortViaOrderBy(true);
        resultPanel.applyFilter();
        final DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(resultPanel);
        hookup.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(hookup){

            @Override
            public void processRaw(DataRequest.Context context, Connection connection) throws Exception {
                try {
                    ResultSet resultSet;
                    PreparedStatement statement;
                    boolean exists = false;
                    int position = -1;
                    try {
                        statement = DatabaseOpenFileDescriptor.createStatement(connection, existsQuery, dialect);
                        resultSet = statement.executeQuery();
                        exists = resultSet.next();
                        JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
                        JdbcUtil.closeStatementSafe((Statement)statement);
                    }
                    catch (Exception ex) {
                        context.reportException(ex, existsQuery);
                    }
                    if (exists) {
                        try {
                            statement = DatabaseOpenFileDescriptor.createStatement(connection, countQuery, dialect);
                            resultSet = statement.executeQuery();
                            position = 0;
                            while (resultSet.next()) {
                                position += resultSet.getInt(1);
                            }
                            JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
                            JdbcUtil.closeStatementSafe((Statement)statement);
                        }
                        catch (Exception ex) {
                            context.reportException(ex, countQuery);
                        }
                    }
                    resultPanel.showCell(resultPanel.uiRow(position + 1), resultPanel.uiColumn(0));
                }
                catch (Exception e) {
                    context.reportException(e, null);
                }
            }
        });
    }

    private QueryWithParameters buildSelectQuery(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "buildSelectQuery"));
        }
        DasTable dasTable = DataGridUtil.getDatabaseTable(grid);
        List<DataConsumer.Column> columns = this.getColumns(grid);
        if (dasTable == null || columns == null) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        DdlBuilder builder = DbImplUtil.createBuilderForUIExec(dialect, (DasObject)dasTable);
        List<ColumnUpdateData> data = IntStream.range(0, Math.min(this.myValues.length, columns.size())).mapToObj(idx -> new ColumnUpdateData((DataConsumer.Column)columns.get(idx), this.myValues[idx])).collect(Collectors.toList());
        List<ColumnUpdateData> parameters = DbImplUtil.createSelectAllQueryWithParameters(builder, dasTable, dialect, data, 1);
        return new QueryWithParameters(builder.getStatement(), (List)ContainerUtil.immutableList(parameters));
    }

    private QueryWithParameters buildCountQuery(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "buildCountQuery"));
        }
        DasTable dasTable = DataGridUtil.getDatabaseTable(grid);
        if (dasTable == null) {
            return null;
        }
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
        DdlBuilder builder = DbImplUtil.createSelectAllQuery(dasTable, dialect);
        builder.space().keyword("WHERE").space();
        ArrayList parameters = ContainerUtil.newArrayList();
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        for (int i2 = 0; i2 < this.myColumnNames.length; ++i2) {
            String columnName = this.myColumnNames[i2];
            Object parameterValue = this.myValues[i2];
            DataConsumer.Column column = model.getColumn(DataGridUtil.findColumn(grid, columnName));
            if (column == null) {
                return null;
            }
            if (i2 > 0) {
                builder.space().keyword("OR").space();
            }
            Pair columnValuePair = Pair.create((Object)column, (Object)parameterValue);
            builder.columnRef(columnName).space().symbol("<").space().symbol("?");
            parameters.add(columnValuePair);
            DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column);
            if (dasColumn != null && !dasColumn.isNotNull()) {
                builder.space().keyword("OR").space().columnRef(columnName).space().keywords("IS", "NULL");
            }
            for (int j = 0; j < i2; ++j) {
                builder.space().keyword("AND").space();
                int placeholdersCount = DbImplUtil.composeWhereItemWithParameters(builder, column, parameterValue == null ? ThreeState.YES : ThreeState.NO, null, dialect);
                for (int k = 0; k < placeholdersCount; ++k) {
                    parameters.add(columnValuePair);
                }
            }
        }
        DbDataSource dataSource = DataGridUtil.getDatabaseSystem(grid);
        String sql = DbImplUtil.createSelectCountQuery(this.getProject(), dialect, builder.getStatement(), dataSource);
        return sql != null ? new QueryWithParameters(sql, ContainerUtil.immutableList((List)parameters)) : null;
    }

    @Nullable
    private List<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "getColumns"));
        }
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        List columns = ContainerUtil.mapNotNull((Object[])this.myColumnNames, columnName -> {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "lambda$getColumns$2"));
            }
            return model.getColumn(DataGridUtil.findColumn(grid, columnName));
        });
        return columns.size() == this.myColumnNames.length ? columns : null;
    }

    @NotNull
    private static PreparedStatement createStatement(@NotNull Connection connection, @NotNull QueryWithParameters queryWithParameters, @NotNull DatabaseDialectEx dialect) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "createStatement"));
        }
        if (queryWithParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryWithParameters", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "createStatement"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "createStatement"));
        }
        PreparedStatement statement = connection.prepareStatement(queryWithParameters.sql);
        ImmutableList<ColumnUpdateData> datas = queryWithParameters.data;
        for (int i2 = 0; i2 < datas.size(); ++i2) {
            DbImplUtil.setStatementParameter(statement, (ColumnUpdateData)datas.get(i2), dialect, true, i2 + 1);
        }
        PreparedStatement preparedStatement = statement;
        if (preparedStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseOpenFileDescriptor", "createStatement"));
        }
        return preparedStatement;
    }

    private static class QueryWithParameters {
        public final String sql;
        public final ImmutableList<ColumnUpdateData> data;

        private QueryWithParameters(@NotNull String sql, @NotNull List<ColumnUpdateData> data) {
            if (sql == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/editor/DatabaseOpenFileDescriptor$QueryWithParameters", "<init>"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/editor/DatabaseOpenFileDescriptor$QueryWithParameters", "<init>"));
            }
            this.sql = sql;
            this.data = ContainerUtil.immutableList(data);
        }

        private QueryWithParameters(@NotNull String sql, @NotNull ImmutableList<Pair<DataConsumer.Column, Object>> pairs) {
            if (sql == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sql", "com/intellij/database/editor/DatabaseOpenFileDescriptor$QueryWithParameters", "<init>"));
            }
            if (pairs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairs", "com/intellij/database/editor/DatabaseOpenFileDescriptor$QueryWithParameters", "<init>"));
            }
            this(sql, (List<ColumnUpdateData>)QueryWithParameters.convert(pairs));
        }

        @NotNull
        private static ImmutableList<ColumnUpdateData> convert(@NotNull List<Pair<DataConsumer.Column, Object>> pairs) {
            if (pairs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pairs", "com/intellij/database/editor/DatabaseOpenFileDescriptor$QueryWithParameters", "convert"));
            }
            List data = ContainerUtil.map(pairs, pair -> {
                DataConsumer.Column first = (DataConsumer.Column)pair.getFirst();
                Object second = pair.getSecond();
                return new ColumnUpdateData(first, second);
            });
            ImmutableList immutableList = ContainerUtil.immutableList((List)data);
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/DatabaseOpenFileDescriptor$QueryWithParameters", "convert"));
            }
            return immutableList;
        }
    }
}

