/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.DateDelegate;
import com.intellij.database.run.ui.grid.editors.EraDateAndTimeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ShortZonedTimestampDelegate;
import com.intellij.database.run.ui.grid.editors.TimeDelegate;
import com.intellij.database.run.ui.grid.editors.TimestampDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimeDelegate;
import com.intellij.database.run.ui.grid.editors.ZonedTimestampDelegate;
import com.intellij.openapi.util.Pair;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatterCreator {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_ZONE_PATTERN = "[ ][xxx]";
    private static final String ERA_PATTERN = "[ ][GGG]";

    private FormatterCreator() {
    }

    @NotNull
    public static DateAndTimeFormatter<TimeZonedTime, TemporalAccessor> newShortZonedTimeFormat() {
        DateAndTimeFormatter<TimeZonedTime, TemporalAccessor> dateAndTimeFormatter = FormatterCreator.newZonedTimeFormat(new ShortZonedTimeDelegate());
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newShortZonedTimeFormat"));
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static DateAndTimeFormatter<TimeZonedTime, TemporalAccessor> newZonedTimeFormat() {
        DateAndTimeFormatter<TimeZonedTime, TemporalAccessor> dateAndTimeFormatter = FormatterCreator.newZonedTimeFormat(new ZonedTimeDelegate());
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newZonedTimeFormat"));
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static DateAndTimeFormatter<Time, LocalTime> newTimeFormat() {
        DateAndTimeFormatter<Time, LocalTime> dateAndTimeFormatter = FormatterCreator.newTimeFormat(new TimeDelegate());
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newTimeFormat"));
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> DateAndTimeFormatter<T, V> newTimeFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/extractors/FormatterCreator", "newTimeFormat"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder();
        FormatterCreator.appendTime(stringBuilder, formatterBuilder);
        DateAndTimeFormatter<T, V> dateAndTimeFormatter = new DateAndTimeFormatter<T, V>((Pair<String, DateTimeFormatter>)Pair.create((Object)stringBuilder.toString(), (Object)FormatterCreator.toFormatter(formatterBuilder)), delegate);
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newTimeFormat"));
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static DateAndTimeFormatter<Timestamp, LocalDateTime> newTimestampFormat(int scale) {
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        FormatterCreator.appendDate(stringBuilder, formatterBuilder);
        FormatterCreator.appendTime(stringBuilder.append(' '), formatterBuilder.appendPattern("[ ]"));
        FormatterCreator.appendFraction(stringBuilder, formatterBuilder, scale);
        DateAndTimeFormatter<Timestamp, LocalDateTime> dateAndTimeFormatter = new DateAndTimeFormatter<Timestamp, LocalDateTime>((Pair<String, DateTimeFormatter>)Pair.create((Object)stringBuilder.toString(), (Object)FormatterCreator.toFormatter(formatterBuilder)), new TimestampDelegate());
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newTimestampFormat"));
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static CompositeFormatter newEraZonedTimestampFormat(@Nullable DataConsumer.Column column, int scale) {
        CompositeFormatter compositeFormatter = FormatterCreator.newEraZonedTsFormat(new ZonedTimestampDelegate(), column, scale);
        if (compositeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newEraZonedTimestampFormat"));
        }
        return compositeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> CompositeFormatter newEraZonedTsFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, @Nullable DataConsumer.Column column, int scale) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/extractors/FormatterCreator", "newEraZonedTsFormat"));
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        DateTimeFormatter full = FormatterCreator.toFormatter(new DateTimeFormatterBuilder().append(FormatterCreator.toFormatter(builders.fb)).optionalStart().parseLenient().appendPattern("[ ]").appendOffset("+HH:MM:ss", "+00").optionalEnd().parseStrict());
        DateTimeFormatter shortFormatter = FormatterCreator.toFormatter(new DateTimeFormatterBuilder().append(FormatterCreator.toFormatter(builders.fb)).optionalStart().parseLenient().appendPattern("[ ]").appendOffset("+HH:mm", "+00").optionalEnd().parseStrict());
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(PostgresDialect.INSTANCE, column);
        String pattern = builders.sb.toString();
        EraDateAndTimeFormatter fullEra = FormatterCreator.eraFormatter(pattern, full, delegate, resolver);
        EraDateAndTimeFormatter shortEra = FormatterCreator.eraFormatter(pattern, shortFormatter, delegate, resolver);
        CompositeFormatter compositeFormatter = new CompositeFormatter(fullEra, fullEra, shortEra);
        if (compositeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newEraZonedTsFormat"));
        }
        return compositeFormatter;
    }

    @NotNull
    public static Formatter newEraTimestampFormat(@NotNull DatabaseDialect dialect, @Nullable DataConsumer.Column column, int scale) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/FormatterCreator", "newEraTimestampFormat"));
        }
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        EraDateAndTimeFormatter eraDateAndTimeFormatter = FormatterCreator.eraFormatter(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new TimestampDelegate(), BoundaryValueResolver.getResolver(dialect, column));
        if (eraDateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newEraTimestampFormat"));
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    public static EraDateAndTimeFormatter newShortEraZonedTimestampFormat(int scale) {
        Builders builders = FormatterCreator.createBuildersForTimestamp(scale);
        builders.fb.optionalStart().appendLiteral(" ").appendOffset("+HH:MM:ss", "+00:00").optionalEnd();
        EraDateAndTimeFormatter eraDateAndTimeFormatter = FormatterCreator.eraFormatter(builders.sb.toString(), FormatterCreator.toFormatter(builders.fb), new ShortZonedTimestampDelegate(), BoundaryValueResolver.ALWAYS_NULL);
        if (eraDateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newShortEraZonedTimestampFormat"));
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    public static EraDateAndTimeFormatter newEraDateFormatter(@Nullable DatabaseDialect dialect, @Nullable DataConsumer.Column column) {
        EraDateAndTimeFormatter eraDateAndTimeFormatter = FormatterCreator.newEraDateFormatter(new DateDelegate(), dialect, column);
        if (eraDateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newEraDateFormatter"));
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> EraDateAndTimeFormatter newEraDateFormatter(@NotNull DateAndTimeFormatterDelegate<T, V> delegate, @Nullable DatabaseDialect dialect, @Nullable DataConsumer.Column column) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/extractors/FormatterCreator", "newEraDateFormatter"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder();
        FormatterCreator.appendDate(stringBuilder, formatterBuilder);
        DateAndTimeFormatter<T, V> regular = new DateAndTimeFormatter<T, V>((Pair<String, DateTimeFormatter>)Pair.create((Object)stringBuilder.toString(), (Object)FormatterCreator.toFormatter(formatterBuilder)), delegate, BoundaryValueResolver.getResolver(dialect, column));
        formatterBuilder.appendPattern(ERA_PATTERN);
        DateAndTimeFormatter<T, V> era = new DateAndTimeFormatter<T, V>((Pair<String, DateTimeFormatter>)Pair.create((Object)stringBuilder.toString(), (Object)FormatterCreator.toFormatter(formatterBuilder)), delegate, BoundaryValueResolver.getResolver(dialect, column));
        EraDateAndTimeFormatter eraDateAndTimeFormatter = new EraDateAndTimeFormatter(regular, era);
        if (eraDateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newEraDateFormatter"));
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    public static DateAndTimeFormatter<Date, LocalDate> newDateFormatter() {
        StringBuilder stringBuilder = new StringBuilder();
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder();
        FormatterCreator.appendDate(stringBuilder, formatterBuilder);
        DateAndTimeFormatter<Date, LocalDate> dateAndTimeFormatter = new DateAndTimeFormatter<Date, LocalDate>((Pair<String, DateTimeFormatter>)Pair.create((Object)stringBuilder.toString(), (Object)FormatterCreator.toFormatter(formatterBuilder)), new DateDelegate());
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newDateFormatter"));
        }
        return dateAndTimeFormatter;
    }

    @NotNull
    public static <T, V extends TemporalAccessor> DateAndTimeFormatter<T, V> newZonedTimeFormat(@NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/extractors/FormatterCreator", "newZonedTimeFormat"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder();
        FormatterCreator.appendTime(stringBuilder, formatterBuilder);
        Pair zonedPair = Pair.create((Object)stringBuilder.toString(), (Object)FormatterCreator.toFormatter(formatterBuilder.appendPattern(TIME_ZONE_PATTERN)));
        DateAndTimeFormatter<T, V> dateAndTimeFormatter = new DateAndTimeFormatter<T, V>((Pair<String, DateTimeFormatter>)zonedPair, delegate);
        if (dateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "newZonedTimeFormat"));
        }
        return dateAndTimeFormatter;
    }

    private static void appendTime(@NotNull StringBuilder stringBuilder, @NotNull DateTimeFormatterBuilder formatterBuilder) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "com/intellij/database/extractors/FormatterCreator", "appendTime"));
        }
        if (formatterBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatterBuilder", "com/intellij/database/extractors/FormatterCreator", "appendTime"));
        }
        stringBuilder.append("HH:mm:ss");
        formatterBuilder.parseLenient().optionalStart().appendValue(ChronoField.HOUR_OF_DAY, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalEnd().optionalStart().appendLiteral(":").optionalEnd().optionalStart().appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().parseStrict();
    }

    private static void appendDate(@NotNull StringBuilder stringBuilder, @NotNull DateTimeFormatterBuilder formatterBuilder) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "com/intellij/database/extractors/FormatterCreator", "appendDate"));
        }
        if (formatterBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatterBuilder", "com/intellij/database/extractors/FormatterCreator", "appendDate"));
        }
        stringBuilder.append(DATE_PATTERN);
        formatterBuilder.appendValue(ChronoField.YEAR_OF_ERA, 4, 7, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2);
    }

    private static void appendFraction(@NotNull StringBuilder stringBuilder, @NotNull DateTimeFormatterBuilder formatterBuilder, int scale) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringBuilder", "com/intellij/database/extractors/FormatterCreator", "appendFraction"));
        }
        if (formatterBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatterBuilder", "com/intellij/database/extractors/FormatterCreator", "appendFraction"));
        }
        stringBuilder.append(scale > 0 ? "." : "");
        for (int i2 = 0; i2 < scale; ++i2) {
            stringBuilder.append('f');
        }
        if (scale > 0) {
            formatterBuilder.parseLenient().appendFraction(ChronoField.NANO_OF_SECOND, scale, scale, true).parseStrict();
        }
    }

    @NotNull
    private static <T, V extends TemporalAccessor> EraDateAndTimeFormatter eraFormatter(@NotNull String regular, @NotNull DateTimeFormatter regularFormatter, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver) {
        if (regular == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regular", "com/intellij/database/extractors/FormatterCreator", "eraFormatter"));
        }
        if (regularFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regularFormatter", "com/intellij/database/extractors/FormatterCreator", "eraFormatter"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/extractors/FormatterCreator", "eraFormatter"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/database/extractors/FormatterCreator", "eraFormatter"));
        }
        DateTimeFormatter era = FormatterCreator.toFormatter(new DateTimeFormatterBuilder().append(regularFormatter).appendPattern(ERA_PATTERN));
        EraDateAndTimeFormatter eraDateAndTimeFormatter = new EraDateAndTimeFormatter(new DateAndTimeFormatter<T, V>((Pair<String, DateTimeFormatter>)Pair.create((Object)regular, (Object)regularFormatter), delegate, resolver), new DateAndTimeFormatter<T, V>((Pair<String, DateTimeFormatter>)Pair.create((Object)regular, (Object)era), delegate, resolver));
        if (eraDateAndTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "eraFormatter"));
        }
        return eraDateAndTimeFormatter;
    }

    @NotNull
    private static DateTimeFormatter toFormatter(@NotNull DateTimeFormatterBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/extractors/FormatterCreator", "toFormatter"));
        }
        DateTimeFormatter dateTimeFormatter = builder.toFormatter(Locale.US);
        if (dateTimeFormatter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "toFormatter"));
        }
        return dateTimeFormatter;
    }

    @NotNull
    private static Builders createBuildersForTimestamp(int scale) {
        DateTimeFormatterBuilder formatterBuilder = new DateTimeFormatterBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        FormatterCreator.appendDate(stringBuilder, formatterBuilder);
        FormatterCreator.appendTime(stringBuilder.append(' '), formatterBuilder.appendPattern("[ ]"));
        FormatterCreator.appendFraction(stringBuilder, formatterBuilder, scale);
        Builders builders = new Builders(stringBuilder, formatterBuilder);
        if (builders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/FormatterCreator", "createBuildersForTimestamp"));
        }
        return builders;
    }

    private static class Builders {
        private final StringBuilder sb;
        private final DateTimeFormatterBuilder fb;

        private Builders(@NotNull StringBuilder sb, @NotNull DateTimeFormatterBuilder fb) {
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/extractors/FormatterCreator$Builders", "<init>"));
            }
            if (fb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fb", "com/intellij/database/extractors/FormatterCreator$Builders", "<init>"));
            }
            this.sb = sb;
            this.fb = fb;
        }
    }
}

