/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableList;
import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseSingleDatabaseIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.OraIntroQueries;
import com.intellij.database.introspection.OraIntrospector;
import com.intellij.database.introspection.OraIntrospector$OraSchemaRetriever$retrieveSources$;
import com.intellij.database.introspection.OraIntrospectorFunctions;
import com.intellij.database.introspection.OraObjectCodes;
import com.intellij.database.introspection.StringListAggregator;
import com.intellij.database.introspection.StringSetAggregator;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.IdentifyingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraLikeTable;
import com.intellij.database.model.oracle.OraModCheck;
import com.intellij.database.model.oracle.OraModCluster;
import com.intellij.database.model.oracle.OraModClusterIndex;
import com.intellij.database.model.oracle.OraModCollectionType;
import com.intellij.database.model.oracle.OraModConstraint;
import com.intellij.database.model.oracle.OraModForeignKey;
import com.intellij.database.model.oracle.OraModIndex;
import com.intellij.database.model.oracle.OraModInfraColumn;
import com.intellij.database.model.oracle.OraModInnerRoutine;
import com.intellij.database.model.oracle.OraModKey;
import com.intellij.database.model.oracle.OraModLikeColumn;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModMajorObject;
import com.intellij.database.model.oracle.OraModMatView;
import com.intellij.database.model.oracle.OraModModel;
import com.intellij.database.model.oracle.OraModModule;
import com.intellij.database.model.oracle.OraModObjectType;
import com.intellij.database.model.oracle.OraModObjectTypeAttribute;
import com.intellij.database.model.oracle.OraModObjectTypeBody;
import com.intellij.database.model.oracle.OraModPackage;
import com.intellij.database.model.oracle.OraModPackageBody;
import com.intellij.database.model.oracle.OraModRoot;
import com.intellij.database.model.oracle.OraModRoutine;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModSequence;
import com.intellij.database.model.oracle.OraModSingleRoutine;
import com.intellij.database.model.oracle.OraModTable;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.model.oracle.OraModTrigger;
import com.intellij.database.model.oracle.OraModView;
import com.intellij.database.model.oracle.OraModule;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.openapi.util.Condition;
import com.intellij.util.StringFunKt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.SqlQuery;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001:\u0003#$%B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0014J9\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u001e\u0010 \u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0014J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/database/introspection/OraIntrospector;", "Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/model/oracle/OraModModel;", "Lcom/intellij/database/model/oracle/OraModRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "Lcom/intellij/database/model/oracle/OraModSchema;", "facade", "Lorg/jetbrains/dekaf/core/DBFacade;", "(Lorg/jetbrains/dekaf/core/DBFacade;)V", "fast", "", "queries", "Lcom/intellij/database/introspection/OraIntroQueries;", "applyNamespaces", "", "scs", "", "Lcom/intellij/database/introspection/LongIdName;", "initInternalState", "introspectFragment", "namespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "", "", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespacesInTran", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "introspectSchemasAuto", "schemas", "introspectSessionState", "OraDatabaseFirstRetriever", "OraDatabaseIncRetriever", "OraSchemaRetriever", "database-introspection"})
public final class OraIntrospector
extends BaseSingleDatabaseIntrospector<OraModModel, OraModRoot, OraSchema, OraModSchema> {
    private final OraIntroQueries queries;
    private boolean fast;

    @Override
    protected void initInternalState() {
        super.initInternalState();
        if (!this.getServerVersion().isOrGreater(new int[]{10}) && this.getDriverVersion().isOrGreater(new int[]{12})) {
            String message = String.format("Unsupported combination of server/driver versions: found Oracle server version %s with JDBC driver version %s that is not compatible. Oracle server version 9.x must be connected by JDBC driver versions 9.x to 11.x.", this.getServerVersion(), this.getDriverVersion());
            throw (Throwable)new IllegalStateException(message);
        }
        Object object = this.getDbFacade().inTransaction((InTransaction)new InTransaction<Boolean>(this){
            final /* synthetic */ OraIntrospector this$0;

            public final Boolean run(@NotNull DBTransaction tran) {
                Boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                try {
                    bl = (Boolean)tran.query(OraIntrospector.access$getQueries$p((OraIntrospector)this.this$0).checkBaseDictionariesAccess).run();
                }
                catch (NoTableOrViewException ntv) {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = oraIntrospector;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dbFacade.inTransaction(I\u2026     false\n      }\n    })");
        this.fast = (Boolean)object;
        BaseIntrospectionFunctions.setMajorVersionParameters(this.getServerVersion(), 10, this.queryParameters);
        BaseIntrospectionFunctions.setOracleFastSlowModeParameters(this.fast, this.queryParameters);
        OraIntrospectorFunctions.access$getLOG$p().info(String.format("Oracle Introspector: initialized for Oracle version %s driver version %s using %s mode", this.getServerVersion(), this.getDriverVersion(), this.fast ? "FAST" : "SLOW"));
    }

    @Override
    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        List schemas;
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List list = schemas = (List)tran.query(this.queries.retrieveAllSchemas).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"schemas");
        this.applyNamespaces(list);
    }

    private final void applyNamespaces(List<LongIdName> scs) {
        ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(scs){
            final /* synthetic */ List $scs;

            public final void perform(OraModRoot root2) {
                NamingIdentifyingFamily schemas = root2.getSchemas();
                boolean wasEmpty = schemas.isEmpty();
                boolean beforePublic = true;
                schemas.markChildrenAsSyncPending();
                for (int i2 = 0; i2 < this.$scs.size(); ++i2) {
                    LongIdName sc = (LongIdName)this.$scs.get(i2);
                    OraModSchema schema = (OraModSchema)schemas.renew(sc.id, sc.name);
                    beforePublic &= sc.id != 1L;
                    if (i2 == 0) {
                        schema.setVisible(true);
                    }
                    if (!beforePublic || !wasEmpty) continue;
                    schema.setVisible(true);
                }
                schemas.removeSyncPendingChildren();
            }
            {
                this.$scs = list;
            }
        });
    }

    @Override
    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Object object = tran.query(this.queries.retrieveSessionInfo).run();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        OraIntroQueries.OneSessionInfo sessionInfo = (OraIntroQueries.OneSessionInfo)object;
        ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(sessionInfo){
            final /* synthetic */ OraIntroQueries.OneSessionInfo $sessionInfo;

            public final void perform(OraModRoot root2) {
                OraModSchema currentSchema = (OraModSchema)root2.getSchemas().createOrGet(this.$sessionInfo.current_schema);
                currentSchema.setVisible(true);
                currentSchema.setCurrent(true);
                OraModSchema userSchema = (OraModSchema)root2.getSchemas().createOrGet(this.$sessionInfo.current_user);
                userSchema.setVisible(true);
            }
            {
                this.$sessionInfo = oneSessionInfo;
            }
        });
    }

    @Override
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends OraSchema> schemas) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
        ArrayList schemasToProcess = new ArrayList(schemas);
        Iterator it = schemasToProcess.iterator();
        while (it.hasNext()) {
            OraSchema s = (OraSchema)it.next();
            if (s.getObjectId() != Long.MIN_VALUE || !(Intrinsics.areEqual((Object)s.getName(), (Object)"SYS") ^ true)) continue;
            OraIntrospectorFunctions.access$getLOG$p().warn("Oracle schema " + s.getRealName() + " has no object Id");
            it.remove();
        }
        ArrayList<OraSchema> schemas1 = new ArrayList<OraSchema>(schemasToProcess.size());
        ArrayList schemas2 = new ArrayList(schemasToProcess.size());
        for (OraSchema schema : schemasToProcess) {
            (schema.getIntrospectionTimestamp() == null ? schemas1 : schemas2).add(schema);
        }
        if (!schemas1.isEmpty()) {
            OraDatabaseFirstRetriever retriever1 = new OraDatabaseFirstRetriever(tran, (List<? extends OraSchema>)schemas1, false);
            retriever1.init$database_introspection();
            retriever1.process();
        }
        if (!schemas2.isEmpty()) {
            OraDatabaseIncRetriever retriever2 = new OraDatabaseIncRetriever(tran, schemas2, false);
            retriever2.init$database_introspection();
            retriever2.process();
        }
        Iterator iterator = schemasToProcess.iterator();
        while (iterator.hasNext()) {
            OraSchema schema;
            OraSchema oraSchema = schema = (OraSchema)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)oraSchema, (String)"schema");
            OraSchemaRetriever retriever = new OraSchemaRetriever(tran, oraSchema);
            retriever.init$database_introspection();
            retriever.retrieveMain$database_introspection();
        }
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
        boolean bl = namespace.getModel() == (OraModModel)this.getModel();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = namespace instanceof OraSchema;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        BasicNamespace basicNamespace = namespace;
        if (basicNamespace == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraSchema");
        }
        OraSchema schema = (OraSchema)basicNamespace;
        this.getDbFacade().inTransaction(new InTransactionNoResult(this, schema, withSources, objectKind, objectNames){
            final /* synthetic */ OraIntrospector this$0;
            final /* synthetic */ OraSchema $schema;
            final /* synthetic */ boolean $withSources;
            final /* synthetic */ ObjectKind $objectKind;
            final /* synthetic */ String[] $objectNames;

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                OraSchemaRetriever retriever = this.this$0.new OraSchemaRetriever(dBTransaction, this.$schema, this.$withSources, this.$objectKind, this.$objectNames);
                retriever.init$database_introspection();
                retriever.retrieveMain$database_introspection();
            }
            {
                this.this$0 = oraIntrospector;
                this.$schema = oraSchema;
                this.$withSources = bl;
                this.$objectKind = objectKind;
                this.$objectNames = stringArray;
            }
        });
        ((OraModModel)this.getModel()).waitForSourcesWritten();
    }

    public OraIntrospector(@NotNull DBFacade facade) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        super(facade, OraModModel.class, OraModRoot.class, OraModSchema.class);
        OraIntroQueries oraIntroQueries = OraIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)oraIntroQueries, (String)"QUERIES");
        this.queries = oraIntroQueries;
    }

    public static final /* synthetic */ void access$setFast$p(OraIntrospector $this, boolean bl) {
        $this.fast = bl;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002B%\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseFirstRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/oracle/OraModModel;", "Lcom/intellij/database/model/oracle/OraModRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "Lcom/intellij/database/model/oracle/OraModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "glutton", "", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "prepareParameters", "", "process", "retrieveAllOrdinaryNames", "retrieveAllSynonyms", "database-introspection"})
    private final class OraDatabaseFirstRetriever
    extends BaseIntrospector.DatabaseRetriever {
        private final List<OraSchema> schemas;
        private final boolean glutton;

        @Override
        protected void prepareParameters() {
            Stream stream;
            Stream stream2;
            Collection $receiver$iv;
            super.prepareParameters();
            this.setQueryParameter(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            Collection collection = this.schemas;
            String string = "ALL_SCHEMA_IDS";
            OraDatabaseFirstRetriever oraDatabaseFirstRetriever = this;
            Collection collection2 = $receiver$iv;
            if (collection2 instanceof Collection) {
                Stream stream3 = $receiver$iv.stream();
                if (stream3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.stream.Stream<out T>");
                }
                stream2 = stream3;
            } else {
                Stream stream4 = StreamSupport.stream(Spliterators.spliteratorUnknownSize($receiver$iv.iterator(), 0), false);
                stream2 = stream4;
                Intrinsics.checkExpressionValueIsNotNull(stream4, (String)"StreamSupport.stream(Spl\u2026is.iterator(), 0), false)");
            }
            Stream stream5 = stream2;
            oraDatabaseFirstRetriever.setQueryParameter(string, stream5.map(prepareParameters.1.INSTANCE).toArray());
            $receiver$iv = this.schemas;
            string = "ALL_SCHEMA_NAMES";
            oraDatabaseFirstRetriever = this;
            collection2 = $receiver$iv;
            if (collection2 instanceof Collection) {
                Stream stream6 = $receiver$iv.stream();
                if (stream6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.stream.Stream<out T>");
                }
                stream = stream6;
            } else {
                Stream stream7 = StreamSupport.stream(Spliterators.spliteratorUnknownSize($receiver$iv.iterator(), 0), false);
                stream = stream7;
                Intrinsics.checkExpressionValueIsNotNull(stream7, (String)"StreamSupport.stream(Spl\u2026is.iterator(), 0), false)");
            }
            stream5 = stream;
            oraDatabaseFirstRetriever.setQueryParameter(string, stream5.map(prepareParameters.2.INSTANCE).toArray());
        }

        @Override
        public void process() {
            this.retrieveAllOrdinaryNames();
            this.retrieveAllSynonyms();
        }

        private final void retrieveAllOrdinaryNames() {
            SqlQuery<String[]> query;
            this.reportRetrieving("Major Object Names");
            SqlQuery<String[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            String[] items = this.performQuery(sqlQuery);
            OraDatabaseFirstRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this, items){
                final /* synthetic */ OraDatabaseFirstRetriever this$0;
                final /* synthetic */ String[] $items$inlined;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    for (OraSchema schema : OraDatabaseFirstRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root3.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModSchema");
                        }
                        OraModSchema ms = (OraModSchema)basicModSchema;
                        ms.getSequences().clear();
                        ms.getObjectTypes().clear();
                        ms.getCollectionTypes().clear();
                        ms.getTables().clear();
                        ms.getMatViews().clear();
                        ms.getViews().clear();
                        ms.getPackages().clear();
                        ms.getRoutines().clear();
                    }
                    NamingIdentifyingFamily namingIdentifyingFamily = root3.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospectorFunctions.access$processNames(this.$items$inlined, (ModNamingIdentifyingFamily)namingIdentifyingFamily, false);
                }
                {
                    this.this$0 = oraDatabaseFirstRetriever;
                    this.$items$inlined = stringArray;
                }
            });
        }

        private final void retrieveAllSynonyms() {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraDatabaseFirstRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(ss){
                final /* synthetic */ List $ss$inlined;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    OraIntrospectorFunctions.access$processSynonyms(this.$ss$inlined, root3);
                }
                {
                    this.$ss$inlined = list;
                }
            });
        }

        public OraDatabaseFirstRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
            super(transaction);
            this.schemas = schemas;
            this.glutton = glutton;
        }

        @NotNull
        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseFirstRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002B%\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$OraDatabaseIncRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/oracle/OraModModel;", "Lcom/intellij/database/model/oracle/OraModRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "Lcom/intellij/database/model/oracle/OraModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schemas", "", "glutton", "", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Ljava/util/List;Z)V", "since", "Ljava/util/Date;", "determineAndRemoveAllDroppedStuff", "", "prepareParameters", "process", "retrieveAllOrdinaryNames", "root", "retrieveAllSynonyms", "database-introspection"})
    private final class OraDatabaseIncRetriever
    extends BaseIntrospector.DatabaseRetriever {
        private Date since;
        private final List<OraSchema> schemas;
        private final boolean glutton;

        @Override
        protected void prepareParameters() {
            Stream stream;
            Stream stream2;
            Collection $receiver$iv;
            super.prepareParameters();
            this.setQueryParameter(this.glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            Collection collection = this.schemas;
            String string = "ALL_SCHEMA_IDS";
            OraDatabaseIncRetriever oraDatabaseIncRetriever = this;
            Collection collection2 = $receiver$iv;
            if (collection2 instanceof Collection) {
                Stream stream3 = $receiver$iv.stream();
                if (stream3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.stream.Stream<out T>");
                }
                stream2 = stream3;
            } else {
                Stream stream4 = StreamSupport.stream(Spliterators.spliteratorUnknownSize($receiver$iv.iterator(), 0), false);
                stream2 = stream4;
                Intrinsics.checkExpressionValueIsNotNull(stream4, (String)"StreamSupport.stream(Spl\u2026is.iterator(), 0), false)");
            }
            Stream stream5 = stream2;
            oraDatabaseIncRetriever.setQueryParameter(string, stream5.map(prepareParameters.1.INSTANCE).toArray());
            $receiver$iv = this.schemas;
            string = "ALL_SCHEMA_NAMES";
            oraDatabaseIncRetriever = this;
            collection2 = $receiver$iv;
            if (collection2 instanceof Collection) {
                Stream stream6 = $receiver$iv.stream();
                if (stream6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.stream.Stream<out T>");
                }
                stream = stream6;
            } else {
                Stream stream7 = StreamSupport.stream(Spliterators.spliteratorUnknownSize($receiver$iv.iterator(), 0), false);
                stream = stream7;
                Intrinsics.checkExpressionValueIsNotNull(stream7, (String)"StreamSupport.stream(Spl\u2026is.iterator(), 0), false)");
            }
            stream5 = stream;
            oraDatabaseIncRetriever.setQueryParameter(string, stream5.map(prepareParameters.2.INSTANCE).toArray());
        }

        @Override
        public void process() {
            this.determineAndRemoveAllDroppedStuff();
            long sinceTime = System.currentTimeMillis();
            for (OraSchema schema : this.schemas) {
                Date schemaIntrospectionTimestamp = schema.getIntrospectionTimestamp();
                if (schemaIntrospectionTimestamp == null) continue;
                sinceTime = Math.min(sinceTime, schemaIntrospectionTimestamp.getTime());
            }
            this.since = new Timestamp(sinceTime);
            this.setQueryParameter("INC", Boolean.TRUE);
            this.setQueryParameter("SINCE", this.since);
            OraDatabaseIncRetriever this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    OraDatabaseIncRetriever.access$retrieveAllOrdinaryNames(this.this$0, root3);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                }
            });
            this_$iv = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p(this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this){
                final /* synthetic */ OraDatabaseIncRetriever this$0;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    OraDatabaseIncRetriever.access$retrieveAllSynonyms(this.this$0, root3);
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void determineAndRemoveAllDroppedStuff() {
            void this_$iv;
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            OraDatabaseIncRetriever oraDatabaseIncRetriever = this;
            BaseIntrospector.AbstractRetriever.access$getModel$p((BaseIntrospector.AbstractRetriever)this_$iv).modify(BaseIntrospector.access$getModRootClass$p(this_$iv.BaseIntrospector.this), new ModelModifier<MR>(this, identifiers){
                final /* synthetic */ OraDatabaseIncRetriever this$0;
                final /* synthetic */ TLongHashSet $identifiers$inlined;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    OraModRoot root3 = (OraModRoot)MR;
                    for (OraSchema schema : OraDatabaseIncRetriever.access$getSchemas$p(this.this$0)) {
                        BasicModSchema basicModSchema = root3.mod(schema);
                        if (basicModSchema == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModSchema");
                        }
                        OraModSchema s = (OraModSchema)basicModSchema;
                        OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers$inlined);
                    }
                }
                {
                    this.this$0 = oraDatabaseIncRetriever;
                    this.$identifiers$inlined = tLongHashSet;
                }
            });
        }

        private final void retrieveAllOrdinaryNames(OraModRoot root2) {
            SqlQuery<String[]> query;
            this.reportRetrieving("Major Object Names");
            NamingIdentifyingFamily modelSchemas = root2.getSchemas();
            SqlQuery<String[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllMajorNamesSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            String[] items = this.performQuery(sqlQuery);
            NamingIdentifyingFamily namingIdentifyingFamily = modelSchemas;
            Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"modelSchemas");
            OraIntrospectorFunctions.access$processNames(items, (ModNamingIdentifyingFamily)namingIdentifyingFamily, true);
        }

        private final void retrieveAllSynonyms(OraModRoot root2) {
            this.reportRetrieving("Synonyms");
            SqlQuery<List<OraIntroQueries.OneSynonym>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveAllSynonyms;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveAllSynonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(sqlQuery);
            OraIntrospectorFunctions.access$processSynonyms(ss, root2);
        }

        public OraDatabaseIncRetriever(@NotNull DBTransaction transaction, List<? extends OraSchema> schemas, boolean glutton) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schemas, (String)"schemas");
            super(transaction);
            this.since = BaseIntrospectionFunctions.AGES_AGO;
            this.schemas = schemas;
            this.glutton = glutton;
        }

        public static final /* synthetic */ void access$retrieveAllOrdinaryNames(OraDatabaseIncRetriever $this, @NotNull OraModRoot root2) {
            $this.retrieveAllOrdinaryNames(root2);
        }

        public static final /* synthetic */ void access$retrieveAllSynonyms(OraDatabaseIncRetriever $this, @NotNull OraModRoot root2) {
            $this.retrieveAllSynonyms(root2);
        }

        @NotNull
        public static final /* synthetic */ List access$getSchemas$p(OraDatabaseIncRetriever $this) {
            return $this.schemas;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b \n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002B\u0017\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB7\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002J\b\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020AH\u0014J\b\u0010C\u001a\u00020AH\u0002J\b\u0010D\u001a\u00020AH\u0014J\b\u0010E\u001a\u00020AH\u0016J\b\u0010F\u001a\u00020AH\u0002J\u0010\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020\u0011H\u0014J\b\u0010I\u001a\u00020AH\u0002J\b\u0010J\u001a\u00020AH\u0002J\b\u0010K\u001a\u00020AH\u0002J\b\u0010L\u001a\u00020AH\u0002J\b\u0010M\u001a\u00020AH\u0002J\b\u0010N\u001a\u00020AH\u0002J\b\u0010O\u001a\u00020AH\u0002J\b\u0010P\u001a\u00020AH\u0002J\b\u0010Q\u001a\u00020AH\u0002J\b\u0010R\u001a\u00020AH\u0002J\b\u0010S\u001a\u00020AH\u0002J\b\u0010T\u001a\u00020AH\u0002J\b\u0010U\u001a\u00020AH\u0002J\b\u0010V\u001a\u00020AH\u0002J\b\u0010W\u001a\u00020AH\u0002J\b\u0010X\u001a\u00020AH\u0002J\b\u0010Y\u001a\u00020AH\u0002J\b\u0010Z\u001a\u00020AH\u0002J\r\u0010[\u001a\u00020AH\u0000\u00a2\u0006\u0002\b\\J\b\u0010]\u001a\u00020AH\u0014J\b\u0010^\u001a\u00020AH\u0002J\b\u0010_\u001a\u00020AH\u0002J\b\u0010`\u001a\u00020AH\u0002J\u000e\u0010a\u001a\b\u0012\u0004\u0012\u00020c0bH\u0002J\b\u0010d\u001a\u00020AH\u0002J\b\u0010e\u001a\u00020AH\u0002J\b\u0010f\u001a\u00020AH\u0002J\b\u0010g\u001a\u00020AH\u0002J\b\u0010h\u001a\u00020AH\u0002J\b\u0010i\u001a\u00020AH\u0002J\u000e\u0010j\u001a\b\u0012\u0004\u0012\u00020k0bH\u0002J\b\u0010l\u001a\u00020AH\u0002J\u000e\u0010m\u001a\b\u0012\u0004\u0012\u00020n0bH\u0002J\b\u0010o\u001a\u00020AH\u0002J\u0016\u0010p\u001a\b\u0012\u0004\u0012\u00020r0q2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0012\u0010s\u001a\u0004\u0018\u00010t2\u0006\u0010u\u001a\u00020vH\u0002J\u001e\u0010w\u001a\u00020A2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020y0q2\u0006\u0010z\u001a\u00020{H\u0002R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001e\"\u0004\b)\u0010 R\u001a\u0010*\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 R\u001a\u0010-\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001e\"\u0004\b/\u0010 R\u001a\u00100\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001e\"\u0004\b2\u0010 R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001e\"\u0004\b;\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lcom/intellij/database/introspection/OraIntrospector$OraSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/oracle/OraModModel;", "Lcom/intellij/database/model/oracle/OraModRoot;", "Lcom/intellij/database/model/oracle/OraSchema;", "Lcom/intellij/database/model/oracle/OraModSchema;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/oracle/OraSchema;)V", "withSources", "", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "fragmentNames", "", "", "(Lcom/intellij/database/introspection/OraIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/oracle/OraSchema;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "affectedClusters", "Ljava/util/HashSet;", "Lcom/intellij/database/model/oracle/OraCluster;", "affectedDepObjects", "Lcom/intellij/database/model/basic/BasicSchemaObject;", "affectedInnerRoutines", "Lcom/intellij/database/model/basic/BasicRoutine;", "affectedModules", "Lcom/intellij/database/model/oracle/OraModule;", "affectsClusters", "getAffectsClusters$database_introspection", "()Z", "setAffectsClusters$database_introspection", "(Z)V", "affectsModulesOrBodies", "getAffectsModulesOrBodies$database_introspection", "setAffectsModulesOrBodies$database_introspection", "affectsSingleRoutines", "getAffectsSingleRoutines$database_introspection", "setAffectsSingleRoutines$database_introspection", "affectsTables", "getAffectsTables$database_introspection", "setAffectsTables$database_introspection", "affectsTriggers", "getAffectsTriggers$database_introspection", "setAffectsTriggers$database_introspection", "affectsViews", "getAffectsViews$database_introspection", "setAffectsViews$database_introspection", "haveDefaults", "getHaveDefaults$database_introspection", "setHaveDefaults$database_introspection", "myBeginTimestamp", "Ljava/sql/Timestamp;", "myFromTimestamp", "srcFromTimestamp", "tablesToReorderDetails", "Lcom/intellij/database/model/oracle/OraLikeTable;", "toStop", "getToStop$database_introspection", "setToStop$database_introspection", "adjustBigIntegerForSequence", "Ljava/math/BigInteger;", "bigDecimalValue", "Ljava/math/BigDecimal;", "adjustInnerRoutines", "", "clearSchema", "determineAndRemoveDroppedStuff", "prepareParameters", "process", "reorderTableDetails", "reportRetrieving", "what", "retrieveChecks", "retrieveClusterIndices", "retrieveClusters", "retrieveCollectionTypes", "retrieveColumnDefaults", "retrieveColumns", "retrieveComments", "retrieveConstraintColumns", "retrieveEntireSchema", "retrieveErrors", "retrieveForeignKeys", "retrieveFragment", "retrieveFragmentNewObjectNames", "retrieveIndices", "retrieveIndicesColumns", "retrieveInnerRoutines", "retrieveInnerRoutinesArguments", "retrieveKeys", "retrieveMain", "retrieveMain$database_introspection", "retrieveMainContent", "retrieveObjectTypeAttributes", "retrieveObjectTypes", "retrievePackages", "retrieveProgramSources", "", "Lcom/intellij/database/introspection/OraIntroQueries$OneSrcLine;", "retrieveSchemaInfo", "retrieveSequences", "retrieveSingleRoutines", "retrieveSingleRoutinesArguments", "retrieveSources", "retrieveTables", "retrieveTriggerSources", "Lcom/intellij/database/introspection/OraIntroQueries$OneTriggerSource;", "retrieveTriggers", "retrieveViewSources", "Lcom/intellij/database/introspection/OraIntroQueries$OneViewSource;", "retrieveViews", "seanceRelatedTablesAndViews", "", "Lcom/intellij/database/model/oracle/OraModLikeTable;", "trigTurnOf", "Lcom/intellij/database/model/properties/TrigTurn;", "turn", "", "updateInvalidStatus", "family", "Lcom/intellij/database/model/basic/BasicModElement;", "invalids", "Lgnu/trove/TLongHashSet;", "database-introspection"})
    private final class OraSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        private final DBTransaction tran;
        private Timestamp myFromTimestamp;
        private Timestamp myBeginTimestamp;
        private Timestamp srcFromTimestamp;
        private boolean affectsClusters;
        private boolean affectsTables;
        private boolean affectsViews;
        private boolean affectsTriggers;
        private boolean affectsSingleRoutines;
        private boolean affectsModulesOrBodies;
        private boolean haveDefaults;
        private boolean toStop;
        private final HashSet<OraLikeTable> tablesToReorderDetails;
        private final HashSet<OraCluster> affectedClusters;
        private final HashSet<OraModule> affectedModules;
        private final HashSet<BasicRoutine> affectedInnerRoutines;
        private final HashSet<BasicSchemaObject> affectedDepObjects;

        public final boolean getAffectsClusters$database_introspection() {
            return this.affectsClusters;
        }

        public final void setAffectsClusters$database_introspection(boolean bl) {
            this.affectsClusters = bl;
        }

        public final boolean getAffectsTables$database_introspection() {
            return this.affectsTables;
        }

        public final void setAffectsTables$database_introspection(boolean bl) {
            this.affectsTables = bl;
        }

        public final boolean getAffectsViews$database_introspection() {
            return this.affectsViews;
        }

        public final void setAffectsViews$database_introspection(boolean bl) {
            this.affectsViews = bl;
        }

        public final boolean getAffectsTriggers$database_introspection() {
            return this.affectsTriggers;
        }

        public final void setAffectsTriggers$database_introspection(boolean bl) {
            this.affectsTriggers = bl;
        }

        public final boolean getAffectsSingleRoutines$database_introspection() {
            return this.affectsSingleRoutines;
        }

        public final void setAffectsSingleRoutines$database_introspection(boolean bl) {
            this.affectsSingleRoutines = bl;
        }

        public final boolean getAffectsModulesOrBodies$database_introspection() {
            return this.affectsModulesOrBodies;
        }

        public final void setAffectsModulesOrBodies$database_introspection(boolean bl) {
            this.affectsModulesOrBodies = bl;
        }

        public final boolean getHaveDefaults$database_introspection() {
            return this.haveDefaults;
        }

        public final void setHaveDefaults$database_introspection(boolean bl) {
            this.haveDefaults = bl;
        }

        public final boolean getToStop$database_introspection() {
            return this.toStop;
        }

        public final void setToStop$database_introspection(boolean bl) {
            this.toStop = bl;
        }

        @Override
        protected void prepareParameters() {
            super.prepareParameters();
            String[] fragmentKindTypeNames = OraObjectCodes.KIND_ORACLE_NAMES.get(this.getFragmentKind());
            this.setQueryParameter("major_object_type_names", fragmentKindTypeNames);
            this.setQueryParameter("major_object_names", this.getFragmentNames());
            this.setQueryParameter("src_since", this.srcFromTimestamp);
        }

        @Override
        public void process() {
            this.retrieveMain$database_introspection();
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveMain$database_introspection();
        }

        public final void retrieveMain$database_introspection() {
            if (this.getMode().fragment) {
                this.retrieveFragment();
            } else {
                this.retrieveEntireSchema();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveEntireSchema() {
            void this_$iv;
            boolean skipSystemSchema;
            boolean bl = skipSystemSchema = this.getMode().increment && OraIntrospectorFunctions.access$getSYSTEM_SCHEMAS$p().contains(((OraSchema)this.getSchema()).getName()) && !OraIntrospector.this.getMyConsiderSystemSchemasReinstrospection() && !((OraSchema)this.getSchema()).isCurrent();
            if (skipSystemSchema) {
                return;
            }
            Timestamp beginTimestamp = (Timestamp)this.tran.query(((OraIntrospector)OraIntrospector.this).queries.askForTimeNow).run();
            boolean bl2 = beginTimestamp != null;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Failed to obtain the current timestamp from the database";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.myBeginTimestamp = beginTimestamp;
            this.reportRetrieving("schema information");
            this.retrieveSchemaInfo();
            if (this.toStop) {
                return;
            }
            Date modifiedTimestamp = ((OraSchema)this.getSchema()).getModifiedTimestamp();
            Timestamp srcFromTimestamp1 = this.srcFromTimestamp;
            boolean bl3 = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.myFromTimestamp) && (!this.getWithSources() || srcFromTimestamp1 != null && !srcFromTimestamp1.before(modifiedTimestamp));
            if (this.toStop) {
                return;
            }
            this.retrieveSequences();
            this.retrieveObjectTypes();
            this.retrieveCollectionTypes();
            this.retrieveObjectTypeAttributes();
            this.retrieveClusters();
            this.retrieveTables();
            this.retrieveViews();
            this.retrieveColumns();
            this.retrieveColumnDefaults();
            this.retrieveClusterIndices();
            this.retrieveIndices();
            this.retrieveIndicesColumns();
            this.retrieveKeys();
            this.retrieveForeignKeys();
            this.retrieveChecks();
            this.retrieveConstraintColumns();
            this.reorderTableDetails();
            this.retrieveTriggers();
            this.retrievePackages();
            this.retrieveInnerRoutines();
            this.retrieveInnerRoutinesArguments();
            this.adjustInnerRoutines();
            this.retrieveSingleRoutines();
            this.retrieveSingleRoutinesArguments();
            this.retrieveComments();
            this.retrieveSources();
            this.retrieveErrors();
            this.reportRetrieving("finishing the schema...");
            OraSchemaRetriever oraSchemaRetriever = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>(beginTimestamp){
                final /* synthetic */ Timestamp $beginTimestamp$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.setIntrospectionTimestamp(this.$beginTimestamp$inlined);
                }
                {
                    this.$beginTimestamp$inlined = timestamp;
                }
            });
            if (this.getWithSources()) {
                ((OraModModel)this.getModel()).setSchemaSourcesVersion((BasicSchema)this.getSchema(), beginTimestamp.getTime());
            }
        }

        private final void retrieveFragment() {
            this.retrieveFragmentNewObjectNames();
            this.determineAndRemoveDroppedStuff();
            ObjectKind objectKind = this.getFragmentKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SEQUENCE)) {
                this.retrieveSequences();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.CLUSTER)) {
                this.retrieveClusters();
                this.retrieveColumns();
                this.retrieveClusterIndices();
                this.retrieveIndicesColumns();
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                this.retrieveTables();
                this.retrieveColumns();
                this.retrieveColumnDefaults();
                this.retrieveComments();
                this.retrieveIndices();
                this.retrieveIndicesColumns();
                this.retrieveKeys();
                this.retrieveForeignKeys();
                this.retrieveChecks();
                this.retrieveConstraintColumns();
                this.retrieveTriggers();
                this.reorderTableDetails();
                this.retrieveSources();
            } else if (!Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW)) {
                if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                    this.retrieveViews();
                    this.retrieveColumns();
                    this.retrieveComments();
                    this.retrieveTriggers();
                    this.reorderTableDetails();
                    this.retrieveSources();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
                    this.retrieveSingleRoutines();
                    this.retrieveSingleRoutinesArguments();
                    this.retrieveSources();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE)) {
                    this.retrievePackages();
                    this.retrieveInnerRoutines();
                    this.retrieveInnerRoutinesArguments();
                    this.adjustInnerRoutines();
                    this.retrieveSources();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
                    this.retrieveObjectTypes();
                    this.retrieveObjectTypeAttributes();
                    this.retrieveInnerRoutines();
                    this.retrieveInnerRoutinesArguments();
                    this.adjustInnerRoutines();
                    this.retrieveSources();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLLECTION_TYPE)) {
                    this.retrieveCollectionTypes();
                } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SYNONYM)) {
                    // empty if block
                }
            }
        }

        private final void retrieveFragmentNewObjectNames() {
            SqlQuery<String[]> listIdsQuery;
            ObjectKind fragmentKind = this.getFragmentKind();
            SqlQuery<String[]> sqlQuery = listIdsQuery = fragmentKind == ObjectKind.OBJECT_TYPE || fragmentKind == ObjectKind.COLLECTION_TYPE ? ((OraIntrospector)OraIntrospector.this).queries.listFragmentTypeIds : ((OraIntrospector)OraIntrospector.this).queries.listFragmentRegularIds;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"listIdsQuery");
            String[] items = this.performQuery(sqlQuery);
            ((OraModModel)this.getModel()).modify(OraModRoot.class, new ModelModifier<OraModRoot>(items){
                final /* synthetic */ String[] $items;

                public final void perform(OraModRoot root2) {
                    NamingIdentifyingFamily namingIdentifyingFamily = root2.getSchemas();
                    Intrinsics.checkExpressionValueIsNotNull((Object)namingIdentifyingFamily, (String)"root.schemas");
                    OraIntrospectorFunctions.access$processNames(this.$items, (ModNamingIdentifyingFamily)namingIdentifyingFamily, true);
                }
                {
                    this.$items = stringArray;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void determineAndRemoveDroppedStuff() {
            void this_$iv;
            SqlQuery<long[]> query;
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> sqlQuery = query = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).queries.retrieveAllObjectIdentifiersSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"query");
            long[] idsArray = this.performQuery(sqlQuery);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            OraSchemaRetriever oraSchemaRetriever = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>(identifiers){
                final /* synthetic */ TLongHashSet $identifiers$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema s = (OraModSchema)MS;
                    OraIntrospectorFunctions.access$dropUnexistentObjectsInSchema(s, this.$identifiers$inlined);
                }
                {
                    this.$identifiers$inlined = tLongHashSet;
                }
            });
        }

        @Override
        protected void clearSchema() {
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.dropChildren();
                    schema2.setCreatedTimestamp(null);
                    schema2.setModifiedTimestamp(null);
                    schema2.setIntrospectionTimestamp(null);
                    ((OraModModel)this.this$0.getModel()).setSchemaSourcesVersion(schema2, null);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                }
            });
        }

        private final void retrieveSchemaInfo() {
            boolean schemaIsPublic = Intrinsics.areEqual((Object)((OraSchema)this.getSchema()).getName(), (Object)"PUBLIC");
            SqlQuery<OraIntroQueries.OneSchemaInfo> sqlQuery = schemaIsPublic ? ((OraIntrospector)OraIntrospector.this).queries.retrievePublicSchemaInfo : ((OraIntrospector)OraIntrospector.this).queries.retrieveSchemaInfo;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"if (schemaIsPublic) quer\u2026ueries.retrieveSchemaInfo");
            OraIntroQueries.OneSchemaInfo info = this.performQuery(sqlQuery);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(info){
                final /* synthetic */ OraIntroQueries.OneSchemaInfo $info$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.setObjectId(this.$info$inlined.user_id);
                    schema2.setCreatedTimestamp(this.$info$inlined.created_timestamp);
                    schema2.setModifiedTimestamp(this.$info$inlined.modified_timestamp);
                }
                {
                    this.$info$inlined = oneSchemaInfo;
                }
            });
            this.setQueryParameter("SCHEMA_ID", info.user_id);
        }

        private final void retrieveSequences() {
            if (((OraSchema)this.getSchema()).getSequences().isEmpty()) {
                return;
            }
            this.reportRetrieving("Sequences");
            SqlQuery<List<OraIntroQueries.OneSequence>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSequences;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSequences");
            List<OraIntroQueries.OneSequence> ss = this.performQuery(sqlQuery);
            if (ss.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ss){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ss$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneSequence s : this.$ss$inlined) {
                        OraModSequence sequence = (OraModSequence)schema2.getSequences().renew(s.object_id, s.sequence_name);
                        sequence.setSequenceIdentity(SequenceIdentity.of(OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.min_value), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.last_number), BigInteger.valueOf(s.increment_by), OraSchemaRetriever.access$adjustBigIntegerForSequence(this.this$0, s.max_value)));
                        sequence.setOrdered(s.order_flag);
                        sequence.setCycled(s.cycle_flag);
                        Integer n = s.cache_size;
                        sequence.setCacheSize(n != null ? n : 0);
                        sequence.setCreatedTimestamp(s.created_timestamp);
                        sequence.setModifiedTimestamp(s.modified_timestamp);
                    }
                    schema2.getSequences().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ss$inlined = list;
                }
            });
        }

        private final BigInteger adjustBigIntegerForSequence(BigDecimal bigDecimalValue) {
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            return Intrinsics.areEqual((Object)bi.toString(), (Object)"9999999999999999999999999999") ? (BigInteger)null : bi;
        }

        private final void retrieveObjectTypes() {
            if (((OraSchema)this.getSchema()).getObjectTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Types");
            SqlQuery<List<OraIntroQueries.OneObjectType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypes");
            List<OraIntroQueries.OneObjectType> ots = this.performQuery(sqlQuery);
            if (ots.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ots){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ots$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneObjectType ot : this.$ots$inlined) {
                        OraModObjectType oType = (OraModObjectType)schema2.getObjectTypes().renew(ot.object_id, ot.type_name);
                        oType.setSuperSchemaName(ot.supertype_schema_name);
                        oType.setSuperObjectName(ot.supertype_name);
                        oType.setCreatedTimestamp(ot.created_timestamp);
                        oType.setModifiedTimestamp(ot.modified_timestamp);
                        oType.setIncomplete(ot.is_incomplete);
                        oType.setFinal(ot.is_final);
                        oType.setInstantiable(ot.is_instantiable);
                        if (ot.body_object_id != 0L) {
                            OraModObjectTypeBody body = (OraModObjectTypeBody)oType.getBodies().createOrGet();
                            body.setObjectId(ot.body_object_id);
                            body.setName(ot.type_name);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body, ot.body_created_timestamp, ot.body_modified_timestamp);
                        } else {
                            oType.getBodies().clear();
                        }
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(oType);
                        OraSchemaRetriever.access$getAffectedModules$p(this.this$0).add(oType);
                    }
                    schema2.getObjectTypes().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ots$inlined = list;
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveCollectionTypes() {
            if (((OraSchema)this.getSchema()).getCollectionTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Collection Types");
            SqlQuery<List<OraIntroQueries.OneCollectionType>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveCollectionTypes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveCollectionTypes");
            List<OraIntroQueries.OneCollectionType> cts = this.performQuery(sqlQuery);
            if (cts.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cts){
                final /* synthetic */ List $cts$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneCollectionType ct : this.$cts$inlined) {
                        OraModCollectionType cType = (OraModCollectionType)schema2.getCollectionTypes().renew(ct.object_id, ct.type_name);
                        cType.setArray(ct.collection_kind == 'A');
                        cType.setUpperBound(ct.upper_bound);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema2, ct.data_type_schema_name, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                        cType.setElementType(type);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(cType, ct.created_timestamp, ct.modified_timestamp);
                    }
                    schema2.getCollectionTypes().sort();
                }
                {
                    this.$cts$inlined = list;
                }
            });
        }

        private final void retrieveObjectTypeAttributes() {
            if (((OraSchema)this.getSchema()).getObjectTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Type Attributes");
            SqlQuery<List<OraIntroQueries.OneObjectTypeAttribute>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveObjectTypeAttributes;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveObjectTypeAttributes");
            List<OraIntroQueries.OneObjectTypeAttribute> attrs = this.performQuery(sqlQuery);
            if (attrs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(attrs){
                final /* synthetic */ List $attrs$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    HashSet<OraModObjectType> affectedObjectTypes = new HashSet<OraModObjectType>(schema2.getObjectTypes().size());
                    for (OraIntroQueries.OneObjectTypeAttribute ota : this.$attrs$inlined) {
                        OraModObjectType ot = (OraModObjectType)schema2.getObjectTypes().createOrGet(ota.type_name);
                        OraModObjectTypeAttribute attr = (OraModObjectTypeAttribute)ot.getAttributes().createOrGet(ota.attr_name);
                        attr.setPosition(ota.position);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema2, ota.data_type_schema, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                        attr.setDataType(type);
                        affectedObjectTypes.add(ot);
                    }
                    for (OraModObjectType objectType : affectedObjectTypes) {
                        objectType.getAttributes().sort();
                    }
                }
                {
                    this.$attrs$inlined = list;
                }
            });
        }

        private final void retrieveClusters() {
            if (((OraSchema)this.getSchema()).getClusters().isEmpty()) {
                return;
            }
            this.reportRetrieving("Clusters");
            SqlQuery<List<OraIntroQueries.OneCluster>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusters;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveClusters");
            List<OraIntroQueries.OneCluster> cs = this.performQuery(sqlQuery);
            if (cs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cs$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneCluster c : this.$cs$inlined) {
                        String string;
                        OraModCluster cluster = (OraModCluster)schema2.getClusters().createOrGet(c.id);
                        cluster.setClusterType(ClusterType.of((char)c.type_code));
                        cluster.setBlockSize(c.block_size);
                        OraModCluster oraModCluster = cluster;
                        if (c.hash_expression != null) {
                            String string2;
                            OraModCluster oraModCluster2 = oraModCluster;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                            oraModCluster = oraModCluster2;
                            string = string4;
                        } else {
                            string = null;
                        }
                        oraModCluster.setHashExpression(string);
                        cluster.setHashCardinality(c.hash_cardinality);
                        cluster.setTablespaceName(c.tablespace_name);
                        OraSchemaRetriever.access$getAffectedClusters$p(this.this$0).add(cluster);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cs$inlined = list;
                }
            });
            this.affectsClusters = true;
        }

        private final void retrieveTables() {
            if (((OraSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables");
            SqlQuery<List<OraIntroQueries.OneTable>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTables;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTables");
            List<OraIntroQueries.OneTable> tabs = this.performQuery(sqlQuery);
            if (tabs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, tabs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $tabs$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneTable tab : this.$tabs$inlined) {
                        OraModTable table = (OraModTable)schema2.getTables().renew(tab.object_id, tab.table_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(table, tab.created_timestamp, tab.modified_timestamp);
                        table.setRowTypeSchemaName(tab.row_type_schema_name);
                        table.setRowTypeObjectName(tab.row_type_name);
                        table.getChecks().clear();
                        table.getForeignKeys().clear();
                        table.getKeys().clear();
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(table);
                    }
                    schema2.getTables().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$tabs$inlined = list;
                }
            });
            this.affectsTables = true;
        }

        private final void retrieveViews() {
            if (((OraSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            this.reportRetrieving("Views");
            SqlQuery<List<OraIntroQueries.OneView>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViews;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViews");
            List<OraIntroQueries.OneView> vs = this.performQuery(sqlQuery);
            if (vs.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, vs){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $vs$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneView v : this.$vs$inlined) {
                        OraModView view2 = (OraModView)schema2.getViews().renew(v.object_id, v.view_name);
                        view2.setModifiable(v.modifiable);
                        view2.setInvalid(v.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(view2, v.created_timestamp, v.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(view2);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$vs$inlined = list;
                }
            });
            this.affectsViews = true;
        }

        private final void retrieveColumns() {
            this.haveDefaults = false;
            if (!(this.affectsClusters || this.affectsTables || this.affectsViews)) {
                return;
            }
            this.reportRetrieving("Table and View Columns");
            SqlQuery<List<OraIntroQueries.OneColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumns");
            List<OraIntroQueries.OneColumn> cols = this.performQuery(sqlQuery);
            if (cols.isEmpty()) {
                return;
            }
            HashSet affectedTables = new HashSet();
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cols, affectedTables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cols$inlined;
                final /* synthetic */ HashSet $affectedTables$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    OraModMajorObject major = null;
                    long major_id = Long.MIN_VALUE;
                    for (OraIntroQueries.OneColumn col : this.$cols$inlined) {
                        PositioningNamingFamily positioningNamingFamily;
                        Object majorKind$iv;
                        if (col.major_id != major_id) {
                            void majorId$iv;
                            Family<? extends BasicElement> majorFamily$iv;
                            BasicMajorObject basicMajorObject;
                            OraModMajorObject $receiver$iv;
                            BasicSchema basicSchema = schema2;
                            char c = col.major_kind;
                            ObjectKind[] objectKindArray = new ObjectKind[4];
                            ObjectKind objectKind = ObjectKind.CLUSTER;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"CLUSTER");
                            objectKindArray[0] = objectKind;
                            ObjectKind objectKind2 = ObjectKind.TABLE;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"TABLE");
                            objectKindArray[1] = objectKind2;
                            ObjectKind objectKind3 = ObjectKind.MAT_VIEW;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"MAT_VIEW");
                            objectKindArray[2] = objectKind3;
                            ObjectKind objectKind4 = ObjectKind.VIEW;
                            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind4, (String)"VIEW");
                            objectKindArray[3] = objectKind4;
                            ObjectKind objectKind5 = ModelFun.toKind(c, "CTMV", objectKindArray);
                            long l = col.major_id;
                            if ($receiver$iv.familyOf((ObjectKind)majorKind$iv) == null) {
                                basicMajorObject = null;
                            } else if ((majorFamily$iv instanceof IdentifyingFamily ? ((IdentifyingFamily)majorFamily$iv).getByObjectId((long)majorId$iv) : (BasicIdentifiedElement)null) == null) {
                                basicMajorObject = null;
                            } else {
                                BasicIdentifiedElement majorObject$iv;
                                majorObject$iv = majorObject$iv;
                                basicMajorObject = majorObject$iv instanceof OraModMajorObject ? (BasicMajorObject)((Object)majorObject$iv) : (BasicMajorObject)null;
                            }
                            major = (OraModMajorObject)basicMajorObject;
                            if (major == null) continue;
                            major_id = col.major_id;
                            $receiver$iv = major;
                            if ($receiver$iv instanceof OraModLikeTable) {
                                ((OraModLikeTable)((Object)major)).getColumns().markChildrenAsSyncPending();
                                this.$affectedTables$inlined.add(major);
                            } else if ($receiver$iv instanceof OraModCluster) {
                                ((OraModCluster)major).getColumns().markChildrenAsSyncPending();
                                OraSchemaRetriever.access$getAffectedClusters$p(this.this$0).add(major);
                            }
                        }
                        boolean $receiver$iv = major != null;
                        if (_Assertions.ENABLED && !$receiver$iv) {
                            majorKind$iv = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError(majorKind$iv));
                        }
                        majorKind$iv = major;
                        if (majorKind$iv instanceof OraModCluster) {
                            PositioningNamingFamily positioningNamingFamily2 = ((OraModCluster)major).getColumns();
                            positioningNamingFamily = positioningNamingFamily2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily2, (String)"major.columns");
                        } else {
                            if (!(majorKind$iv instanceof OraModLikeTable)) continue;
                            PositioningNamingFamily positioningNamingFamily3 = ((OraModLikeTable)((Object)major)).getColumns();
                            positioningNamingFamily = positioningNamingFamily3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)positioningNamingFamily3, (String)"major.columns");
                        }
                        PositioningNamingFamily tableColumns = positioningNamingFamily;
                        E e = tableColumns.createOrGet(col.column_name);
                        Intrinsics.checkExpressionValueIsNotNull(e, (String)"tableColumns.createOrGet(col.column_name)");
                        OraModInfraColumn column = (OraModInfraColumn)e;
                        column.resetSyncPending();
                        column.setPosition(col.column_position);
                        DataType type = OraIntrospectorFunctions.access$makeDataType(schema2, col.data_type_schema_name, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                        column.setDataType(type);
                        if (column instanceof OraModLikeColumn) {
                            ((OraModLikeColumn)column).setNotNull(col.mandatory);
                        }
                        if (!(column instanceof OraModTableColumn)) continue;
                        if (col.has_default_expression) {
                            this.this$0.setHaveDefaults$database_introspection(true);
                            continue;
                        }
                        ((OraModTableColumn)column).setDefaultExpression(null);
                    }
                    if (this.this$0.getMode().increment || this.this$0.getMode().fragment) {
                        Iterator<E> iterator = this.$affectedTables$inlined.iterator();
                        while (iterator.hasNext()) {
                            OraLikeTable affectedTable;
                            OraLikeTable oraLikeTable = affectedTable = (OraLikeTable)iterator.next();
                            if (oraLikeTable == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModLikeTable");
                            }
                            ((OraModLikeTable)oraLikeTable).getColumns().removeSyncPendingChildren();
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cols$inlined = list;
                    this.$affectedTables$inlined = hashSet;
                }
            });
            this.tablesToReorderDetails.addAll(affectedTables);
        }

        private final void retrieveColumnDefaults() {
            if (!this.haveDefaults) {
                return;
            }
            this.reportRetrieving("Table and View Column Defaults");
            SqlQuery<List<OraIntroQueries.OneColumnDefault>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveColumnDefaults;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveColumnDefaults");
            List<OraIntroQueries.OneColumnDefault> rows = this.performQuery(sqlQuery);
            if (rows.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(rows){
                final /* synthetic */ List $rows$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneColumnDefault col : this.$rows$inlined) {
                        OraModTableColumn column;
                        OraModTable table;
                        if ((OraModTable)schema2.getTables().get(col.table_name) == null) {
                            continue;
                        }
                        if ((OraModTableColumn)table.getColumns().get(col.column_name) == null) {
                            continue;
                        }
                        column.setDefaultExpression(col.default_expression);
                    }
                }
                {
                    this.$rows$inlined = list;
                }
            });
        }

        private final void retrieveClusterIndices() {
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery;
            if (((OraSchema)this.getSchema()).getClusters().isEmpty()) {
                return;
            }
            if (OraIntrospector.this.fast) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesFast;
            } else if (((OraSchema)this.getSchema()).isCurrent()) {
                sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveClusterIndicesUser;
            } else {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> query = sqlQuery;
            this.reportRetrieving("Cluster Indices");
            SqlQuery<List<OraIntroQueries.OneClusterIndex>> sqlQuery2 = query;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"query");
            List<OraIntroQueries.OneClusterIndex> inds = this.performQuery(sqlQuery2);
            if (inds.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, inds){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $inds$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneClusterIndex ind : this.$inds$inlined) {
                        OraModCluster cluster;
                        if ((OraModCluster)schema2.getClusters().get(ind.cluster_name) == null) {
                            continue;
                        }
                        OraModClusterIndex index = (OraModClusterIndex)cluster.getIndices().createOrGet();
                        index.setObjectId(ind.index_id);
                        index.setName(ind.index_name);
                        index.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index, ind.created_timestamp, ind.modified_timestamp);
                        if (!this.this$0.getMode().fragment) continue;
                        index.setColNames(CollectionsKt.emptyList());
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$inds$inlined = list;
                }
            });
        }

        private final void retrieveIndices() {
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Indices");
            SqlQuery<List<OraIntroQueries.OneIndex>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndices;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndices");
            List<OraIntroQueries.OneIndex> indices = this.performQuery(sqlQuery);
            if (indices.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, indices){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $indices$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneIndex ind : this.$indices$inlined) {
                        OraModTable table;
                        if ((OraModTable)schema2.getTables().get(ind.table_name) == null) {
                            continue;
                        }
                        OraModIndex index = (OraModIndex)table.getIndices().renew(ind.object_id, ind.index_name);
                        CharSequence charSequence = ind.index_name;
                        Pattern pattern = OraIntrospectorFunctions.access$getSURROGATE_NAME_PATTERN$p();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"SURROGATE_NAME_PATTERN");
                        index.setNameSurrogate(BaseIntrospectionFunctions.matches(charSequence, pattern));
                        index.setUnique(ind.uniqueness);
                        index.setClustering(ind.clustering);
                        index.setTablespaceName(ind.tablespace_name);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(index, ind.created_timestamp, ind.modified_timestamp);
                        if (this.this$0.getMode().fragment) {
                            index.setColNames(CollectionsKt.emptyList());
                        }
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$indices$inlined = list;
                }
            });
        }

        private final void retrieveIndicesColumns() {
            if (!this.affectsTables) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneIndexColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveIndicesColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveIndicesColumns");
            List<OraIntroQueries.OneIndexColumn> ics = this.performQuery(sqlQuery);
            if (ics.isEmpty()) {
                return;
            }
            StringListAggregator columns = new StringListAggregator();
            StringSetAggregator descendants = new StringSetAggregator();
            for (OraIntroQueries.OneIndexColumn oneIndexColumn : ics) {
                String column;
                String string;
                String key = oneIndexColumn.table_name + OraIntrospectorFunctions.delim + oneIndexColumn.index_name;
                if (oneIndexColumn.column_expression == null) {
                    string = oneIndexColumn.column_name;
                } else {
                    String string2 = oneIndexColumn.column_expression;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ic.column_expression");
                    string = OraIntrospectorFunctions.access$unquoteNameIfPossible(string2);
                }
                String string3 = column = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"column");
                columns.add(key, string3);
                if (!oneIndexColumn.descendant) continue;
                String string4 = column;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"column");
                descendants.add(key, string4);
            }
            OraSchemaRetriever oraSchemaRetriever = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(oraSchemaRetriever).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(oraSchemaRetriever), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)oraSchemaRetriever).this$0), new ModelModifier<MS>(this, columns, descendants){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $columns$inlined;
                final /* synthetic */ StringSetAggregator $descendants$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Map<K, CV> map = this.$columns$inlined.getResult();
                    Iterator<Map.Entry<K, CV>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        OraModIndex index;
                        String indexName;
                        OraModTable table;
                        String tableName;
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        String key = (String)entry2.getKey();
                        Map.Entry<K, CV> entry3 = entry;
                        List colNames = (List)entry3.getValue();
                        int d_pos = StringsKt.indexOf$default((CharSequence)key, (char)OraIntrospectorFunctions.delim, (int)0, (boolean)false, (int)6, null);
                        if (d_pos < 0) continue;
                        String string = key;
                        int n = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n, d_pos), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string3 = key;
                        int n2 = d_pos + 1;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                        if ((OraModTable)schema2.getTables().get(tableName) == null) {
                            continue;
                        }
                        if ((OraModIndex)table.getIndices().get(indexName) == null) {
                            continue;
                        }
                        index.setColNames(colNames);
                        Set set = (Set)this.$descendants$inlined.get(key);
                        if (set == null) {
                            set = SetsKt.emptySet();
                        }
                        index.setReverseColNames(set);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$columns$inlined = stringListAggregator;
                    this.$descendants$inlined = stringSetAggregator;
                }
            });
        }

        private final void retrieveKeys() {
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Keys");
            SqlQuery<List<OraIntroQueries.OneKey>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveKeys");
            List<OraIntroQueries.OneKey> keys = this.performQuery(sqlQuery);
            if (keys.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(keys){
                final /* synthetic */ List $keys$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneKey k : this.$keys$inlined) {
                        if (k.table_name == null || k.constraint_name == null) continue;
                        OraModTable table = (OraModTable)schema2.getTables().createOrGet(k.table_name);
                        OraModKey key = (OraModKey)table.getKeys().createOrGet(k.constraint_name);
                        key.setColNames(CollectionsKt.emptyList());
                        key.setNameSurrogate(k.is_surrogate_name);
                        key.setPrimary(k.is_pk);
                        key.setDeferrable(k.is_deferrable);
                        key.setInitiallyDeferred(k.is_initially_deferred);
                        key.setModifiedTimestamp(k.modified_timestamp);
                        key.setUnderlyingIndexName(k.index_name);
                    }
                }
                {
                    this.$keys$inlined = list;
                }
            });
        }

        private final void retrieveForeignKeys() {
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Foreign Keys");
            SqlQuery<List<OraIntroQueries.OneForeignKey>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveForeignKeys;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveForeignKeys");
            List<OraIntroQueries.OneForeignKey> fks = this.performQuery(sqlQuery);
            if (fks.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(fks){
                final /* synthetic */ List $fks$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneForeignKey fk : this.$fks$inlined) {
                        OraModTable table = (OraModTable)schema2.getTables().createOrGet(fk.table_name);
                        OraModForeignKey fkey = (OraModForeignKey)table.getForeignKeys().createOrGet(fk.constraint_name);
                        fkey.setColNames(CollectionsKt.emptyList());
                        fkey.setRefSchemaName(fk.ref_schema_name);
                        fkey.setRefTableName(fk.ref_table_name);
                        fkey.setRefKeyName(fk.ref_key_name);
                        fkey.setNameSurrogate(fk.is_surrogate_name);
                        fkey.setDeferrable(fk.is_deferrable);
                        fkey.setInitiallyDeferred(fk.is_initially_deferred);
                        fkey.setOnDelete(fk.cascade_delete ? CascadeRule.delete : CascadeRule.restrict);
                        fkey.setModifiedTimestamp(fk.modified_timestamp);
                    }
                }
                {
                    this.$fks$inlined = list;
                }
            });
        }

        private final void retrieveChecks() {
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Check Constraints");
            SqlQuery<List<OraIntroQueries.OneCheck>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveChecks;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveChecks");
            List<OraIntroQueries.OneCheck> cks = this.performQuery(sqlQuery);
            if (cks.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cks){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $cks$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneCheck ck : this.$cks$inlined) {
                        if (ck.predicate == null || ck.is_surrogate_name && OraIntrospectorFunctions.access$getAUTO_NOT_NULL_CHECK_PATTERN$p().matcher(ck.predicate).matches()) continue;
                        OraModTable table = (OraModTable)schema2.getTables().createOrGet(ck.table_name);
                        OraModCheck check = (OraModCheck)table.getChecks().createOrGet(ck.constraint_name);
                        check.setColNames(CollectionsKt.emptyList());
                        check.setNameSurrogate(ck.is_surrogate_name);
                        check.setPredicate(ck.predicate);
                        check.setModifiedTimestamp(ck.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(check.getTable());
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$cks$inlined = list;
                }
            });
        }

        private final void retrieveConstraintColumns() {
            if (!this.affectsTables) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneConstraintColumn>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveConstraintColumns;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveConstraintColumns");
            List<OraIntroQueries.OneConstraintColumn> ccs = this.performQuery(sqlQuery);
            if (ccs.isEmpty()) {
                return;
            }
            StringListAggregator agg = new StringListAggregator();
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                String key = cc.table_name + OraIntrospectorFunctions.delim + cc.constraint_name;
                String string = cc.column_name;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cc.column_name");
                agg.add(key, string);
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, agg){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ StringListAggregator $agg$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Map<K, CV> map = this.$agg$inlined.getResult();
                    Iterator<Map.Entry<K, CV>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        OraModConstraint constraint;
                        OraModTable table;
                        void constraintName;
                        void tableName;
                        Map.Entry<K, CV> entry;
                        Map.Entry<K, CV> entry2 = entry = iterator.next();
                        String key = (String)entry2.getKey();
                        Object object = entry;
                        List colNames = (List)object.getValue();
                        Object object2 = StringFunKt.unPair(key, OraIntrospectorFunctions.delim);
                        object = (String)object2.component1();
                        String string = (String)object2.component2();
                        object2 = null;
                        object2 = (CharSequence)tableName;
                        if (object2.length() == 0) continue;
                        object2 = (CharSequence)constraintName;
                        if (object2.length() == 0) continue;
                        if ((OraModTable)schema2.getTables().get((String)tableName) == null) {
                            continue;
                        }
                        if (OraIntrospectorFunctions.access$findModConstraint(table, (String)constraintName) == null) {
                            continue;
                        }
                        constraint.setColNames(colNames);
                        OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0).add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$agg$inlined = stringListAggregator;
                }
            });
        }

        private final void reorderTableDetails() {
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraLikeTable table : OraSchemaRetriever.access$getTablesToReorderDetails$p(this.this$0)) {
                        OraLikeTable oraLikeTable = table;
                        if (oraLikeTable instanceof OraModTable) {
                            ((OraModTable)table).getColumns().sort();
                            ((OraModTable)table).getIndices().sort();
                            ((OraModTable)table).getKeys().sort();
                            ((OraModTable)table).getForeignKeys().sort();
                            ((OraModTable)table).getChecks().sort();
                            continue;
                        }
                        if (!(oraLikeTable instanceof OraModLikeTable)) continue;
                        ((OraModLikeTable)table).getColumns().sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTriggers() {
            Object cols;
            Object also_retrieve_update_columns;
            void this_$iv;
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Triggers");
            SqlQuery<List<OraIntroQueries.OneTrigger>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggers;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggers");
            List<OraIntroQueries.OneTrigger> ts2 = this.performQuery(sqlQuery);
            if (ts2.isEmpty()) {
                return;
            }
            HashSet tables = new HashSet(ts2.size());
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            String[] stringArray = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>((OraSchemaRetriever)this, ts2, also_retrieve_update_columns, tables){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $ts$inlined;
                final /* synthetic */ Ref.BooleanRef $also_retrieve_update_columns$inlined;
                final /* synthetic */ HashSet $tables$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneTrigger trig : this.$ts$inlined) {
                        OraModLikeTable table;
                        String string = trig.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, string) == null) {
                            continue;
                        }
                        OraModTrigger trigger2 = (OraModTrigger)table.getTriggers().renew(trig.trigger_id, trig.trigger_name);
                        trigger2.setEvents(TrigEvent.of(trig.events));
                        trigger2.setTurn(OraSchemaRetriever.access$trigTurnOf(this.this$0, trig.turn));
                        this.$also_retrieve_update_columns$inlined.element |= trig.has_on_update_columns;
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(trigger2, trig.created_timestamp, trig.modified_timestamp);
                        this.$tables$inlined.add(table);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$ts$inlined = list;
                    this.$also_retrieve_update_columns$inlined = booleanRef;
                    this.$tables$inlined = hashSet;
                }
            });
            if (also_retrieve_update_columns.element) {
                void this_$iv2;
                String[] col;
                SqlQuery<List<String[]>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerUpdateColumns;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveTriggerUpdateColumns");
                cols = this.performQuery(sqlQuery2);
                StringListAggregator columns = new StringListAggregator();
                Iterator iterator = cols.iterator();
                while (iterator.hasNext()) {
                    col = (String[])iterator.next();
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null) continue;
                    String key = tableName + OraIntrospectorFunctions.delim + triggerName;
                    columns.add(key, columnName);
                }
                col = this;
                BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv2).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv2), BaseIntrospector.access$getModSchemaClass$p(this_$iv2.this$0), new ModelModifier<MS>(columns){
                    final /* synthetic */ StringListAggregator $columns$inlined;

                    /*
                     * WARNING - void declaration
                     */
                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        OraModSchema schema2 = (OraModSchema)MS;
                        Map<K, CV> map = this.$columns$inlined.getResult();
                        Iterator<Map.Entry<K, CV>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            OraModTrigger trigger2;
                            OraModLikeTable table;
                            void triggerName;
                            void tableName;
                            Map.Entry<K, CV> entry;
                            Map.Entry<K, CV> entry2 = entry = iterator.next();
                            String key = (String)entry2.getKey();
                            Object object = entry;
                            List names = (List)object.getValue();
                            Object object2 = StringFunKt.unPair(key, OraIntrospectorFunctions.delim);
                            object = (String)object2.component1();
                            String string = (String)object2.component2();
                            object2 = null;
                            object2 = (CharSequence)tableName;
                            if (object2.length() == 0) continue;
                            object2 = (CharSequence)triggerName;
                            if (object2.length() == 0) continue;
                            if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, (String)tableName) == null) {
                                continue;
                            }
                            if ((OraModTrigger)table.getTriggers().get((String)triggerName) == null) {
                                continue;
                            }
                            trigger2.setColNames(names);
                        }
                    }
                    {
                        this.$columns$inlined = stringListAggregator;
                    }
                });
            }
            cols = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>(tables){
                final /* synthetic */ HashSet $tables$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraModLikeTable table : this.$tables$inlined) {
                        table.getTriggers().sort();
                    }
                }
                {
                    this.$tables$inlined = hashSet;
                }
            });
            this.affectedDepObjects.addAll(tables);
            this.affectsTriggers = true;
            also_retrieve_update_columns = null;
        }

        private final TrigTurn trigTurnOf(short turn) {
            switch (turn) {
                case -2: {
                    return TrigTurn.BEFORE_STMT;
                }
                case -1: {
                    return TrigTurn.BEFORE_ROW;
                }
                case 1: {
                    return TrigTurn.AFTER_ROW;
                }
                case 2: {
                    return TrigTurn.AFTER_STMT;
                }
                case 0: {
                    return TrigTurn.INSTEAD_OF;
                }
            }
            return null;
        }

        private final void retrievePackages() {
            if (((OraSchema)this.getSchema()).getPackages().isEmpty()) {
                return;
            }
            this.reportRetrieving("Packages");
            SqlQuery<List<OraIntroQueries.OnePackage>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrievePackages;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrievePackages");
            List<OraIntroQueries.OnePackage> packages = this.performQuery(sqlQuery);
            if (packages.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, packages){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $packages$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OnePackage p : this.$packages$inlined) {
                        OraModPackage pack;
                        if (!p.is_body) {
                            pack = (OraModPackage)schema2.getPackages().renew(p.object_id, p.package_name);
                            pack.setInvalid(p.is_invalid);
                            OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(pack, p.created_timestamp, p.modified_timestamp);
                            OraSchemaRetriever.access$getAffectedModules$p(this.this$0).add(pack);
                            OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(pack);
                            continue;
                        }
                        pack = (OraModPackage)schema2.getPackages().createOrGet(p.package_name);
                        OraModPackageBody body = (OraModPackageBody)pack.getBodies().createOrGet();
                        body.setObjectId(p.object_id);
                        body.setInvalid(p.is_invalid);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(body, p.created_timestamp, p.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedModules$p(this.this$0).add(pack);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(body);
                    }
                    schema2.getPackages().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$packages$inlined = list;
                }
            });
            this.affectsModulesOrBodies = true;
        }

        private final void retrieveInnerRoutines() {
            if (this.affectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions");
            SqlQuery<List<OraIntroQueries.OneInnerRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutines");
            List<OraIntroQueries.OneInnerRoutine> routines = this.performQuery(sqlQuery);
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Iterator<E> iterator = OraSchemaRetriever.access$getAffectedModules$p(this.this$0).iterator();
                    while (iterator.hasNext()) {
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModModule");
                        }
                        ((OraModModule)oraModule).getRoutines().markChildrenAsSyncPending();
                    }
                    for (OraIntroQueries.OneInnerRoutine r : this.$routines$inlined) {
                        OraModModule module = null;
                        if (r.module_kind == 'T' || r.module_kind == 'Z') {
                            module = (OraModModule)schema2.getObjectTypes().get(r.module_name);
                        }
                        if (module == null && (r.module_kind == 'P' || r.module_kind == 'Z')) {
                            module = (OraModModule)schema2.getPackages().get(r.module_name);
                        }
                        if (module == null) continue;
                        OraModInnerRoutine routine2 = (OraModInnerRoutine)module.getRoutines().createOrGet(r.routine_name);
                        routine2.setDeterministic(r.is_deterministic);
                        OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0).add(routine2);
                    }
                    boolean toReorder = this.this$0.OraIntrospector.this.getServerVersion().get(0) < 11;
                    Iterator<E> iterator2 = OraSchemaRetriever.access$getAffectedModules$p(this.this$0).iterator();
                    while (iterator2.hasNext()) {
                        OraModule module;
                        OraModule oraModule = module = (OraModule)iterator2.next();
                        if (oraModule == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.oracle.OraModModule");
                        }
                        NamingFamily moduleRoutines = ((OraModModule)oraModule).getRoutines();
                        moduleRoutines.removeSyncPendingChildren();
                        if (!toReorder) continue;
                        moduleRoutines.sort();
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines$inlined = list;
                }
            });
        }

        private final void retrieveInnerRoutinesArguments() {
            if (this.affectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneInnerRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveInnerRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveInnerRoutineArguments");
            List<OraIntroQueries.OneInnerRoutineArgument> args = this.performQuery(sqlQuery);
            if (args.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(args){
                final /* synthetic */ List $args$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneInnerRoutineArgument a : this.$args$inlined) {
                        OraModInnerRoutine routine2;
                        OraModModule m;
                        if (a.package_name == null || a.routine_name == null) continue;
                        String string = a.package_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"a.package_name");
                        if (OraIntrospectorFunctions.access$findModuleByName(schema2, string) == null) {
                            continue;
                        }
                        if ((OraModInnerRoutine)m.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema2;
                        OraModRoutine oraModRoutine = routine2;
                        String string2 = a.arg_name;
                        char c = a.arg_direction;
                        String string3 = a.data_type_schema_name;
                        String string4 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraModRoutine, string2, c, string3, string4);
                    }
                }
                {
                    this.$args$inlined = list;
                }
            });
        }

        private final void adjustInnerRoutines() {
            if (this.affectedInnerRoutines.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ OraSchemaRetriever this$0;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (BasicRoutine routine2 : OraSchemaRetriever.access$getAffectedInnerRoutines$p(this.this$0)) {
                        if (!(routine2 instanceof BasicModRoutine)) continue;
                        ((BasicModRoutine)routine2).setRoutineKind(((BasicModRoutine)routine2).getReturnArgument() == null ? DasRoutine.Kind.PROCEDURE : DasRoutine.Kind.FUNCTION);
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                }
            });
        }

        private final void retrieveSingleRoutines() {
            if (((OraSchema)this.getSchema()).getRoutines().isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions");
            SqlQuery<List<OraIntroQueries.OneSingleRoutine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutines;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutines");
            List<OraIntroQueries.OneSingleRoutine> routines = this.performQuery(sqlQuery);
            if (routines.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, routines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ List $routines$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneSingleRoutine r : this.$routines$inlined) {
                        OraModSingleRoutine routine2 = (OraModSingleRoutine)schema2.getRoutines().renew(r.object_id, r.name);
                        routine2.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                        routine2.setInvalid(r.is_invalid);
                        routine2.setDeterministic(r.is_deterministic);
                        OraIntrospectorFunctions.access$setCreatedAndModifiedTimestamps(routine2, r.created_timestamp, r.modified_timestamp);
                        OraSchemaRetriever.access$getAffectedDepObjects$p(this.this$0).add(routine2);
                    }
                    schema2.getRoutines().sort();
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$routines$inlined = list;
                }
            });
            this.affectsSingleRoutines = true;
        }

        private final void retrieveSingleRoutinesArguments() {
            if (!this.affectsSingleRoutines) {
                return;
            }
            this.reportRetrieving("Procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneSingleRoutineArgument>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSingleRoutineArguments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSingleRoutineArguments");
            List<OraIntroQueries.OneSingleRoutineArgument> args = this.performQuery(sqlQuery);
            if (args.isEmpty()) {
                return;
            }
            OraSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(args){
                final /* synthetic */ List $args$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    for (OraIntroQueries.OneSingleRoutineArgument a : this.$args$inlined) {
                        OraModSingleRoutine routine2;
                        if (a.routine_name == null) continue;
                        if ((OraModSingleRoutine)schema2.getRoutines().get(a.routine_name) == null) {
                            continue;
                        }
                        BasicSchema basicSchema = schema2;
                        OraModRoutine oraModRoutine = routine2;
                        String string = a.arg_name;
                        char c = a.arg_direction;
                        String string2 = a.data_type_schema_name;
                        String string3 = a.data_type;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"a.data_type");
                        OraIntrospectorFunctions.access$makeArgument(basicSchema, oraModRoutine, string, c, string2, string3);
                    }
                }
                {
                    this.$args$inlined = list;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveComments() {
            void this_$iv;
            long hash;
            if (((OraSchema)this.getSchema()).getTables().isEmpty() && ((OraSchema)this.getSchema()).getMatViews().isEmpty() && ((OraSchema)this.getSchema()).getViews().isEmpty()) {
                if (((OraSchema)this.getSchema()).getCommentsHash() != 0L) {
                    OraSchemaRetriever this_$iv2 = this;
                    BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv2).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv2), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv2).this$0), new ModelModifier<MS>(){

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            OraModSchema schema2 = (OraModSchema)MS;
                            schema2.setCommentsHash(0L);
                        }
                    });
                }
                return;
            }
            this.reportRetrieving("Comments");
            SqlQuery<Long> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.calculateCommentsHash;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.calculateCommentsHash");
            Long l = this.performQuery(sqlQuery);
            long l2 = hash = l != null ? l : 0L;
            if (hash == ((OraSchema)this.getSchema()).getCommentsHash()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneComment>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveComments;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveComments");
            List<OraIntroQueries.OneComment> comments = this.performQuery(sqlQuery2);
            OraSchemaRetriever oraSchemaRetriever = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>(this, hash, comments){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ long $hash$inlined;
                final /* synthetic */ List $comments$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    schema2.setCommentsHash(Intrinsics.areEqual((Object)((Object)this.this$0.getMode()), (Object)((Object)IntrospectionMode.FRAGMENT)) ? -1L : this.$hash$inlined);
                    HashSet<BasicModNamedElement> touched = new HashSet<BasicModNamedElement>();
                    for (OraIntroQueries.OneComment c : this.$comments$inlined) {
                        OraModLikeColumn column;
                        OraModLikeTable table;
                        String string = c.table_name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"c.table_name");
                        if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, string) == null) {
                            continue;
                        }
                        if (c.column_name == null) {
                            table.setComment(c.comments);
                            touched.add(table);
                            continue;
                        }
                        if ((OraModLikeColumn)table.getColumns().get(c.column_name) == null) {
                            continue;
                        }
                        column.setComment(c.comments);
                        touched.add(column);
                    }
                    for (OraModLikeTable t : OraSchemaRetriever.access$seanceRelatedTablesAndViews(this.this$0, schema2)) {
                        if (touched.contains(t) ^ true) {
                            t.setComment(null);
                        }
                        for (OraModLikeColumn column : t.getColumns()) {
                            if (!(touched.contains(column) ^ true)) continue;
                            column.setComment(null);
                        }
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$hash$inlined = l;
                    this.$comments$inlined = list;
                }
            });
        }

        private final Iterable<OraModLikeTable> seanceRelatedTablesAndViews(OraModSchema schema) {
            if (Intrinsics.areEqual((Object)((Object)this.getMode()), (Object)((Object)IntrospectionMode.FRAGMENT))) {
                Iterable iterable = (Iterable)JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables()).filter((Condition)new Condition<OraModTable>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModTable it) {
                        return ArraysKt.contains((Object[])this.this$0.getFragmentNames(), (Object)it.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getMatViews()).filter((Condition)new Condition<OraModMatView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModMatView it) {
                        return ArraysKt.contains((Object[])this.this$0.getFragmentNames(), (Object)it.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                })).append((Iterable)JBIterable.from((Iterable)schema.getViews()).filter((Condition)new Condition<OraModView>(this){
                    final /* synthetic */ OraSchemaRetriever this$0;

                    public final boolean value(OraModView it) {
                        return ArraysKt.contains((Object[])this.this$0.getFragmentNames(), (Object)it.getName());
                    }
                    {
                        this.this$0 = oraSchemaRetriever;
                    }
                }));
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"JBIterable.empty<OraModL\u2026.name in fragmentNames })");
                return iterable;
            }
            Iterable iterable = (Iterable)JBIterable.empty().append((Iterable)JBIterable.from((Iterable)schema.getTables())).append((Iterable)JBIterable.from((Iterable)schema.getMatViews())).append((Iterable)JBIterable.from((Iterable)schema.getViews()));
            Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"JBIterable.empty<OraModL\u2026rable.from(schema.views))");
            return iterable;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveSources() {
            void this_$iv;
            if (!this.getWithSources()) {
                return;
            }
            Collection<OraIntroQueries.OneViewSource> viewBodies = this.retrieveViewSources();
            Collection<OraIntroQueries.OneTriggerSource> triggerBodies = this.retrieveTriggerSources();
            Collection<OraIntroQueries.OneSrcLine> programLines = this.retrieveProgramSources();
            this.reportRetrieving("applying sources");
            OraIntrospector oraIntrospector = OraIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, viewBodies, triggerBodies, programLines){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ Collection $viewBodies$inlined;
                final /* synthetic */ Collection $triggerBodies$inlined;
                final /* synthetic */ Collection $programLines$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    Object this_$iv;
                    Collection collection = this.$viewBodies$inlined;
                    if (!collection.isEmpty()) {
                        this_$iv = this.this$0;
                        BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;

                            public final void perform(MS schema) {
                                MS MS = schema;
                                Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                                OraModSchema schema2 = (OraModSchema)MS;
                                for (OraIntroQueries.OneViewSource v : this.this$0.$viewBodies$inlined) {
                                    OraModView view2;
                                    OraModView oraModView = view2 = (OraModView)schema2.getViews().createOrGet(v.view_name);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)oraModView, (String)"view");
                                    OraIntrospectorFunctions.access$applyViewSources(oraModView, v.text);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    this_$iv = this.$triggerBodies$inlined;
                    if (!this_$iv.isEmpty()) {
                        this_$iv = this.this$0;
                        BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;

                            public final void perform(MS schema) {
                                MS MS = schema;
                                Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                                OraModSchema schema2 = (OraModSchema)MS;
                                for (OraIntroQueries.OneTriggerSource trig : this.this$0.$triggerBodies$inlined) {
                                    OraModTrigger trigger2;
                                    OraModLikeTable table;
                                    String string = trig.table_name;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trig.table_name");
                                    if (OraIntrospectorFunctions.access$findTableOrViewByName(schema2, string) == null) {
                                        continue;
                                    }
                                    if ((OraModTrigger)table.getTriggers().get(trig.trigger_name) == null) {
                                        continue;
                                    }
                                    OraIntrospectorFunctions.access$applyTriggerSources(trigger2, trig.trigger_body);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    this_$iv = this.$programLines$inlined;
                    if (!this_$iv.isEmpty()) {
                        void theName;
                        void theType;
                        void this_$iv2;
                        this_$iv = new Ref.ObjectRef();
                        ((Ref.ObjectRef)this_$iv).element = "";
                        Ref.ObjectRef $i$f$inSchema = new Ref.ObjectRef();
                        $i$f$inSchema.element = "";
                        StringBuilder buf = new StringBuilder();
                        OraSchemaRetriever oraSchemaRetriever = this.this$0;
                        BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv2).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv2), BaseIntrospector.access$getModSchemaClass$p(this_$iv2.this$0), (ModelModifier)new ModelModifier<MS>((Ref.ObjectRef)theType, (Ref.ObjectRef)theName, buf, this){
                            final /* synthetic */ Ref.ObjectRef $theType$inlined;
                            final /* synthetic */ Ref.ObjectRef $theName$inlined;
                            final /* synthetic */ StringBuilder $buf$inlined;
                            final /* synthetic */ OraSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;

                            public final void perform(MS schema) {
                                MS MS = schema;
                                Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                                OraModSchema schema2 = (OraModSchema)MS;
                                for (OraIntroQueries.OneSrcLine line : this.this$0.$programLines$inlined) {
                                    boolean theSame;
                                    boolean bl = theSame = Intrinsics.areEqual((Object)((String)this.$theType$inlined.element), (Object)line.type) && Intrinsics.areEqual((Object)((String)this.$theName$inlined.element), (Object)line.name);
                                    if (!theSame) {
                                        String string = (String)this.$theType$inlined.element;
                                        String string2 = (String)this.$theName$inlined.element;
                                        String string3 = this.$buf$inlined.toString();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"buf.toString()");
                                        OraIntrospectorFunctions.access$applySources(schema2, string, string2, string3);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)line.type, (String)"line.type");
                                        this.$theType$inlined.element = this.$theType$inlined.element;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)line.name, (String)"line.name");
                                        this.$theName$inlined.element = this.$theName$inlined.element;
                                        this.$buf$inlined.delete(0, this.$buf$inlined.length());
                                    }
                                    this.$buf$inlined.append(line.text);
                                }
                                String string = (String)this.$theType$inlined.element;
                                String string4 = (String)this.$theName$inlined.element;
                                String string5 = this.$buf$inlined.toString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"buf.toString()");
                                OraIntrospectorFunctions.access$applySources(schema2, string, string4, string5);
                            }
                            {
                                this.$theType$inlined = objectRef;
                                this.$theName$inlined = objectRef2;
                                this.$buf$inlined = stringBuilder;
                                this.this$0 = var4_4;
                            }
                        });
                        Object var2_2 = null;
                        collection = null;
                    }
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$viewBodies$inlined = collection;
                    this.$triggerBodies$inlined = collection2;
                    this.$programLines$inlined = collection3;
                }
            });
        }

        private final Collection<OraIntroQueries.OneViewSource> retrieveViewSources() {
            Collection views;
            if (this.affectsViews) {
                this.reportRetrieving("View Sources");
                SqlQuery<List<OraIntroQueries.OneViewSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveViewSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveViewSources");
                views = this.performQuery(sqlQuery);
            } else {
                views = SetsKt.emptySet();
            }
            return views;
        }

        private final Collection<OraIntroQueries.OneTriggerSource> retrieveTriggerSources() {
            Collection triggers;
            if (this.affectsTables || this.affectsViews) {
                this.reportRetrieving("Trigger Sources");
                SqlQuery<List<OraIntroQueries.OneTriggerSource>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveTriggerSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveTriggerSources");
                triggers = this.performQuery(sqlQuery);
            } else {
                triggers = SetsKt.emptySet();
            }
            return triggers;
        }

        private final Collection<OraIntroQueries.OneSrcLine> retrieveProgramSources() {
            Collection lines;
            if (this.affectsModulesOrBodies || this.affectsSingleRoutines || this.affectsTriggers) {
                this.reportRetrieving("Procedures and Functions Sources");
                SqlQuery<List<OraIntroQueries.OneSrcLine>> sqlQuery = ((OraIntrospector)OraIntrospector.this).queries.retrieveSources;
                Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"queries.retrieveSources");
                lines = this.performQuery(sqlQuery);
            } else {
                lines = SetsKt.emptySet();
            }
            return lines;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveErrors() {
            void this_$iv;
            void this_$iv2;
            SqlQuery<long[]> invalidObjectsQuery;
            this.reportRetrieving("Statuses and Errors");
            SqlQuery<long[]> sqlQuery = invalidObjectsQuery = OraIntrospector.this.fast ? ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsFast : ((OraIntrospector)OraIntrospector.this).queries.listInvalidObjectsSlow;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"invalidObjectsQuery");
            long[] invalidObjectsAr = this.performQuery(sqlQuery);
            TLongHashSet invalids = new TLongHashSet(invalidObjectsAr);
            OraSchemaRetriever oraSchemaRetriever = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv2).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv2), BaseIntrospector.access$getModSchemaClass$p(this_$iv2.this$0), new ModelModifier<MS>(this, invalids){
                final /* synthetic */ OraSchemaRetriever this$0;
                final /* synthetic */ TLongHashSet $invalids$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    Iterable iterable = schema2.getObjectTypes();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"schema.objectTypes");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, iterable, this.$invalids$inlined);
                    Iterable iterable2 = schema2.getPackages();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable2, (String)"schema.packages");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, iterable2, this.$invalids$inlined);
                    Iterable iterable3 = schema2.getRoutines();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable3, (String)"schema.routines");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, iterable3, this.$invalids$inlined);
                    Iterable iterable4 = schema2.getTables();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable4, (String)"schema.tables");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, iterable4, this.$invalids$inlined);
                    Iterable iterable5 = schema2.getViews();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable5, (String)"schema.views");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, iterable5, this.$invalids$inlined);
                    Iterable iterable6 = schema2.getSynonyms();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable6, (String)"schema.synonyms");
                    OraSchemaRetriever.access$updateInvalidStatus(this.this$0, iterable6, this.$invalids$inlined);
                }
                {
                    this.this$0 = oraSchemaRetriever;
                    this.$invalids$inlined = tLongHashSet;
                }
            });
            if (invalids.isEmpty()) {
                return;
            }
            SqlQuery<List<OraIntroQueries.OneError>> sqlQuery2 = ((OraIntrospector)OraIntrospector.this).queries.retrieveErrors;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery2, (String)"queries.retrieveErrors");
            List<OraIntroQueries.OneError> errs = this.performQuery(sqlQuery2);
            if (errs.isEmpty()) {
                return;
            }
            OraSchemaRetriever $i$f$inSchema = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>(errs){
                final /* synthetic */ List $errs$inlined;

                public final void perform(MS schema) {
                    Object error;
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    OraModSchema schema2 = (OraModSchema)MS;
                    MultiMap map = new MultiMap();
                    for (OraIntroQueries.OneError err : this.$errs$inlined) {
                        BasicModSourceAware src = null;
                        switch (err.type_code) {
                            case 'R': {
                                src = (BasicModSourceAware)schema2.getRoutines().get(err.name);
                                break;
                            }
                            case 'V': {
                                src = (BasicModSourceAware)schema2.getViews().get(err.name);
                                break;
                            }
                            case 'T': {
                                OraModObjectType m = (OraModObjectType)schema2.getObjectTypes().get(err.name);
                                if (m == null) break;
                                src = err.is_body ? (BasicModSourceAware)m.getBodies().get() : (BasicModSourceAware)m;
                                break;
                            }
                            case 'P': {
                                OraModPackage p = (OraModPackage)schema2.getPackages().get(err.name);
                                if (p == null) break;
                                src = err.is_body ? (BasicModSourceAware)p.getBodies().get() : (BasicModSourceAware)p;
                                break;
                            }
                            case 'G': {
                                String string = err.name;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"err.name");
                                src = OraIntrospectorFunctions.access$findTrigger(schema2, string);
                            }
                        }
                        if (src == null) continue;
                        error = SourceError.of(err.line, err.position, err.message);
                        map.putValue((Object)src, error);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        error = entry;
                        BasicModSourceAware key = (BasicModSourceAware)error.getKey();
                        Map.Entry entry2 = entry;
                        Collection value = (Collection)entry2.getValue();
                        key.setErrors((List)ImmutableList.copyOf((Collection)value));
                    }
                }
                {
                    this.$errs$inlined = list;
                }
            });
        }

        private final void updateInvalidStatus(Iterable<? extends BasicModElement> family, TLongHashSet invalids) {
            for (BasicModElement basicModElement : family) {
                BasicModElement basicModElement2;
                if (basicModElement instanceof BasicModSourceAware && basicModElement instanceof BasicIdentifiedElement) {
                    boolean invalid = invalids.contains(((BasicIdentifiedElement)((Object)basicModElement)).getObjectId());
                    ((BasicModSourceAware)basicModElement).setInvalid(invalid);
                    if (!invalid) {
                        ((BasicModSourceAware)basicModElement).setErrors(ModelConsts.NO_ERRORS);
                    }
                }
                if ((basicModElement2 = basicModElement) instanceof OraModLikeTable) {
                    Iterable iterable = ((OraModLikeTable)basicModElement).getTriggers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"e.triggers");
                    this.updateInvalidStatus(iterable, invalids);
                    continue;
                }
                if (basicModElement2 instanceof OraModObjectType) {
                    Iterable iterable = ((OraModObjectType)basicModElement).getBodies();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"e.bodies");
                    this.updateInvalidStatus(iterable, invalids);
                    continue;
                }
                if (!(basicModElement2 instanceof OraModPackage)) continue;
                Iterable iterable = ((OraModPackage)basicModElement).getBodies();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"e.bodies");
                this.updateInvalidStatus(iterable, invalids);
            }
        }

        @Override
        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            String modeStr = this.getMode().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((OraSchema)this.getSchema()).getName(), modeStr);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026)\", schema.name, modeStr)");
            OraIntrospector.this.updateStatus(string, what);
        }

        public OraSchemaRetriever(@NotNull DBTransaction tran, OraSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)OraIntrospector.this, tran, (BasicSchema)schema);
            this.tablesToReorderDetails = new HashSet();
            this.affectedClusters = new HashSet();
            this.affectedModules = new HashSet();
            this.affectedInnerRoutines = new HashSet();
            this.affectedDepObjects = new HashSet();
            this.tran = tran;
            Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.myFromTimestamp = this.getMode().increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO;
            Long srcExistentVersion = ((OraModModel)this.getModel()).getSchemaSourcesVersion(schema);
            this.srcFromTimestamp = srcExistentVersion != null && Intrinsics.compare((long)srcExistentVersion, (long)0) > 0 ? new Timestamp(srcExistentVersion) : BaseIntrospectionFunctions.AGES_AGO;
        }

        public OraSchemaRetriever(@NotNull DBTransaction tran, OraSchema schema, @NotNull boolean withSources, @NotNull ObjectKind fragmentKind, String[] fragmentNames) {
            Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)fragmentKind, (String)"fragmentKind");
            Intrinsics.checkParameterIsNotNull((Object)fragmentNames, (String)"fragmentNames");
            super((BaseIntrospector)OraIntrospector.this, tran, (BasicSchema)schema, IntrospectionMode.FRAGMENT);
            this.tablesToReorderDetails = new HashSet();
            this.affectedClusters = new HashSet();
            this.affectedModules = new HashSet();
            this.affectedInnerRoutines = new HashSet();
            this.affectedDepObjects = new HashSet();
            this.tran = tran;
            this.setFragmentKind(fragmentKind);
            this.setFragmentNames(fragmentNames);
            this.setWithSources(withSources);
            this.myFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.srcFromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
        }

        @Nullable
        public static final /* synthetic */ BigInteger access$adjustBigIntegerForSequence(OraSchemaRetriever $this, @Nullable BigDecimal bigDecimalValue) {
            return $this.adjustBigIntegerForSequence(bigDecimalValue);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedDepObjects$p(OraSchemaRetriever $this) {
            return $this.affectedDepObjects;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedModules$p(OraSchemaRetriever $this) {
            return $this.affectedModules;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedClusters$p(OraSchemaRetriever $this) {
            return $this.affectedClusters;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getTablesToReorderDetails$p(OraSchemaRetriever $this) {
            return $this.tablesToReorderDetails;
        }

        @Nullable
        public static final /* synthetic */ TrigTurn access$trigTurnOf(OraSchemaRetriever $this, short turn) {
            return $this.trigTurnOf(turn);
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getAffectedInnerRoutines$p(OraSchemaRetriever $this) {
            return $this.affectedInnerRoutines;
        }

        @NotNull
        public static final /* synthetic */ Iterable access$seanceRelatedTablesAndViews(OraSchemaRetriever $this, @NotNull OraModSchema schema) {
            return $this.seanceRelatedTablesAndViews(schema);
        }

        public static final /* synthetic */ void access$updateInvalidStatus(OraSchemaRetriever $this, @NotNull Iterable family, @NotNull TLongHashSet invalids) {
            $this.updateInvalidStatus(family, invalids);
        }
    }
}

