/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.families;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.families.Family;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public interface ModFamily<E extends BasicModElement>
extends Family<E> {
    @Override
    @NotNull
    public BasicModModel getModel();

    @Override
    @NotNull
    public BasicModElement getOwner();

    @NotNull
    public E createNewOne();

    default public void markChildrenAsSyncPending() {
        for (BasicModElement e : this) {
            e.setSyncPending(true);
        }
    }

    default public void removeSyncPendingChildren() {
        this.remove(BasicModElement::isSyncPending);
    }

    public void remove(@NotNull Predicate<? super E> var1);

    public void sort();

    public void clear();

    @Deprecated
    default public boolean isPopulatable() {
        return true;
    }
}

