/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.impl.BaseModel;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.model.sqlite.SQLiteModCheck;
import com.intellij.database.model.sqlite.SQLiteModForeignKey;
import com.intellij.database.model.sqlite.SQLiteModIndex;
import com.intellij.database.model.sqlite.SQLiteModKey;
import com.intellij.database.model.sqlite.SQLiteModModel;
import com.intellij.database.model.sqlite.SQLiteModRoot;
import com.intellij.database.model.sqlite.SQLiteModSchema;
import com.intellij.database.model.sqlite.SQLiteModTable;
import com.intellij.database.model.sqlite.SQLiteModTableColumn;
import com.intellij.database.model.sqlite.SQLiteModTrigger;
import com.intellij.database.model.sqlite.SQLiteModView;
import com.intellij.database.model.sqlite.SQLiteModViewColumn;
import com.intellij.database.model.sqlite.SQLiteRoot;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SQLiteImplModel
extends BaseModel
implements SQLiteModModel {
    private final Root myRoot = new Root();

    SQLiteImplModel() {
    }

    @Override
    @NotNull
    public SQLiteRoot getRoot() {
        Root root2 = this.myRoot;
        if (root2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel", "getRoot"));
        }
        return root2;
    }

    final class Trigger
    extends BaseModel.BaseRegularElement
    implements SQLiteModTrigger {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private TrigTurn myTurn;
        @NotNull
        private Set<TrigEvent> myEvent;

        private Trigger(BaseModel.BaseFamily<? extends Trigger> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$Trigger", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myTurn = null;
            this.myEvent = Collections.emptySet();
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Trigger", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Trigger> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Trigger", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$Trigger", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Trigger", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$Trigger", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public TrigTurn getTurn() {
            return this.myTurn;
        }

        @Override
        public void setTurn(@Nullable TrigTurn turn) {
            if (BaseModel.eq((Object)this.myTurn, (Object)turn)) {
                return;
            }
            this.modifying();
            this.myTurn = turn;
        }

        @Override
        @NotNull
        public Set<TrigEvent> getEvent() {
            Set<TrigEvent> set = this.myEvent;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Trigger", "getEvent"));
            }
            return set;
        }

        @Override
        public void setEvent(@Nullable Set<TrigEvent> event) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = event != null ? ImmutableSet.copyOf(event) : Collections.emptySet();
            if (x.isEmpty() && this.myEvent.isEmpty()) {
                return;
            }
            this.modifying();
            this.myEvent = x;
        }
    }

    final class Check
    extends BaseModel.BaseRegularElement
    implements SQLiteModCheck {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myPredicate;

        private Check(BaseModel.BaseFamily<? extends Check> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$Check", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myPredicate = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Check", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Check> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Check", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$Check", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Check", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$Check", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Check", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getPredicate() {
            return this.myPredicate;
        }

        @Override
        public void setPredicate(@Nullable String predicate) {
            if (BaseModel.eq(this.myPredicate, predicate)) {
                return;
            }
            this.modifying();
            this.myPredicate = predicate;
        }
    }

    final class ForeignKey
    extends BaseModel.BaseRegularElement
    implements SQLiteModForeignKey {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        @Nullable
        private String myRefSchemaName;
        @Nullable
        private String myRefTableName;
        @Nullable
        private String myRefKeyName;
        @NotNull
        private List<String> myRefColNames;
        @NotNull
        private CascadeRule myOnDelete;
        @NotNull
        private CascadeRule myOnUpdate;

        private ForeignKey(BaseModel.BaseFamily<? extends ForeignKey> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myRefSchemaName = null;
            this.myRefTableName = null;
            this.myRefKeyName = null;
            this.myRefColNames = Collections.emptyList();
            this.myOnDelete = CascadeRule.restrict;
            this.myOnUpdate = CascadeRule.restrict;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<ForeignKey> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        @Nullable
        public String getRefSchemaName() {
            return this.myRefSchemaName;
        }

        @Override
        public void setRefSchemaName(@Nullable String refSchemaName) {
            if (BaseModel.eq(this.myRefSchemaName, refSchemaName)) {
                return;
            }
            this.modifying();
            this.myRefSchemaName = refSchemaName;
        }

        @Override
        @Nullable
        public String getRefTableName() {
            return this.myRefTableName;
        }

        @Override
        public void setRefTableName(@Nullable String refTableName) {
            if (BaseModel.eq(this.myRefTableName, refTableName)) {
                return;
            }
            this.modifying();
            this.myRefTableName = refTableName;
        }

        @Override
        @Nullable
        public String getRefKeyName() {
            return this.myRefKeyName;
        }

        @Override
        public void setRefKeyName(@Nullable String refKeyName) {
            if (BaseModel.eq(this.myRefKeyName, refKeyName)) {
                return;
            }
            this.modifying();
            this.myRefKeyName = refKeyName;
        }

        @Override
        @NotNull
        public List<String> getRefColNames() {
            List<String> list = this.myRefColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "getRefColNames"));
            }
            return list;
        }

        @Override
        public void setRefColNames(@Nullable List<String> refColNames) {
            ImmutableList x;
            ImmutableList immutableList = x = refColNames != null ? ImmutableList.copyOf(refColNames) : Collections.emptyList();
            if (x.isEmpty() && this.myRefColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myRefColNames = x;
        }

        @Override
        @NotNull
        public CascadeRule getOnDelete() {
            CascadeRule cascadeRule = this.myOnDelete;
            if (cascadeRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "getOnDelete"));
            }
            return cascadeRule;
        }

        @Override
        public void setOnDelete(@NotNull CascadeRule onDelete) {
            if (onDelete == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDelete", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "setOnDelete"));
            }
            if (this.myOnDelete.equals((Object)onDelete)) {
                return;
            }
            this.modifying();
            this.myOnDelete = onDelete;
        }

        @Override
        @NotNull
        public CascadeRule getOnUpdate() {
            CascadeRule cascadeRule = this.myOnUpdate;
            if (cascadeRule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "getOnUpdate"));
            }
            return cascadeRule;
        }

        @Override
        public void setOnUpdate(@NotNull CascadeRule onUpdate) {
            if (onUpdate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onUpdate", "com/intellij/database/model/impl/SQLiteImplModel$ForeignKey", "setOnUpdate"));
            }
            if (this.myOnUpdate.equals((Object)onUpdate)) {
                return;
            }
            this.modifying();
            this.myOnUpdate = onUpdate;
        }
    }

    final class Key
    extends BaseModel.BaseRegularElement
    implements SQLiteModKey {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        private boolean myDeferrable;
        private boolean myInitiallyDeferred;
        private boolean myPrimary;

        private Key(BaseModel.BaseFamily<? extends Key> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$Key", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myDeferrable = false;
            this.myInitiallyDeferred = false;
            this.myPrimary = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Key", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Key> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Key", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$Key", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Key", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$Key", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Key", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        public boolean isDeferrable() {
            return this.myDeferrable;
        }

        @Override
        public void setDeferrable(boolean deferrable) {
            if (this.myDeferrable == deferrable) {
                return;
            }
            this.modifying();
            this.myDeferrable = deferrable;
        }

        @Override
        public boolean isInitiallyDeferred() {
            return this.myInitiallyDeferred;
        }

        @Override
        public void setInitiallyDeferred(boolean initiallyDeferred) {
            if (this.myInitiallyDeferred == initiallyDeferred) {
                return;
            }
            this.modifying();
            this.myInitiallyDeferred = initiallyDeferred;
        }

        @Override
        public boolean isPrimary() {
            return this.myPrimary;
        }

        @Override
        public void setPrimary(boolean primary) {
            if (this.myPrimary == primary) {
                return;
            }
            this.modifying();
            this.myPrimary = primary;
        }
    }

    final class Index
    extends BaseModel.BaseRegularElement
    implements SQLiteModIndex {
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private List<String> myColNames;
        @NotNull
        private Set<String> myReverseColNames;
        private boolean myUnique;

        private Index(BaseModel.BaseFamily<? extends Index> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$Index", "<init>"));
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myColNames = Collections.emptyList();
            this.myReverseColNames = Collections.emptySet();
            this.myUnique = false;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Index", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModNamingFamily<Index> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Index", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$Index", "familyOf"));
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Index", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$Index", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public List<String> getColNames() {
            List<String> list = this.myColNames;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Index", "getColNames"));
            }
            return list;
        }

        @Override
        public void setColNames(@Nullable List<String> colNames) {
            ImmutableList x;
            ImmutableList immutableList = x = colNames != null ? ImmutableList.copyOf(colNames) : Collections.emptyList();
            if (x.isEmpty() && this.myColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myColNames = x;
        }

        @Override
        @NotNull
        public Set<String> getReverseColNames() {
            Set<String> set = this.myReverseColNames;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Index", "getReverseColNames"));
            }
            return set;
        }

        @Override
        public void setReverseColNames(@Nullable Set<String> reverseColNames) {
            ImmutableSet x;
            ImmutableSet immutableSet = x = reverseColNames != null ? ImmutableSet.copyOf(reverseColNames) : Collections.emptySet();
            if (x.isEmpty() && this.myReverseColNames.isEmpty()) {
                return;
            }
            this.modifying();
            this.myReverseColNames = x;
        }

        @Override
        public boolean isUnique() {
            return this.myUnique;
        }

        @Override
        public void setUnique(boolean unique) {
            if (this.myUnique == unique) {
                return;
            }
            this.modifying();
            this.myUnique = unique;
        }
    }

    final class ViewColumn
    extends BaseModel.BaseRegularElement
    implements SQLiteModViewColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;

        private ViewColumn(BaseModel.BaseFamily<? extends ViewColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
        }

        @Override
        @NotNull
        public View getView() {
            View view2 = (View)this.myParentFamily.owner;
            if (view2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "getView"));
            }
            return view2;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<ViewColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/SQLiteImplModel$ViewColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }
    }

    final class View
    extends BaseModel.BaseRegularElement
    implements SQLiteModView {
        private final Columns myColumns;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean mySystem;

        private View(BaseModel.BaseFamily<? extends View> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$View", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySystem = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$View", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<View> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$View", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$View", "getColumns"));
            }
            return columns;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$View", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$View", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$View", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<ViewColumn> {
            private Columns(View owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$View$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ViewColumn instantiate() {
                return new ViewColumn(this);
            }
        }
    }

    final class TableColumn
    extends BaseModel.BaseRegularElement
    implements SQLiteModTableColumn {
        private short myPosition;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @NotNull
        private DataType myDataType;
        private boolean myNotNull;
        @Nullable
        private SequenceIdentity mySequenceIdentity;
        @Nullable
        private String myDefaultExpression;

        private TableColumn(BaseModel.BaseFamily<? extends TableColumn> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "<init>"));
            }
            super(parentFamily);
            this.myPosition = 0;
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myDataType = ModelConsts.NO_DATA_TYPE;
            this.myNotNull = false;
            this.mySequenceIdentity = null;
            this.myDefaultExpression = null;
        }

        @Override
        @NotNull
        public Table getTable() {
            Table table = (Table)this.myParentFamily.owner;
            if (table == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "getTable"));
            }
            return table;
        }

        @Override
        @NotNull
        public ModPositioningNamingFamily<TableColumn> getParentFamily() {
            ModPositioningNamingFamily modPositioningNamingFamily = (ModPositioningNamingFamily)((Object)this.myParentFamily);
            if (modPositioningNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "getParentFamily"));
            }
            return modPositioningNamingFamily;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "familyOf"));
            }
            return null;
        }

        @Override
        public short getPosition() {
            return this.myPosition;
        }

        @Override
        public void setPosition(short position) {
            if (this.myPosition == position) {
                return;
            }
            this.modifying();
            this.myPosition = position;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myDataType;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "getDataType"));
            }
            return dataType;
        }

        @Override
        public void setDataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/model/impl/SQLiteImplModel$TableColumn", "setDataType"));
            }
            if (this.myDataType.equals(dataType)) {
                return;
            }
            this.modifying();
            this.myDataType = dataType;
        }

        @Override
        public boolean isNotNull() {
            return this.myNotNull;
        }

        @Override
        public void setNotNull(boolean notNull) {
            if (this.myNotNull == notNull) {
                return;
            }
            this.modifying();
            this.myNotNull = notNull;
        }

        @Override
        @Nullable
        public SequenceIdentity getSequenceIdentity() {
            return this.mySequenceIdentity;
        }

        @Override
        public void setSequenceIdentity(@Nullable SequenceIdentity sequenceIdentity) {
            if (BaseModel.eq(this.mySequenceIdentity, sequenceIdentity)) {
                return;
            }
            this.modifying();
            this.mySequenceIdentity = sequenceIdentity;
        }

        @Override
        @Nullable
        public String getDefaultExpression() {
            return this.myDefaultExpression;
        }

        @Override
        public void setDefaultExpression(@Nullable String defaultExpression) {
            if (BaseModel.eq(this.myDefaultExpression, defaultExpression)) {
                return;
            }
            this.modifying();
            this.myDefaultExpression = defaultExpression;
        }
    }

    final class Table
    extends BaseModel.BaseRegularElement
    implements SQLiteModTable {
        private final Columns myColumns;
        private final Indices myIndices;
        private final Keys myKeys;
        private final ForeignKeys myForeignKeys;
        private final Checks myChecks;
        private final Triggers myTriggers;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        private boolean mySystem;
        private boolean myTemporary;

        private Table(BaseModel.BaseFamily<? extends Table> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$Table", "<init>"));
            }
            super(parentFamily);
            this.myColumns = new Columns(this);
            this.myIndices = new Indices(this);
            this.myKeys = new Keys(this);
            this.myForeignKeys = new ForeignKeys(this);
            this.myChecks = new Checks(this);
            this.myTriggers = new Triggers(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.mySystem = false;
            this.myTemporary = false;
        }

        @Override
        @NotNull
        public Schema getSchema() {
            Schema schema = (Schema)this.myParentFamily.owner;
            if (schema == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getSchema"));
            }
            return schema;
        }

        @Override
        @NotNull
        public ModNamingFamily<Table> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Columns getColumns() {
            Columns columns = this.myColumns;
            if (columns == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getColumns"));
            }
            return columns;
        }

        @Override
        @NotNull
        public Indices getIndices() {
            Indices indices = this.myIndices;
            if (indices == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getIndices"));
            }
            return indices;
        }

        @Override
        @NotNull
        public Keys getKeys() {
            Keys keys = this.myKeys;
            if (keys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getKeys"));
            }
            return keys;
        }

        @Override
        @NotNull
        public ForeignKeys getForeignKeys() {
            ForeignKeys foreignKeys = this.myForeignKeys;
            if (foreignKeys == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getForeignKeys"));
            }
            return foreignKeys;
        }

        @Override
        @NotNull
        public Checks getChecks() {
            Checks checks = this.myChecks;
            if (checks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getChecks"));
            }
            return checks;
        }

        @Override
        @NotNull
        public Triggers getTriggers() {
            Triggers triggers = this.myTriggers;
            if (triggers == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getTriggers"));
            }
            return triggers;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$Table", "familyOf"));
            }
            if (kind == ObjectKind.COLUMN) {
                return this.myColumns;
            }
            if (kind == ObjectKind.INDEX) {
                return this.myIndices;
            }
            if (kind == ObjectKind.KEY) {
                return this.myKeys;
            }
            if (kind == ObjectKind.FOREIGN_KEY) {
                return this.myForeignKeys;
            }
            if (kind == ObjectKind.CHECK) {
                return this.myChecks;
            }
            if (kind == ObjectKind.TRIGGER) {
                return this.myTriggers;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Table", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$Table", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        public boolean isSystem() {
            return this.mySystem;
        }

        @Override
        public void setSystem(boolean system) {
            if (this.mySystem == system) {
                return;
            }
            this.modifying();
            this.mySystem = system;
        }

        @Override
        public boolean isTemporary() {
            return this.myTemporary;
        }

        @Override
        public void setTemporary(boolean temporary) {
            if (this.myTemporary == temporary) {
                return;
            }
            this.modifying();
            this.myTemporary = temporary;
        }

        private final class Triggers
        extends BaseModel.BaseNamingFamily<Trigger> {
            private Triggers(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Table$Triggers", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Trigger instantiate() {
                return new Trigger(this);
            }
        }

        private final class Checks
        extends BaseModel.BaseNamingFamily<Check> {
            private Checks(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Table$Checks", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Check instantiate() {
                return new Check(this);
            }
        }

        private final class ForeignKeys
        extends BaseModel.BaseNamingFamily<ForeignKey> {
            private ForeignKeys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Table$ForeignKeys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected ForeignKey instantiate() {
                return new ForeignKey(this);
            }
        }

        private final class Keys
        extends BaseModel.BaseNamingFamily<Key> {
            private Keys(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Table$Keys", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Key instantiate() {
                return new Key(this);
            }
        }

        private final class Indices
        extends BaseModel.BaseNamingFamily<Index> {
            private Indices(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Table$Indices", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Index instantiate() {
                return new Index(this);
            }
        }

        private final class Columns
        extends BaseModel.BasePositioningNamingFamily<TableColumn> {
            private Columns(Table owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Table$Columns", "<init>"));
                }
                super(owner);
            }

            @Override
            protected TableColumn instantiate() {
                return new TableColumn(this);
            }
        }
    }

    final class Schema
    extends BaseModel.BaseRegularElement
    implements SQLiteModSchema {
        private final Tables myTables;
        private final Views myViews;
        @NotNull
        private String myName;
        private boolean myNameSurrogate;
        @Nullable
        private String myComment;
        @Nullable
        private Date myIntrospectionTimestamp;
        private boolean myCurrent;
        private boolean myVisible;

        private Schema(BaseModel.BaseFamily<? extends Schema> parentFamily) {
            if (parentFamily == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentFamily", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "<init>"));
            }
            super(parentFamily);
            this.myTables = new Tables(this);
            this.myViews = new Views(this);
            this.myName = ModelConsts.NO_NAME;
            this.myNameSurrogate = false;
            this.myComment = null;
            this.myIntrospectionTimestamp = null;
            this.myCurrent = false;
            this.myVisible = false;
        }

        @Override
        @NotNull
        public Root getRoot() {
            Root root2 = (Root)this.myParentFamily.owner;
            if (root2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "getRoot"));
            }
            return root2;
        }

        @Override
        @NotNull
        public ModNamingFamily<Schema> getParentFamily() {
            ModNamingFamily modNamingFamily = (ModNamingFamily)((Object)this.myParentFamily);
            if (modNamingFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "getParentFamily"));
            }
            return modNamingFamily;
        }

        @Override
        @NotNull
        public Tables getTables() {
            Tables tables = this.myTables;
            if (tables == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "getTables"));
            }
            return tables;
        }

        @Override
        @NotNull
        public Views getViews() {
            Views views = this.myViews;
            if (views == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "getViews"));
            }
            return views;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "familyOf"));
            }
            if (kind == ObjectKind.TABLE) {
                return this.myTables;
            }
            if (kind == ObjectKind.VIEW) {
                return this.myViews;
            }
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "getName"));
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/impl/SQLiteImplModel$Schema", "setName"));
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return this.myNameSurrogate;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if (this.myNameSurrogate == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myNameSurrogate = nameSurrogate;
        }

        @Override
        @Nullable
        public String getComment() {
            return this.myComment;
        }

        @Override
        public void setComment(@Nullable String comment) {
            if (BaseModel.eq(this.myComment, comment)) {
                return;
            }
            this.modifying();
            this.myComment = comment;
        }

        @Override
        @Nullable
        public Date getIntrospectionTimestamp() {
            return this.myIntrospectionTimestamp;
        }

        @Override
        public void setIntrospectionTimestamp(@Nullable Date introspectionTimestamp) {
            if (BaseModel.eq(this.myIntrospectionTimestamp, introspectionTimestamp)) {
                return;
            }
            this.modifying();
            this.myIntrospectionTimestamp = introspectionTimestamp;
        }

        @Override
        public boolean isCurrent() {
            return this.myCurrent;
        }

        @Override
        public void setCurrent(boolean current) {
            if (this.myCurrent == current) {
                return;
            }
            this.modifying();
            this.myCurrent = current;
        }

        @Override
        public boolean isVisible() {
            return this.myVisible;
        }

        @Override
        public void setVisible(boolean visible) {
            if (this.myVisible == visible) {
                return;
            }
            this.modifying();
            this.myVisible = visible;
        }

        private final class Views
        extends BaseModel.BaseNamingFamily<View> {
            private Views(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Schema$Views", "<init>"));
                }
                super(owner);
            }

            @Override
            protected View instantiate() {
                return new View(this);
            }
        }

        private final class Tables
        extends BaseModel.BaseNamingFamily<Table> {
            private Tables(Schema owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Schema$Tables", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Table instantiate() {
                return new Table(this);
            }
        }
    }

    final class Root
    extends BaseModel.BaseRoot
    implements SQLiteModRoot {
        private final Schemas mySchemas = new Schemas(this);

        private Root() {
        }

        @Override
        @NotNull
        public Schemas getSchemas() {
            Schemas schemas = this.mySchemas;
            if (schemas == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/SQLiteImplModel$Root", "getSchemas"));
            }
            return schemas;
        }

        @Override
        @Nullable
        public ModFamily<? extends BasicModElement> familyOf(@NotNull ObjectKind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/impl/SQLiteImplModel$Root", "familyOf"));
            }
            if (kind == ObjectKind.SCHEMA) {
                return this.mySchemas;
            }
            return null;
        }

        private final class Schemas
        extends BaseModel.BaseNamingFamily<Schema> {
            private Schemas(Root owner) {
                if (owner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/SQLiteImplModel$Root$Schemas", "<init>"));
                }
                super(owner);
            }

            @Override
            protected Schema instantiate() {
                return new Schema(this);
            }
        }
    }
}

