/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModLikeTrigger;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresRule;
import com.intellij.database.model.properties.PostgresFireMode;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModRule
extends PostgresRule,
PostgresModLikeTrigger {
    @Override
    @NotNull
    public PostgresModLikeStoredTable getLikeStoredTable();

    @Override
    @NotNull
    default public PostgresModLikeStoredTable getDbParent() {
        PostgresModLikeStoredTable postgresModLikeStoredTable = this.getLikeStoredTable();
        if (postgresModLikeStoredTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModRule", "getDbParent"));
        }
        return postgresModLikeStoredTable;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRule> getParentFamily();

    @Override
    @NotNull
    default public PostgresModSchema getSchema() {
        PostgresModSchema postgresModSchema = this.getLikeStoredTable().getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModRule", "getSchema"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModRule", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModRule", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setTurn(@Nullable TrigTurn var1);

    @Override
    public void setEvents(@NotNull Set<TrigEvent> var1);

    @Override
    public void setCondition(@Nullable String var1);

    @Override
    public void setFireMode(@Nullable PostgresFireMode var1);

    public void setCommands(@NotNull List<String> var1);

    default public void setCommands(String ... commands) {
        this.setCommands(Arrays.asList(commands));
    }

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModRule", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String invalid = properties.get("Invalid");
        String stateNumber = properties.get("StateNumber");
        String turn = properties.get("Turn");
        String events = properties.get("Events");
        String condition = properties.get("Condition");
        String fireMode = properties.get("FireMode");
        String commands = properties.get("Commands");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (turn != null) {
            this.setTurn(PropertyConverter.importTrigTurn(turn));
        }
        if (events != null) {
            this.setEvents(PropertyConverter.importSetOfTrigEvent(events));
        }
        if (condition != null) {
            this.setCondition(PropertyConverter.importString(condition));
        }
        if (fireMode != null) {
            this.setFireMode(PropertyConverter.importPostgresFireMode(fireMode));
        }
        if (commands != null) {
            this.setCommands(PropertyConverter.importListOfString(commands));
        }
    }
}

