/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SQLiteModCheck;
import com.intellij.database.model.sqlite.SQLiteModForeignKey;
import com.intellij.database.model.sqlite.SQLiteModIndex;
import com.intellij.database.model.sqlite.SQLiteModKey;
import com.intellij.database.model.sqlite.SQLiteModLikeTable;
import com.intellij.database.model.sqlite.SQLiteModSchema;
import com.intellij.database.model.sqlite.SQLiteModTableColumn;
import com.intellij.database.model.sqlite.SQLiteModTrigger;
import com.intellij.database.model.sqlite.SQLiteTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SQLiteModTable
extends SQLiteTable,
SQLiteModLikeTable {
    @Override
    @NotNull
    public SQLiteModSchema getSchema();

    @Override
    @NotNull
    default public SQLiteModSchema getDbParent() {
        SQLiteModSchema sQLiteModSchema = this.getSchema();
        if (sQLiteModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SQLiteModTable", "getDbParent"));
        }
        return sQLiteModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends SQLiteModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends SQLiteModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingFamily<? extends SQLiteModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingFamily<? extends SQLiteModKey> getKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends SQLiteModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends SQLiteModCheck> getChecks();

    @NotNull
    public ModNamingFamily<? extends SQLiteModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SQLiteModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SQLiteModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    public void setTemporary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sqlite/SQLiteModTable", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String temporary = properties.get("Temporary");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (temporary != null) {
            this.setTemporary(PropertyConverter.importBoolean(temporary));
        }
    }
}

