/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanTreeNode
implements TreeNode {
    private final PlanModel.GenericNode myNode;
    private final PlanTreeNode myParent;
    private final List<PlanTreeNode> myChildren;

    public static PlanTreeNode create(@NotNull PlanModel.GenericNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/ui/PlanTreeNode", "create"));
        }
        return new PlanTreeNode(node);
    }

    private PlanTreeNode(@NotNull PlanModel.GenericNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/ui/PlanTreeNode", "<init>"));
        }
        this(node, null);
    }

    private PlanTreeNode(@NotNull PlanModel.GenericNode node, @Nullable PlanTreeNode parent) {
        PlanModel.GenericNode[] children;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/plan/ui/PlanTreeNode", "<init>"));
        }
        this.myNode = node;
        this.myParent = parent;
        this.myChildren = ContainerUtil.newArrayListWithCapacity((int)node.getChildren().length);
        for (PlanModel.GenericNode aChildren : children = node.getChildren()) {
            this.myChildren.add(new PlanTreeNode(aChildren, this));
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.myChildren.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.myChildren.size();
    }

    @Override
    public TreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.myChildren.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.myChildren.isEmpty();
    }

    public Enumeration children() {
        return Collections.enumeration(this.myChildren);
    }

    public PlanModel.GenericNode getNode() {
        return this.myNode;
    }

    public String toString() {
        return this.myNode.getType().toString() + " (" + this.myNode.getTitle() + ")";
    }
}

