/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbColumnImpl
extends DbElementImpl<DasColumn, DbTable>
implements DbColumn {
    public DbColumnImpl(DbTable parent, DasColumn delegate) {
        super(parent, delegate);
    }

    @NotNull
    public DataType getDataType() {
        DataType dataType = ((DasColumn)this.myDelegate).getDataType();
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbColumnImpl", "getDataType"));
        }
        return dataType;
    }

    @Nullable
    public DasUserDefinedType getCustomType() {
        return null;
    }

    public boolean isNotNull() {
        return ((DasColumn)this.myDelegate).isNotNull();
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder sb = super.getDocumentation();
        DdlBuilder.Colored colored = this.createDocBuilder(sb);
        String remarks = this.getComment();
        if (StringUtil.isNotEmpty((String)remarks)) {
            colored.plain("<br>").plain("-- " + remarks, DefaultLanguageHighlighterColors.LINE_COMMENT);
        }
        sb.append("<br><code><pre>");
        colored.element((DasObject)this);
        DasTableKey primaryKey = DasUtil.getPrimaryKey((DasTable)((DasTable)this.myParent));
        if (primaryKey != null && DasUtil.containsName((String)this.getName(), (MultiRef)primaryKey.getColumnsRef())) {
            colored.newLine();
            colored.key(primaryKey);
        }
        for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)((DasTable)this.myParent))) {
            if (!DasUtil.containsName((String)this.getName(), (MultiRef)key.getColumnsRef())) continue;
            colored.newLine();
            colored.foreignKey(key);
        }
        for (DasIndex o : DasUtil.getIndices((DasTable)((DasTable)this.myParent))) {
            if (!DasUtil.containsName((String)this.getName(), (MultiRef)o.getColumnsRef())) continue;
            colored.newLine();
            colored.index(o);
        }
        sb.append("</pre></code><br>");
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbColumnImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    public DbTable getTable() {
        return (DbTable)this.myParent;
    }

    public String getDefault() {
        return ((DasColumn)this.myDelegate).getDefault();
    }

    @Override
    public int getWeight() {
        return 10030;
    }
}

