/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbConstraint;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.find.findUsages.CustomUsageSearcher;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCustomUsageSearcher
extends CustomUsageSearcher
implements UsageTypeProvider {
    private static final UsageType SCHEMA_USAGE_TYPE = new UsageType(DatabaseMessages.message((String)"usage.type.schema", (Object[])new Object[0]));

    public void processElementUsages(@NotNull PsiElement element, @NotNull Processor<Usage> processor, @NotNull FindUsagesOptions options) {
        DbColumn column;
        DbTable table;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DbCustomUsageSearcher", "processElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbCustomUsageSearcher", "processElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/psi/DbCustomUsageSearcher", "processElementUsages"));
        }
        if (!(element instanceof DbElement)) {
            return;
        }
        DbElement target = (DbElement)element;
        ObjectKind targetKind = target.getKind();
        if (targetKind == ObjectKind.NONE) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbCustomUsageSearcher", "lambda$processElementUsages$0"));
            }
            for (DasObject c : target.getDataSource().getModel().traverser()) {
                ProgressManager.checkCanceled();
                if (DbCustomUsageSearcher.processCandidate((DbElement)c, target, targetKind, processor)) continue;
                return;
            }
        });
        if (element instanceof DbTable) {
            table = (DbTable)element;
            column = null;
        } else if (element instanceof DbColumn) {
            column = (DbColumn)element;
            table = column.getDbParent();
        } else {
            return;
        }
        if (table == null) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/psi/DbCustomUsageSearcher", "lambda$processElementUsages$1"));
            }
            DbCustomUsageSearcher.processKeysAndIndices(table.getDataSource(), table, column, processor);
        });
    }

    public UsageType getUsageType(PsiElement element) {
        if (element instanceof DbElement) {
            return SCHEMA_USAGE_TYPE;
        }
        return null;
    }

    private static boolean processCandidate(@NotNull DbElement candidate, @NotNull DbElement target, ObjectKind targetKind, Processor<Usage> processor) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/database/psi/DbCustomUsageSearcher", "processCandidate"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/psi/DbCustomUsageSearcher", "processCandidate"));
        }
        if (targetKind == ObjectKind.COLUMN) {
            if (candidate instanceof DbConstraint) {
                if (ContainerUtil.find((Iterable)((DbConstraint)candidate).getColumnsRef().resolveObjects(), (Object)target) != null && !processor.process((Object)DbCustomUsageSearcher.createUsage(candidate, target))) {
                    return false;
                }
                if (candidate instanceof DbForeignKey && ContainerUtil.find((Iterable)((DbForeignKey)candidate).getRefColumns().resolveObjects(), (Object)target) != null && !processor.process((Object)DbCustomUsageSearcher.createUsage(candidate, target))) {
                    return false;
                }
            } else if (candidate instanceof DbIndex && ContainerUtil.find((Iterable)((DbIndex)candidate).getColumnsRef().resolveObjects(), (Object)target) != null && !processor.process((Object)DbCustomUsageSearcher.createUsage(candidate, target))) {
                return false;
            }
        } else if (candidate instanceof DasSynonym && ((DasSynonym)candidate).resolveTarget() == target && !processor.process((Object)DbCustomUsageSearcher.createUsage(candidate, target))) {
            return false;
        }
        return true;
    }

    private static void processKeysAndIndices(@NotNull DbDataSource dataSource, final @NotNull DbTable table, final @Nullable DbColumn column, final Processor<Usage> consumer) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/psi/DbCustomUsageSearcher", "processKeysAndIndices"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/psi/DbCustomUsageSearcher", "processKeysAndIndices"));
        }
        final String colName = column == null ? null : column.getName();
        Processor<DasObject> processor = new Processor<DasObject>(){

            public boolean process(DasObject dbElement) {
                if (dbElement instanceof DbTable) {
                    DbTable t = (DbTable)dbElement;
                    if (column != null && table.equals(t)) {
                        DasTableKey primaryKey = DasUtil.getPrimaryKey((DasTable)t);
                        if (primaryKey != null && !this.process((DasObject)primaryKey)) {
                            return false;
                        }
                        if (!ContainerUtil.process((Iterable)DasUtil.getIndices((DasTable)t), (Processor)this)) {
                            return false;
                        }
                    }
                    if (!ContainerUtil.process((Iterable)DasUtil.getForeignKeys((DasTable)t), (Processor)this)) {
                        return false;
                    }
                } else if (dbElement instanceof DbTableKey) {
                    DbForeignKey fk;
                    DbTable refTable;
                    DbTableKey k = (DbTableKey)dbElement;
                    if (column != null && table.equals(k.getTable())) {
                        for (String c : k.getColumnsRef().names()) {
                            if (!Comparing.equal((String)colName, (String)c)) continue;
                            consumer.process((Object)DbCustomUsageSearcher.createUsage((DbElement)k, (DbElement)column));
                        }
                    }
                    if (k instanceof DbForeignKey && table.equals(refTable = (fk = (DbForeignKey)k).getRefTable())) {
                        if (column == null) {
                            consumer.process((Object)DbCustomUsageSearcher.createUsage((DbElement)fk, (DbElement)table));
                        } else {
                            for (String c : fk.getRefColumns().names()) {
                                if (!Comparing.equal((String)colName, (String)c)) continue;
                                consumer.process((Object)DbCustomUsageSearcher.createUsage((DbElement)fk, (DbElement)column));
                            }
                        }
                    }
                } else {
                    return ContainerUtil.process((Iterable)dbElement.getDbChildren(DbElement.class, ObjectKind.NONE), (Processor)this);
                }
                return true;
            }
        };
        ContainerUtil.process((Iterable)dataSource.getDbChildren(DbElement.class, ObjectKind.NONE), (Processor)processor);
    }

    private static Usage createUsage(@NotNull DbElement o, @NotNull DbElement resolveTo) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/psi/DbCustomUsageSearcher", "createUsage"));
        }
        if (resolveTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveTo", "com/intellij/database/psi/DbCustomUsageSearcher", "createUsage"));
        }
        return new MyUsage(o, resolveTo);
    }

    private static class MyUsage
    implements PsiElementUsage,
    UsagePresentation {
        private final TextChunk[] myChunks;
        private final String myText;
        private final DbElement myO;
        private final DbElement myNavigateTo;

        public MyUsage(@NotNull DbElement o, final @NotNull DbElement resolveTo) {
            DasTypedObject keyColumn;
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage", "<init>"));
            }
            if (resolveTo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveTo", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage", "<init>"));
            }
            final TextAttributes emptyAttrs = new TextAttributes();
            final ArrayList chunks = ContainerUtil.newArrayList();
            String text = new DdlBuilder.Colored(){

                @Override
                @NotNull
                public DdlBuilder.Colored ref(@Nullable DasObject object, String name) {
                    if (resolveTo.equals(object) || object == null && resolveTo instanceof DasColumn && Comparing.equal((String)resolveTo.getName(), (String)name)) {
                        this.pushStyle(new TextAttributes(null, null, null, null, 1));
                        super.ref(object, name);
                        DdlBuilder.Colored colored = this.popStyle();
                        if (colored == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage$1", "ref"));
                        }
                        return colored;
                    }
                    DdlBuilder.Colored colored = super.ref(object, name);
                    if (colored == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage$1", "ref"));
                    }
                    return colored;
                }

                @Override
                protected void setAttributes(TextAttributes attributes, boolean enabled) {
                }

                @Override
                @NotNull
                protected DdlBuilder.Colored append(@NotNull String text) {
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage$1", "append"));
                    }
                    TextAttributes attributes = (TextAttributes)this.myStack.peekLast();
                    chunks.add(new TextChunk(attributes == null ? emptyAttrs : attributes, text));
                    DdlBuilder.Colored colored = super.append(text);
                    if (colored == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage$1", "append"));
                    }
                    return colored;
                }
            }.configureFor(o).element((DasObject)o).getStatement();
            this.myO = o;
            if (StringUtil.isNotEmpty((String)text)) {
                this.myText = text;
            } else {
                this.myText = DbPresentation.getPresentableName((DasObject)o);
                chunks.add(new TextChunk(emptyAttrs, this.myText));
            }
            DbElement navigateTo = o instanceof DbForeignKey ? ((keyColumn = (DasTypedObject)Iterables.getFirst((Iterable)((DbForeignKey)o).getRefColumns().resolveObjects(), null)) instanceof DbElement ? (DbElement)keyColumn : this.myO.getDbParent()) : o;
            chunks.add(new TextChunk(SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes(), " (" + QNameUtil.getQualifiedName(this.myO.getDbParent()) + ")"));
            this.myChunks = chunks.toArray(new TextChunk[chunks.size()]);
            this.myNavigateTo = navigateTo;
        }

        @NotNull
        public UsagePresentation getPresentation() {
            MyUsage myUsage = this;
            if (myUsage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage", "getPresentation"));
            }
            return myUsage;
        }

        public boolean isValid() {
            return this.myO.isValid() && this.myNavigateTo.isValid();
        }

        public boolean isReadOnly() {
            return true;
        }

        public FileEditorLocation getLocation() {
            return null;
        }

        public void selectInEditor() {
        }

        public void highlightInEditor() {
        }

        public void navigate(boolean requestFocus) {
            DatabaseViewOptions viewOptions = DatabaseView.getDatabaseView(this.myNavigateTo.getProject()).getViewOptions();
            if (viewOptions.SHOW_TABLE_DETAILS) {
                this.myO.navigate(requestFocus);
            } else {
                this.myNavigateTo.navigate(requestFocus);
            }
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public PsiElement getElement() {
            return this.myO;
        }

        public boolean isNonCodeUsage() {
            return true;
        }

        @NotNull
        public TextChunk[] getText() {
            if (this.myChunks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage", "getText"));
            }
            return this.myChunks;
        }

        @NotNull
        public String getPlainText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbCustomUsageSearcher$MyUsage", "getPlainText"));
            }
            return string;
        }

        public Icon getIcon() {
            return this.myO.getIcon();
        }

        public String getTooltipText() {
            return this.myText;
        }
    }
}

