/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DbRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement psiElement = PsiElementRenameHandler.getElement((DataContext)dataContext);
        return psiElement instanceof DbElement && !DbRenameHandler.isVetoedElement((DbElement)psiElement);
    }

    private static boolean isVetoedElement(@NotNull DbElement dbElement) {
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/database/psi/DbRenameHandler", "isVetoedElement"));
        }
        if (dbElement instanceof DbDataSource) {
            return false;
        }
        DbElement parent = dbElement.getDbParent();
        ObjectKind kind = dbElement.getKind();
        ObjectKind pkind = parent == null ? null : parent.getKind();
        Object delegate = dbElement.getDelegate();
        if (delegate instanceof SqlElement) {
            return false;
        }
        if (pkind != ObjectKind.TABLE && kind == ObjectKind.COLUMN) {
            return true;
        }
        if (dbElement instanceof DasNamespace) {
            return true;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(dbElement);
        DatabaseEditorCapabilities.DbEditorCaps caps = dialect.getSchemaEditor().getDbEditorCaps();
        if (kind == ObjectKind.VIEW) {
            return !dialect.supportsRenameView();
        }
        if (dbElement instanceof DbRoutine) {
            return ((DbRoutine)dbElement).getPackageName() != null || !dialect.supportsRenameRoutine();
        }
        DatabaseEditorCapabilities.ObjectEditorCaps modifyCaps = caps.getModifyCaps(kind);
        return modifyCaps == null || !modifyCaps.getRename().isAvailable();
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        Object delegate;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/psi/DbRenameHandler", "invoke"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        Object object = delegate = element instanceof DbElement ? ((DbElement)element).getDelegate() : null;
        if (delegate instanceof PsiElement) {
            PsiElement[] psiElements = (PsiElement[])ContainerUtil.findAllAsArray(((DbElementImpl)element).getDelegates(), PsiElement.class);
            RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, psiElements, dataContext);
        } else if (delegate instanceof DasTable || delegate instanceof DasTableChild || delegate instanceof DasRoutine) {
            RefactoringActionHandlerFactory.getInstance().createRenameHandler().invoke(project, new PsiElement[]{element}, dataContext);
        } else if (element instanceof DbDataSource) {
            String initialName = ((DbDataSource)element).getName();
            String newName = Messages.showInputDialog((Project)project, (String)("Rename Data Source '" + initialName + "' to:"), (String)"Rename", (Icon)Messages.getQuestionIcon(), (String)initialName, null);
            if (StringUtil.isNotEmpty((String)newName)) {
                ((DbDataSource)element).setName(newName);
            }
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/psi/DbRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/psi/DbRenameHandler", "invoke"));
        }
        this.invoke(project, null, null, dataContext);
    }

    public static class DatabaseVetoRenameCondition
    implements Condition<PsiElement> {
        public boolean value(PsiElement element) {
            return element instanceof DbElement && DbRenameHandler.isVetoedElement((DbElement)element);
        }
    }
}

