/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.jar.Attributes;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleRunConfiguration
extends RunConfigurationBase
implements RunProfile {
    private static final ConfigurationType TYPE = new UnknownConfigurationType(){

        public Icon getIcon() {
            return AllIcons.RunConfigurations.Ql_console;
        }
    };
    public static final ConfigurationFactory FACTORY = new ConfigurationFactory(TYPE){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ConsoleRunConfiguration$2", "createTemplateConfiguration"));
            }
            ConsoleRunConfiguration consoleRunConfiguration = new ConsoleRunConfiguration(project, "Default");
            if (consoleRunConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleRunConfiguration$2", "createTemplateConfiguration"));
            }
            return consoleRunConfiguration;
        }
    };
    public String VM_PARAMETERS;
    public Map<String, String> VM_ENV;

    @NotNull
    public static ConsoleRunConfiguration newConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ConsoleRunConfiguration", "newConfiguration"));
        }
        ConsoleRunConfiguration consoleRunConfiguration = (ConsoleRunConfiguration)FACTORY.createTemplateConfiguration(project);
        if (consoleRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleRunConfiguration", "newConfiguration"));
        }
        return consoleRunConfiguration;
    }

    public ConsoleRunConfiguration(Project project, String name) {
        super(project, FACTORY, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        throw new UnsupportedOperationException();
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/database/run/ConsoleRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/database/run/ConsoleRunConfiguration", "getState"));
        }
        if (!(env.getRunnerSettings() instanceof RunContext)) {
            throw new ExecutionException(DatabaseMessages.message((String)"console.run.configuration.no.context.specified", (Object[])new Object[0]));
        }
        return new CommandLineState(env){

            private SimpleJavaParameters createJavaParameters() throws ExecutionException {
                Sdk contextJdk;
                RunContext runContext = (RunContext)ObjectUtils.notNull((Object)this.getEnvironment().getRunnerSettings());
                Module module = runContext.getModule();
                Project project = ConsoleRunConfiguration.this.getProject();
                if (project.isDisposed() || module != null && module.isDisposed()) {
                    throw new ExecutionException("Execution cancelled");
                }
                SimpleJavaParameters params2 = new SimpleJavaParameters();
                params2.setCharset(EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
                ParametersList vm = params2.getVMParametersList();
                vm.addParametersString(ConsoleRunConfiguration.this.VM_PARAMETERS);
                if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")))) {
                    vm.add("-Djava.net.preferIPv4Stack=true");
                }
                if (ConsoleRunConfiguration.this.VM_ENV != null) {
                    for (Map.Entry<String, String> entry : ConsoleRunConfiguration.this.VM_ENV.entrySet()) {
                        params2.addEnv(entry.getKey(), entry.getValue());
                    }
                }
                Sdk projectJdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
                Sdk ideaJdk = new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome());
                runContext.collectClassPath(params2.getClassPath());
                if (module != null) {
                    Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    VirtualFile homeDirectory = jdk == null ? null : jdk.getHomeDirectory();
                    contextJdk = homeDirectory == null || !homeDirectory.isValid() ? projectJdk : jdk;
                } else {
                    contextJdk = projectJdk;
                }
                params2.setJdk(ConsoleRunConfiguration.getMaxJdk(ideaJdk, contextJdk));
                params2.setWorkingDirectory(PathManager.getBinPath());
                params2.setMainClass(runContext.getMainClassName());
                runContext.tuneParams(params2);
                params2.setUseDynamicClasspath(JdkUtil.useDynamicClasspath((Project)project));
                return params2;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/database/run/ConsoleRunConfiguration$3", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/database/run/ConsoleRunConfiguration$3", "execute"));
                }
                OSProcessHandler processHandler = this.startProcess();
                DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult(null, (ProcessHandler)processHandler, AnAction.EMPTY_ARRAY);
                if (defaultExecutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleRunConfiguration$3", "execute"));
                }
                return defaultExecutionResult;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler oSProcessHandler = ((SimpleJavaParameters)ReadAction.compute(() -> this.createJavaParameters())).createOSProcessHandler();
                if (oSProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ConsoleRunConfiguration$3", "startProcess"));
                }
                return oSProcessHandler;
            }
        };
    }

    private static Sdk getMaxJdk(Sdk ideaJdk, Sdk contextJdk) {
        if (contextJdk == null) {
            return ideaJdk;
        }
        String ideaVersion = JdkUtil.getJdkMainAttribute((Sdk)ideaJdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        String contextVersion = JdkUtil.getJdkMainAttribute((Sdk)contextJdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return Comparing.compare((Comparable)((Object)contextVersion), (Comparable)((Object)ideaVersion)) <= 0 ? ideaJdk : contextJdk;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
    }

    public void readExternal(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
    }

    public void setOptionsFromDataSource(LocalDataSource dataSource) {
        ParametersList params2 = new ParametersList();
        params2.addParametersString(dataSource.getVmOptions());
        String tns_admin = dataSource.getAdditionalJdbcProperties().get("TNSADMIN_DIR");
        if (tns_admin != null) {
            params2.replaceOrAppend("-Doracle.net.tns_admin=", "-Doracle.net.tns_admin=" + tns_admin);
        }
        this.VM_PARAMETERS = params2.getParametersString();
        this.VM_ENV = ContainerUtil.newLinkedHashMap(dataSource.getVmEnv());
    }

    public ConsoleRunConfiguration clone() {
        ConsoleRunConfiguration result = (ConsoleRunConfiguration)super.clone();
        result.VM_PARAMETERS = this.VM_PARAMETERS;
        result.VM_ENV = this.VM_ENV == null ? null : ContainerUtil.newLinkedHashMap(this.VM_ENV);
        return result;
    }

    public static interface RunContext
    extends RunnerSettings {
        @Nullable
        public Module getModule();

        public String getMainClassName();

        public void collectClassPath(PathsList var1) throws ExecutionException;

        public void tuneParams(@NotNull SimpleJavaParameters var1) throws ExecutionException;

        default public void readExternal(Element element) throws InvalidDataException {
        }

        default public void writeExternal(Element element) throws WriteExternalException {
        }
    }
}

