/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EditValueAction
extends AnAction
implements DumbAware,
GridAction {
    public EditValueAction() {
        super(null, null, null);
        this.setEnabledInModalContext(true);
    }

    public void update(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String text = this.getText(!dataGrid.isEditable());
        String description = this.getDescription(!dataGrid.isEditable());
        boolean visible = ActionPlaces.isPopupPlace((String)e.getPlace());
        e.getPresentation().setText(text);
        e.getPresentation().setDescription(description);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(this.isEnabled(dataGrid));
    }

    boolean isEnabled(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/EditValueAction", "isEnabled"));
        }
        return grid.isCellEditingAllowed() && grid.isReady() && !grid.isEditing() && EditValueAction.isSelectedColumnsEditable(grid);
    }

    private static boolean isSelectedColumnsEditable(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/EditValueAction", "isSelectedColumnsEditable"));
        }
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        List columns = model.getColumns(grid.getSelectionModel().getSelectedColumns());
        return JBIterable.from(columns).filter(DbImplUtil::isComputedColumn).size() == 0;
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null) {
            dataGrid.editSelectedCell();
        }
    }

    protected String getText(boolean viewMode) {
        return viewMode ? "View" : "Edit";
    }

    protected String getDescription(boolean viewMode) {
        return (viewMode ? "View" : "Edit") + " selected cell";
    }
}

