/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ParameterizedRunnable;

public abstract class ScriptProcessAction
extends DumbAwareAction {
    private final ConsoleDataRequest.Decision myFeedback;

    public ScriptProcessAction(ConsoleDataRequest.Decision feedback) {
        super(null, null, null);
        this.myFeedback = feedback;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(ScriptProcessAction.getExecutionFeedbackListener(e.getDataContext()) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ParameterizedRunnable<ConsoleDataRequest.Decision> efl = ScriptProcessAction.getExecutionFeedbackListener(e.getDataContext());
        if (efl != null) {
            efl.run((Object)this.myFeedback);
        }
    }

    private static ParameterizedRunnable<ConsoleDataRequest.Decision> getExecutionFeedbackListener(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        ConsoleDataRequest.ErrorPanelInfo epInfo = (ConsoleDataRequest.ErrorPanelInfo)ConsoleDataRequest.QL_ERROR_PANEL_INFO_KEY.get((UserDataHolder)editor);
        return epInfo != null ? epInfo.getExecutionFeedbackListener() : null;
    }

    public static class Stop
    extends ScriptProcessAction {
        public Stop() {
            super(ConsoleDataRequest.Decision.STOP);
        }
    }

    public static class Retry
    extends ScriptProcessAction {
        public Retry() {
            super(ConsoleDataRequest.Decision.RETRY);
        }
    }

    public static class IgnoreAll
    extends ScriptProcessAction {
        public IgnoreAll() {
            super(ConsoleDataRequest.Decision.IGNORE_ALL);
        }
    }

    public static class Ignore
    extends ScriptProcessAction {
        public Ignore() {
            super(ConsoleDataRequest.Decision.IGNORE);
        }
    }
}

