/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationColumn;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.TableResultView;
import com.intellij.database.run.ui.grid.GridSelection;
import com.intellij.openapi.Disposable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMutationModel
implements GridModel<DataConsumer.Row, DataConsumer.Column>,
GridDataSupport {
    private final GridMutator<DataConsumer.Row, DataConsumer.Column> myMutator;
    private final TableResultPanel myGrid;
    private final GridModel<DataConsumer.Row, DataConsumer.Column> myModel;
    private final TableResultView myView;

    public GridMutationModel(@Nullable GridMutator<DataConsumer.Row, DataConsumer.Column> mutator, @NotNull TableResultPanel grid, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, @NotNull TableResultView view2) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/GridMutationModel", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/run/ui/grid/GridMutationModel", "<init>"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/run/ui/grid/GridMutationModel", "<init>"));
        }
        this.myMutator = mutator;
        this.myGrid = grid;
        this.myModel = model;
        this.myView = view2;
    }

    @Override
    public void revert(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/GridMutationModel", "revert"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/grid/GridMutationModel", "revert"));
        }
        if (this.getDatabaseMutator() == null) {
            return;
        }
        DataGridRequestSource requestSource = new DataGridRequestSource(rows, columns);
        GridRequestSource<DataConsumer.Row, DataConsumer.Column> source = GridRequestSource.create(this.myGrid, (Object)requestSource);
        GridSelection selection = GridSelection.store((JTable)((Object)this.myView));
        this.getDatabaseMutator().revert(source, rows, columns);
        this.myGrid.getAutoscrollLocker().runWithLock(() -> selection.restore((JTable)((Object)this.myView)));
    }

    @Override
    public void finishBuildingAndApply(@NotNull List<CellMutation.Builder> builders) {
        List<CellMutation> mutations;
        if (builders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builders", "com/intellij/database/run/ui/grid/GridMutationModel", "finishBuildingAndApply"));
        }
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        List<CellMutation> list = mutations = mutator == null ? ContainerUtil.map(builders, CellMutation.Builder::build) : builders.stream().map(builder -> builder.type(builder.getRow() != null && mutator.isInsertedRow(builder.getRow()) ? MutationType.INSERT : MutationType.MODIFY)).map(CellMutation.Builder::build).collect(Collectors.toList());
        if (this.myMutator != null) {
            this.myMutator.mutate(GridRequestSource.create(this.myGrid, (Object)new DataGridRequestSource(this.myGrid)), mutations);
        }
    }

    @Override
    public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/GridMutationModel", "isDeletedRows"));
        }
        return this.getRowsMutator() != null && this.getRowsMutator().isDeletedRows(rows);
    }

    @Override
    public boolean hasPendingChanges() {
        return this.hasMutator() && ((GridMutator)ObjectUtils.assertNotNull(this.myMutator)).hasPendingChanges();
    }

    @Override
    public boolean hasMutator() {
        return this.myMutator != null;
    }

    @Override
    public boolean hasRowMutator() {
        return this.getRowsMutator() != null;
    }

    @Override
    public boolean canRevert() {
        return this.getDatabaseMutator() != null;
    }

    @Override
    public boolean isSubmitImmediately() {
        return this.myMutator != null && this.myMutator.isUpdateImmediately();
    }

    @Override
    @NotNull
    public List<DataConsumer.Column> getColumns() {
        List<DataConsumer.Column> list = this.wrap(this.myModel.getColumns());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getColumns"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<DataConsumer.Column> getColumns(@NotNull ModelIndexSet<DataConsumer.Column> columnsIdxs) {
        if (columnsIdxs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsIdxs", "com/intellij/database/run/ui/grid/GridMutationModel", "getColumns"));
        }
        List<DataConsumer.Column> list = this.wrap(this.myModel.getColumns(columnsIdxs));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getColumns"));
        }
        return list;
    }

    @Override
    @Nullable
    public DataConsumer.Column getColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/grid/GridMutationModel", "getColumn"));
        }
        return (DataConsumer.Column)ContainerUtil.getFirstItem(this.wrap(ContainerUtil.list((Object[])new DataConsumer.Column[]{this.myModel.getColumn(columnIdx)})));
    }

    @Override
    @NotNull
    public List<DataConsumer.Row> getRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/GridMutationModel", "getRows"));
        }
        List<DataConsumer.Row> list = this.myModel.getRows();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getRows"));
        }
        return list;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<DataConsumer.Row> row, ModelIndex<DataConsumer.Column> column) {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        MutationData value = mutator == null ? null : mutator.getMutation(row, column);
        return value == null ? this.myModel.getValueAt(row, column) : value.getValue();
    }

    @Override
    public boolean allValuesEqualTo(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, Object what) {
        ModelIndexSet<DataConsumer.Column> realColumns;
        if (rowIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIndices", "com/intellij/database/run/ui/grid/GridMutationModel", "allValuesEqualTo"));
        }
        if (columnIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIndices", "com/intellij/database/run/ui/grid/GridMutationModel", "allValuesEqualTo"));
        }
        ModelIndexSet<DataConsumer.Row> realRows = this.getRealRows(rowIndices);
        return this.myModel.allValuesEqualTo(realRows, realColumns = this.getRealColumns(columnIndices), what) && (this.getDatabaseMutator() == null || !this.getDatabaseMutator().hasMutatedRows(realRows, realColumns));
    }

    @Override
    public boolean allValuesEqualTo(@NotNull List<CellMutation> mutations) {
        if (mutations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutations", "com/intellij/database/run/ui/grid/GridMutationModel", "allValuesEqualTo"));
        }
        return this.myModel.allValuesEqualTo(mutations);
    }

    @Override
    @Nullable
    public DataConsumer.Row getRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/GridMutationModel", "getRow"));
        }
        return this.myModel.getRow(row);
    }

    @Override
    @NotNull
    public List<DataConsumer.Row> getRows() {
        List<DataConsumer.Row> list = this.myModel.getRows();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getRows"));
        }
        return list;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getColumnIndices() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.myModel.getColumnIndices();
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getColumnIndices"));
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getRowIndices() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.myModel.getRowIndices();
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getRowIndices"));
        }
        return modelIndexSet;
    }

    @Override
    public int getColumnCount() {
        return this.myModel.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.myModel.getRowCount();
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/run/ui/grid/GridMutationModel", "isValidRowIdx"));
        }
        return this.myModel.isValidRowIdx(rowIdx);
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIdx", "com/intellij/database/run/ui/grid/GridMutationModel", "isValidColumnIdx"));
        }
        return this.myModel.isValidColumnIdx(columnIdx);
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myModel.isUpdatingNow();
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<DataConsumer.Row, DataConsumer.Column> l, @NotNull Disposable disposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/run/ui/grid/GridMutationModel", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/run/ui/grid/GridMutationModel", "addListener"));
        }
        this.myModel.addListener(l, disposable);
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myMutator, GridMutator.DatabaseMutator.class);
    }

    @NotNull
    private ModelIndexSet<DataConsumer.Row> getRealRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/grid/GridMutationModel", "getRealRows"));
        }
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.myView.isMultiEditingAllowed() ? this.myGrid.getSelectionModel().getSelectedRows() : rows;
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getRealRows"));
        }
        return modelIndexSet;
    }

    @NotNull
    private ModelIndexSet<DataConsumer.Column> getRealColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/grid/GridMutationModel", "getRealColumns"));
        }
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.myView.isMultiEditingAllowed() ? this.myGrid.getSelectionModel().getSelectedColumns() : columns;
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "getRealColumns"));
        }
        return modelIndexSet;
    }

    @NotNull
    private List<DataConsumer.Column> wrap(@NotNull List<DataConsumer.Column> columns) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/run/ui/grid/GridMutationModel", "wrap"));
        }
        List<DataConsumer.Column> list = this.getDatabaseMutator() == null ? columns : columns.stream().map(column -> column == null ? null : new MutationColumn((DataConsumer.Column)column, this.getDatabaseMutator(), this.myGrid)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridMutationModel", "wrap"));
        }
        return list;
    }
}

