/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GridTransferableData
implements Transferable {
    public static final DataFlavor ourFlavor = new DataFlavor(GridTransferableData.class, "Cells");
    private final List<DataTypeConversion.Builder> myConversions;
    private final Transferable myTransferable;
    private final int myFirstRowIdx;
    private final int myFirstColumnIdx;

    public GridTransferableData(@NotNull List<DataTypeConversion.Builder> conversions, @NotNull Transferable transferable, int firstRowIdx, int firstColumnIdx) {
        if (conversions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conversions", "com/intellij/database/run/ui/grid/GridTransferableData", "<init>"));
        }
        if (transferable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferable", "com/intellij/database/run/ui/grid/GridTransferableData", "<init>"));
        }
        this.myConversions = conversions;
        this.myTransferable = transferable;
        this.myFirstRowIdx = firstRowIdx;
        this.myFirstColumnIdx = firstColumnIdx;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])ArrayUtil.mergeArrays((Object[])ContainerUtil.ar((Object[])new DataFlavor[]{ourFlavor}), (Object[])this.myTransferable.getTransferDataFlavors());
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == ourFlavor || this.myTransferable.isDataFlavorSupported(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return flavor == ourFlavor ? this : this.myTransferable.getTransferData(flavor);
    }

    @NotNull
    public List<DataTypeConversion.Builder> getConversions() {
        List<DataTypeConversion.Builder> list = this.myConversions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/GridTransferableData", "getConversions"));
        }
        return list;
    }

    public int getFirstRowIdx() {
        return this.myFirstRowIdx;
    }

    public int getFirstColumnIdx() {
        return this.myFirstColumnIdx;
    }
}

