/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.util.text.StringUtil;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class TokenPattern {
    private final RunAutomaton myAutomaton;
    private final Pattern myPattern;
    private static MatchMethod ourMethod = MatchMethod.BRICS;

    public TokenPattern(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/util/TokenPattern", "<init>"));
        }
        try {
            this.myAutomaton = new RunAutomaton(new RegExp(new BricsRegexConverter(pattern).getBrics()).toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider()));
        }
        catch (IllegalArgumentException e) {
            throw new PatternSyntaxException(e.getMessage(), pattern, 0);
        }
        this.myPattern = Pattern.compile(pattern);
    }

    public Matcher newMatcher() {
        return new Matcher();
    }

    public static void setMatchMethod(MatchMethod m) {
        ourMethod = m;
    }

    private static class BricsRegexConverter {
        private StringBuilder myResult = new StringBuilder();
        private CharSequence myPattern;
        private int myIndex = 0;

        public BricsRegexConverter(CharSequence pattern) {
            this.myPattern = pattern;
            this.process();
        }

        private void process() {
            while (this.processOne()) {
            }
        }

        public String getBrics() {
            return this.myResult.toString();
        }

        private boolean processOne() {
            if (this.myIndex >= this.myPattern.length()) {
                return false;
            }
            char c = this.myPattern.charAt(this.myIndex);
            switch (c) {
                case ')': {
                    return false;
                }
                case '(': {
                    this.processGroup();
                    break;
                }
                case '[': {
                    this.processClass();
                    break;
                }
                case '\\': {
                    this.processEscape();
                    break;
                }
                default: {
                    this.processChar();
                }
            }
            return true;
        }

        private void processChar() {
            char c = this.myPattern.charAt(this.myIndex);
            if (c == '#' || c == '@' || c == '\"' || c == '<') {
                this.escaped(c);
            } else {
                this.myResult.append(c);
            }
            ++this.myIndex;
        }

        private void processEscape() {
            ++this.myIndex;
            if (this.myIndex >= this.myPattern.length()) {
                this.myResult.append("\\");
                return;
            }
            char c = this.myPattern.charAt(this.myIndex);
            ++this.myIndex;
            switch (c) {
                case 'D': 
                case 'd': {
                    this.charClass("0-9", c == 'd');
                    break;
                }
                case 'S': 
                case 's': {
                    this.charClassNamed("whitespacechar", c == 's');
                    break;
                }
                case 'W': 
                case 'w': {
                    this.charClass("a-zA-Z_0-9", c == 'w');
                    break;
                }
                case 'p': {
                    int end;
                    int b = this.myIndex < this.myPattern.length() ? (int)this.myPattern.charAt(this.myIndex) : 65535;
                    int n = end = b != 123 ? -1 : StringUtil.indexOf((CharSequence)this.myPattern, (char)'}', (int)this.myIndex);
                    if (end == -1) {
                        this.escaped(c);
                    } else {
                        this.charClassNamed(this.myPattern.subSequence(this.myIndex + 1, end), true);
                        this.myIndex = end + 1;
                    }
                }
                default: {
                    this.escaped(c);
                }
            }
        }

        private void processClass() {
            boolean found;
            int end = StringUtil.indexOf((CharSequence)this.myPattern, (char)']', (int)this.myIndex);
            boolean bl = found = end != -1;
            if (!found) {
                end = this.myPattern.length();
            }
            ++this.myIndex;
            this.myResult.append('[');
            while (this.myIndex < end) {
                char c = this.myPattern.charAt(this.myIndex);
                if (c == '&' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '#' || c == '@' || c == '.') {
                    this.escaped(c);
                } else {
                    this.myResult.append(c);
                }
                ++this.myIndex;
            }
            this.myResult.append(']');
            this.myIndex = end + 1;
        }

        private void processGroup() {
            ++this.myIndex;
            boolean discard = false;
            int state = this.myResult.length();
            if (this.myPattern.length() > this.myIndex && this.myPattern.charAt(this.myIndex) == '?') {
                ++this.myIndex;
                discard = this.myPattern.length() > this.myIndex && this.myPattern.charAt(this.myIndex) != ':';
                ++this.myIndex;
            }
            this.myResult.append("(");
            this.process();
            if (this.myPattern.length() > this.myIndex && this.myPattern.charAt(this.myIndex) == ')') {
                this.myResult.append(")");
                ++this.myIndex;
            }
            if (discard) {
                this.myResult.setLength(state);
            }
        }

        private void charClass(CharSequence cl, boolean positive) {
            this.myResult.append("[");
            if (!positive) {
                this.myResult.append("^");
            }
            this.myResult.append(cl);
            this.myResult.append("]");
        }

        private void charClassNamed(CharSequence cl, boolean positive) {
            if (!positive) {
                this.myResult.append("~");
            }
            this.myResult.append("<");
            this.myResult.append(cl);
            this.myResult.append(">");
        }

        private void escaped(char c) {
            this.myResult.append("\\").append(c);
        }
    }

    public static enum MatchMethod {
        BRICS,
        JAVA,
        BOTH;

    }

    public class Matcher {
        private CharSequence myBuffer;
        private MatchResult myResult;

        public void reset(CharSequence buffer) {
            this.myBuffer = buffer;
            this.myResult = null;
        }

        public int start() {
            return this.myResult.start();
        }

        public int end() {
            return this.myResult.end();
        }

        public boolean find(int start, int end) {
            start = Math.min(start, this.myBuffer.length());
            end = Math.min(end, this.myBuffer.length());
            if (ourMethod == MatchMethod.BRICS || ourMethod == MatchMethod.BOTH) {
                AutomatonMatcher matcher = TokenPattern.this.myAutomaton.newMatcher(this.myBuffer, start, end);
                this.myResult = null;
                while (matcher.find()) {
                    this.processCaptures(start + matcher.start(), start + matcher.end());
                    if (this.myResult == null) continue;
                }
                if (ourMethod == MatchMethod.BOTH) {
                    java.util.regex.Matcher javaMatcher = TokenPattern.this.myPattern.matcher(this.myBuffer).region(start, end);
                    javaMatcher.useAnchoringBounds(false);
                    javaMatcher.useTransparentBounds(true);
                    boolean res = javaMatcher.find();
                    assert (res == (this.myResult != null));
                    if (res) {
                        assert (this.myResult.start() == javaMatcher.start());
                        assert (this.myResult.end() == javaMatcher.end());
                    }
                }
                return this.myResult != null;
            }
            if (ourMethod == MatchMethod.JAVA) {
                java.util.regex.Matcher matcher = TokenPattern.this.myPattern.matcher(this.myBuffer).region(start, end);
                matcher.useAnchoringBounds(false);
                matcher.useTransparentBounds(true);
                boolean found = matcher.find();
                this.myResult = found ? matcher : null;
                return found;
            }
            return false;
        }

        private boolean processCaptures(int start, int end) {
            java.util.regex.Matcher matcher = TokenPattern.this.myPattern.matcher(this.myBuffer).region(start, end);
            matcher.useAnchoringBounds(false);
            matcher.useTransparentBounds(true);
            if (matcher.lookingAt()) {
                this.myResult = matcher;
                return true;
            }
            return false;
        }

        public MatchResult getResult() {
            return this.myResult;
        }
    }
}

