/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.generators;

import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.generators.Clipboard;
import com.intellij.database.view.generators.Files;
import com.intellij.database.view.generators.Logger;
import com.intellij.database.view.generators.SchemaScriptBindings;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;

public class SchemaScripts {
    private static final String SCRIPT_DIR = "schema";

    private SchemaScripts() {
    }

    @NotNull
    public static List<VirtualFile> getScriptFiles() {
        List list;
        try {
            VirtualFile scriptDir = SchemaScripts.getScriptsDirectoryImpl(false);
            Object[] scriptDirChildren = scriptDir != null ? scriptDir.getChildren() : VirtualFile.EMPTY_ARRAY;
            list = ContainerUtil.filter((Object[])scriptDirChildren, (Condition)ExtensionsRootType.regularFileFilter());
        }
        catch (IOException iOException) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/SchemaScripts", "getScriptFiles"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/SchemaScripts", "getScriptFiles"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile getScriptsDirectory() {
        try {
            return SchemaScripts.getScriptsDirectoryImpl(true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    private static VirtualFile getScriptsDirectoryImpl(boolean createIfMissing) throws IOException {
        return ExtensionsRootType.getInstance().findResourceDirectory(DatabasePluginId.get(), SCRIPT_DIR, createIfMissing);
    }

    public static boolean areAvailableIn(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/generators/SchemaScripts", "areAvailableIn"));
        }
        boolean inDatabaseView = DatabaseView.DATABASE_VIEW_KEY.getData(context) != null;
        return inDatabaseView && !SchemaScripts.getSelection(context).isEmpty();
    }

    public static void runScript(@NotNull DataContext context, final @NotNull VirtualFile scriptFile) {
        JBIterable selection;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/generators/SchemaScripts", "runScript"));
        }
        if (scriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFile", "com/intellij/database/view/generators/SchemaScripts", "runScript"));
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        final IdeScriptEngine engine = SchemaScripts.prepareEngine(project, scriptFile, (JBIterable<DasObject>)(selection = JBIterable.from(SchemaScripts.getSelection(context))));
        if (engine == null) {
            return;
        }
        ExtensionScriptsUtil.prepareScript(scriptFile);
        Task.Backgroundable task = new Task.Backgroundable(project, "Running '" + scriptFile.getName() + "'", true){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/generators/SchemaScripts$1", "run"));
                }
                if (project != null && project.isDisposed() || selection.find(o -> !((DbElement)o).isValid()) != null) {
                    return;
                }
                try {
                    String script = ExtensionScriptsUtil.loadScript(project, scriptFile);
                    ExtensionScriptsUtil.evalScript(project, engine, script);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    private static IdeScriptEngine prepareEngine(@Nullable Project project, @NotNull VirtualFile scriptFile, @NotNull JBIterable<DasObject> selection) {
        if (scriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFile", "com/intellij/database/view/generators/SchemaScripts", "prepareEngine"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/database/view/generators/SchemaScripts", "prepareEngine"));
        }
        IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor(project, scriptFile);
        if (engine != null) {
            ExtensionScriptsUtil.setBindings(engine).bind(SchemaScriptBindings.PROJECT, project).bind(SchemaScriptBindings.SELECTION, selection).bind(SchemaScriptBindings.CLIPBOARD, new ClipboardImpl()).bind(SchemaScriptBindings.LOG, new LoggerImpl(engine)).bind(SchemaScriptBindings.FILES, new FilesImpl(project));
        }
        return engine;
    }

    @NotNull
    private static Set<DbElement> getSelection(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/generators/SchemaScripts", "getSelection"));
        }
        Set<DbElement> set = DatabaseView.getSelectedElements(context, DbElement.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/SchemaScripts", "getSelection"));
        }
        return set;
    }

    private static class FilesImpl
    implements Files {
        private final Project myProject;

        private FilesImpl(@Nullable Project project) {
            this.myProject = project;
        }

        public void chooseFileAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseFileAndSave"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseFileAndSave"));
            }
            if (saveAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseFileAndSave"));
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor(title, description, new String[0]);
            this.chooseFileAndSaveImpl((FileChooserDescriptor)descriptor, saveAction);
        }

        public void chooseDirectoryAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseDirectoryAndSave"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseDirectoryAndSave"));
            }
            if (saveAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseDirectoryAndSave"));
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title).withDescription(description);
            this.chooseFileAndSaveImpl(descriptor, saveAction);
        }

        public void refresh(@NotNull File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "refresh"));
            }
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
        }

        private void chooseFileAndSaveImpl(@NotNull FileChooserDescriptor descriptor, @NotNull Consumer<File> saveAction) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseFileAndSaveImpl"));
            }
            if (saveAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "chooseFileAndSaveImpl"));
            }
            Ref fileRef = Ref.create();
            Runnable runnable = () -> {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/view/generators/SchemaScripts$FilesImpl", "lambda$chooseFileAndSaveImpl$1"));
                }
                FileChooserFactory.getInstance().createPathChooser(descriptor, this.myProject, null).choose(null, files -> fileRef.set(ContainerUtil.getFirstItem((List)files)));
            };
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)runnable);
                if (!fileRef.isNull()) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)fileRef.get()));
                    saveAction.consume((Object)file);
                    this.refresh(file);
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class LoggerImpl
    implements Logger {
        private final IdeScriptEngine myEngine;

        private LoggerImpl(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/database/view/generators/SchemaScripts$LoggerImpl", "<init>"));
            }
            this.myEngine = engine;
        }

        public void print(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/view/generators/SchemaScripts$LoggerImpl", "print"));
            }
            try {
                this.myEngine.getStdOut().append(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void error(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/view/generators/SchemaScripts$LoggerImpl", "error"));
            }
            this.error(message, null);
        }

        public void error(@NotNull String message, @Nullable Throwable th) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/view/generators/SchemaScripts$LoggerImpl", "error"));
            }
            try {
                Writer err = this.myEngine.getStdErr();
                err.append(message).append("\n");
                if (th != null) {
                    err.append(ExceptionUtil.getThrowableText((Throwable)th));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ClipboardImpl
    implements Clipboard {
        private ClipboardImpl() {
        }

        @NotNull
        public String get() {
            String string;
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                string = contents != null ? (String)contents.getTransferData(DataFlavor.stringFlavor) : "";
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/SchemaScripts$ClipboardImpl", "get"));
            }
            return string;
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/SchemaScripts$ClipboardImpl", "get"));
            }
            return "";
        }

        public void set(@Nullable String text) {
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(StringUtil.notNullize((String)text)));
        }
    }
}

