/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.JBIterable;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class EditorModelBase {
    public final EditorModelsCache modelsCache;
    private final DeModel myModel;
    private final EventDispatcher<Listener> myDispatcher;
    private boolean myModified;

    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelBase", "getModel"));
        }
        return deModel;
    }

    @NotNull
    public JBIterable<? extends DeObject> getEditedObjects() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelBase", "getEditedObjects"));
        }
        return jBIterable;
    }

    public EditorModelBase(@NotNull DeModel model, @NotNull EditorModelsCache modelsCache) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/models/EditorModelBase", "<init>"));
        }
        if (modelsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsCache", "com/intellij/database/view/models/EditorModelBase", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModel = model;
        this.modelsCache = modelsCache;
    }

    @NotNull
    public SchemaExportHelper getExportHelper() {
        SchemaExportHelper schemaExportHelper = this.myModel.getExportHelper();
        if (schemaExportHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/EditorModelBase", "getExportHelper"));
        }
        return schemaExportHelper;
    }

    public void addListener(@NotNull Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/models/EditorModelBase", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/view/models/EditorModelBase", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void commit() {
        if (this.isModified()) {
            this.myModified = false;
            ((Listener)this.myDispatcher.getMulticaster()).changed();
        }
    }

    protected void modify() {
        this.myModified = true;
    }

    public static interface Listener
    extends EventListener {
        public void changed();
    }
}

