/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntrospectionScopes {
    public static final IntrospectionScope CURRENT_SCOPE = new IntrospectionScope.SingleDBScope("@", (ImmutableSet<String>)ImmutableSet.of((Object)"@"), false);
    public static final IntrospectionScope EMPTY_SCOPE = new IntrospectionScope.EmptyScope();
    public static final IntrospectionScope ALL_SCOPE = new IntrospectionScope.AllScope();

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull Collection<String> schemas) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        boolean resolved = !IntrospectionScope.isWildcard(database) && !IntrospectionScope.containsWildcards(schemas);
        IntrospectionScope.SingleDBScope singleDBScope = new IntrospectionScope.SingleDBScope(database, (ImmutableSet<String>)ImmutableSet.copyOf(schemas), resolved);
        if (singleDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return singleDBScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull String database, @NotNull String schema) {
        boolean resolved;
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        boolean bl = resolved = !IntrospectionScope.isWildcard(database) && !IntrospectionScope.isWildcard(schema);
        if (!resolved) {
            if (database.equals("@") && schema.equals("@")) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfCurrent();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
                }
                return introspectionScope;
            }
            if (database.equals("*") && schema.equals("*")) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfAll();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
                }
                return introspectionScope;
            }
        }
        IntrospectionScope.SingleDBScope singleDBScope = new IntrospectionScope.SingleDBScope(database, (ImmutableSet<String>)ImmutableSet.of((Object)schema), resolved);
        if (singleDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return singleDBScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull ImmutableMap<String, ImmutableSet<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        boolean resolved = IntrospectionScope.containsWildcards((Collection<String>)databasesAndSchemas.keySet());
        if (resolved) {
            for (ImmutableSet schemas : databasesAndSchemas.values()) {
                if (!IntrospectionScope.containsWildcards((Collection<String>)schemas)) continue;
                resolved = false;
                break;
            }
        }
        IntrospectionScope.MultiDBScope multiDBScope = new IntrospectionScope.MultiDBScope(databasesAndSchemas, resolved);
        if (multiDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return multiDBScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull Collection<Couple<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(IntrospectionScopes.pairsToMap(databasesAndSchemas));
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return introspectionScope;
    }

    @NotNull
    private static MultiMap<String, String> pairsToMap(@NotNull Collection<Couple<String>> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/dbm/common/IntrospectionScopes", "pairsToMap"));
        }
        MultiMap result = MultiMap.create();
        for (Pair pair : databasesAndSchemas) {
            result.putValue(pair.first, pair.second);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "pairsToMap"));
        }
        return multiMap;
    }

    @NotNull
    public static IntrospectionScope collapse(@NotNull MultiMap<String, String> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/dbm/common/IntrospectionScopes", "collapse"));
        }
        if (databasesAndSchemas.get((Object)"*").contains("*")) {
            IntrospectionScope introspectionScope = ALL_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "collapse"));
            }
            return introspectionScope;
        }
        for (String d : databasesAndSchemas.keySet()) {
            if (!databasesAndSchemas.get((Object)d).contains("*")) continue;
            Collection modifiable = databasesAndSchemas.getModifiable((Object)d);
            modifiable.clear();
            modifiable.add("*");
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(databasesAndSchemas);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "collapse"));
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope scopeOf(@NotNull MultiMap<String, String> databasesAndSchemas) {
        if (databasesAndSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databasesAndSchemas", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        Set databases = databasesAndSchemas.keySet();
        if (databases.size() == 1) {
            String database = (String)databases.iterator().next();
            Collection schemas = databasesAndSchemas.get((Object)database);
            if (database.equals("*") && schemas.contains("*")) {
                IntrospectionScope introspectionScope = IntrospectionScopes.scopeOfAll();
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
                }
                return introspectionScope;
            }
            boolean resolved = !IntrospectionScope.isWildcard(database) && !IntrospectionScope.containsWildcards(schemas);
            IntrospectionScope.SingleDBScope singleDBScope = new IntrospectionScope.SingleDBScope(database, (ImmutableSet<String>)ImmutableSet.copyOf((Collection)schemas), resolved);
            if (singleDBScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
            }
            return singleDBScope;
        }
        boolean resolved = true;
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (String database : databases) {
            Collection schemas = databasesAndSchemas.get((Object)database);
            b.put((Object)database, (Object)ImmutableSet.copyOf((Collection)schemas));
            if (resolved && IntrospectionScope.isWildcard(database)) {
                resolved = false;
            }
            if (!resolved || !IntrospectionScope.containsWildcards(schemas)) continue;
            resolved = false;
        }
        IntrospectionScope.MultiDBScope multiDBScope = new IntrospectionScope.MultiDBScope((ImmutableMap<String, ImmutableSet<String>>)b.build(), resolved);
        if (multiDBScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOf"));
        }
        return multiDBScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope scopeOfCurrent() {
        IntrospectionScope introspectionScope = CURRENT_SCOPE;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOfCurrent"));
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope scopeOfNothing() {
        IntrospectionScope introspectionScope = EMPTY_SCOPE;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOfNothing"));
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope scopeOfAll() {
        IntrospectionScope introspectionScope = ALL_SCOPE;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "scopeOfAll"));
        }
        return introspectionScope;
    }

    @NotNull
    @Contract(pure=true)
    public static IntrospectionScope importScope(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
        }
        if (string.isEmpty()) {
            IntrospectionScope introspectionScope = EMPTY_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        if (string.equals("@") || string.equals("@:@")) {
            IntrospectionScope introspectionScope = CURRENT_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        if (string.equals("*") || string.equals("*:*")) {
            IntrospectionScope introspectionScope = ALL_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
            }
            return introspectionScope;
        }
        IntrospectionScope introspectionScope = IntrospectionScope.importState(string);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "importScope"));
        }
        return introspectionScope;
    }

    @NotNull
    public static IntrospectionScope fromSchemaPattern(@Nullable String schemaPattern) {
        if (StringUtil.isEmpty((String)schemaPattern)) {
            IntrospectionScope introspectionScope = EMPTY_SCOPE;
            if (introspectionScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "fromSchemaPattern"));
            }
            return introspectionScope;
        }
        String[] strings = IntrospectionScopes.splitSchemaPattern(schemaPattern);
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)strings.length);
        for (String string : strings) {
            if ("*".equals(string)) {
                IntrospectionScope introspectionScope = ALL_SCOPE;
                if (introspectionScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "fromSchemaPattern"));
                }
                return introspectionScope;
            }
            List split = StringUtil.split((String)string, (String)".");
            if (split.size() != 2) continue;
            list.add(Couple.of(split.get(0), split.get(1)));
        }
        IntrospectionScope introspectionScope = IntrospectionScopes.scopeOf(list);
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "fromSchemaPattern"));
        }
        return introspectionScope;
    }

    @NotNull
    public static String[] splitSchemaPattern(@NotNull String schemaPattern) {
        String[] stringArray;
        if (schemaPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaPattern", "com/intellij/dbm/common/IntrospectionScopes", "splitSchemaPattern"));
        }
        if (StringUtil.isEmptyOrSpaces((String)schemaPattern)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = schemaPattern.split("[\\s,]+");
        }
        String[] strings = stringArray;
        for (int i2 = 0; i2 < strings.length; ++i2) {
            strings[i2] = strings[i2].replaceAll("&nbsp;", " ").replaceAll("&amp;", "&");
        }
        if (strings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionScopes", "splitSchemaPattern"));
        }
        return strings;
    }
}

