/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.Casing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.highlighting.QuoteIdentifierQuickFix;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialectEx
extends SqlLanguageDialect
implements CasingProvider {
    protected static final ReservedEntity RE_NEXTVAL = new ReservedEntity("nextval", ObjectKind.COLUMN);
    protected static final ReservedEntity RE_CURRVAL = new ReservedEntity("currval", ObjectKind.COLUMN);
    protected static final ReservedEntity RE_NEW = new ReservedEntity("new", ObjectKind.COLUMN);
    protected static final ReservedEntity RE_OLD = new ReservedEntity("old", ObjectKind.COLUMN);
    protected static final ReservedEntity RE_DUAL = new ReservedEntity("dual", ObjectKind.TABLE);
    private static final Set<ObjectKind> ourUnresolvableKinds = ContainerUtil.newConcurrentSet();

    public SqlLanguageDialectEx(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/dialects/SqlLanguageDialectEx", "<init>"));
        }
        super(id);
    }

    @NotNull
    public abstract DatabaseDialectEx getDatabaseDialect();

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = this.getDatabaseDialect().getFamilyId();
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return null;
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return false;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processReservedEntitiesWithType"));
        }
        if ((SqlImplUtil.equalsInsensetiveOrTrue(name, SqlLanguageDialectEx.RE_NEXTVAL.name, resolve) || SqlImplUtil.equalsInsensetiveOrTrue(name, SqlLanguageDialectEx.RE_CURRVAL.name, resolve)) && SqlImplUtil.getQualifierKind(element) == ObjectKind.SEQUENCE) {
            if (!processor.executeTarget((DasObject)RE_NEXTVAL, element, (SqlType)SqlType.INTEGER, false, ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget((DasObject)RE_CURRVAL, element, (SqlType)SqlType.INTEGER, false, ResolveState.initial())) {
                return false;
            }
        }
        SqlCreateTriggerStatement triggerStatement = null;
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, SqlLanguageDialectEx.RE_NEW.name, resolve) || SqlImplUtil.equalsInsensetiveOrTrue(name, SqlLanguageDialectEx.RE_OLD.name, resolve)) {
            triggerStatement = (SqlCreateTriggerStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlCreateTriggerStatement.class);
        }
        if (triggerStatement == null && element instanceof SqlVariableDefinition && element.getParent() instanceof SqlCreateTriggerStatement) {
            String realName = PsiTreeUtil.getDeepestFirst((PsiElement)element).getText();
            Object object = triggerStatement = Comparing.strEqual((String)realName, (String)SqlLanguageDialectEx.RE_NEW.name, (boolean)false) || Comparing.strEqual((String)realName, (String)SqlLanguageDialectEx.RE_OLD.name, (boolean)false) ? (SqlCreateTriggerStatement)element.getParent() : null;
        }
        if (triggerStatement != null) {
            SqlPrimitiveType sqlType;
            SqlReferenceExpression expression = triggerStatement.getTargetContextExpression();
            Object object = sqlType = expression == null ? SqlType.UNKNOWN : expression.getSqlType();
            if (!processor.executeTarget((DasObject)RE_NEW, element, (SqlType)sqlType, false, ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget((DasObject)RE_OLD, element, (SqlType)sqlType, false, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return this.checkIdentifierIsKeyword(o, manager, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
        if (!(type instanceof SqlKeywordTokenType) || !this.isReservedKeyword(type)) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.1.should.be.quoted", o.getName()), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierStartsWithLetter(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        String text = o.getText();
        if (text.length() <= 0 || Character.isLetter(text.charAt(0))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
    }

    protected static boolean processReservedEntitiesWithTypeDual(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processReservedEntitiesWithTypeDual"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processReservedEntitiesWithTypeDual"));
        }
        if (processor.getExpectedTypes().contains(ObjectKind.COLUMN)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, SqlFromClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class}) == null) {
            return true;
        }
        if (element instanceof SqlReferenceExpression && ((SqlReferenceExpression)element).getQualifierExpression() != null) {
            return true;
        }
        return SqlLanguageDialectEx.processReservedEntitiesWithTypeSimple((DasObject)RE_DUAL, (SqlType)SqlTableTypeBase.EMPTY_TABLE, name, element, resolve, processor, true, false);
    }

    protected static boolean processReservedEntitiesWithTypeSimple(DasObject entity, SqlType result, @Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor, boolean checkType, Boolean forcedCaseSense) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processReservedEntitiesWithTypeSimple"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processReservedEntitiesWithTypeSimple"));
        }
        return !SqlImplUtil.equalsInsensetiveOrTrue(name, entity.getName(), resolve) || checkType && !processor.getExpectedTypes().contains(entity.getKind()) || processor.executeTarget(entity, element, result, forcedCaseSense, ResolveState.initial());
    }

    public TokenSet getStatementSeparators() {
        return SqlTokens.STATEMENT_SEPARATORS;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        ASTNode node;
        SqlColumnStub stub;
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/sql/dialects/SqlLanguageDialectEx", "isAutoIncrementColumn"));
        }
        SqlColumnStub sqlColumnStub = stub = column instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)column).getStub() : null;
        if (stub != null) {
            return stub.isAutoVal();
        }
        ASTNode aSTNode = node = column instanceof PsiElement ? ((PsiElement)column).getNode() : null;
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE) != null;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        if (type instanceof SqlDbElementType) {
            ContainerUtil.addIfNotNull(result, (Object)((SqlDbElementType)type).parentType);
        }
        if (type == ObjectKind.VARIABLE) {
            result.add((ObjectKind)ObjectKind.VARIABLE);
        }
        if (type == ObjectKind.INDEX) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.TRIGGER) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OBJECT_TYPE) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        for (Couple couple : this.getDatabaseDialect().getMetaModel().getKindCouples()) {
            if (couple.second != type || couple.first == ObjectKind.NONE) continue;
            result.add((Object)couple.first);
        }
        if (type == SqlDbElementType.USER) {
            result.add((ObjectKind)SqlDbElementType.USER);
        }
        return result;
    }

    @NotNull
    public SqlType getSqlType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
        }
        int type = this.getDatabaseDialect().getJavaTypeForNativeType(name);
        if (type != 1111) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.findByJdbcType((int)type);
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (StringUtil.isEmpty((String)name)) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        String fixed = name.toUpperCase();
        if (fixed.contains("BINARY")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.BYTES;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.contains("BOOL")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.BOOLEAN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.equals("DATE")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.DATE;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.equals("TIME")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.TIME;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.equals("TIMESTAMP")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.TIMESTAMP;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.contains("DATE") || fixed.contains("TIME")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.DATE_TIME;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.contains("REAL") || fixed.contains("DOUBLE") || fixed.contains("FLOAT") || fixed.contains("NUMBER")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.REAL;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.contains("INTERVAL")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.INTERVAL;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.equals("CHAR") || fixed.contains("INT")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.INTEGER;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.contains("CHAR")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.STRING;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (fixed.contains("REFERENCE")) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.REFERENCE;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getSqlType"));
        }
        return sqlPrimitiveType;
    }

    public boolean canBeCalledWithoutParens(@NotNull SqlFunctionDefinition.Prototype prototype) {
        if (prototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "com/intellij/sql/dialects/SqlLanguageDialectEx", "canBeCalledWithoutParens"));
        }
        SqlFunctionDefinition def = prototype.getFunction();
        return prototype.getParams().length == 0 && !"required".equals(def.getDialectAttribute("parens"));
    }

    @NotNull
    public SqlType getDefinitionType(SqlTypedDefinition definition, int usageOffset) {
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getDefinitionType"));
        }
        return sqlPrimitiveType;
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/dialects/SqlLanguageDialectEx", "quoteIdentifier"));
        }
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/sql/dialects/SqlLanguageDialectEx", "quoteIdentifier"));
        }
        return this.quoteIdentifier(identifier.getProject(), newElementName);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlLanguageDialectEx", "quoteIdentifier"));
        }
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/sql/dialects/SqlLanguageDialectEx", "quoteIdentifier"));
        }
        SqlCodeStyleSettings settings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        boolean force = settings.QUOTE_IDENTIFIER == 0 || this.isReservedKeyword((IElementType)SqlTokenRegistry.findTokenType((String)newElementName));
        return this.getDatabaseDialect().quoteIdentifier(newElementName, force, !force);
    }

    public JBIterable<? extends SqlDefinition> extractDefinitions(@NotNull SqlElement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/sql/dialects/SqlLanguageDialectEx", "extractDefinitions"));
        }
        if (statement instanceof SqlSelectStatement) {
            return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)statement).expand(Conditions.notInstanceOf(SqlSelectIntoNewTableClauseImpl.class))).filter(SqlSelectIntoNewTableClauseImpl.class);
        }
        if (statement instanceof SqlBlockStatementImpl) {
            JBIterable children = SqlImplUtil.childrenIt((PsiElement)statement).filter(SqlElement.class);
            return children.filter(SqlDefinition.class).append((Iterable)children.flatten(this::extractDefinitions));
        }
        return JBIterable.empty();
    }

    public boolean processFileDeclarations(@NotNull List<SqlElement> ddl, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement lastParent, @NotNull PsiElement place) {
        if (ddl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ddl", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processFileDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processFileDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processFileDeclarations"));
        }
        if (lastParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastParent", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processFileDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processFileDeclarations"));
        }
        return true;
    }

    public boolean shallResolve(ObjectKind type) {
        return !ourUnresolvableKinds.contains(type);
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/SqlLanguageDialectEx", "shouldQuotedTypeReferenceBeChecked"));
        }
        return true;
    }

    @NotNull
    public abstract Map<String, SqlFunctionDefinition> getSupportedFunctions();

    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Map<String, SqlFunctionDefinition.Type> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getBuiltInTypes"));
        }
        return map;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getCasing"));
        }
        Casing casing = this.getDatabaseDialect().getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getCasing"));
        }
        return casing;
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return null;
    }

    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlLanguageDialectEx", "supportsSql92CharSetSpecFor"));
        }
        return false;
    }

    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getDelimiterAt"));
        }
        return ";";
    }

    public boolean mayContainExternalPsi() {
        return false;
    }

    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlLanguageDialectEx", "isMajorChild"));
        }
        return kind == ObjectKind.TRIGGER || kind == ObjectKind.INDEX;
    }

    @Nullable
    public TreePattern getDefaultImports(@Nullable DbDataSource dataSource) {
        TreePattern imports = this.getBaseImports(dataSource);
        return imports == null ? null : this.applyImplicitImports(dataSource, imports);
    }

    @Nullable
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource) {
        ObjectKind kind;
        JBIterable kinds = this.getDatabaseDialect().getMetaModel().getRootNamespaceKinds();
        if (kinds.contains((Object)ObjectKind.DATABASE)) {
            kind = ObjectKind.DATABASE;
        } else if (kinds.contains((Object)ObjectKind.SCHEMA)) {
            kind = ObjectKind.SCHEMA;
        } else {
            throw new AssertionError((Object)"Unexpected root kind");
        }
        String userName = SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource));
        SqlImportUtil.PatternItemsFactory f = new SqlImportUtil.PatternItemsFactory(this);
        return new TreePattern(f.createDataSources(dataSource, f.createNodeIfNotNull(ObjectName.plain((String)userName), kind, new TreePatternNode.Group[0])));
    }

    @NotNull
    public TreePattern applyImplicitImports(@Nullable DbDataSource dataSource, @NotNull TreePattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/SqlLanguageDialectEx", "applyImplicitImports"));
        }
        TreePattern treePattern = pattern;
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "applyImplicitImports"));
        }
        return treePattern;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @NotNull Iterable<? extends DasNamespace> objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/sql/dialects/SqlLanguageDialectEx", "forcedContextPattern"));
        }
        TreePattern treePattern = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(objects).transform(n -> SqlDialectImplUtil.createObjectPattern(dataSource, (DasObject)n, null)));
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "forcedContextPattern"));
        }
        return treePattern;
    }

    @NotNull
    public TreePattern processImports(@NotNull SqlUseDatabaseStatement stmt, @NotNull TreePattern prev) {
        int k;
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processImports"));
        }
        if (prev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prev", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processImports"));
        }
        List refs = ContainerUtil.newSmartList();
        ObjectKind kind = null;
        for (SqlReferenceExpression ref : ContainerUtil.iterateBackward((List)stmt.getUseReferences())) {
            refs.add(ref);
            ObjectKind k2 = ref.getReferenceElementType().getTargetKind();
            assert (kind == null || kind == k2);
            kind = k2;
        }
        if (refs.isEmpty() || kind == null) {
            TreePattern treePattern = prev;
            if (treePattern == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processImports"));
            }
            return treePattern;
        }
        TreePattern state = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)refs).transform(r -> SqlImportUtil.createRefPattern(r, this.getDatabaseDialect())).filter(x -> x != null));
        List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDatabaseDialect());
        int n = k = path == null ? -1 : path.indexOf(kind);
        if (k != -1 && path.size() > 0) {
            ObjectKind[] kinds = ContainerUtil.reverse(path).toArray(new ObjectKind[path.size()]);
            k = kinds.length - 1 - k;
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            mask[k] = false;
            TreePattern masked = TreePatternUtils.mask(prev, kinds, mask, false);
            for (int i2 = k; i2 < mask.length; ++i2) {
                mask[i2] = i2 == k;
            }
            TreePattern maskedState = k == mask.length - 1 ? state : TreePatternUtils.mask(state, kinds, mask, false);
            state = TreePatternUtils.union(stmt.isInclusive() ? prev : TreePatternUtils.minus(prev, masked), TreePatternUtils.intersect(maskedState, masked));
        }
        TreePattern treePattern = this.applyImplicitImports(null, state);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "processImports"));
        }
        return treePattern;
    }

    @NotNull
    public SqlTableType createSequenceType(@NotNull PsiElement element, @Nullable PsiElement object) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/SqlLanguageDialectEx", "createSequenceType"));
        }
        SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "createSequenceType"));
        }
        return sqlTableType;
    }

    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getIgnoredParentKinds"));
        }
        Set<ObjectKind> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlLanguageDialectEx", "getIgnoredParentKinds"));
        }
        return set;
    }

    static {
        ourUnresolvableKinds.add(SqlDbElementType.CHARSET);
        ourUnresolvableKinds.add(SqlDbElementType.COLLATION);
        ourUnresolvableKinds.add(SqlDbElementType.DB_LINK);
        ourUnresolvableKinds.add(SqlDbElementType.GENERIC_AT_LINK);
        ourUnresolvableKinds.add(SqlDbElementType.USER);
        ourUnresolvableKinds.add(SqlDbElementType.ROLE);
        ourUnresolvableKinds.add(SqlDbElementType.ARGUMENT);
        ourUnresolvableKinds.add(ObjectKind.OPERATOR);
    }
}

