/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.db2.Db2Dialect;
import com.intellij.sql.dialects.db2.Db2OptionalKeywords;
import com.intellij.sql.dialects.db2.Db2ReservedKeywords;
import com.intellij.sql.dialects.db2.Db2Tokens;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import com.intellij.sql.psi.impl.lexer._Db2Lexer;

public class Db2Lexer
extends SqlLexer {
    public Db2Lexer() {
        super(Db2Tokens.class, new _Db2Lexer());
    }

    @Override
    protected void lookSqlKeyword(Lexer baseLexer) {
        boolean useOriginal = false;
        IElementType sqlType = this.getSqlTokenType(baseLexer);
        if (sqlType instanceof SqlKeywordTokenType) {
            LexerPosition pos = baseLexer.getCurrentPosition();
            baseLexer.advance();
            while (SqlTokens.WHITE_SPACE_TOKENS.contains(baseLexer.getTokenType()) || SqlTokens.COMMENT_TOKENS.contains(baseLexer.getTokenType())) {
                baseLexer.advance();
            }
            useOriginal = baseLexer.getTokenType() == SqlTokens.SQL_PERIOD;
            baseLexer.restore(pos);
        }
        this.advanceAs(baseLexer, useOriginal ? baseLexer.getTokenType() : sqlType);
    }

    static {
        Db2Lexer.initTokensAndFunctions(Db2Tokens.class, Db2ReservedKeywords.class, Db2OptionalKeywords.class, Db2Dialect.INSTANCE);
    }
}

