/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.support.SqlCommenter;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlCommenter
extends SqlCommenter
implements SelfManagingCommenter {
    public static final String SHARP_LINE_PREFIX = "# ";
    public static final String SHARP_LINE_PREFIX_NO_SPACE = "#";

    @Override
    public String getLineCommentPrefix() {
        return SHARP_LINE_PREFIX;
    }

    @Override
    public IElementType getLineCommentTokenType() {
        return SqlTokens.MYSQL_LINE_COMMENT;
    }

    @Nullable
    public CommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "createLineCommentingState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/mysql/MysqlCommenter", "createLineCommentingState"));
        }
        return null;
    }

    @Nullable
    public CommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "createBlockCommentingState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/mysql/MysqlCommenter", "createBlockCommentingState"));
        }
        return null;
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "commentLine"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/sql/dialects/mysql/MysqlCommenter", "commentLine"));
        }
        document.insertString(offset, (CharSequence)SHARP_LINE_PREFIX);
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "uncommentLine"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/sql/dialects/mysql/MysqlCommenter", "uncommentLine"));
        }
        if (offset == 0 && line > 0) {
            return;
        }
        for (String p : new String[]{SHARP_LINE_PREFIX, "-- ", SHARP_LINE_PREFIX_NO_SPACE}) {
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)p)) continue;
            document.deleteString(offset, offset + p.length());
            break;
        }
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "isLineCommented"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/sql/dialects/mysql/MysqlCommenter", "isLineCommented"));
        }
        CharSequence sequence = document.getCharsSequence();
        return CharArrayUtil.regionMatches((CharSequence)sequence, (int)offset, (CharSequence)"-- ") || CharArrayUtil.regionMatches((CharSequence)sequence, (int)offset, (CharSequence)SHARP_LINE_PREFIX) || CharArrayUtil.regionMatches((CharSequence)sequence, (int)offset, (CharSequence)SHARP_LINE_PREFIX_NO_SPACE);
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getCommentPrefix"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getCommentPrefix"));
        }
        return this.getLineCommentPrefix();
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getBlockCommentRange"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getBlockCommentRange"));
        }
        return SelfManagingCommenterUtil.getBlockCommentRange((int)selectionStart, (int)selectionEnd, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getBlockCommentPrefix"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getBlockCommentPrefix"));
        }
        return this.getBlockCommentPrefix();
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getBlockCommentSuffix"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/sql/dialects/mysql/MysqlCommenter", "getBlockCommentSuffix"));
        }
        return this.getBlockCommentSuffix();
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        SelfManagingCommenterUtil.uncommentBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, CommenterDataHolder data) {
        TextRange textRange = SelfManagingCommenterUtil.insertBlockComment((int)startOffset, (int)endOffset, (Document)document, (String)this.getBlockCommentPrefix(), (String)this.getBlockCommentSuffix());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlCommenter", "insertBlockComment"));
        }
        return textRange;
    }
}

