/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql.refactoring;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlExtractVariableHelper
extends SqlExtractVariableHelper {
    @Override
    @Nullable
    public PsiElement createDeclaration(@NotNull Project project, @NotNull String name, @NotNull String type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "createDeclaration"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "createDeclaration"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "createDeclaration"));
        }
        String text = "DECLARE " + name + " " + type + ";";
        SqlFile fileFromText = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)MysqlDialect.INSTANCE, (CharSequence)("create procedure test() begin " + text + " end"));
        return fileFromText.getFirstChild().getLastChild().getChildren()[0];
    }

    @Override
    @Nullable
    public PsiElement createInitializerDeclaration(@NotNull Project project, @NotNull String name, @NotNull String text) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "createInitializerDeclaration"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "createInitializerDeclaration"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "createInitializerDeclaration"));
        }
        String allText = "SET " + name + " = " + text;
        return SqlPsiElementFactory.createStatementFromText(allText, MysqlDialect.INSTANCE, project, null);
    }

    @Override
    public SqlTypeElement getTypeElement(@NotNull PsiElement target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "getTypeElement"));
        }
        return (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)target.getParent(), SqlTypeElement.class);
    }

    @Override
    public PsiElement addDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement block) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "addDeclaration"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/sql/dialects/mysql/refactoring/MysqlExtractVariableHelper", "addDeclaration"));
        }
        PsiElement child = block.getFirstChild();
        PsiElement element = block.addAfter(declaration, child);
        PsiElement semi = SqlPsiElementFactory.createLeafFromText(declaration.getProject(), MysqlDialect.INSTANCE, ";");
        block.addAfter(semi, element);
        block.addBefore(SqlPsiElementFactory.newLine(block.getProject()), element);
        return element;
    }
}

