/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.dialects.oracle.OracleOptionalKeywords;
import com.intellij.sql.dialects.oracle.OraclePlReservedKeywords;
import com.intellij.sql.dialects.oracle.OracleReservedKeywords;
import com.intellij.sql.dialects.oracle.OracleTokens;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import com.intellij.sql.psi.impl.lexer._OracleLexer;
import com.intellij.sql.util.SqlTokenRegistry;
import org.jetbrains.annotations.Nullable;

public class OracleLexer
extends SqlLexer {
    public OracleLexer() {
        super(OracleTokens.class, new _OracleLexer());
    }

    protected OracleLexer(Class tokenClass, FlexLexer flexLexer) {
        super(tokenClass, flexLexer);
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!this.lookAheadRangeOperator(baseLexer) && !this.lookAheadCustomQuotation(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadCustomQuotation(Lexer baseLexer) {
        String ident = OracleLexer.getCustomEndingQuote(baseLexer);
        if (ident == null) {
            return false;
        }
        int identLen = ident.length();
        int stringStart = baseLexer.getTokenStart() + identLen + baseLexer.getTokenText().indexOf("'");
        return this.processCustomQuotation(baseLexer, ident, stringStart, false, SqlTokens.SQL_CUSTOM_LQUOTE, SqlTokens.SQL_CUSTOM_RQUOTE, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN);
    }

    @Nullable
    private static String getCustomEndingQuote(Lexer baseLexer) {
        char prefix;
        IElementType type = baseLexer.getTokenType();
        if (type != SqlTokens.SQL_STRING_TOKEN && type != SqlTokens.BAD_CHARACTER) {
            return null;
        }
        String text = baseLexer.getTokenText();
        int index = text.indexOf(39);
        if (index + 1 >= text.length()) {
            return null;
        }
        char c = prefix = index > 0 ? text.charAt(index - 1) : (char)'\u0000';
        if (prefix != 'Q' && prefix != 'q') {
            return null;
        }
        char delimiter = text.charAt(index + 1);
        if (delimiter == '(') {
            return ")'";
        }
        if (delimiter == '<') {
            return ">'";
        }
        if (delimiter == '{') {
            return "}'";
        }
        if (delimiter == '[') {
            return "]'";
        }
        return delimiter + "'";
    }

    static {
        SqlTokenRegistry.initTypeMap(OraclePlReservedKeywords.class, null);
        OracleLexer.initTokensAndFunctions(OracleTokens.class, OracleReservedKeywords.class, OracleOptionalKeywords.class, OracleDialect.INSTANCE);
    }
}

