/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiFile containingFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/formatter/SqlPreFormatProcessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/sql/formatter/SqlPreFormatProcessor", "process"));
        }
        PsiElement psiElement = element.getPsi();
        PsiFile psiFile = containingFile = psiElement == null || !psiElement.isValid() ? null : psiElement.getContainingFile();
        if (!(containingFile instanceof SqlFile)) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor", "process"));
            }
            return textRange;
        }
        if (Boolean.TRUE.equals(containingFile.getUserData(InjectedLanguageUtil.FRANKENSTEIN_INJECTION))) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor", "process"));
            }
            return textRange;
        }
        if (containingFile.getTextLength() < 1024 && SqlImplUtil.sqlTraverser((PsiElement)containingFile).filter(SqlStatement.class).isEmpty()) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor", "process"));
            }
            return textRange;
        }
        SqlLanguageDialect language = ((SqlFile)containingFile).getSqlLanguage();
        if (language == DbSqlUtil.getGenericDialect() || SqlPreFormatProcessor.getSqlSettings((Project)containingFile.getProject()).DISABLE_FORMATTING) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor", "process"));
            }
            return textRange;
        }
        TextRange textRange = new MyFormatter(psiElement, language.getDatabaseDialect()).process(range);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor", "process"));
        }
        return textRange;
    }

    @NotNull
    private static SqlCodeStyleSettings getSqlSettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/formatter/SqlPreFormatProcessor", "getSqlSettings"));
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(SqlCodeStyleSettings.class);
        if (sqlCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor", "getSqlSettings"));
        }
        return sqlCodeStyleSettings;
    }

    private static class MyFormatter {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final PsiElement myElement;
        @NotNull
        protected final PsiDocumentManager myDocumentManager;
        @NotNull
        private final DatabaseDialect myDialect;
        @Nullable
        protected final Document myDocument;
        protected final SqlCodeStyleSettings mySqlCodeStyleSettings;

        public MyFormatter(@NotNull PsiElement element, @NotNull DatabaseDialect dialect) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter", "<init>"));
            }
            this.myDialect = dialect;
            this.myProject = element.getProject();
            this.myElement = element;
            this.mySqlCodeStyleSettings = SqlPreFormatProcessor.getSqlSettings(this.myProject);
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            PsiFile file = element.getContainingFile();
            this.myDocument = (Document)ObjectUtils.chooseNotNull((Object)this.myDocumentManager.getDocument(file), (Object)file.getUserData(FileDocumentManagerImpl.HARD_REF_TO_DOCUMENT_KEY));
        }

        @NotNull
        private TextRange process(final @NotNull TextRange range) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter", "process"));
            }
            if (this.myDocument == null || this.mySqlCodeStyleSettings == null) {
                TextRange textRange = range;
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter", "process"));
                }
                return textRange;
            }
            if (PostprocessReformattingAspect.getInstance((Project)this.myProject).isDisabled()) {
                TextRange textRange = range;
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter", "process"));
                }
                return textRange;
            }
            final ArrayList keywords = ContainerUtil.newArrayList();
            final ArrayList types = ContainerUtil.newArrayList();
            final ArrayList identifiers = ContainerUtil.newArrayList();
            final List readOnlyFragments = this.myDocument instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)this.myProject).getNonEditableFragments((DocumentWindow)this.myDocument) : ContainerUtil.emptyList();
            this.myElement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter$1", "visitElement"));
                    }
                    this.process(element);
                    if (element instanceof IsExternal) {
                        this.process(element.getFirstChild());
                        return;
                    }
                    super.visitElement(element);
                }

                public void process(@Nullable PsiElement element) {
                    if (element == null) {
                        return;
                    }
                    TextRange nodeRange = element.getNode().getTextRange();
                    if (range.intersects(nodeRange) && !this.intersect(readOnlyFragments, nodeRange)) {
                        boolean parameter;
                        boolean isKeyword = element.getNode().getElementType() instanceof SqlKeywordTokenType;
                        PsiElement parent = element.getParent();
                        boolean isRemapped = parent instanceof SqlIdentifier;
                        ASTNode parentNode = parent != null ? parent.getNode() : null;
                        IElementType parentType = parentNode != null ? parentNode.getElementType() : null;
                        PsiElement gradnpa = parent instanceof SqlReferenceExpression ? parent.getParent() : null;
                        ASTNode grandpaNode = gradnpa == null ? null : gradnpa.getNode();
                        IElementType grandpaType = grandpaNode != null ? grandpaNode.getElementType() : null;
                        boolean insideSpecialLiteral = parentType == SqlCompositeElementTypes.SQL_SPECIAL_LITERAL && !"null".equalsIgnoreCase(element.getText());
                        boolean functionName = parentType == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE || parentType == SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE || grandpaType == SqlCompositeElementTypes.SQL_FUNCTION_CALL;
                        boolean bl = parameter = parentType == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
                        if (isKeyword && !isRemapped && !insideSpecialLiteral) {
                            if (element.getParent() instanceof SqlTypeElement) {
                                types.add(nodeRange);
                            } else {
                                keywords.add(nodeRange);
                            }
                        } else {
                            boolean identifier = element instanceof SqlIdentifier;
                            boolean asterisk = "*".equals(element.getText());
                            if (!(!identifier || functionName || parameter || range.getLength() <= 1 && asterisk)) {
                                identifiers.add((SqlIdentifier)element);
                            }
                        }
                    }
                }

                private boolean intersect(@NotNull List<TextRange> trs, @NotNull TextRange r) {
                    if (trs == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trs", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter$1", "intersect"));
                    }
                    if (r == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter$1", "intersect"));
                    }
                    for (TextRange tr : trs) {
                        if (!tr.intersects(r)) continue;
                        return true;
                    }
                    return false;
                }
            });
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            if (!keywords.isEmpty()) {
                start = Math.min(start, ((TextRange)keywords.get(0)).getStartOffset());
                end = Math.max(end, ((TextRange)keywords.get(keywords.size() - 1)).getEndOffset());
            }
            if (!identifiers.isEmpty()) {
                start = Math.min(start, ((SqlIdentifier)identifiers.get(0)).getTextRange().getStartOffset());
                end = Math.max(end, ((SqlIdentifier)identifiers.get(identifiers.size() - 1)).getTextRange().getEndOffset());
            }
            TextRange fixedRange = new TextRange(start, end);
            CharSequence charSequence = this.myDocument.getCharsSequence();
            int[] delta = new int[]{0};
            ((DocumentEx)this.myDocument).setInBulkUpdate(true);
            PairProcessor processor = (range1, s) -> {
                TextRange shifted = TextRange.create((int)(range1.getStartOffset() + delta[0]), (int)(range1.getEndOffset() + delta[0]));
                String text = this.myDocument.getText(shifted);
                if (text.equals(s)) {
                    return true;
                }
                if (this.myDocument.getRangeGuard(shifted.getStartOffset(), shifted.getEndOffset()) != null) {
                    return true;
                }
                this.myDocument.replaceString(shifted.getStartOffset(), shifted.getEndOffset(), (CharSequence)s);
                delta[0] = delta[0] + (s.length() - range1.getLength());
                return true;
            };
            this.processKeywords(keywords, charSequence, (PairProcessor<TextRange, String>)processor);
            this.processTypes(types, charSequence, (PairProcessor<TextRange, String>)processor);
            this.processIdentifiers(identifiers, (PairProcessor<TextRange, String>)processor);
            ((DocumentEx)this.myDocument).setInBulkUpdate(false);
            if (this.myDocumentManager.isUncommited(this.myDocument)) {
                this.myDocumentManager.commitDocument(this.myDocument);
            }
            TextRange textRange = fixedRange.grown(delta[0]);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/SqlPreFormatProcessor$MyFormatter", "process"));
            }
            return textRange;
        }

        private void processKeywords(List<TextRange> keywords, CharSequence charSequence, PairProcessor<TextRange, String> processor) {
            MyFormatter.processRanges(keywords, charSequence, processor, SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.KEYWORD_CASE));
        }

        private void processTypes(List<TextRange> types, CharSequence charSequence, PairProcessor<TextRange, String> processor) {
            MyFormatter.processRanges(types, charSequence, processor, this.mySqlCodeStyleSettings.getCaseModeExt(this.mySqlCodeStyleSettings.TYPE_CASE));
        }

        private static void processRanges(List<TextRange> ranges, CharSequence charSequence, PairProcessor<TextRange, String> processor, Case mode) {
            if (mode == Case.MIXED) {
                return;
            }
            for (TextRange range : ranges) {
                String text = charSequence.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
                String newText = mode.apply(text);
                processor.process((Object)range, (Object)newText);
            }
        }

        private void processIdentifiers(List<SqlIdentifier> identifiers, PairProcessor<TextRange, String> processor) {
            Case quotedMode = SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.QUOTED_IDENTIFIER_CASE);
            Case simpleMode = SqlCodeStyleSettings.getCaseMode((int)this.mySqlCodeStyleSettings.IDENTIFIER_CASE);
            if (quotedMode == Case.MIXED && simpleMode == Case.MIXED && this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 2) {
                return;
            }
            for (SqlIdentifier psi : identifiers) {
                String newText;
                boolean isQuoted = !psi.isPlainIdentifier();
                String identifierName = psi.getName();
                String prefix = psi.getNamePrefix();
                String text = psi.getText();
                if (this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 0 && !isQuoted) {
                    newText = this.myDialect.quoteIdentifier(identifierName, true, false);
                    newText = quotedMode.apply(newText);
                } else {
                    newText = this.mySqlCodeStyleSettings.QUOTE_IDENTIFIER == 1 && isQuoted ? (SqlImplUtil.canUnquote(identifierName, this.myDialect) ? simpleMode.apply(identifierName) : quotedMode.apply(text)) : (isQuoted ? quotedMode : simpleMode).apply(prefix == null ? text : text.replaceFirst(prefix, ""));
                }
                if (newText == null) continue;
                if (prefix != null) {
                    newText = prefix + newText;
                }
                TextRange range = psi.getTextRange();
                processor.process((Object)range, (Object)newText);
            }
        }
    }
}

