/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.completion.SqlCompletionContributor;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlUnionExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDerivedTableAliasInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection", "createAnnotationVisitor"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection", "createAnnotationVisitor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection", "createAnnotationVisitor"));
        }
        DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
        if (!(familyId.isMysql() || familyId.isPostgres() || familyId.isTransactSql() || familyId.isDerby())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlParenthesizedExpression(@NotNull SqlParenthesizedExpression o) {
                List list;
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$1", "visitSqlParenthesizedExpression"));
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                PsiElement parent = o.getParent();
                SqlParenthesizedExpression item = o;
                while (true) {
                    list = item.getExpressionList();
                    SqlExpression expression = (SqlExpression)ContainerUtil.getFirstItem((List)list);
                    if (list.size() != 1 || !(expression instanceof SqlParenthesizedExpression)) break;
                    item = (SqlParenthesizedExpression)expression;
                }
                if (this.shouldNotCheckElement((SqlElement)item)) {
                    return;
                }
                list = item.getExpressionList();
                if ((parent instanceof SqlFromClause || parent instanceof SqlJoinExpression) && list.size() == 1 && (list.get(0) instanceof SqlQueryExpression || list.get(0) instanceof SqlUnionExpression)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlMessages.message("derived.table.alias", new Object[0]), (LocalQuickFix)new IntroduceAliasQuickFix(o), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
                super.visitSqlParenthesizedExpression(o);
            }
        };
    }

    private static class IntroduceAliasQuickFix
    extends SqlEditorAwareFix<SqlParenthesizedExpression> {
        IntroduceAliasQuickFix(@Nullable SqlParenthesizedExpression element) {
            super(element);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlMessages.message("quickfix.name.introduce.alias", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$IntroduceAliasQuickFix", "getText"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = SqlMessages.message("sql.inspections.group.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$IntroduceAliasQuickFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlParenthesizedExpression element, @Nullable Editor editor) {
            PsiFile file;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$IntroduceAliasQuickFix", "applyFix"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$IntroduceAliasQuickFix", "applyFix"));
            }
            PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
            Document document = instance.getDocument(file = element.getContainingFile());
            if (document == null) {
                return;
            }
            Collection<String> strings = SqlCompletionContributor.suggestAliasName((SqlExpression)element);
            String alias = (String)ContainerUtil.getFirstItem(strings, (Object)"alias");
            String asKeyword = " as ";
            int insertOffset = element.getTextRange().getEndOffset();
            document.insertString(insertOffset, (CharSequence)(asKeyword + alias));
            instance.commitDocument(document);
            if (editor != null) {
                int startOffset = insertOffset + asKeyword.length();
                editor.getCaretModel().moveToOffset(startOffset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(startOffset, startOffset + alias.length());
            }
        }
    }
}

