/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTokenType;
import org.jetbrains.annotations.NotNull;

public class SqlBinaryExpressionImpl
extends SqlExpressionImpl
implements SqlBinaryExpression {
    public SqlBinaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlBinaryExpression((SqlBinaryExpression)this);
    }

    @NotNull
    public SqlExpression getLOperand() {
        SqlExpression sqlExpression = (SqlExpression)this.findNotNullChildByClass(SqlExpression.class);
        if (sqlExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getLOperand"));
        }
        return sqlExpression;
    }

    public SqlExpression getROperand() {
        return (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.getLOperand(), SqlExpression.class);
    }

    @NotNull
    public IElementType getOpSign() {
        PsiElement signElement = this.getOpSignElement();
        ASTNode astNode = signElement.getNode();
        assert (astNode != null);
        IElementType iElementType = astNode.getElementType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getOpSign"));
        }
        return iElementType;
    }

    @NotNull
    public PsiElement getOpSignElement() {
        for (ASTNode node = this.getLOperand().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            if (type == TokenType.WHITE_SPACE || SqlTokens.COMMENT_TOKENS.contains(type)) continue;
            if (type instanceof SqlTokenType) {
                PsiElement psiElement = node.getPsi();
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getOpSignElement"));
                }
                return psiElement;
            }
            if (type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                PsiElement psiElement = node.getPsi();
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getOpSignElement"));
                }
                return psiElement;
            }
            if (type instanceof SqlCompositeElementType) break;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{SqlStatement.class, PsiFile.class});
        throw new AssertionError((Object)((Object)((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)this)) + ": parent='" + (parent == null ? this : this.getParent()).getText() + "'"));
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType lType = this.getLOperand().getSqlType();
        SqlExpression rOp = this.getROperand();
        SqlType rType = rOp == null ? null : rOp.getSqlType();
        IElementType sign = this.getOpSign();
        if (sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_GT || sign == SqlTokens.SQL_OP_LT || sign == SqlTokens.SQL_OP_GE || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_LOGICAL_AND || sign == SqlTokens.SQL_OP_LOGICAL_OR || sign == SqlTokens.SQL_OP_NULLSAFE_EQ || sign == SqlTokens.SQL_OP_NEQ2 || sign == SqlTokens.SQL_OP_NEQ3 || sign == SqlTokens.SQL_OP_NEQ_WS || sign == SqlTokens.SQL_OP_NEQ2_WS || sign == SqlTokens.SQL_OP_NEQ3_WS) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.BOOLEAN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (sign == SqlTokens.SQL_OP_PLUS || sign == SqlTokens.SQL_OP_MINUS || sign == SqlTokens.SQL_OP_MUL || sign == SqlTokens.SQL_OP_DIV) {
            if (lType == SqlType.REAL || rType == SqlType.REAL) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.REAL;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.DATE) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.DATE;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.TIME) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.TIME;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.TIMESTAMP) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.TIMESTAMP;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            if (lType == SqlType.DATE_TIME) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.DATE_TIME;
                if (sqlPrimitiveType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
                }
                return sqlPrimitiveType;
            }
            SqlPrimitiveType sqlPrimitiveType = SqlType.INTEGER;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (sign == SqlTokens.SQL_OP_BITWISE_XOR || sign == SqlTokens.SQL_OP_BITWISE_AND || sign == SqlTokens.SQL_OP_BITWISE_OR || sign == SqlTokens.SQL_OP_INVERT || sign == SqlTokens.SQL_OP_LEFT_SHIFT || sign == SqlTokens.SQL_OP_RIGHT_SHIFT || sign == SqlTokens.SQL_OP_MODULO) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.INTEGER;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (sign == SqlTokens.SQL_OP_CONCAT) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.STRING;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlBinaryExpressionImpl", "getSqlType"));
        }
        return sqlPrimitiveType;
    }
}

