/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class SqlQueryExpressionImpl
extends SqlExpressionImpl
implements SqlQueryExpression {
    public SqlQueryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlQueryExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlQueryExpression((SqlQueryExpression)this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        SqlWithClause withClause;
        DatabaseFamilyId familyId;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlQueryExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlQueryExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlQueryExpressionImpl", "processDeclarations"));
        }
        SqlSelectClause selectClause = this.getSelectClause();
        SqlTableExpression tableExpression = this.getTableExpression();
        if (selectClause != null && lastParent != selectClause && (tableExpression == null || lastParent != tableExpression || !PsiTreeUtil.isAncestor((PsiElement)tableExpression, (PsiElement)place, (boolean)false) || ((familyId = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getFamilyId()).isMysql() || familyId.isH2()) && PsiTreeUtil.getParentOfType((PsiElement)place, SqlHavingClause.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class}) != null || (familyId.isMysql() || familyId.isPostgres() || familyId.isH2()) && PsiTreeUtil.getParentOfType((PsiElement)place, SqlGroupByClause.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class}) != null) && !selectClause.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (tableExpression != null && lastParent != tableExpression && !tableExpression.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        for (SqlExtraDeclarationsProvider child : SqlImplUtil.childrenTreeIt((PsiElement)this).filter(SqlExtraDeclarationsProvider.class)) {
            if (child.processExtraDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        PsiElement firstChild = this.getFirstChild();
        SqlWithClause sqlWithClause = withClause = firstChild instanceof SqlWithClause ? (SqlWithClause)firstChild : null;
        return withClause == null || firstChild.processDeclarations(processor, state, lastParent, place);
    }

    public SqlTableExpression getTableExpression() {
        return (SqlTableExpression)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_TABLE_EXPRESSION);
    }

    public SqlSelectClause getSelectClause() {
        return (SqlSelectClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_SELECT_CLAUSE);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlTableExpression tableExpression = this.getTableExpression();
        SqlSelectClause selectClause = this.getSelectClause();
        if (selectClause == null) {
            Object object = tableExpression == null ? SqlType.UNKNOWN : tableExpression.getSqlType();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlQueryExpressionImpl", "getSqlType"));
            }
            return object;
        }
        SqlTableType sqlTableType = SqlImplUtil.getSelectType(selectClause.getExpressions(), (PsiElement)this);
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlQueryExpressionImpl", "getSqlType"));
        }
        return sqlTableType;
    }
}

