/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenFileHyperlinkInfo
implements FileHyperlinkInfo {
    private static final int UNDEFINED_OFFSET = -1;
    private final Project myProject;
    private final VirtualFile myFile;
    private final boolean myIncludeInOccurenceNavigation;
    private final int myDocumentLine;
    private final int myDocumentColumn;

    public OpenFileHyperlinkInfo(@NotNull OpenFileDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        this(descriptor.getProject(), descriptor.getFile(), descriptor.getLine(), descriptor.getColumn());
    }

    public OpenFileHyperlinkInfo(@NotNull Project project, @NotNull VirtualFile file, boolean includeInOccurenceNavigation, int documentLine, int documentColumn) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        this.myProject = project;
        this.myFile = file;
        this.myIncludeInOccurenceNavigation = includeInOccurenceNavigation;
        this.myDocumentLine = documentLine;
        this.myDocumentColumn = documentColumn;
    }

    public OpenFileHyperlinkInfo(@NotNull Project project, @NotNull VirtualFile file, int line) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        this(project, file, line, 0);
    }

    public OpenFileHyperlinkInfo(@NotNull Project project, @NotNull VirtualFile file, int line, int column) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "<init>"));
        }
        this(project, file, true, line, column);
    }

    @Override
    public OpenFileDescriptor getDescriptor() {
        int offset;
        if (!this.myFile.isValid()) {
            return null;
        }
        int line = this.myDocumentLine;
        FileDocumentManager.getInstance().getDocument(this.myFile);
        LineNumbersMapping mapping = (LineNumbersMapping)this.myFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY);
        if (mapping != null && (line = mapping.bytecodeToSource(this.myDocumentLine + 1) - 1) < 0) {
            line = this.myDocumentLine;
        }
        if ((offset = OpenFileHyperlinkInfo.calculateOffset(this.myFile, line, this.myDocumentColumn)) != -1) {
            return new OpenFileDescriptor(this.myProject, this.myFile, offset);
        }
        return new OpenFileDescriptor(this.myProject, this.myFile, line, this.myDocumentColumn);
    }

    @Override
    public void navigate(Project project) {
        ApplicationManager.getApplication().runReadAction(() -> {
            OpenFileDescriptor descriptor = this.getDescriptor();
            if (descriptor != null) {
                FileEditorManager.getInstance(project).openTextEditor(descriptor, true);
            }
        });
    }

    @Override
    public boolean includeInOccurenceNavigation() {
        return this.myIncludeInOccurenceNavigation;
    }

    private static int calculateOffset(final @NotNull VirtualFile file, final int documentLine, final int documentColumn) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/filters/OpenFileHyperlinkInfo", "calculateOffset"));
        }
        return ApplicationManager.getApplication().runReadAction(new Computable<Integer>(){

            public Integer compute() {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    int lineCount = document.getLineCount();
                    if (0 <= documentLine && documentLine < lineCount) {
                        int lineStartOffset = document.getLineStartOffset(documentLine);
                        int lineEndOffset = document.getLineEndOffset(documentLine);
                        int fixedColumn = Math.min(Math.max(documentColumn, 0), lineEndOffset - lineStartOffset);
                        return lineStartOffset + fixedColumn;
                    }
                }
                return -1;
            }
        });
    }
}

