/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import org.jetbrains.annotations.Nullable;

public abstract class EditorWriteActionHandler
extends EditorActionHandler {
    private boolean inExecution;

    protected EditorWriteActionHandler() {
    }

    protected EditorWriteActionHandler(boolean runForEachCaret) {
        super(runForEachCaret);
    }

    @Override
    public void doExecute(final Editor editor, final @Nullable Caret caret, final DataContext dataContext) {
        if (editor.isViewer() || !EditorModificationUtil.requestWriting(editor)) {
            return;
        }
        DocumentRunnable runnable = new DocumentRunnable(editor.getDocument(), editor.getProject()){

            @Override
            public void run() {
                Document doc = editor.getDocument();
                doc.startGuardedBlockChecking();
                try {
                    EditorWriteActionHandler.this.executeWriteAction(editor, caret, dataContext);
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                }
                finally {
                    doc.stopGuardedBlockChecking();
                }
            }
        };
        if (editor instanceof TextComponentEditor) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().runWriteAction(runnable);
        }
    }

    public void executeWriteAction(Editor editor, DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.executeWriteAction(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.executeWriteAction(editor, dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }
}

