/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypeActionRunnable;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.reporting.FreezeLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedAction {
    @NotNull
    private TypedActionHandler myRawHandler;
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    public TypedAction() {
        this.myRawHandler = new DefaultRawHandler();
    }

    private void ensureHandlersLoaded() {
        if (!this.myHandlersLoaded) {
            this.myHandlersLoaded = true;
            for (EditorTypedHandlerBean handlerBean : (EditorTypedHandlerBean[])Extensions.getExtensions(EditorTypedHandlerBean.EP_NAME)) {
                this.myHandler = handlerBean.getHandler(this.myHandler);
            }
        }
    }

    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    @NotNull
    public TypedActionHandler getRawHandler() {
        TypedActionHandler typedActionHandler = this.myRawHandler;
        if (typedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actionSystem/TypedAction", "getRawHandler"));
        }
        return typedActionHandler;
    }

    @NotNull
    public TypedActionHandler setupRawHandler(@NotNull TypedActionHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/actionSystem/TypedAction", "setupRawHandler"));
        }
        TypedActionHandler tmp = this.myRawHandler;
        this.myRawHandler = handler;
        TypedActionHandler typedActionHandler = tmp;
        if (typedActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actionSystem/TypedAction", "setupRawHandler"));
        }
        return typedActionHandler;
    }

    public final void actionPerformed(@Nullable Editor editor, char charTyped, DataContext dataContext) {
        if (editor == null) {
            return;
        }
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        FreezeLogger.getInstance().runUnderPerformanceMonitor(project, () -> this.myRawHandler.execute(editor, charTyped, dataContext));
    }

    private class DefaultRawHandler
    implements TypedActionHandler {
        private DefaultRawHandler() {
        }

        @Override
        public void execute(final @NotNull Editor editor, final char charTyped, final @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actionSystem/TypedAction$DefaultRawHandler", "execute"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/actionSystem/TypedAction$DefaultRawHandler", "execute"));
            }
            CommandProcessor.getInstance().executeCommand(CommonDataKeys.PROJECT.getData(dataContext), (Runnable)new TypeActionRunnable(){

                @Override
                public char getTypedChar() {
                    return charTyped;
                }

                @Override
                public void run() {
                    if (!EditorModificationUtil.requestWriting(editor)) {
                        HintManager.getInstance().showInformationHint(editor, "File is not writable");
                        return;
                    }
                    ApplicationManager.getApplication().runWriteAction(new DocumentRunnable(editor.getDocument(), editor.getProject()){

                        @Override
                        public void run() {
                            Document doc = editor.getDocument();
                            doc.startGuardedBlockChecking();
                            try {
                                TypedAction.this.getHandler().execute(editor, charTyped, dataContext);
                            }
                            catch (ReadOnlyFragmentModificationException e) {
                                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
                            }
                            finally {
                                doc.stopGuardedBlockChecking();
                            }
                        }
                    });
                }
            }, "", (Object)editor.getDocument(), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
        }
    }

    private static class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actionSystem/TypedAction$Handler", "execute"));
            }
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/editor/actionSystem/TypedAction$Handler", "execute"));
            }
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }
    }
}

