/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SimpleToolWindowPanel
extends JPanel
implements QuickActionProvider,
DataProvider {
    protected JComponent myToolbar;
    private JComponent myContent;
    private boolean myBorderless;
    protected boolean myVertical;
    private boolean myProvideQuickActions;

    public SimpleToolWindowPanel(boolean vertical) {
        this(vertical, false);
    }

    public SimpleToolWindowPanel(boolean vertical, boolean borderless) {
        this.setLayout(new BorderLayout(vertical ? 0 : 1, vertical ? 1 : 0));
        this.myBorderless = borderless;
        this.myVertical = vertical;
        this.setProvideQuickActions(true);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof Container) {
                    ((Container)child).addContainerListener(this);
                }
                if (SimpleToolWindowPanel.this.myBorderless) {
                    UIUtil.removeScrollBorder((Component)SimpleToolWindowPanel.this);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof Container) {
                    ((Container)child).removeContainerListener(this);
                }
            }
        });
    }

    public boolean isToolbarVisible() {
        return this.myToolbar != null && this.myToolbar.isVisible();
    }

    public void setToolbar(@Nullable JComponent c) {
        if (c == null) {
            this.remove(this.myToolbar);
        }
        this.myToolbar = c;
        if (c != null) {
            if (this.myVertical) {
                this.add((Component)c, "North");
            } else {
                this.add((Component)c, "West");
            }
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        return QuickActionProvider.KEY.is(dataId) && this.myProvideQuickActions ? this : null;
    }

    public SimpleToolWindowPanel setProvideQuickActions(boolean provide) {
        this.myProvideQuickActions = provide;
        return this;
    }

    @Override
    public List<AnAction> getActions(boolean originalProvider) {
        JBIterable toolbars = UIUtil.uiTraverser((Component)this.myToolbar).traverse().filter(ActionToolbar.class);
        if (toolbars.size() == 0) {
            return null;
        }
        return toolbars.flatten(toolbar -> toolbar.getActions(originalProvider)).toList();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isCycleRoot() {
        return false;
    }

    public void setContent(JComponent c) {
        this.myContent = c;
        this.add((Component)c, "Center");
        if (this.myBorderless) {
            UIUtil.removeScrollBorder((Component)c);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myToolbar != null && this.myToolbar.getParent() == this && this.myContent != null && this.myContent.getParent() == this) {
            g.setColor(UIUtil.getBorderColor());
            if (this.myVertical) {
                int y = (int)this.myToolbar.getBounds().getMaxY();
                g.drawLine(0, y, this.getWidth(), y);
            } else {
                int x = (int)this.myToolbar.getBounds().getMaxX();
                g.drawLine(x, 0, x, this.getHeight());
            }
        }
    }
}

