/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class PackageWrapper {
    private final PsiManager myManager;
    @NotNull
    private final String myQualifiedName;

    public PackageWrapper(PsiManager manager, @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/refactoring/PackageWrapper", "<init>"));
        }
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    public PackageWrapper(PsiPackage aPackage) {
        this.myManager = aPackage.getManager();
        this.myQualifiedName = aPackage.getQualifiedName();
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public PsiDirectory[] getDirectories() {
        String qName = this.myQualifiedName;
        while (qName.endsWith(".")) {
            qName = StringUtil.trimEnd((String)qName, (String)".");
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(qName);
        if (aPackage != null) {
            return aPackage.getDirectories();
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    public boolean exists() {
        Project project = this.myManager.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(this.myQualifiedName);
        return aPackage != null && aPackage.getDirectories(GlobalSearchScope.projectScope(project)).length > 0;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/PackageWrapper", "getQualifiedName"));
        }
        return string;
    }

    public boolean equalToPackage(PsiPackage aPackage) {
        return aPackage != null && this.myQualifiedName.equals(aPackage.getQualifiedName());
    }

    public static PackageWrapper create(PsiPackage aPackage) {
        return new PackageWrapper(aPackage);
    }
}

