/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RequestBuilder {
    public abstract RequestBuilder connectTimeout(int var1);

    public abstract RequestBuilder readTimeout(int var1);

    public abstract RequestBuilder redirectLimit(int var1);

    public abstract RequestBuilder gzip(boolean var1);

    public abstract RequestBuilder forceHttps(boolean var1);

    public abstract RequestBuilder useProxy(boolean var1);

    public abstract RequestBuilder hostNameVerifier(@Nullable HostnameVerifier var1);

    public abstract RequestBuilder sslSocketFactory(@Nullable SSLSocketFactory var1);

    public abstract RequestBuilder userAgent(@Nullable String var1);

    public abstract RequestBuilder productNameAsUserAgent();

    public abstract RequestBuilder accept(@Nullable String var1);

    public abstract RequestBuilder tuner(@Nullable HttpRequests.ConnectionTuner var1);

    public abstract <T> T connect(@NotNull HttpRequests.RequestProcessor<T> var1) throws IOException;

    public int tryConnect() throws IOException {
        return this.connect(request -> {
            URLConnection connection = request.getConnection();
            return connection instanceof HttpURLConnection ? ((HttpURLConnection)connection).getResponseCode() : -1;
        });
    }

    public <T> T connect(@NotNull HttpRequests.RequestProcessor<T> processor, T errorValue, @Nullable Logger logger) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/io/RequestBuilder", "connect"));
        }
        try {
            return this.connect(processor);
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.warn(e);
            }
            return errorValue;
        }
    }

    public void saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/RequestBuilder", "saveToFile"));
        }
        this.connect(request -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/RequestBuilder", "lambda$saveToFile$1"));
            }
            return request.saveToFile(file, indicator);
        });
    }

    @NotNull
    public byte[] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
        byte[] byArray = this.connect(request -> request.readBytes(indicator));
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "readBytes"));
        }
        return byArray;
    }

    @NotNull
    public String readString(@Nullable ProgressIndicator indicator) throws IOException {
        String string = this.connect(request -> request.readString(indicator));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/RequestBuilder", "readString"));
        }
        return string;
    }
}

