/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class XDebuggerEvaluator {
    public abstract void evaluate(@NotNull String var1, @NotNull XEvaluationCallback var2, @Nullable XSourcePosition var3);

    public void evaluate(@NotNull XExpression expression, @NotNull XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "evaluate"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "evaluate"));
        }
        this.evaluate(expression.getExpression(), callback, expressionPosition);
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return true;
    }

    @Deprecated
    @Nullable
    protected TextRange getExpressionRangeAtOffset(Project project, Document document, int offset, boolean sideEffectsAllowed) {
        return null;
    }

    @Nullable
    protected ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "getExpressionInfoAtOffset"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "getExpressionInfoAtOffset"));
        }
        TextRange range = this.getExpressionRangeAtOffset(project, document, offset, sideEffectsAllowed);
        return range == null ? null : new ExpressionInfo(range);
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "getExpressionInfoAtOffsetAsync"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "getExpressionInfoAtOffsetAsync"));
        }
        Promise<ExpressionInfo> promise = Promise.resolve(this.getExpressionInfoAtOffset(project, document, offset, sideEffectsAllowed));
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "getExpressionInfoAtOffsetAsync"));
        }
        return promise;
    }

    @NotNull
    public String formatTextForEvaluation(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "formatTextForEvaluation"));
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "formatTextForEvaluation"));
        }
        return string;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/evaluation/XDebuggerEvaluator", "getEvaluationMode"));
        }
        return text.contains("\n") ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
    }

    public static interface XEvaluationCallback
    extends XValueCallback {
        public void evaluated(@NotNull XValue var1);
    }
}

