using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class ActionsModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<ActionDefsModel> Defs { get { return _Defs; }}
    [NotNull] private readonly RdProperty<ActionDefsModel> _Defs;
    [NotNull] public IRdProperty<ActionExecuteRequest> Execute { get { return _Execute; }}
    [NotNull] private readonly RdProperty<ActionExecuteRequest> _Execute;
    [NotNull] public IRdProperty<bool> EscapeAvailability { get { return _EscapeAvailability; }}
    [NotNull] private readonly RdProperty<bool> _EscapeAvailability;
    
    //primary constructor
    public ActionsModel(
      [NotNull] RdProperty<ActionDefsModel> defs,
      [NotNull] RdProperty<ActionExecuteRequest> execute,
      [NotNull] RdProperty<bool> escapeAvailability
    )
    {
      _Defs = defs;
      _Execute = execute;
      _EscapeAvailability = escapeAvailability;
      escapeAvailability.OptimizeNested = true;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(ActionDefModel.Read, ActionDefModel.Write);
      serializers.Register(ActionDefsModel.Read, ActionDefsModel.Write);
      serializers.Register(TextControlConstant.Read, TextControlConstant.Write);
      serializers.Register(ClipboardTextConstant.Read, ClipboardTextConstant.Write);
      serializers.Register(SelectedItemsConstant.Read, SelectedItemsConstant.Write);
      serializers.Register(DataContextModel.Read, DataContextModel.Write);
      serializers.RegisterEnum<ActionExecuteSyncHandshakeResult>();
      serializers.Register(ActionExecuteSyncHandshake.Read, ActionExecuteSyncHandshake.Write);
      serializers.Register(ActionExecuteRequest.Read, ActionExecuteRequest.Write);
    }
    
    public ActionsModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<ActionDefsModel>().Static(1001),
      new RdProperty<ActionExecuteRequest>().Static(1002),
      new RdProperty<bool>().Static(1003)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _Defs.BindEx(lifetime, this, "defs");
      _Execute.BindEx(lifetime, this, "execute");
      _EscapeAvailability.BindEx(lifetime, this, "escapeAvailability");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Defs.IdentifyEx(ids);
      _Execute.IdentifyEx(ids);
      _EscapeAvailability.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionsModel (");
      using (printer.IndentCookie()) {
        printer.Print("defs = "); _Defs.PrintEx(printer); printer.Println();
        printer.Print("execute = "); _Execute.PrintEx(printer); printer.Println();
        printer.Print("escapeAvailability = "); _EscapeAvailability.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionDefModel : RdBindableBase {
    //fields
    [NotNull] public string ReSharperId {get; private set;}
    
    //primary constructor
    public ActionDefModel(
      [NotNull] string reSharperId
    )
    {
      ReSharperId = reSharperId;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<ActionDefModel> Read = (ctx, reader) => 
    {
      var reSharperId = reader.ReadString();
      return new ActionDefModel(reSharperId);
    };
    
    public static CtxWriteDelegate<ActionDefModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ReSharperId);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionDefModel (");
      using (printer.IndentCookie()) {
        printer.Print("reSharperId = "); ReSharperId.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionDefsModel : RdBindableBase {
    //fields
    [NotNull] public List<ActionDefModel> AllDefs {get; private set;}
    
    //primary constructor
    public ActionDefsModel(
      [NotNull] List<ActionDefModel> allDefs
    )
    {
      AllDefs = allDefs;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<ActionDefModel>> ReadActionDefModelList = ActionDefModel.Read.List();
    public static CtxReadDelegate<ActionDefsModel> Read = (ctx, reader) => 
    {
      var allDefs = ReadActionDefModelList(ctx, reader);
      return new ActionDefsModel(allDefs);
    };
    
    public static CtxWriteDelegate<List<ActionDefModel>> WriteActionDefModelList = ActionDefModel.Write.List();
    public static CtxWriteDelegate<ActionDefsModel> Write = (ctx, writer, value) => 
    {
      WriteActionDefModelList(ctx, writer, value.AllDefs);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      AllDefs.BindEx(lifetime, this, "allDefs");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      AllDefs.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionDefsModel (");
      using (printer.IndentCookie()) {
        printer.Print("allDefs = "); AllDefs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionExecuteRequest : RdBindableBase {
    //fields
    [NotNull] public DataContextModel DataContext {get; private set;}
    [NotNull] public string ReSharperId {get; private set;}
    [NotNull] public IRdProperty<ActionExecuteSyncHandshake> Handshake { get { return _Handshake; }}
    [NotNull] private readonly RdProperty<ActionExecuteSyncHandshake> _Handshake;
    
    //primary constructor
    private ActionExecuteRequest(
      [NotNull] DataContextModel dataContext,
      [NotNull] string reSharperId,
      [NotNull] RdProperty<ActionExecuteSyncHandshake> handshake
    )
    {
      DataContext = dataContext;
      ReSharperId = reSharperId;
      _Handshake = handshake;
    }
    //secondary constructor
    public ActionExecuteRequest (
      [NotNull] DataContextModel DataContext,
      [NotNull] string ReSharperId
    ) : this (
      DataContext,
      ReSharperId,
      new RdProperty<ActionExecuteSyncHandshake>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ActionExecuteSyncHandshake> ReadActionExecuteSyncHandshakeNullable = ActionExecuteSyncHandshake.Read.NullableClass();
    public static CtxReadDelegate<ActionExecuteRequest> Read = (ctx, reader) => 
    {
      var dataContext = DataContextModel.Read(ctx, reader);
      var reSharperId = reader.ReadString();
      var handshake = RdProperty<ActionExecuteSyncHandshake>.Read(ctx, reader);
      return new ActionExecuteRequest(dataContext, reSharperId, handshake);
    };
    
    public static CtxWriteDelegate<ActionExecuteSyncHandshake> WriteActionExecuteSyncHandshakeNullable = ActionExecuteSyncHandshake.Write.NullableClass();
    public static CtxWriteDelegate<ActionExecuteRequest> Write = (ctx, writer, value) => 
    {
      DataContextModel.Write(ctx, writer, value.DataContext);
      writer.Write(value.ReSharperId);
      RdProperty<ActionExecuteSyncHandshake>.Write(ctx, writer, value._Handshake);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      DataContext.BindEx(lifetime, this, "dataContext");
      _Handshake.BindEx(lifetime, this, "handshake");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      DataContext.IdentifyEx(ids);
      _Handshake.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionExecuteRequest (");
      using (printer.IndentCookie()) {
        printer.Print("dataContext = "); DataContext.PrintEx(printer); printer.Println();
        printer.Print("reSharperId = "); ReSharperId.PrintEx(printer); printer.Println();
        printer.Print("handshake = "); _Handshake.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ActionExecuteSyncHandshake : RdBindableBase {
    //fields
    [NotNull] public ISink<ActionExecuteSyncHandshakeResult> Result { get { return _Result; }}
    [NotNull] private readonly RdSignal<ActionExecuteSyncHandshakeResult> _Result;
    [NotNull] public ISource<ActionExecuteSyncHandshakeResult> BackendResult { get { return _BackendResult; }}
    [NotNull] private readonly RdSignal<ActionExecuteSyncHandshakeResult> _BackendResult;
    
    //primary constructor
    private ActionExecuteSyncHandshake(
      [NotNull] RdSignal<ActionExecuteSyncHandshakeResult> result,
      [NotNull] RdSignal<ActionExecuteSyncHandshakeResult> backendResult
    )
    {
      _Result = result;
      _BackendResult = backendResult;
    }
    //secondary constructor
    public ActionExecuteSyncHandshake (
    ) : this (
      new RdSignal<ActionExecuteSyncHandshakeResult>(),
      new RdSignal<ActionExecuteSyncHandshakeResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ActionExecuteSyncHandshakeResult> ReadActionExecuteSyncHandshakeResult = new CtxReadDelegate<ActionExecuteSyncHandshakeResult>(Serializers.ReadEnum<ActionExecuteSyncHandshakeResult>);
    public static CtxReadDelegate<ActionExecuteSyncHandshake> Read = (ctx, reader) => 
    {
      var result = RdSignal<ActionExecuteSyncHandshakeResult>.Read(ctx, reader);
      var backendResult = RdSignal<ActionExecuteSyncHandshakeResult>.Read(ctx, reader);
      return new ActionExecuteSyncHandshake(result, backendResult);
    };
    
    public static CtxWriteDelegate<ActionExecuteSyncHandshakeResult> WriteActionExecuteSyncHandshakeResult = new CtxWriteDelegate<ActionExecuteSyncHandshakeResult>(Serializers.WriteEnum<ActionExecuteSyncHandshakeResult>);
    public static CtxWriteDelegate<ActionExecuteSyncHandshake> Write = (ctx, writer, value) => 
    {
      RdSignal<ActionExecuteSyncHandshakeResult>.Write(ctx, writer, value._Result);
      RdSignal<ActionExecuteSyncHandshakeResult>.Write(ctx, writer, value._BackendResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Result.BindEx(lifetime, this, "result");
      _BackendResult.BindEx(lifetime, this, "backendResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Result.IdentifyEx(ids);
      _BackendResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ActionExecuteSyncHandshake (");
      using (printer.IndentCookie()) {
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
        printer.Print("backendResult = "); _BackendResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ActionExecuteSyncHandshakeResult {
    Ready
  }
  
  
  public class ClipboardTextConstant : RdDataConstant
   {
    //fields
    [CanBeNull] public string Text {get; private set;}
    
    //primary constructor
    public ClipboardTextConstant(
      [CanBeNull] string text
    )
    {
      Text = text;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static new CtxReadDelegate<ClipboardTextConstant> Read = (ctx, reader) => 
    {
      var text = ReadStringNullable(ctx, reader);
      return new ClipboardTextConstant(text);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static new CtxWriteDelegate<ClipboardTextConstant> Write = (ctx, writer, value) => 
    {
      WriteStringNullable(ctx, writer, value.Text);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ClipboardTextConstant) obj);
    }
    public bool Equals(ClipboardTextConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Text, other.Text);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (Text != null ?Text.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ClipboardTextConstant (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class DataContextModel : RdBindableBase {
    //fields
    [NotNull] public List<RdDataConstant> DataContext {get; private set;}
    
    //primary constructor
    public DataContextModel(
      [NotNull] List<RdDataConstant> dataContext
    )
    {
      DataContext = dataContext;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<RdDataConstant>> ReadRdDataConstantList = RdDataConstant.Read.List();
    public static CtxReadDelegate<DataContextModel> Read = (ctx, reader) => 
    {
      var dataContext = ReadRdDataConstantList(ctx, reader);
      return new DataContextModel(dataContext);
    };
    
    public static CtxWriteDelegate<List<RdDataConstant>> WriteRdDataConstantList = RdDataConstant.Write.List();
    public static CtxWriteDelegate<DataContextModel> Write = (ctx, writer, value) => 
    {
      WriteRdDataConstantList(ctx, writer, value.DataContext);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("DataContextModel (");
      using (printer.IndentCookie()) {
        printer.Print("dataContext = "); DataContext.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class RdDataConstant {
    //fields
    //primary constructor
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RdDataConstant> Read = (ctx, reader) => ctx.Serializers.Read<RdDataConstant>(ctx, reader);
    
    public static CtxWriteDelegate<RdDataConstant> Write = (ctx, writer, value) => ctx.Serializers.Write<RdDataConstant>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class SelectedItemsConstant : RdDataConstant
   {
    //fields
    [NotNull] public List<int> Items {get; private set;}
    
    //primary constructor
    public SelectedItemsConstant(
      [NotNull] List<int> items
    )
    {
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<int>> ReadIntList = Serializers.ReadInt.List();
    public static new CtxReadDelegate<SelectedItemsConstant> Read = (ctx, reader) => 
    {
      var items = ReadIntList(ctx, reader);
      return new SelectedItemsConstant(items);
    };
    
    public static CtxWriteDelegate<List<int>> WriteIntList = Serializers.WriteInt.List();
    public static new CtxWriteDelegate<SelectedItemsConstant> Write = (ctx, writer, value) => 
    {
      WriteIntList(ctx, writer, value.Items);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((SelectedItemsConstant) obj);
    }
    public bool Equals(SelectedItemsConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Items.SequenceEqual(other.Items);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Items);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("SelectedItemsConstant (");
      using (printer.IndentCookie()) {
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TextControlConstant : RdDataConstant
   {
    //fields
    [CanBeNull] public TextControlId Id {get; private set;}
    
    //primary constructor
    public TextControlConstant(
      [CanBeNull] TextControlId id
    )
    {
      Id = id;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<TextControlId> ReadTextControlIdNullable = TextControlId.Read.NullableClass();
    public static new CtxReadDelegate<TextControlConstant> Read = (ctx, reader) => 
    {
      var id = ReadTextControlIdNullable(ctx, reader);
      return new TextControlConstant(id);
    };
    
    public static CtxWriteDelegate<TextControlId> WriteTextControlIdNullable = TextControlId.Write.NullableClass();
    public static new CtxWriteDelegate<TextControlConstant> Write = (ctx, writer, value) => 
    {
      WriteTextControlIdNullable(ctx, writer, value.Id);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TextControlConstant) obj);
    }
    public bool Equals(TextControlConstant other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Equals(Id, other.Id);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (Id != null ?Id.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TextControlConstant (");
      using (printer.IndentCookie()) {
        printer.Print("id = "); Id.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
