using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class AddProjectReferenceModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<ModelReady> WhenReady { get { return _WhenReady; }}
    [NotNull] private readonly RdProperty<ModelReady> _WhenReady;
    
    //primary constructor
    public AddProjectReferenceModel(
      [NotNull] RdProperty<ModelReady> whenReady
    )
    {
      _WhenReady = whenReady;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.RegisterEnum<ReferenceItemKind>();
      serializers.Register(AddReferenceItem.Read, AddReferenceItem.Write);
      serializers.Register(ReferenceList.Read, ReferenceList.Write);
      serializers.Register(CustomLibraries.Read, CustomLibraries.Write);
      serializers.Register(ModelReady.Read, ModelReady.Write);
    }
    
    public AddProjectReferenceModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<ModelReady>().Static(1004)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _WhenReady.BindEx(lifetime, this, "whenReady");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _WhenReady.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("AddProjectReferenceModel (");
      using (printer.IndentCookie()) {
        printer.Print("whenReady = "); _WhenReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class AddReferenceItem : IPrintable, IEquatable<AddReferenceItem> {
    //fields
    [NotNull] public string ShortPresentation {get; private set;}
    [NotNull] public string PresentationDisambiguation {get; private set;}
    [NotNull] public string FailReason {get; private set;}
    [NotNull] public string Tooltip {get; private set;}
    [NotNull] public string TargetLocation {get; private set;}
    public ReferenceItemKind Kind {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public AddReferenceItem(
      [NotNull] string shortPresentation,
      [NotNull] string presentationDisambiguation,
      [NotNull] string failReason,
      [NotNull] string tooltip,
      [NotNull] string targetLocation,
      ReferenceItemKind kind,
      [NotNull] JetBrains.Rider.Model.Icon icon
    )
    {
      ShortPresentation = shortPresentation;
      PresentationDisambiguation = presentationDisambiguation;
      FailReason = failReason;
      Tooltip = tooltip;
      TargetLocation = targetLocation;
      Kind = kind;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<AddReferenceItem> Read = (ctx, reader) => 
    {
      var shortPresentation = reader.ReadString();
      var presentationDisambiguation = reader.ReadString();
      var failReason = reader.ReadString();
      var tooltip = reader.ReadString();
      var targetLocation = reader.ReadString();
      var kind = (ReferenceItemKind)reader.ReadInt();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      return new AddReferenceItem(shortPresentation, presentationDisambiguation, failReason, tooltip, targetLocation, kind, icon);
    };
    
    public static CtxWriteDelegate<AddReferenceItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ShortPresentation);
      writer.Write(value.PresentationDisambiguation);
      writer.Write(value.FailReason);
      writer.Write(value.Tooltip);
      writer.Write(value.TargetLocation);
      writer.Write((int)value.Kind);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((AddReferenceItem) obj);
    }
    public bool Equals(AddReferenceItem other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ShortPresentation == other.ShortPresentation && PresentationDisambiguation == other.PresentationDisambiguation && FailReason == other.FailReason && Tooltip == other.Tooltip && TargetLocation == other.TargetLocation && Kind == other.Kind && Equals(Icon, other.Icon);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + ShortPresentation.GetHashCode();
        __r = __r*31 + PresentationDisambiguation.GetHashCode();
        __r = __r*31 + FailReason.GetHashCode();
        __r = __r*31 + Tooltip.GetHashCode();
        __r = __r*31 + TargetLocation.GetHashCode();
        __r = __r*31 + (int) Kind;
        __r = __r*31 + Icon.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("AddReferenceItem (");
      using (printer.IndentCookie()) {
        printer.Print("shortPresentation = "); ShortPresentation.PrintEx(printer); printer.Println();
        printer.Print("presentationDisambiguation = "); PresentationDisambiguation.PrintEx(printer); printer.Println();
        printer.Print("failReason = "); FailReason.PrintEx(printer); printer.Println();
        printer.Print("tooltip = "); Tooltip.PrintEx(printer); printer.Println();
        printer.Print("targetLocation = "); TargetLocation.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class CustomLibraries : IPrintable, IEquatable<CustomLibraries> {
    //fields
    [NotNull] public List<string> Paths {get; private set;}
    
    //primary constructor
    public CustomLibraries(
      [NotNull] List<string> paths
    )
    {
      Paths = paths;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<CustomLibraries> Read = (ctx, reader) => 
    {
      var paths = ReadStringList(ctx, reader);
      return new CustomLibraries(paths);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<CustomLibraries> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Paths);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((CustomLibraries) obj);
    }
    public bool Equals(CustomLibraries other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Paths.SequenceEqual(other.Paths);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(Paths);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("CustomLibraries (");
      using (printer.IndentCookie()) {
        printer.Print("paths = "); Paths.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class ModelReady : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<int, ReferenceList> GetReferences { get { return _GetReferences; }}
    [NotNull] private readonly RdEndpoint<int, ReferenceList> _GetReferences;
    [NotNull] public ISink<ReferenceList> ReferenceApplied { get { return _ReferenceApplied; }}
    [NotNull] private readonly RdSignal<ReferenceList> _ReferenceApplied;
    [NotNull] public ISink<CustomLibraries> CustomReferenceApplied { get { return _CustomReferenceApplied; }}
    [NotNull] private readonly RdSignal<CustomLibraries> _CustomReferenceApplied;
    
    //primary constructor
    private ModelReady(
      [NotNull] RdEndpoint<int, ReferenceList> getReferences,
      [NotNull] RdSignal<ReferenceList> referenceApplied,
      [NotNull] RdSignal<CustomLibraries> customReferenceApplied
    )
    {
      _GetReferences = getReferences;
      _ReferenceApplied = referenceApplied;
      _CustomReferenceApplied = customReferenceApplied;
    }
    //secondary constructor
    public ModelReady (
    ) : this (
      new RdEndpoint<int, ReferenceList>(),
      new RdSignal<ReferenceList>(),
      new RdSignal<CustomLibraries>()
    ) {}
    //statics
    
    public static CtxReadDelegate<ModelReady> Read = (ctx, reader) => 
    {
      var getReferences = RdEndpoint<int, ReferenceList>.Read(ctx, reader);
      var referenceApplied = RdSignal<ReferenceList>.Read(ctx, reader);
      var customReferenceApplied = RdSignal<CustomLibraries>.Read(ctx, reader);
      return new ModelReady(getReferences, referenceApplied, customReferenceApplied);
    };
    
    public static CtxWriteDelegate<ModelReady> Write = (ctx, writer, value) => 
    {
      RdEndpoint<int, ReferenceList>.Write(ctx, writer, value._GetReferences);
      RdSignal<ReferenceList>.Write(ctx, writer, value._ReferenceApplied);
      RdSignal<CustomLibraries>.Write(ctx, writer, value._CustomReferenceApplied);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _GetReferences.BindEx(lifetime, this, "getReferences");
      _ReferenceApplied.BindEx(lifetime, this, "referenceApplied");
      _CustomReferenceApplied.BindEx(lifetime, this, "customReferenceApplied");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GetReferences.IdentifyEx(ids);
      _ReferenceApplied.IdentifyEx(ids);
      _CustomReferenceApplied.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("ModelReady (");
      using (printer.IndentCookie()) {
        printer.Print("getReferences = "); _GetReferences.PrintEx(printer); printer.Println();
        printer.Print("referenceApplied = "); _ReferenceApplied.PrintEx(printer); printer.Println();
        printer.Print("customReferenceApplied = "); _CustomReferenceApplied.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum ReferenceItemKind {
    SystemLibrary,
    CustomLibrary,
    ProjectReference,
    BadResult
  }
  
  
  public class ReferenceList : IPrintable, IEquatable<ReferenceList> {
    //fields
    [NotNull] public List<AddReferenceItem> ReferenceItems {get; private set;}
    
    //primary constructor
    public ReferenceList(
      [NotNull] List<AddReferenceItem> referenceItems
    )
    {
      ReferenceItems = referenceItems;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<AddReferenceItem>> ReadAddReferenceItemList = AddReferenceItem.Read.List();
    public static CtxReadDelegate<ReferenceList> Read = (ctx, reader) => 
    {
      var referenceItems = ReadAddReferenceItemList(ctx, reader);
      return new ReferenceList(referenceItems);
    };
    
    public static CtxWriteDelegate<List<AddReferenceItem>> WriteAddReferenceItemList = AddReferenceItem.Write.List();
    public static CtxWriteDelegate<ReferenceList> Write = (ctx, writer, value) => 
    {
      WriteAddReferenceItemList(ctx, writer, value.ReferenceItems);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((ReferenceList) obj);
    }
    public bool Equals(ReferenceList other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return ReferenceItems.SequenceEqual(other.ReferenceItems);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + CollectionUtil.GetHashCode(ReferenceItems);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("ReferenceList (");
      using (printer.IndentCookie()) {
        printer.Print("referenceItems = "); ReferenceItems.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
