using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class BuildModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<JetBrains.Rider.Model.BuildModelReady> BuildModelReady { get { return _BuildModelReady; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.BuildModelReady> _BuildModelReady;
    
    //primary constructor
    public BuildModel(
      [NotNull] RdProperty<JetBrains.Rider.Model.BuildModelReady> buildModelReady
    )
    {
      _BuildModelReady = buildModelReady;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.RegisterEnum<BuildEventKind>();
      serializers.RegisterEnum<BuildResultKind>();
      serializers.RegisterEnum<BuildMessageKind>();
      serializers.RegisterEnum<BuildOperationKind>();
      serializers.Register(BuildEvent.Read, BuildEvent.Write);
      serializers.Register(BuildOutputMessage.Read, BuildOutputMessage.Write);
      serializers.Register(BuildSession.Read, BuildSession.Write);
      serializers.Register(BuildArgs.Read, BuildArgs.Write);
      serializers.Register(JetBrains.Rider.Model.BuildModelReady.Read, JetBrains.Rider.Model.BuildModelReady.Write);
    }
    
    public BuildModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<JetBrains.Rider.Model.BuildModelReady>().Static(1005)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _BuildModelReady.BindEx(lifetime, this, "buildModelReady");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _BuildModelReady.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BuildModel (");
      using (printer.IndentCookie()) {
        printer.Print("buildModelReady = "); _BuildModelReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BuildArgs : IPrintable, IEquatable<BuildArgs> {
    //fields
    public BuildOperationKind Operation {get; private set;}
    [NotNull] public List<string> SelectedProjects {get; private set;}
    
    //primary constructor
    public BuildArgs(
      BuildOperationKind operation,
      [NotNull] List<string> selectedProjects
    )
    {
      Operation = operation;
      SelectedProjects = selectedProjects;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static CtxReadDelegate<BuildArgs> Read = (ctx, reader) => 
    {
      var operation = (BuildOperationKind)reader.ReadInt();
      var selectedProjects = ReadStringList(ctx, reader);
      return new BuildArgs(operation, selectedProjects);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static CtxWriteDelegate<BuildArgs> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Operation);
      WriteStringList(ctx, writer, value.SelectedProjects);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildArgs) obj);
    }
    public bool Equals(BuildArgs other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Operation == other.Operation && SelectedProjects.SequenceEqual(other.SelectedProjects);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Operation;
        __r = __r*31 + CollectionUtil.GetHashCode(SelectedProjects);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildArgs (");
      using (printer.IndentCookie()) {
        printer.Print("operation = "); Operation.PrintEx(printer); printer.Println();
        printer.Print("selectedProjects = "); SelectedProjects.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class BuildEvent : IPrintable, IEquatable<BuildEvent> {
    //fields
    public BuildEventKind Kind {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    [CanBeNull] public string Code {get; private set;}
    [CanBeNull] public string ProjectPath {get; private set;}
    [CanBeNull] public string FilePath {get; private set;}
    [CanBeNull] public int? Line {get; private set;}
    [CanBeNull] public int? Column {get; private set;}
    
    //primary constructor
    public BuildEvent(
      BuildEventKind kind,
      [CanBeNull] string message,
      [CanBeNull] string code,
      [CanBeNull] string projectPath,
      [CanBeNull] string filePath,
      [CanBeNull] int? line,
      [CanBeNull] int? column
    )
    {
      Kind = kind;
      Message = message;
      Code = code;
      ProjectPath = projectPath;
      FilePath = filePath;
      Line = line;
      Column = column;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<BuildEvent> Read = (ctx, reader) => 
    {
      var kind = (BuildEventKind)reader.ReadInt();
      var message = ReadStringNullable(ctx, reader);
      var code = ReadStringNullable(ctx, reader);
      var projectPath = ReadStringNullable(ctx, reader);
      var filePath = ReadStringNullable(ctx, reader);
      var line = ReadIntNullable(ctx, reader);
      var column = ReadIntNullable(ctx, reader);
      return new BuildEvent(kind, message, code, projectPath, filePath, line, column);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<BuildEvent> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteStringNullable(ctx, writer, value.Message);
      WriteStringNullable(ctx, writer, value.Code);
      WriteStringNullable(ctx, writer, value.ProjectPath);
      WriteStringNullable(ctx, writer, value.FilePath);
      WriteIntNullable(ctx, writer, value.Line);
      WriteIntNullable(ctx, writer, value.Column);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildEvent) obj);
    }
    public bool Equals(BuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(Message, other.Message) && Equals(Code, other.Code) && Equals(ProjectPath, other.ProjectPath) && Equals(FilePath, other.FilePath) && Equals(Line, other.Line) && Equals(Column, other.Column);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Kind;
        __r = __r*31 + (Message != null ?Message.GetHashCode() : 0);
        __r = __r*31 + (Code != null ?Code.GetHashCode() : 0);
        __r = __r*31 + (ProjectPath != null ?ProjectPath.GetHashCode() : 0);
        __r = __r*31 + (FilePath != null ?FilePath.GetHashCode() : 0);
        __r = __r*31 + (Line != null ?Line.GetHashCode() : 0);
        __r = __r*31 + (Column != null ?Column.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("code = "); Code.PrintEx(printer); printer.Println();
        printer.Print("projectPath = "); ProjectPath.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("column = "); Column.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BuildEventKind {
    Error,
    Warning
  }
  
  
  public enum BuildMessageKind {
    Error,
    Warning,
    Message
  }
  
  
  public class BuildModelReady : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<bool> Ready { get { return _Ready; }}
    [NotNull] private readonly RdProperty<bool> _Ready;
    [NotNull] public IRdProperty<bool> UseIncrementalBuild { get { return _UseIncrementalBuild; }}
    [NotNull] private readonly RdProperty<bool> _UseIncrementalBuild;
    [NotNull] public ISink<BuildArgs> Run { get { return _Run; }}
    [NotNull] private readonly RdSignal<BuildArgs> _Run;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.BuildSession> BuildSession { get { return _BuildSession; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.BuildSession> _BuildSession;
    
    //primary constructor
    private BuildModelReady(
      [NotNull] RdProperty<bool> ready,
      [NotNull] RdProperty<bool> useIncrementalBuild,
      [NotNull] RdSignal<BuildArgs> run,
      [NotNull] RdProperty<JetBrains.Rider.Model.BuildSession> buildSession
    )
    {
      _Ready = ready;
      _UseIncrementalBuild = useIncrementalBuild;
      _Run = run;
      _BuildSession = buildSession;
      ready.OptimizeNested = true;
      useIncrementalBuild.OptimizeNested = true;
    }
    //secondary constructor
    public BuildModelReady (
    ) : this (
      new RdProperty<bool>(),
      new RdProperty<bool>(),
      new RdSignal<BuildArgs>(),
      new RdProperty<JetBrains.Rider.Model.BuildSession>()
    ) {}
    //statics
    
    public static CtxReadDelegate<JetBrains.Rider.Model.BuildSession> ReadBuildSessionNullable = JetBrains.Rider.Model.BuildSession.Read.NullableClass();
    public static CtxReadDelegate<BuildModelReady> Read = (ctx, reader) => 
    {
      var ready = RdProperty<bool>.Read(ctx, reader);
      var useIncrementalBuild = RdProperty<bool>.Read(ctx, reader);
      var run = RdSignal<BuildArgs>.Read(ctx, reader);
      var buildSession = RdProperty<JetBrains.Rider.Model.BuildSession>.Read(ctx, reader);
      return new BuildModelReady(ready, useIncrementalBuild, run, buildSession);
    };
    
    public static CtxWriteDelegate<JetBrains.Rider.Model.BuildSession> WriteBuildSessionNullable = JetBrains.Rider.Model.BuildSession.Write.NullableClass();
    public static CtxWriteDelegate<BuildModelReady> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._Ready);
      RdProperty<bool>.Write(ctx, writer, value._UseIncrementalBuild);
      RdSignal<BuildArgs>.Write(ctx, writer, value._Run);
      RdProperty<JetBrains.Rider.Model.BuildSession>.Write(ctx, writer, value._BuildSession);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Ready.BindEx(lifetime, this, "ready");
      _UseIncrementalBuild.BindEx(lifetime, this, "useIncrementalBuild");
      _Run.BindEx(lifetime, this, "run");
      _BuildSession.BindEx(lifetime, this, "buildSession");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Ready.IdentifyEx(ids);
      _UseIncrementalBuild.IdentifyEx(ids);
      _Run.IdentifyEx(ids);
      _BuildSession.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BuildModelReady (");
      using (printer.IndentCookie()) {
        printer.Print("ready = "); _Ready.PrintEx(printer); printer.Println();
        printer.Print("useIncrementalBuild = "); _UseIncrementalBuild.PrintEx(printer); printer.Println();
        printer.Print("run = "); _Run.PrintEx(printer); printer.Println();
        printer.Print("buildSession = "); _BuildSession.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BuildOperationKind {
    Build,
    Rebuild,
    Clean
  }
  
  
  public class BuildOutputMessage : IPrintable, IEquatable<BuildOutputMessage> {
    //fields
    [NotNull] public string Message {get; private set;}
    public BuildMessageKind Type {get; private set;}
    
    //primary constructor
    public BuildOutputMessage(
      [NotNull] string message,
      BuildMessageKind type
    )
    {
      Message = message;
      Type = type;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<BuildOutputMessage> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      var type = (BuildMessageKind)reader.ReadInt();
      return new BuildOutputMessage(message, type);
    };
    
    public static CtxWriteDelegate<BuildOutputMessage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
      writer.Write((int)value.Type);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((BuildOutputMessage) obj);
    }
    public bool Equals(BuildOutputMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Message == other.Message && Type == other.Type;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Message.GetHashCode();
        __r = __r*31 + (int) Type;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("BuildOutputMessage (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("type = "); Type.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BuildResultKind {
    HasErrors,
    HasWarnings,
    Successful,
    Canceled,
    Crashed
  }
  
  
  public class BuildSession : RdBindableBase {
    //fields
    public BuildOperationKind Operation {get; private set;}
    [NotNull] public IVoidSink Cancel { get { return _Cancel; }}
    [NotNull] private readonly RdVoidSignal _Cancel;
    [NotNull] public IRdProperty<double> Progress { get { return _Progress; }}
    [NotNull] private readonly RdProperty<double> _Progress;
    [NotNull] public IRdProperty<string> ActiveProjectName { get { return _ActiveProjectName; }}
    [NotNull] private readonly RdProperty<string> _ActiveProjectName;
    [NotNull] public IRdProperty<string> LogFileName { get { return _LogFileName; }}
    [NotNull] private readonly RdProperty<string> _LogFileName;
    [NotNull] public ISource<BuildResultKind> Result { get { return _Result; }}
    [NotNull] private readonly RdSignal<BuildResultKind> _Result;
    [NotNull] public ISource<JetBrains.Rider.Model.BuildEvent> BuildEvent { get { return _BuildEvent; }}
    [NotNull] private readonly RdSignal<JetBrains.Rider.Model.BuildEvent> _BuildEvent;
    [NotNull] public ISource<BuildOutputMessage> OutputMessage { get { return _OutputMessage; }}
    [NotNull] private readonly RdSignal<BuildOutputMessage> _OutputMessage;
    
    //primary constructor
    private BuildSession(
      BuildOperationKind operation,
      [NotNull] RdVoidSignal cancel,
      [NotNull] RdProperty<double> progress,
      [NotNull] RdProperty<string> activeProjectName,
      [NotNull] RdProperty<string> logFileName,
      [NotNull] RdSignal<BuildResultKind> result,
      [NotNull] RdSignal<JetBrains.Rider.Model.BuildEvent> buildEvent,
      [NotNull] RdSignal<BuildOutputMessage> outputMessage
    )
    {
      Operation = operation;
      _Cancel = cancel;
      _Progress = progress;
      _ActiveProjectName = activeProjectName;
      _LogFileName = logFileName;
      _Result = result;
      _BuildEvent = buildEvent;
      _OutputMessage = outputMessage;
      progress.OptimizeNested = true;
      activeProjectName.OptimizeNested = true;
      logFileName.OptimizeNested = true;
    }
    //secondary constructor
    public BuildSession (
      BuildOperationKind Operation
    ) : this (
      Operation,
      new RdVoidSignal(),
      new RdProperty<double>(),
      new RdProperty<string>(),
      new RdProperty<string>(),
      new RdSignal<BuildResultKind>(),
      new RdSignal<JetBrains.Rider.Model.BuildEvent>(),
      new RdSignal<BuildOutputMessage>()
    ) {}
    //statics
    
    public static CtxReadDelegate<BuildResultKind> ReadBuildResultKind = new CtxReadDelegate<BuildResultKind>(Serializers.ReadEnum<BuildResultKind>);
    public static CtxReadDelegate<BuildSession> Read = (ctx, reader) => 
    {
      var operation = (BuildOperationKind)reader.ReadInt();
      var cancel = RdVoidSignal.Read(ctx, reader);
      var progress = RdProperty<double>.Read(ctx, reader);
      var activeProjectName = RdProperty<string>.Read(ctx, reader);
      var logFileName = RdProperty<string>.Read(ctx, reader);
      var result = RdSignal<BuildResultKind>.Read(ctx, reader);
      var buildEvent = RdSignal<JetBrains.Rider.Model.BuildEvent>.Read(ctx, reader);
      var outputMessage = RdSignal<BuildOutputMessage>.Read(ctx, reader);
      return new BuildSession(operation, cancel, progress, activeProjectName, logFileName, result, buildEvent, outputMessage);
    };
    
    public static CtxWriteDelegate<BuildResultKind> WriteBuildResultKind = new CtxWriteDelegate<BuildResultKind>(Serializers.WriteEnum<BuildResultKind>);
    public static CtxWriteDelegate<BuildSession> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Operation);
      RdVoidSignal.Write(ctx, writer, value._Cancel);
      RdProperty<double>.Write(ctx, writer, value._Progress);
      RdProperty<string>.Write(ctx, writer, value._ActiveProjectName);
      RdProperty<string>.Write(ctx, writer, value._LogFileName);
      RdSignal<BuildResultKind>.Write(ctx, writer, value._Result);
      RdSignal<JetBrains.Rider.Model.BuildEvent>.Write(ctx, writer, value._BuildEvent);
      RdSignal<BuildOutputMessage>.Write(ctx, writer, value._OutputMessage);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Cancel.BindEx(lifetime, this, "cancel");
      _Progress.BindEx(lifetime, this, "progress");
      _ActiveProjectName.BindEx(lifetime, this, "activeProjectName");
      _LogFileName.BindEx(lifetime, this, "logFileName");
      _Result.BindEx(lifetime, this, "result");
      _BuildEvent.BindEx(lifetime, this, "buildEvent");
      _OutputMessage.BindEx(lifetime, this, "outputMessage");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Cancel.IdentifyEx(ids);
      _Progress.IdentifyEx(ids);
      _ActiveProjectName.IdentifyEx(ids);
      _LogFileName.IdentifyEx(ids);
      _Result.IdentifyEx(ids);
      _BuildEvent.IdentifyEx(ids);
      _OutputMessage.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("BuildSession (");
      using (printer.IndentCookie()) {
        printer.Print("operation = "); Operation.PrintEx(printer); printer.Println();
        printer.Print("cancel = "); _Cancel.PrintEx(printer); printer.Println();
        printer.Print("progress = "); _Progress.PrintEx(printer); printer.Println();
        printer.Print("activeProjectName = "); _ActiveProjectName.PrintEx(printer); printer.Println();
        printer.Print("logFileName = "); _LogFileName.PrintEx(printer); printer.Println();
        printer.Print("result = "); _Result.PrintEx(printer); printer.Println();
        printer.Print("buildEvent = "); _BuildEvent.PrintEx(printer); printer.Println();
        printer.Print("outputMessage = "); _OutputMessage.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
