using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model
{
  
  
  [ShellComponent]
  public class EditProjectPropertiesModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<EditProjectPropertiesModelReady> WhenReady { get { return _WhenReady; }}
    [NotNull] private readonly RdProperty<EditProjectPropertiesModelReady> _WhenReady;
    
    //primary constructor
    public EditProjectPropertiesModel(
      [NotNull] RdProperty<EditProjectPropertiesModelReady> whenReady
    )
    {
      _WhenReady = whenReady;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(RelatedTargetFile.Read, RelatedTargetFile.Write);
      serializers.Register(EditProjectPropertySectionDiagnosticItem.Read, EditProjectPropertySectionDiagnosticItem.Write);
      serializers.Register(EditProjectPropertySectionItemBoolean.Read, EditProjectPropertySectionItemBoolean.Write);
      serializers.Register(EditProjectPropertyItem.Read, EditProjectPropertyItem.Write);
      serializers.Register(EditProjectPropertySectionItemCombo.Read, EditProjectPropertySectionItemCombo.Write);
      serializers.Register(EditProjectPropertySectionItemText.Read, EditProjectPropertySectionItemText.Write);
      serializers.Register(EditProjectPropertySection.Read, EditProjectPropertySection.Write);
      serializers.Register(EditProjectPropertyConfigurationSection.Read, EditProjectPropertyConfigurationSection.Write);
      serializers.Register(EditProjectPropertiesSessionResult.Read, EditProjectPropertiesSessionResult.Write);
      serializers.Register(EditProjectPropertiesSession.Read, EditProjectPropertiesSession.Write);
      serializers.Register(EditProjectPropertiesModelReady.Read, EditProjectPropertiesModelReady.Write);
    }
    
    public EditProjectPropertiesModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<EditProjectPropertiesModelReady>().Static(1009)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _WhenReady.BindEx(lifetime, this, "whenReady");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _WhenReady.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertiesModel (");
      using (printer.IndentCookie()) {
        printer.Print("whenReady = "); _WhenReady.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertiesModelReady : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<EditProjectPropertiesSession> EditPropertiesSession { get { return _EditPropertiesSession; }}
    [NotNull] private readonly RdProperty<EditProjectPropertiesSession> _EditPropertiesSession;
    
    //primary constructor
    private EditProjectPropertiesModelReady(
      [NotNull] RdProperty<EditProjectPropertiesSession> editPropertiesSession
    )
    {
      _EditPropertiesSession = editPropertiesSession;
    }
    //secondary constructor
    public EditProjectPropertiesModelReady (
    ) : this (
      new RdProperty<EditProjectPropertiesSession>()
    ) {}
    //statics
    
    public static CtxReadDelegate<EditProjectPropertiesSession> ReadEditProjectPropertiesSessionNullable = EditProjectPropertiesSession.Read.NullableClass();
    public static CtxReadDelegate<EditProjectPropertiesModelReady> Read = (ctx, reader) => 
    {
      var editPropertiesSession = RdProperty<EditProjectPropertiesSession>.Read(ctx, reader);
      return new EditProjectPropertiesModelReady(editPropertiesSession);
    };
    
    public static CtxWriteDelegate<EditProjectPropertiesSession> WriteEditProjectPropertiesSessionNullable = EditProjectPropertiesSession.Write.NullableClass();
    public static CtxWriteDelegate<EditProjectPropertiesModelReady> Write = (ctx, writer, value) => 
    {
      RdProperty<EditProjectPropertiesSession>.Write(ctx, writer, value._EditPropertiesSession);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _EditPropertiesSession.BindEx(lifetime, this, "editPropertiesSession");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _EditPropertiesSession.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertiesModelReady (");
      using (printer.IndentCookie()) {
        printer.Print("editPropertiesSession = "); _EditPropertiesSession.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertiesSession : RdBindableBase {
    //fields
    public int ProjectId {get; private set;}
    [NotNull] public IRdProperty<EditProjectPropertiesSessionResult> SessionResult { get { return _SessionResult; }}
    [NotNull] private readonly RdProperty<EditProjectPropertiesSessionResult> _SessionResult;
    
    //primary constructor
    private EditProjectPropertiesSession(
      int projectId,
      [NotNull] RdProperty<EditProjectPropertiesSessionResult> sessionResult
    )
    {
      ProjectId = projectId;
      _SessionResult = sessionResult;
    }
    //secondary constructor
    public EditProjectPropertiesSession (
      int ProjectId
    ) : this (
      ProjectId,
      new RdProperty<EditProjectPropertiesSessionResult>()
    ) {}
    //statics
    
    public static CtxReadDelegate<EditProjectPropertiesSession> Read = (ctx, reader) => 
    {
      var projectId = reader.ReadInt();
      var sessionResult = RdProperty<EditProjectPropertiesSessionResult>.Read(ctx, reader);
      return new EditProjectPropertiesSession(projectId, sessionResult);
    };
    
    public static CtxWriteDelegate<EditProjectPropertiesSession> Write = (ctx, writer, value) => 
    {
      writer.Write(value.ProjectId);
      RdProperty<EditProjectPropertiesSessionResult>.Write(ctx, writer, value._SessionResult);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _SessionResult.BindEx(lifetime, this, "sessionResult");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _SessionResult.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertiesSession (");
      using (printer.IndentCookie()) {
        printer.Print("projectId = "); ProjectId.PrintEx(printer); printer.Println();
        printer.Print("sessionResult = "); _SessionResult.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertiesSessionResult : RdBindableBase {
    //fields
    [NotNull] public List<RelatedTargetFile> Files {get; private set;}
    [NotNull] public List<EditProjectPropertySectionDiagnosticItem> DiagnosticItems {get; private set;}
    [NotNull] public List<EditProjectPropertySection> MainSections {get; private set;}
    [NotNull] public List<EditProjectPropertyConfigurationSection> ConfigurationSections {get; private set;}
    [NotNull] public ISink<bool> Save { get { return _Save; }}
    [NotNull] private readonly RdSignal<bool> _Save;
    
    //primary constructor
    private EditProjectPropertiesSessionResult(
      [NotNull] List<RelatedTargetFile> files,
      [NotNull] List<EditProjectPropertySectionDiagnosticItem> diagnosticItems,
      [NotNull] List<EditProjectPropertySection> mainSections,
      [NotNull] List<EditProjectPropertyConfigurationSection> configurationSections,
      [NotNull] RdSignal<bool> save
    )
    {
      Files = files;
      DiagnosticItems = diagnosticItems;
      MainSections = mainSections;
      ConfigurationSections = configurationSections;
      _Save = save;
    }
    //secondary constructor
    public EditProjectPropertiesSessionResult (
      [NotNull] List<RelatedTargetFile> Files,
      [NotNull] List<EditProjectPropertySectionDiagnosticItem> DiagnosticItems,
      [NotNull] List<EditProjectPropertySection> MainSections,
      [NotNull] List<EditProjectPropertyConfigurationSection> ConfigurationSections
    ) : this (
      Files,
      DiagnosticItems,
      MainSections,
      ConfigurationSections,
      new RdSignal<bool>()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<RelatedTargetFile>> ReadRelatedTargetFileList = RelatedTargetFile.Read.List();
    public static CtxReadDelegate<List<EditProjectPropertySectionDiagnosticItem>> ReadEditProjectPropertySectionDiagnosticItemList = EditProjectPropertySectionDiagnosticItem.Read.List();
    public static CtxReadDelegate<List<EditProjectPropertySection>> ReadEditProjectPropertySectionList = EditProjectPropertySection.Read.List();
    public static CtxReadDelegate<List<EditProjectPropertyConfigurationSection>> ReadEditProjectPropertyConfigurationSectionList = EditProjectPropertyConfigurationSection.Read.List();
    public static CtxReadDelegate<EditProjectPropertiesSessionResult> Read = (ctx, reader) => 
    {
      var files = ReadRelatedTargetFileList(ctx, reader);
      var diagnosticItems = ReadEditProjectPropertySectionDiagnosticItemList(ctx, reader);
      var mainSections = ReadEditProjectPropertySectionList(ctx, reader);
      var configurationSections = ReadEditProjectPropertyConfigurationSectionList(ctx, reader);
      var save = RdSignal<bool>.Read(ctx, reader);
      return new EditProjectPropertiesSessionResult(files, diagnosticItems, mainSections, configurationSections, save);
    };
    
    public static CtxWriteDelegate<List<RelatedTargetFile>> WriteRelatedTargetFileList = RelatedTargetFile.Write.List();
    public static CtxWriteDelegate<List<EditProjectPropertySectionDiagnosticItem>> WriteEditProjectPropertySectionDiagnosticItemList = EditProjectPropertySectionDiagnosticItem.Write.List();
    public static CtxWriteDelegate<List<EditProjectPropertySection>> WriteEditProjectPropertySectionList = EditProjectPropertySection.Write.List();
    public static CtxWriteDelegate<List<EditProjectPropertyConfigurationSection>> WriteEditProjectPropertyConfigurationSectionList = EditProjectPropertyConfigurationSection.Write.List();
    public static CtxWriteDelegate<EditProjectPropertiesSessionResult> Write = (ctx, writer, value) => 
    {
      WriteRelatedTargetFileList(ctx, writer, value.Files);
      WriteEditProjectPropertySectionDiagnosticItemList(ctx, writer, value.DiagnosticItems);
      WriteEditProjectPropertySectionList(ctx, writer, value.MainSections);
      WriteEditProjectPropertyConfigurationSectionList(ctx, writer, value.ConfigurationSections);
      RdSignal<bool>.Write(ctx, writer, value._Save);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Files.BindEx(lifetime, this, "files");
      DiagnosticItems.BindEx(lifetime, this, "diagnosticItems");
      MainSections.BindEx(lifetime, this, "mainSections");
      ConfigurationSections.BindEx(lifetime, this, "configurationSections");
      _Save.BindEx(lifetime, this, "save");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Files.IdentifyEx(ids);
      DiagnosticItems.IdentifyEx(ids);
      MainSections.IdentifyEx(ids);
      ConfigurationSections.IdentifyEx(ids);
      _Save.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertiesSessionResult (");
      using (printer.IndentCookie()) {
        printer.Print("files = "); Files.PrintEx(printer); printer.Println();
        printer.Print("diagnosticItems = "); DiagnosticItems.PrintEx(printer); printer.Println();
        printer.Print("mainSections = "); MainSections.PrintEx(printer); printer.Println();
        printer.Print("configurationSections = "); ConfigurationSections.PrintEx(printer); printer.Println();
        printer.Print("save = "); _Save.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertyConfigurationSection : RdBindableBase {
    //fields
    [NotNull] public string Configuration {get; private set;}
    [NotNull] public string Platform {get; private set;}
    [NotNull] public string Caption {get; private set;}
    [NotNull] public List<EditProjectPropertySection> Sections {get; private set;}
    
    //primary constructor
    public EditProjectPropertyConfigurationSection(
      [NotNull] string configuration,
      [NotNull] string platform,
      [NotNull] string caption,
      [NotNull] List<EditProjectPropertySection> sections
    )
    {
      Configuration = configuration;
      Platform = platform;
      Caption = caption;
      Sections = sections;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<EditProjectPropertySection>> ReadEditProjectPropertySectionList = EditProjectPropertySection.Read.List();
    public static CtxReadDelegate<EditProjectPropertyConfigurationSection> Read = (ctx, reader) => 
    {
      var configuration = reader.ReadString();
      var platform = reader.ReadString();
      var caption = reader.ReadString();
      var sections = ReadEditProjectPropertySectionList(ctx, reader);
      return new EditProjectPropertyConfigurationSection(configuration, platform, caption, sections);
    };
    
    public static CtxWriteDelegate<List<EditProjectPropertySection>> WriteEditProjectPropertySectionList = EditProjectPropertySection.Write.List();
    public static CtxWriteDelegate<EditProjectPropertyConfigurationSection> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Configuration);
      writer.Write(value.Platform);
      writer.Write(value.Caption);
      WriteEditProjectPropertySectionList(ctx, writer, value.Sections);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Sections.BindEx(lifetime, this, "sections");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Sections.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertyConfigurationSection (");
      using (printer.IndentCookie()) {
        printer.Print("configuration = "); Configuration.PrintEx(printer); printer.Println();
        printer.Print("platform = "); Platform.PrintEx(printer); printer.Println();
        printer.Print("caption = "); Caption.PrintEx(printer); printer.Println();
        printer.Print("sections = "); Sections.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertyItem : RdBindableBase {
    //fields
    [NotNull] public string XmlName {get; private set;}
    [NotNull] public string UserFriendlyName {get; private set;}
    
    //primary constructor
    public EditProjectPropertyItem(
      [NotNull] string xmlName,
      [NotNull] string userFriendlyName
    )
    {
      XmlName = xmlName;
      UserFriendlyName = userFriendlyName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditProjectPropertyItem> Read = (ctx, reader) => 
    {
      var xmlName = reader.ReadString();
      var userFriendlyName = reader.ReadString();
      return new EditProjectPropertyItem(xmlName, userFriendlyName);
    };
    
    public static CtxWriteDelegate<EditProjectPropertyItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.XmlName);
      writer.Write(value.UserFriendlyName);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertyItem (");
      using (printer.IndentCookie()) {
        printer.Print("xmlName = "); XmlName.PrintEx(printer); printer.Println();
        printer.Print("userFriendlyName = "); UserFriendlyName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertySection : RdBindableBase {
    //fields
    [NotNull] public string Caption {get; private set;}
    [NotNull] public List<EditProjectPropertySectionItem> Items {get; private set;}
    
    //primary constructor
    public EditProjectPropertySection(
      [NotNull] string caption,
      [NotNull] List<EditProjectPropertySectionItem> items
    )
    {
      Caption = caption;
      Items = items;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<List<EditProjectPropertySectionItem>> ReadEditProjectPropertySectionItemList = EditProjectPropertySectionItem.Read.List();
    public static CtxReadDelegate<EditProjectPropertySection> Read = (ctx, reader) => 
    {
      var caption = reader.ReadString();
      var items = ReadEditProjectPropertySectionItemList(ctx, reader);
      return new EditProjectPropertySection(caption, items);
    };
    
    public static CtxWriteDelegate<List<EditProjectPropertySectionItem>> WriteEditProjectPropertySectionItemList = EditProjectPropertySectionItem.Write.List();
    public static CtxWriteDelegate<EditProjectPropertySection> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Caption);
      WriteEditProjectPropertySectionItemList(ctx, writer, value.Items);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Items.BindEx(lifetime, this, "items");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Items.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertySection (");
      using (printer.IndentCookie()) {
        printer.Print("caption = "); Caption.PrintEx(printer); printer.Println();
        printer.Print("items = "); Items.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertySectionDiagnosticItem : RdBindableBase {
    //fields
    [NotNull] public string XmlName {get; private set;}
    [NotNull] public string EvaluatedValue {get; private set;}
    
    //primary constructor
    public EditProjectPropertySectionDiagnosticItem(
      [NotNull] string xmlName,
      [NotNull] string evaluatedValue
    )
    {
      XmlName = xmlName;
      EvaluatedValue = evaluatedValue;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditProjectPropertySectionDiagnosticItem> Read = (ctx, reader) => 
    {
      var xmlName = reader.ReadString();
      var evaluatedValue = reader.ReadString();
      return new EditProjectPropertySectionDiagnosticItem(xmlName, evaluatedValue);
    };
    
    public static CtxWriteDelegate<EditProjectPropertySectionDiagnosticItem> Write = (ctx, writer, value) => 
    {
      writer.Write(value.XmlName);
      writer.Write(value.EvaluatedValue);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertySectionDiagnosticItem (");
      using (printer.IndentCookie()) {
        printer.Print("xmlName = "); XmlName.PrintEx(printer); printer.Println();
        printer.Print("evaluatedValue = "); EvaluatedValue.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class EditProjectPropertySectionItem : RdBindableBase {
    //fields
    [NotNull] public string XmlName {get; private set;}
    [NotNull] public string PresentableName {get; private set;}
    
    //primary constructor
    protected EditProjectPropertySectionItem(
      [NotNull] string xmlName,
      [NotNull] string presentableName
    )
    {
      XmlName = xmlName;
      PresentableName = presentableName;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<EditProjectPropertySectionItem> Read = (ctx, reader) => ctx.Serializers.Read<EditProjectPropertySectionItem>(ctx, reader);
    
    public static CtxWriteDelegate<EditProjectPropertySectionItem> Write = (ctx, writer, value) => ctx.Serializers.Write<EditProjectPropertySectionItem>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class EditProjectPropertySectionItemBoolean : EditProjectPropertySectionItem
   {
    //fields
    public bool InitialValue {get; private set;}
    [NotNull] public IRdProperty<bool> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<bool> _Value;
    
    //primary constructor
    private EditProjectPropertySectionItemBoolean(
      bool initialValue,
      [NotNull] RdProperty<bool> value,
      [NotNull] string xmlName,
      [NotNull] string presentableName
    ) : base (
      xmlName,
      presentableName
     ) 
    {
      InitialValue = initialValue;
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public EditProjectPropertySectionItemBoolean (
      bool InitialValue,
      [NotNull] string XmlName,
      [NotNull] string PresentableName
    ) : this (
      InitialValue,
      new RdProperty<bool>(),
      XmlName,
      PresentableName
    ) {}
    //statics
    
    public static new CtxReadDelegate<EditProjectPropertySectionItemBoolean> Read = (ctx, reader) => 
    {
      var initialValue = reader.ReadBool();
      var value = RdProperty<bool>.Read(ctx, reader);
      var xmlName = reader.ReadString();
      var presentableName = reader.ReadString();
      return new EditProjectPropertySectionItemBoolean(initialValue, value, xmlName, presentableName);
    };
    
    public static new CtxWriteDelegate<EditProjectPropertySectionItemBoolean> Write = (ctx, writer, value) => 
    {
      writer.Write(value.InitialValue);
      RdProperty<bool>.Write(ctx, writer, value._Value);
      writer.Write(value.XmlName);
      writer.Write(value.PresentableName);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertySectionItemBoolean (");
      using (printer.IndentCookie()) {
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("xmlName = "); XmlName.PrintEx(printer); printer.Println();
        printer.Print("presentableName = "); PresentableName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertySectionItemCombo : EditProjectPropertySectionItem
   {
    //fields
    [NotNull] public List<EditProjectPropertyItem> Values {get; private set;}
    [NotNull] public EditProjectPropertyItem InitialValue {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private EditProjectPropertySectionItemCombo(
      [NotNull] List<EditProjectPropertyItem> values,
      [NotNull] EditProjectPropertyItem initialValue,
      [NotNull] RdProperty<string> value,
      [NotNull] string xmlName,
      [NotNull] string presentableName
    ) : base (
      xmlName,
      presentableName
     ) 
    {
      Values = values;
      InitialValue = initialValue;
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public EditProjectPropertySectionItemCombo (
      [NotNull] List<EditProjectPropertyItem> Values,
      [NotNull] EditProjectPropertyItem InitialValue,
      [NotNull] string XmlName,
      [NotNull] string PresentableName
    ) : this (
      Values,
      InitialValue,
      new RdProperty<string>(),
      XmlName,
      PresentableName
    ) {}
    //statics
    
    public static CtxReadDelegate<List<EditProjectPropertyItem>> ReadEditProjectPropertyItemList = EditProjectPropertyItem.Read.List();
    public static new CtxReadDelegate<EditProjectPropertySectionItemCombo> Read = (ctx, reader) => 
    {
      var values = ReadEditProjectPropertyItemList(ctx, reader);
      var initialValue = EditProjectPropertyItem.Read(ctx, reader);
      var value = RdProperty<string>.Read(ctx, reader);
      var xmlName = reader.ReadString();
      var presentableName = reader.ReadString();
      return new EditProjectPropertySectionItemCombo(values, initialValue, value, xmlName, presentableName);
    };
    
    public static CtxWriteDelegate<List<EditProjectPropertyItem>> WriteEditProjectPropertyItemList = EditProjectPropertyItem.Write.List();
    public static new CtxWriteDelegate<EditProjectPropertySectionItemCombo> Write = (ctx, writer, value) => 
    {
      WriteEditProjectPropertyItemList(ctx, writer, value.Values);
      EditProjectPropertyItem.Write(ctx, writer, value.InitialValue);
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.XmlName);
      writer.Write(value.PresentableName);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Values.BindEx(lifetime, this, "values");
      InitialValue.BindEx(lifetime, this, "initialValue");
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Values.IdentifyEx(ids);
      InitialValue.IdentifyEx(ids);
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertySectionItemCombo (");
      using (printer.IndentCookie()) {
        printer.Print("values = "); Values.PrintEx(printer); printer.Println();
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("xmlName = "); XmlName.PrintEx(printer); printer.Println();
        printer.Print("presentableName = "); PresentableName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class EditProjectPropertySectionItemText : EditProjectPropertySectionItem
   {
    //fields
    [NotNull] public string InitialValue {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private EditProjectPropertySectionItemText(
      [NotNull] string initialValue,
      [NotNull] RdProperty<string> value,
      [NotNull] string xmlName,
      [NotNull] string presentableName
    ) : base (
      xmlName,
      presentableName
     ) 
    {
      InitialValue = initialValue;
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public EditProjectPropertySectionItemText (
      [NotNull] string InitialValue,
      [NotNull] string XmlName,
      [NotNull] string PresentableName
    ) : this (
      InitialValue,
      new RdProperty<string>(),
      XmlName,
      PresentableName
    ) {}
    //statics
    
    public static new CtxReadDelegate<EditProjectPropertySectionItemText> Read = (ctx, reader) => 
    {
      var initialValue = reader.ReadString();
      var value = RdProperty<string>.Read(ctx, reader);
      var xmlName = reader.ReadString();
      var presentableName = reader.ReadString();
      return new EditProjectPropertySectionItemText(initialValue, value, xmlName, presentableName);
    };
    
    public static new CtxWriteDelegate<EditProjectPropertySectionItemText> Write = (ctx, writer, value) => 
    {
      writer.Write(value.InitialValue);
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.XmlName);
      writer.Write(value.PresentableName);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("EditProjectPropertySectionItemText (");
      using (printer.IndentCookie()) {
        printer.Print("initialValue = "); InitialValue.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("xmlName = "); XmlName.PrintEx(printer); printer.Println();
        printer.Print("presentableName = "); PresentableName.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RelatedTargetFile : RdBindableBase {
    //fields
    [NotNull] public string FullPath {get; private set;}
    [NotNull] public string ShortPath {get; private set;}
    
    //primary constructor
    public RelatedTargetFile(
      [NotNull] string fullPath,
      [NotNull] string shortPath
    )
    {
      FullPath = fullPath;
      ShortPath = shortPath;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RelatedTargetFile> Read = (ctx, reader) => 
    {
      var fullPath = reader.ReadString();
      var shortPath = reader.ReadString();
      return new RelatedTargetFile(fullPath, shortPath);
    };
    
    public static CtxWriteDelegate<RelatedTargetFile> Write = (ctx, writer, value) => 
    {
      writer.Write(value.FullPath);
      writer.Write(value.ShortPath);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("RelatedTargetFile (");
      using (printer.IndentCookie()) {
        printer.Print("fullPath = "); FullPath.PrintEx(printer); printer.Println();
        printer.Print("shortPath = "); ShortPath.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
