using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.Refactorings
{
  
  
  [ShellComponent]
  public class GenerateViewProviderModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<GenerateWindowModel> GenerateWindow { get { return _GenerateWindow; }}
    [NotNull] private readonly RdProperty<GenerateWindowModel> _GenerateWindow;
    
    //primary constructor
    public GenerateViewProviderModel(
      [NotNull] RdProperty<GenerateWindowModel> generateWindow
    )
    {
      _GenerateWindow = generateWindow;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(GenerateWindowTextOptionModel.Read, GenerateWindowTextOptionModel.Write);
      serializers.Register(GenerateWindowComboOptionModel.Read, GenerateWindowComboOptionModel.Write);
      serializers.Register(GenerateWindowBoolOptionModel.Read, GenerateWindowBoolOptionModel.Write);
      serializers.Register(GenerateWindowElementModel.Read, GenerateWindowElementModel.Write);
      serializers.Register(GenerateWindowGroupingObjectModel.Read, GenerateWindowGroupingObjectModel.Write);
      serializers.Register(GenerateWindowModel.Read, GenerateWindowModel.Write);
    }
    
    public GenerateViewProviderModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<GenerateWindowModel>().Static(1010)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _GenerateWindow.BindEx(lifetime, this, "generateWindow");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _GenerateWindow.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateViewProviderModel (");
      using (printer.IndentCookie()) {
        printer.Print("generateWindow = "); _GenerateWindow.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowBoolOptionModel : GenerateWindowOptionModel
   {
    //fields
    [NotNull] public IRdProperty<bool> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<bool> _Value;
    
    //primary constructor
    private GenerateWindowBoolOptionModel(
      [NotNull] RdProperty<bool> value,
      [NotNull] string label
    ) : base (
      label
     ) 
    {
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public GenerateWindowBoolOptionModel (
      [NotNull] string Label
    ) : this (
      new RdProperty<bool>(),
      Label
    ) {}
    //statics
    
    public static new CtxReadDelegate<GenerateWindowBoolOptionModel> Read = (ctx, reader) => 
    {
      var value = RdProperty<bool>.Read(ctx, reader);
      var label = reader.ReadString();
      return new GenerateWindowBoolOptionModel(value, label);
    };
    
    public static new CtxWriteDelegate<GenerateWindowBoolOptionModel> Write = (ctx, writer, value) => 
    {
      RdProperty<bool>.Write(ctx, writer, value._Value);
      writer.Write(value.Label);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowBoolOptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowComboOptionModel : GenerateWindowOptionModel
   {
    //fields
    [NotNull] public List<string> Options {get; private set;}
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private GenerateWindowComboOptionModel(
      [NotNull] List<string> options,
      [NotNull] RdProperty<string> value,
      [NotNull] string label
    ) : base (
      label
     ) 
    {
      Options = options;
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public GenerateWindowComboOptionModel (
      [NotNull] List<string> Options,
      [NotNull] string Label
    ) : this (
      Options,
      new RdProperty<string>(),
      Label
    ) {}
    //statics
    
    public static CtxReadDelegate<List<string>> ReadStringList = Serializers.ReadString.List();
    public static new CtxReadDelegate<GenerateWindowComboOptionModel> Read = (ctx, reader) => 
    {
      var options = ReadStringList(ctx, reader);
      var value = RdProperty<string>.Read(ctx, reader);
      var label = reader.ReadString();
      return new GenerateWindowComboOptionModel(options, value, label);
    };
    
    public static CtxWriteDelegate<List<string>> WriteStringList = Serializers.WriteString.List();
    public static new CtxWriteDelegate<GenerateWindowComboOptionModel> Write = (ctx, writer, value) => 
    {
      WriteStringList(ctx, writer, value.Options);
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.Label);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowComboOptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowElementModel : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public int GroupingObject {get; private set;}
    [NotNull] public IRdProperty<bool> Enabled { get { return _Enabled; }}
    [NotNull] private readonly RdProperty<bool> _Enabled;
    [NotNull] public IRdProperty<int> IndexInList { get { return _IndexInList; }}
    [NotNull] private readonly RdProperty<int> _IndexInList;
    [NotNull] public IVoidSink MoveUp { get { return _MoveUp; }}
    [NotNull] private readonly RdVoidSignal _MoveUp;
    [NotNull] public IVoidSink MoveDown { get { return _MoveDown; }}
    [NotNull] private readonly RdVoidSignal _MoveDown;
    
    //primary constructor
    private GenerateWindowElementModel(
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      int groupingObject,
      [NotNull] RdProperty<bool> enabled,
      [NotNull] RdProperty<int> indexInList,
      [NotNull] RdVoidSignal moveUp,
      [NotNull] RdVoidSignal moveDown
    )
    {
      Text = text;
      Icon = icon;
      GroupingObject = groupingObject;
      _Enabled = enabled;
      _IndexInList = indexInList;
      _MoveUp = moveUp;
      _MoveDown = moveDown;
      enabled.OptimizeNested = true;
      indexInList.OptimizeNested = true;
    }
    //secondary constructor
    public GenerateWindowElementModel (
      [NotNull] string Text,
      [NotNull] JetBrains.Rider.Model.Icon Icon,
      int GroupingObject
    ) : this (
      Text,
      Icon,
      GroupingObject,
      new RdProperty<bool>(),
      new RdProperty<int>(),
      new RdVoidSignal(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<GenerateWindowElementModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var groupingObject = reader.ReadInt();
      var enabled = RdProperty<bool>.Read(ctx, reader);
      var indexInList = RdProperty<int>.Read(ctx, reader);
      var moveUp = RdVoidSignal.Read(ctx, reader);
      var moveDown = RdVoidSignal.Read(ctx, reader);
      return new GenerateWindowElementModel(text, icon, groupingObject, enabled, indexInList, moveUp, moveDown);
    };
    
    public static CtxWriteDelegate<GenerateWindowElementModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      writer.Write(value.GroupingObject);
      RdProperty<bool>.Write(ctx, writer, value._Enabled);
      RdProperty<int>.Write(ctx, writer, value._IndexInList);
      RdVoidSignal.Write(ctx, writer, value._MoveUp);
      RdVoidSignal.Write(ctx, writer, value._MoveDown);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Enabled.BindEx(lifetime, this, "enabled");
      _IndexInList.BindEx(lifetime, this, "indexInList");
      _MoveUp.BindEx(lifetime, this, "moveUp");
      _MoveDown.BindEx(lifetime, this, "moveDown");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Enabled.IdentifyEx(ids);
      _IndexInList.IdentifyEx(ids);
      _MoveUp.IdentifyEx(ids);
      _MoveDown.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowElementModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("groupingObject = "); GroupingObject.PrintEx(printer); printer.Println();
        printer.Print("enabled = "); _Enabled.PrintEx(printer); printer.Println();
        printer.Print("indexInList = "); _IndexInList.PrintEx(printer); printer.Println();
        printer.Print("moveUp = "); _MoveUp.PrintEx(printer); printer.Println();
        printer.Print("moveDown = "); _MoveDown.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowGroupingObjectModel : RdBindableBase {
    //fields
    [NotNull] public string Text {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    
    //primary constructor
    public GenerateWindowGroupingObjectModel(
      [NotNull] string text,
      [NotNull] JetBrains.Rider.Model.Icon icon
    )
    {
      Text = text;
      Icon = icon;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GenerateWindowGroupingObjectModel> Read = (ctx, reader) => 
    {
      var text = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      return new GenerateWindowGroupingObjectModel(text, icon);
    };
    
    public static CtxWriteDelegate<GenerateWindowGroupingObjectModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Text);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
    }
    //identify method
    public override void Identify(IIdentities ids) {
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowGroupingObjectModel (");
      using (printer.IndentCookie()) {
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class GenerateWindowModel : RdBindableBase {
    //fields
    [NotNull] public string Title {get; private set;}
    [NotNull] public string Description {get; private set;}
    [NotNull] public JetBrains.Rider.Model.Icon Icon {get; private set;}
    public bool AllowGrouping {get; private set;}
    public bool ForceGrouping {get; private set;}
    public bool AllowSorting {get; private set;}
    public bool AllowMoving {get; private set;}
    [NotNull] public List<GenerateWindowElementModel> Elements {get; private set;}
    [NotNull] public List<GenerateWindowGroupingObjectModel> GroupingObjects {get; private set;}
    [NotNull] public List<GenerateWindowOptionModel> Options {get; private set;}
    [NotNull] public IVoidSink OkClicked { get { return _OkClicked; }}
    [NotNull] private readonly RdVoidSignal _OkClicked;
    [NotNull] public IVoidSink CancelClicked { get { return _CancelClicked; }}
    [NotNull] private readonly RdVoidSignal _CancelClicked;
    
    //primary constructor
    private GenerateWindowModel(
      [NotNull] string title,
      [NotNull] string description,
      [NotNull] JetBrains.Rider.Model.Icon icon,
      bool allowGrouping,
      bool forceGrouping,
      bool allowSorting,
      bool allowMoving,
      [NotNull] List<GenerateWindowElementModel> elements,
      [NotNull] List<GenerateWindowGroupingObjectModel> groupingObjects,
      [NotNull] List<GenerateWindowOptionModel> options,
      [NotNull] RdVoidSignal okClicked,
      [NotNull] RdVoidSignal cancelClicked
    )
    {
      Title = title;
      Description = description;
      Icon = icon;
      AllowGrouping = allowGrouping;
      ForceGrouping = forceGrouping;
      AllowSorting = allowSorting;
      AllowMoving = allowMoving;
      Elements = elements;
      GroupingObjects = groupingObjects;
      Options = options;
      _OkClicked = okClicked;
      _CancelClicked = cancelClicked;
    }
    //secondary constructor
    public GenerateWindowModel (
      [NotNull] string Title,
      [NotNull] string Description,
      [NotNull] JetBrains.Rider.Model.Icon Icon,
      bool AllowGrouping,
      bool ForceGrouping,
      bool AllowSorting,
      bool AllowMoving,
      [NotNull] List<GenerateWindowElementModel> Elements,
      [NotNull] List<GenerateWindowGroupingObjectModel> GroupingObjects,
      [NotNull] List<GenerateWindowOptionModel> Options
    ) : this (
      Title,
      Description,
      Icon,
      AllowGrouping,
      ForceGrouping,
      AllowSorting,
      AllowMoving,
      Elements,
      GroupingObjects,
      Options,
      new RdVoidSignal(),
      new RdVoidSignal()
    ) {}
    //statics
    
    public static CtxReadDelegate<List<GenerateWindowElementModel>> ReadGenerateWindowElementModelList = GenerateWindowElementModel.Read.List();
    public static CtxReadDelegate<List<GenerateWindowGroupingObjectModel>> ReadGenerateWindowGroupingObjectModelList = GenerateWindowGroupingObjectModel.Read.List();
    public static CtxReadDelegate<List<GenerateWindowOptionModel>> ReadGenerateWindowOptionModelList = GenerateWindowOptionModel.Read.List();
    public static CtxReadDelegate<GenerateWindowModel> Read = (ctx, reader) => 
    {
      var title = reader.ReadString();
      var description = reader.ReadString();
      var icon = JetBrains.Rider.Model.Icon.Read(ctx, reader);
      var allowGrouping = reader.ReadBool();
      var forceGrouping = reader.ReadBool();
      var allowSorting = reader.ReadBool();
      var allowMoving = reader.ReadBool();
      var elements = ReadGenerateWindowElementModelList(ctx, reader);
      var groupingObjects = ReadGenerateWindowGroupingObjectModelList(ctx, reader);
      var options = ReadGenerateWindowOptionModelList(ctx, reader);
      var okClicked = RdVoidSignal.Read(ctx, reader);
      var cancelClicked = RdVoidSignal.Read(ctx, reader);
      return new GenerateWindowModel(title, description, icon, allowGrouping, forceGrouping, allowSorting, allowMoving, elements, groupingObjects, options, okClicked, cancelClicked);
    };
    
    public static CtxWriteDelegate<List<GenerateWindowElementModel>> WriteGenerateWindowElementModelList = GenerateWindowElementModel.Write.List();
    public static CtxWriteDelegate<List<GenerateWindowGroupingObjectModel>> WriteGenerateWindowGroupingObjectModelList = GenerateWindowGroupingObjectModel.Write.List();
    public static CtxWriteDelegate<List<GenerateWindowOptionModel>> WriteGenerateWindowOptionModelList = GenerateWindowOptionModel.Write.List();
    public static CtxWriteDelegate<GenerateWindowModel> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Title);
      writer.Write(value.Description);
      JetBrains.Rider.Model.Icon.Write(ctx, writer, value.Icon);
      writer.Write(value.AllowGrouping);
      writer.Write(value.ForceGrouping);
      writer.Write(value.AllowSorting);
      writer.Write(value.AllowMoving);
      WriteGenerateWindowElementModelList(ctx, writer, value.Elements);
      WriteGenerateWindowGroupingObjectModelList(ctx, writer, value.GroupingObjects);
      WriteGenerateWindowOptionModelList(ctx, writer, value.Options);
      RdVoidSignal.Write(ctx, writer, value._OkClicked);
      RdVoidSignal.Write(ctx, writer, value._CancelClicked);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      Elements.BindEx(lifetime, this, "elements");
      GroupingObjects.BindEx(lifetime, this, "groupingObjects");
      Options.BindEx(lifetime, this, "options");
      _OkClicked.BindEx(lifetime, this, "okClicked");
      _CancelClicked.BindEx(lifetime, this, "cancelClicked");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      Elements.IdentifyEx(ids);
      GroupingObjects.IdentifyEx(ids);
      Options.IdentifyEx(ids);
      _OkClicked.IdentifyEx(ids);
      _CancelClicked.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowModel (");
      using (printer.IndentCookie()) {
        printer.Print("title = "); Title.PrintEx(printer); printer.Println();
        printer.Print("description = "); Description.PrintEx(printer); printer.Println();
        printer.Print("icon = "); Icon.PrintEx(printer); printer.Println();
        printer.Print("allowGrouping = "); AllowGrouping.PrintEx(printer); printer.Println();
        printer.Print("forceGrouping = "); ForceGrouping.PrintEx(printer); printer.Println();
        printer.Print("allowSorting = "); AllowSorting.PrintEx(printer); printer.Println();
        printer.Print("allowMoving = "); AllowMoving.PrintEx(printer); printer.Println();
        printer.Print("elements = "); Elements.PrintEx(printer); printer.Println();
        printer.Print("groupingObjects = "); GroupingObjects.PrintEx(printer); printer.Println();
        printer.Print("options = "); Options.PrintEx(printer); printer.Println();
        printer.Print("okClicked = "); _OkClicked.PrintEx(printer); printer.Println();
        printer.Print("cancelClicked = "); _CancelClicked.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public abstract class GenerateWindowOptionModel : RdBindableBase {
    //fields
    [NotNull] public string Label {get; private set;}
    
    //primary constructor
    protected GenerateWindowOptionModel(
      [NotNull] string label
    )
    {
      Label = label;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<GenerateWindowOptionModel> Read = (ctx, reader) => ctx.Serializers.Read<GenerateWindowOptionModel>(ctx, reader);
    
    public static CtxWriteDelegate<GenerateWindowOptionModel> Write = (ctx, writer, value) => ctx.Serializers.Write<GenerateWindowOptionModel>(ctx, writer, value);
    //init method
    //identify method
    //equals trait
    //hash code trait
    //pretty print
    //toString
  }
  
  
  public class GenerateWindowTextOptionModel : GenerateWindowOptionModel
   {
    //fields
    [NotNull] public IRdProperty<string> Value { get { return _Value; }}
    [NotNull] private readonly RdProperty<string> _Value;
    
    //primary constructor
    private GenerateWindowTextOptionModel(
      [NotNull] RdProperty<string> value,
      [NotNull] string label
    ) : base (
      label
     ) 
    {
      _Value = value;
      value.OptimizeNested = true;
    }
    //secondary constructor
    public GenerateWindowTextOptionModel (
      [NotNull] string Label
    ) : this (
      new RdProperty<string>(),
      Label
    ) {}
    //statics
    
    public static new CtxReadDelegate<GenerateWindowTextOptionModel> Read = (ctx, reader) => 
    {
      var value = RdProperty<string>.Read(ctx, reader);
      var label = reader.ReadString();
      return new GenerateWindowTextOptionModel(value, label);
    };
    
    public static new CtxWriteDelegate<GenerateWindowTextOptionModel> Write = (ctx, writer, value) => 
    {
      RdProperty<string>.Write(ctx, writer, value._Value);
      writer.Write(value.Label);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Value.BindEx(lifetime, this, "value");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Value.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("GenerateWindowTextOptionModel (");
      using (printer.IndentCookie()) {
        printer.Print("value = "); _Value.PrintEx(printer); printer.Println();
        printer.Print("label = "); Label.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
