using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.TestFramework
{
  
  
  [ShellComponent]
  public class MockBackendModel : RdBindableBase {
    //fields
    [NotNull] public RdEndpoint<TestCommand, RdVoid> ExecuteCommand { get { return _ExecuteCommand; }}
    [NotNull] private readonly RdEndpoint<TestCommand, RdVoid> _ExecuteCommand;
    [NotNull] public RdEndpoint<RdVoid, RdVoid> SyncImpulse { get { return _SyncImpulse; }}
    [NotNull] private readonly RdEndpoint<RdVoid, RdVoid> _SyncImpulse;
    [NotNull] public RdEndpoint<RestoreXamarinComponentsCommand, bool> RestoreXamarinComponents { get { return _RestoreXamarinComponents; }}
    [NotNull] private readonly RdEndpoint<RestoreXamarinComponentsCommand, bool> _RestoreXamarinComponents;
    [NotNull] public IRdProperty<JetBrains.Rider.Model.TestFramework.Primitives> Primitives { get { return _Primitives; }}
    [NotNull] private readonly RdProperty<JetBrains.Rider.Model.TestFramework.Primitives> _Primitives;
    
    //primary constructor
    public MockBackendModel(
      [NotNull] RdEndpoint<TestCommand, RdVoid> executeCommand,
      [NotNull] RdEndpoint<RdVoid, RdVoid> syncImpulse,
      [NotNull] RdEndpoint<RestoreXamarinComponentsCommand, bool> restoreXamarinComponents,
      [NotNull] RdProperty<JetBrains.Rider.Model.TestFramework.Primitives> primitives
    )
    {
      _ExecuteCommand = executeCommand;
      _SyncImpulse = syncImpulse;
      _RestoreXamarinComponents = restoreXamarinComponents;
      _Primitives = primitives;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.Register(JetBrains.Rider.Model.TestFramework.Primitives.Read, JetBrains.Rider.Model.TestFramework.Primitives.Write);
      serializers.RegisterEnum<BackendActivitiesKind>();
      serializers.Register(TestCommand.Read, TestCommand.Write);
      serializers.Register(RestoreXamarinComponentsCommand.Read, RestoreXamarinComponentsCommand.Write);
    }
    
    public MockBackendModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdEndpoint<TestCommand, RdVoid>().Static(1013),
      new RdEndpoint<RdVoid, RdVoid>().Static(1014),
      new RdEndpoint<RestoreXamarinComponentsCommand, bool>().Static(1015),
      new RdProperty<JetBrains.Rider.Model.TestFramework.Primitives>().Static(1016)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _ExecuteCommand.BindEx(lifetime, this, "executeCommand");
      _SyncImpulse.BindEx(lifetime, this, "syncImpulse");
      _RestoreXamarinComponents.BindEx(lifetime, this, "restoreXamarinComponents");
      _Primitives.BindEx(lifetime, this, "primitives");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _ExecuteCommand.IdentifyEx(ids);
      _SyncImpulse.IdentifyEx(ids);
      _RestoreXamarinComponents.IdentifyEx(ids);
      _Primitives.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MockBackendModel (");
      using (printer.IndentCookie()) {
        printer.Print("executeCommand = "); _ExecuteCommand.PrintEx(printer); printer.Println();
        printer.Print("syncImpulse = "); _SyncImpulse.PrintEx(printer); printer.Println();
        printer.Print("restoreXamarinComponents = "); _RestoreXamarinComponents.PrintEx(printer); printer.Println();
        printer.Print("primitives = "); _Primitives.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum BackendActivitiesKind {
    InsertTextInFocusedTextControl,
    ChangeFocusedTextControlAndCaret,
    ChangeSettings
  }
  
  
  public class Primitives : RdBindableBase {
    //fields
    [NotNull] public ISink<bool> InBool { get { return _InBool; }}
    [NotNull] private readonly RdSignal<bool> _InBool;
    [NotNull] public ISink<short> InShort { get { return _InShort; }}
    [NotNull] private readonly RdSignal<short> _InShort;
    [NotNull] public ISink<int> InInt { get { return _InInt; }}
    [NotNull] private readonly RdSignal<int> _InInt;
    [NotNull] public ISink<long> InLong { get { return _InLong; }}
    [NotNull] private readonly RdSignal<long> _InLong;
    [NotNull] public ISink<float> InFloat { get { return _InFloat; }}
    [NotNull] private readonly RdSignal<float> _InFloat;
    [NotNull] public ISink<double> InDouble { get { return _InDouble; }}
    [NotNull] private readonly RdSignal<double> _InDouble;
    [NotNull] public ISink<char> InChar { get { return _InChar; }}
    [NotNull] private readonly RdSignal<char> _InChar;
    [NotNull] public ISink<string> InString { get { return _InString; }}
    [NotNull] private readonly RdSignal<string> _InString;
    [NotNull] public ISink<byte[]> InByteArray { get { return _InByteArray; }}
    [NotNull] private readonly RdSignal<byte[]> _InByteArray;
    [NotNull] public ISink<Guid> InGuid { get { return _InGuid; }}
    [NotNull] private readonly RdSignal<Guid> _InGuid;
    [NotNull] public ISink<DateTime> InDateTime { get { return _InDateTime; }}
    [NotNull] private readonly RdSignal<DateTime> _InDateTime;
    [NotNull] public ISink<Uri> InUri { get { return _InUri; }}
    [NotNull] private readonly RdSignal<Uri> _InUri;
    [NotNull] public ISink<RdId> InRdId { get { return _InRdId; }}
    [NotNull] private readonly RdSignal<RdId> _InRdId;
    [NotNull] public ISource<bool> OutBool { get { return _OutBool; }}
    [NotNull] private readonly RdSignal<bool> _OutBool;
    [NotNull] public ISource<short> OutShort { get { return _OutShort; }}
    [NotNull] private readonly RdSignal<short> _OutShort;
    [NotNull] public ISource<int> OutInt { get { return _OutInt; }}
    [NotNull] private readonly RdSignal<int> _OutInt;
    [NotNull] public ISource<long> OutLong { get { return _OutLong; }}
    [NotNull] private readonly RdSignal<long> _OutLong;
    [NotNull] public ISource<float> OutFloat { get { return _OutFloat; }}
    [NotNull] private readonly RdSignal<float> _OutFloat;
    [NotNull] public ISource<double> OutDouble { get { return _OutDouble; }}
    [NotNull] private readonly RdSignal<double> _OutDouble;
    [NotNull] public ISource<char> OutChar { get { return _OutChar; }}
    [NotNull] private readonly RdSignal<char> _OutChar;
    [NotNull] public ISource<string> OutString { get { return _OutString; }}
    [NotNull] private readonly RdSignal<string> _OutString;
    [NotNull] public ISource<byte[]> OutByteArray { get { return _OutByteArray; }}
    [NotNull] private readonly RdSignal<byte[]> _OutByteArray;
    [NotNull] public ISource<Guid> OutGuid { get { return _OutGuid; }}
    [NotNull] private readonly RdSignal<Guid> _OutGuid;
    [NotNull] public ISource<DateTime> OutDateTime { get { return _OutDateTime; }}
    [NotNull] private readonly RdSignal<DateTime> _OutDateTime;
    [NotNull] public ISource<Uri> OutUri { get { return _OutUri; }}
    [NotNull] private readonly RdSignal<Uri> _OutUri;
    [NotNull] public ISource<RdId> OutRdId { get { return _OutRdId; }}
    [NotNull] private readonly RdSignal<RdId> _OutRdId;
    [NotNull] public IRdProperty<string> OutAll { get { return _OutAll; }}
    [NotNull] private readonly RdProperty<string> _OutAll;
    
    //primary constructor
    private Primitives(
      [NotNull] RdSignal<bool> inBool,
      [NotNull] RdSignal<short> inShort,
      [NotNull] RdSignal<int> inInt,
      [NotNull] RdSignal<long> inLong,
      [NotNull] RdSignal<float> inFloat,
      [NotNull] RdSignal<double> inDouble,
      [NotNull] RdSignal<char> inChar,
      [NotNull] RdSignal<string> inString,
      [NotNull] RdSignal<byte[]> inByteArray,
      [NotNull] RdSignal<Guid> inGuid,
      [NotNull] RdSignal<DateTime> inDateTime,
      [NotNull] RdSignal<Uri> inUri,
      [NotNull] RdSignal<RdId> inRdId,
      [NotNull] RdSignal<bool> outBool,
      [NotNull] RdSignal<short> outShort,
      [NotNull] RdSignal<int> outInt,
      [NotNull] RdSignal<long> outLong,
      [NotNull] RdSignal<float> outFloat,
      [NotNull] RdSignal<double> outDouble,
      [NotNull] RdSignal<char> outChar,
      [NotNull] RdSignal<string> outString,
      [NotNull] RdSignal<byte[]> outByteArray,
      [NotNull] RdSignal<Guid> outGuid,
      [NotNull] RdSignal<DateTime> outDateTime,
      [NotNull] RdSignal<Uri> outUri,
      [NotNull] RdSignal<RdId> outRdId,
      [NotNull] RdProperty<string> outAll
    )
    {
      _InBool = inBool;
      _InShort = inShort;
      _InInt = inInt;
      _InLong = inLong;
      _InFloat = inFloat;
      _InDouble = inDouble;
      _InChar = inChar;
      _InString = inString;
      _InByteArray = inByteArray;
      _InGuid = inGuid;
      _InDateTime = inDateTime;
      _InUri = inUri;
      _InRdId = inRdId;
      _OutBool = outBool;
      _OutShort = outShort;
      _OutInt = outInt;
      _OutLong = outLong;
      _OutFloat = outFloat;
      _OutDouble = outDouble;
      _OutChar = outChar;
      _OutString = outString;
      _OutByteArray = outByteArray;
      _OutGuid = outGuid;
      _OutDateTime = outDateTime;
      _OutUri = outUri;
      _OutRdId = outRdId;
      _OutAll = outAll;
      outAll.OptimizeNested = true;
    }
    //secondary constructor
    public Primitives (
    ) : this (
      new RdSignal<bool>(),
      new RdSignal<short>(),
      new RdSignal<int>(),
      new RdSignal<long>(),
      new RdSignal<float>(),
      new RdSignal<double>(),
      new RdSignal<char>(),
      new RdSignal<string>(),
      new RdSignal<byte[]>(),
      new RdSignal<Guid>(),
      new RdSignal<DateTime>(),
      new RdSignal<Uri>(),
      new RdSignal<RdId>(),
      new RdSignal<bool>(),
      new RdSignal<short>(),
      new RdSignal<int>(),
      new RdSignal<long>(),
      new RdSignal<float>(),
      new RdSignal<double>(),
      new RdSignal<char>(),
      new RdSignal<string>(),
      new RdSignal<byte[]>(),
      new RdSignal<Guid>(),
      new RdSignal<DateTime>(),
      new RdSignal<Uri>(),
      new RdSignal<RdId>(),
      new RdProperty<string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<Primitives> Read = (ctx, reader) => 
    {
      var inBool = RdSignal<bool>.Read(ctx, reader);
      var inShort = RdSignal<short>.Read(ctx, reader);
      var inInt = RdSignal<int>.Read(ctx, reader);
      var inLong = RdSignal<long>.Read(ctx, reader);
      var inFloat = RdSignal<float>.Read(ctx, reader);
      var inDouble = RdSignal<double>.Read(ctx, reader);
      var inChar = RdSignal<char>.Read(ctx, reader);
      var inString = RdSignal<string>.Read(ctx, reader);
      var inByteArray = RdSignal<byte[]>.Read(ctx, reader);
      var inGuid = RdSignal<Guid>.Read(ctx, reader);
      var inDateTime = RdSignal<DateTime>.Read(ctx, reader);
      var inUri = RdSignal<Uri>.Read(ctx, reader);
      var inRdId = RdSignal<RdId>.Read(ctx, reader);
      var outBool = RdSignal<bool>.Read(ctx, reader);
      var outShort = RdSignal<short>.Read(ctx, reader);
      var outInt = RdSignal<int>.Read(ctx, reader);
      var outLong = RdSignal<long>.Read(ctx, reader);
      var outFloat = RdSignal<float>.Read(ctx, reader);
      var outDouble = RdSignal<double>.Read(ctx, reader);
      var outChar = RdSignal<char>.Read(ctx, reader);
      var outString = RdSignal<string>.Read(ctx, reader);
      var outByteArray = RdSignal<byte[]>.Read(ctx, reader);
      var outGuid = RdSignal<Guid>.Read(ctx, reader);
      var outDateTime = RdSignal<DateTime>.Read(ctx, reader);
      var outUri = RdSignal<Uri>.Read(ctx, reader);
      var outRdId = RdSignal<RdId>.Read(ctx, reader);
      var outAll = RdProperty<string>.Read(ctx, reader);
      return new Primitives(inBool, inShort, inInt, inLong, inFloat, inDouble, inChar, inString, inByteArray, inGuid, inDateTime, inUri, inRdId, outBool, outShort, outInt, outLong, outFloat, outDouble, outChar, outString, outByteArray, outGuid, outDateTime, outUri, outRdId, outAll);
    };
    
    public static CtxWriteDelegate<Primitives> Write = (ctx, writer, value) => 
    {
      RdSignal<bool>.Write(ctx, writer, value._InBool);
      RdSignal<short>.Write(ctx, writer, value._InShort);
      RdSignal<int>.Write(ctx, writer, value._InInt);
      RdSignal<long>.Write(ctx, writer, value._InLong);
      RdSignal<float>.Write(ctx, writer, value._InFloat);
      RdSignal<double>.Write(ctx, writer, value._InDouble);
      RdSignal<char>.Write(ctx, writer, value._InChar);
      RdSignal<string>.Write(ctx, writer, value._InString);
      RdSignal<byte[]>.Write(ctx, writer, value._InByteArray);
      RdSignal<Guid>.Write(ctx, writer, value._InGuid);
      RdSignal<DateTime>.Write(ctx, writer, value._InDateTime);
      RdSignal<Uri>.Write(ctx, writer, value._InUri);
      RdSignal<RdId>.Write(ctx, writer, value._InRdId);
      RdSignal<bool>.Write(ctx, writer, value._OutBool);
      RdSignal<short>.Write(ctx, writer, value._OutShort);
      RdSignal<int>.Write(ctx, writer, value._OutInt);
      RdSignal<long>.Write(ctx, writer, value._OutLong);
      RdSignal<float>.Write(ctx, writer, value._OutFloat);
      RdSignal<double>.Write(ctx, writer, value._OutDouble);
      RdSignal<char>.Write(ctx, writer, value._OutChar);
      RdSignal<string>.Write(ctx, writer, value._OutString);
      RdSignal<byte[]>.Write(ctx, writer, value._OutByteArray);
      RdSignal<Guid>.Write(ctx, writer, value._OutGuid);
      RdSignal<DateTime>.Write(ctx, writer, value._OutDateTime);
      RdSignal<Uri>.Write(ctx, writer, value._OutUri);
      RdSignal<RdId>.Write(ctx, writer, value._OutRdId);
      RdProperty<string>.Write(ctx, writer, value._OutAll);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _InBool.BindEx(lifetime, this, "inBool");
      _InShort.BindEx(lifetime, this, "inShort");
      _InInt.BindEx(lifetime, this, "inInt");
      _InLong.BindEx(lifetime, this, "inLong");
      _InFloat.BindEx(lifetime, this, "inFloat");
      _InDouble.BindEx(lifetime, this, "inDouble");
      _InChar.BindEx(lifetime, this, "inChar");
      _InString.BindEx(lifetime, this, "inString");
      _InByteArray.BindEx(lifetime, this, "inByteArray");
      _InGuid.BindEx(lifetime, this, "inGuid");
      _InDateTime.BindEx(lifetime, this, "inDateTime");
      _InUri.BindEx(lifetime, this, "inUri");
      _InRdId.BindEx(lifetime, this, "inRdId");
      _OutBool.BindEx(lifetime, this, "outBool");
      _OutShort.BindEx(lifetime, this, "outShort");
      _OutInt.BindEx(lifetime, this, "outInt");
      _OutLong.BindEx(lifetime, this, "outLong");
      _OutFloat.BindEx(lifetime, this, "outFloat");
      _OutDouble.BindEx(lifetime, this, "outDouble");
      _OutChar.BindEx(lifetime, this, "outChar");
      _OutString.BindEx(lifetime, this, "outString");
      _OutByteArray.BindEx(lifetime, this, "outByteArray");
      _OutGuid.BindEx(lifetime, this, "outGuid");
      _OutDateTime.BindEx(lifetime, this, "outDateTime");
      _OutUri.BindEx(lifetime, this, "outUri");
      _OutRdId.BindEx(lifetime, this, "outRdId");
      _OutAll.BindEx(lifetime, this, "outAll");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _InBool.IdentifyEx(ids);
      _InShort.IdentifyEx(ids);
      _InInt.IdentifyEx(ids);
      _InLong.IdentifyEx(ids);
      _InFloat.IdentifyEx(ids);
      _InDouble.IdentifyEx(ids);
      _InChar.IdentifyEx(ids);
      _InString.IdentifyEx(ids);
      _InByteArray.IdentifyEx(ids);
      _InGuid.IdentifyEx(ids);
      _InDateTime.IdentifyEx(ids);
      _InUri.IdentifyEx(ids);
      _InRdId.IdentifyEx(ids);
      _OutBool.IdentifyEx(ids);
      _OutShort.IdentifyEx(ids);
      _OutInt.IdentifyEx(ids);
      _OutLong.IdentifyEx(ids);
      _OutFloat.IdentifyEx(ids);
      _OutDouble.IdentifyEx(ids);
      _OutChar.IdentifyEx(ids);
      _OutString.IdentifyEx(ids);
      _OutByteArray.IdentifyEx(ids);
      _OutGuid.IdentifyEx(ids);
      _OutDateTime.IdentifyEx(ids);
      _OutUri.IdentifyEx(ids);
      _OutRdId.IdentifyEx(ids);
      _OutAll.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("Primitives (");
      using (printer.IndentCookie()) {
        printer.Print("inBool = "); _InBool.PrintEx(printer); printer.Println();
        printer.Print("inShort = "); _InShort.PrintEx(printer); printer.Println();
        printer.Print("inInt = "); _InInt.PrintEx(printer); printer.Println();
        printer.Print("inLong = "); _InLong.PrintEx(printer); printer.Println();
        printer.Print("inFloat = "); _InFloat.PrintEx(printer); printer.Println();
        printer.Print("inDouble = "); _InDouble.PrintEx(printer); printer.Println();
        printer.Print("inChar = "); _InChar.PrintEx(printer); printer.Println();
        printer.Print("inString = "); _InString.PrintEx(printer); printer.Println();
        printer.Print("inByteArray = "); _InByteArray.PrintEx(printer); printer.Println();
        printer.Print("inGuid = "); _InGuid.PrintEx(printer); printer.Println();
        printer.Print("inDateTime = "); _InDateTime.PrintEx(printer); printer.Println();
        printer.Print("inUri = "); _InUri.PrintEx(printer); printer.Println();
        printer.Print("inRdId = "); _InRdId.PrintEx(printer); printer.Println();
        printer.Print("outBool = "); _OutBool.PrintEx(printer); printer.Println();
        printer.Print("outShort = "); _OutShort.PrintEx(printer); printer.Println();
        printer.Print("outInt = "); _OutInt.PrintEx(printer); printer.Println();
        printer.Print("outLong = "); _OutLong.PrintEx(printer); printer.Println();
        printer.Print("outFloat = "); _OutFloat.PrintEx(printer); printer.Println();
        printer.Print("outDouble = "); _OutDouble.PrintEx(printer); printer.Println();
        printer.Print("outChar = "); _OutChar.PrintEx(printer); printer.Println();
        printer.Print("outString = "); _OutString.PrintEx(printer); printer.Println();
        printer.Print("outByteArray = "); _OutByteArray.PrintEx(printer); printer.Println();
        printer.Print("outGuid = "); _OutGuid.PrintEx(printer); printer.Println();
        printer.Print("outDateTime = "); _OutDateTime.PrintEx(printer); printer.Println();
        printer.Print("outUri = "); _OutUri.PrintEx(printer); printer.Println();
        printer.Print("outRdId = "); _OutRdId.PrintEx(printer); printer.Println();
        printer.Print("outAll = "); _OutAll.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class RestoreXamarinComponentsCommand : IPrintable, IEquatable<RestoreXamarinComponentsCommand> {
    //fields
    [NotNull] public string SolutionFile {get; private set;}
    [NotNull] public string Login {get; private set;}
    [NotNull] public string Pass {get; private set;}
    public int TimeoutMs {get; private set;}
    
    //primary constructor
    public RestoreXamarinComponentsCommand(
      [NotNull] string solutionFile,
      [NotNull] string login,
      [NotNull] string pass,
      int timeoutMs
    )
    {
      SolutionFile = solutionFile;
      Login = login;
      Pass = pass;
      TimeoutMs = timeoutMs;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<RestoreXamarinComponentsCommand> Read = (ctx, reader) => 
    {
      var solutionFile = reader.ReadString();
      var login = reader.ReadString();
      var pass = reader.ReadString();
      var timeoutMs = reader.ReadInt();
      return new RestoreXamarinComponentsCommand(solutionFile, login, pass, timeoutMs);
    };
    
    public static CtxWriteDelegate<RestoreXamarinComponentsCommand> Write = (ctx, writer, value) => 
    {
      writer.Write(value.SolutionFile);
      writer.Write(value.Login);
      writer.Write(value.Pass);
      writer.Write(value.TimeoutMs);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((RestoreXamarinComponentsCommand) obj);
    }
    public bool Equals(RestoreXamarinComponentsCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return SolutionFile == other.SolutionFile && Login == other.Login && Pass == other.Pass && TimeoutMs == other.TimeoutMs;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + SolutionFile.GetHashCode();
        __r = __r*31 + Login.GetHashCode();
        __r = __r*31 + Pass.GetHashCode();
        __r = __r*31 + TimeoutMs.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("RestoreXamarinComponentsCommand (");
      using (printer.IndentCookie()) {
        printer.Print("solutionFile = "); SolutionFile.PrintEx(printer); printer.Println();
        printer.Print("login = "); Login.PrintEx(printer); printer.Println();
        printer.Print("pass = "); Pass.PrintEx(printer); printer.Println();
        printer.Print("timeoutMs = "); TimeoutMs.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class TestCommand : IPrintable, IEquatable<TestCommand> {
    //fields
    public BackendActivitiesKind Kind {get; private set;}
    [CanBeNull] public string Text {get; private set;}
    [CanBeNull] public int? Number {get; private set;}
    
    //primary constructor
    public TestCommand(
      BackendActivitiesKind kind,
      [CanBeNull] string text,
      [CanBeNull] int? number
    )
    {
      Kind = kind;
      Text = text;
      Number = number;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<TestCommand> Read = (ctx, reader) => 
    {
      var kind = (BackendActivitiesKind)reader.ReadInt();
      var text = ReadStringNullable(ctx, reader);
      var number = ReadIntNullable(ctx, reader);
      return new TestCommand(kind, text, number);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<TestCommand> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteStringNullable(ctx, writer, value.Text);
      WriteIntNullable(ctx, writer, value.Number);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((TestCommand) obj);
    }
    public bool Equals(TestCommand other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(Text, other.Text) && Equals(Number, other.Number);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Kind;
        __r = __r*31 + (Text != null ?Text.GetHashCode() : 0);
        __r = __r*31 + (Number != null ?Number.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("TestCommand (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("text = "); Text.PrintEx(printer); printer.Println();
        printer.Print("number = "); Number.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
}
