using System;
using System.Linq;
using System.Collections.Generic;
using JetBrains.Application;
using JetBrains.Annotations;

using JetBrains.Platform.RdFramework;
using JetBrains.Platform.RdFramework.Base;
using JetBrains.Platform.RdFramework.Impl;
using JetBrains.Platform.RdFramework.Tasks;
using JetBrains.Platform.RdFramework.Util;
using JetBrains.Platform.RdFramework.Text;

using JetBrains.Util;
using JetBrains.Util.PersistentMap;
using Lifetime = JetBrains.DataFlow.Lifetime;

// ReSharper disable RedundantEmptyObjectCreationArgumentList
// ReSharper disable InconsistentNaming
// ReSharper disable RedundantOverflowCheckingContext


namespace JetBrains.Rider.Model.MsBuildLogger
{
  
  
  public class MsBuildExeLoggerModel : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<MsBuildExeBuildModelInitialized> BuildModelInitialized { get { return _BuildModelInitialized; }}
    [NotNull] private readonly RdProperty<MsBuildExeBuildModelInitialized> _BuildModelInitialized;
    
    //primary constructor
    public MsBuildExeLoggerModel(
      [NotNull] RdProperty<MsBuildExeBuildModelInitialized> buildModelInitialized
    )
    {
      _BuildModelInitialized = buildModelInitialized;
    }
    //secondary constructor
    //statics
    
    private void Register(ISerializers serializers)
    {
      serializers.RegisterEnum<MsBuildExeEventKind>();
      serializers.Register(MsBuildExeBuildEvent.Read, MsBuildExeBuildEvent.Write);
      serializers.Register(MsBuildExeBuildOutputMessage.Read, MsBuildExeBuildOutputMessage.Write);
      serializers.Register(MsBuildExeBuildResult.Read, MsBuildExeBuildResult.Write);
      serializers.Register(MsBuildExeBuildModelWithParameters.Read, MsBuildExeBuildModelWithParameters.Write);
      serializers.RegisterEnum<MsBuildExeLogEntryType>();
      serializers.Register(MsBuildExeLogEntry.Read, MsBuildExeLogEntry.Write);
      serializers.Register(MsBuildExeBuildModelInitialized.Read, MsBuildExeBuildModelInitialized.Write);
    }
    
    public MsBuildExeLoggerModel(Lifetime lifetime, IProtocol protocol) : this (
      new RdProperty<MsBuildExeBuildModelInitialized>().Static(1001)
    )
    {
      Register(protocol.Serializers);
      Bind(lifetime, protocol, GetType().Name);
    }
    //init method
    protected override void Init(Lifetime lifetime) {
      _BuildModelInitialized.BindEx(lifetime, this, "buildModelInitialized");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _BuildModelInitialized.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeLoggerModel (");
      using (printer.IndentCookie()) {
        printer.Print("buildModelInitialized = "); _BuildModelInitialized.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildEvent : IPrintable, IEquatable<MsBuildExeBuildEvent> {
    //fields
    public MsBuildExeEventKind Kind {get; private set;}
    [CanBeNull] public string Message {get; private set;}
    [CanBeNull] public string Code {get; private set;}
    [CanBeNull] public string ProjectPath {get; private set;}
    [CanBeNull] public string FilePath {get; private set;}
    [CanBeNull] public int? Line {get; private set;}
    [CanBeNull] public int? Column {get; private set;}
    
    //primary constructor
    public MsBuildExeBuildEvent(
      MsBuildExeEventKind kind,
      [CanBeNull] string message,
      [CanBeNull] string code,
      [CanBeNull] string projectPath,
      [CanBeNull] string filePath,
      [CanBeNull] int? line,
      [CanBeNull] int? column
    )
    {
      Kind = kind;
      Message = message;
      Code = code;
      ProjectPath = projectPath;
      FilePath = filePath;
      Line = line;
      Column = column;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<string> ReadStringNullable = Serializers.ReadString.NullableClass();
    public static CtxReadDelegate<int?> ReadIntNullable = Serializers.ReadInt.NullableStruct();
    public static CtxReadDelegate<MsBuildExeBuildEvent> Read = (ctx, reader) => 
    {
      var kind = (MsBuildExeEventKind)reader.ReadInt();
      var message = ReadStringNullable(ctx, reader);
      var code = ReadStringNullable(ctx, reader);
      var projectPath = ReadStringNullable(ctx, reader);
      var filePath = ReadStringNullable(ctx, reader);
      var line = ReadIntNullable(ctx, reader);
      var column = ReadIntNullable(ctx, reader);
      return new MsBuildExeBuildEvent(kind, message, code, projectPath, filePath, line, column);
    };
    
    public static CtxWriteDelegate<string> WriteStringNullable = Serializers.WriteString.NullableClass();
    public static CtxWriteDelegate<int?> WriteIntNullable = Serializers.WriteInt.NullableStruct();
    public static CtxWriteDelegate<MsBuildExeBuildEvent> Write = (ctx, writer, value) => 
    {
      writer.Write((int)value.Kind);
      WriteStringNullable(ctx, writer, value.Message);
      WriteStringNullable(ctx, writer, value.Code);
      WriteStringNullable(ctx, writer, value.ProjectPath);
      WriteStringNullable(ctx, writer, value.FilePath);
      WriteIntNullable(ctx, writer, value.Line);
      WriteIntNullable(ctx, writer, value.Column);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeBuildEvent) obj);
    }
    public bool Equals(MsBuildExeBuildEvent other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Kind == other.Kind && Equals(Message, other.Message) && Equals(Code, other.Code) && Equals(ProjectPath, other.ProjectPath) && Equals(FilePath, other.FilePath) && Equals(Line, other.Line) && Equals(Column, other.Column);
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + (int) Kind;
        __r = __r*31 + (Message != null ?Message.GetHashCode() : 0);
        __r = __r*31 + (Code != null ?Code.GetHashCode() : 0);
        __r = __r*31 + (ProjectPath != null ?ProjectPath.GetHashCode() : 0);
        __r = __r*31 + (FilePath != null ?FilePath.GetHashCode() : 0);
        __r = __r*31 + (Line != null ?Line.GetHashCode() : 0);
        __r = __r*31 + (Column != null ?Column.GetHashCode() : 0);
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildEvent (");
      using (printer.IndentCookie()) {
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("code = "); Code.PrintEx(printer); printer.Println();
        printer.Print("projectPath = "); ProjectPath.PrintEx(printer); printer.Println();
        printer.Print("filePath = "); FilePath.PrintEx(printer); printer.Println();
        printer.Print("line = "); Line.PrintEx(printer); printer.Println();
        printer.Print("column = "); Column.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildModelInitialized : RdBindableBase {
    //fields
    [NotNull] public IRdProperty<MsBuildExeBuildModelWithParameters> BuildModelWithParameters { get { return _BuildModelWithParameters; }}
    [NotNull] private readonly RdProperty<MsBuildExeBuildModelWithParameters> _BuildModelWithParameters;
    [NotNull] public ISink<MsBuildExeLogEntry> Log { get { return _Log; }}
    [NotNull] private readonly RdSignal<MsBuildExeLogEntry> _Log;
    
    //primary constructor
    private MsBuildExeBuildModelInitialized(
      [NotNull] RdProperty<MsBuildExeBuildModelWithParameters> buildModelWithParameters,
      [NotNull] RdSignal<MsBuildExeLogEntry> log
    )
    {
      _BuildModelWithParameters = buildModelWithParameters;
      _Log = log;
    }
    //secondary constructor
    public MsBuildExeBuildModelInitialized (
    ) : this (
      new RdProperty<MsBuildExeBuildModelWithParameters>(),
      new RdSignal<MsBuildExeLogEntry>()
    ) {}
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildModelInitialized> Read = (ctx, reader) => 
    {
      var buildModelWithParameters = RdProperty<MsBuildExeBuildModelWithParameters>.Read(ctx, reader);
      var log = RdSignal<MsBuildExeLogEntry>.Read(ctx, reader);
      return new MsBuildExeBuildModelInitialized(buildModelWithParameters, log);
    };
    
    public static CtxWriteDelegate<MsBuildExeBuildModelInitialized> Write = (ctx, writer, value) => 
    {
      RdProperty<MsBuildExeBuildModelWithParameters>.Write(ctx, writer, value._BuildModelWithParameters);
      RdSignal<MsBuildExeLogEntry>.Write(ctx, writer, value._Log);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _BuildModelWithParameters.BindEx(lifetime, this, "buildModelWithParameters");
      _Log.BindEx(lifetime, this, "log");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _BuildModelWithParameters.IdentifyEx(ids);
      _Log.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildModelInitialized (");
      using (printer.IndentCookie()) {
        printer.Print("buildModelWithParameters = "); _BuildModelWithParameters.PrintEx(printer); printer.Println();
        printer.Print("log = "); _Log.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildModelWithParameters : RdBindableBase {
    //fields
    public bool IsMsBuild {get; private set;}
    [NotNull] public string SolutionFileName {get; private set;}
    [NotNull] public ISink<MsBuildExeBuildEvent> Events { get { return _Events; }}
    [NotNull] private readonly RdSignal<MsBuildExeBuildEvent> _Events;
    [NotNull] public ISink<MsBuildExeBuildOutputMessage> Output { get { return _Output; }}
    [NotNull] private readonly RdSignal<MsBuildExeBuildOutputMessage> _Output;
    [NotNull] public ISink<MsBuildExeBuildResult> BuildDone { get { return _BuildDone; }}
    [NotNull] private readonly RdSignal<MsBuildExeBuildResult> _BuildDone;
    [NotNull] public ISink<string> ProjectFinished { get { return _ProjectFinished; }}
    [NotNull] private readonly RdSignal<string> _ProjectFinished;
    [NotNull] public ISink<string> ProjectStarted { get { return _ProjectStarted; }}
    [NotNull] private readonly RdSignal<string> _ProjectStarted;
    
    //primary constructor
    private MsBuildExeBuildModelWithParameters(
      bool isMsBuild,
      [NotNull] string solutionFileName,
      [NotNull] RdSignal<MsBuildExeBuildEvent> events,
      [NotNull] RdSignal<MsBuildExeBuildOutputMessage> output,
      [NotNull] RdSignal<MsBuildExeBuildResult> buildDone,
      [NotNull] RdSignal<string> projectFinished,
      [NotNull] RdSignal<string> projectStarted
    )
    {
      IsMsBuild = isMsBuild;
      SolutionFileName = solutionFileName;
      _Events = events;
      _Output = output;
      _BuildDone = buildDone;
      _ProjectFinished = projectFinished;
      _ProjectStarted = projectStarted;
    }
    //secondary constructor
    public MsBuildExeBuildModelWithParameters (
      bool IsMsBuild,
      [NotNull] string SolutionFileName
    ) : this (
      IsMsBuild,
      SolutionFileName,
      new RdSignal<MsBuildExeBuildEvent>(),
      new RdSignal<MsBuildExeBuildOutputMessage>(),
      new RdSignal<MsBuildExeBuildResult>(),
      new RdSignal<string>(),
      new RdSignal<string>()
    ) {}
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildModelWithParameters> Read = (ctx, reader) => 
    {
      var isMsBuild = reader.ReadBool();
      var solutionFileName = reader.ReadString();
      var events = RdSignal<MsBuildExeBuildEvent>.Read(ctx, reader);
      var output = RdSignal<MsBuildExeBuildOutputMessage>.Read(ctx, reader);
      var buildDone = RdSignal<MsBuildExeBuildResult>.Read(ctx, reader);
      var projectFinished = RdSignal<string>.Read(ctx, reader);
      var projectStarted = RdSignal<string>.Read(ctx, reader);
      return new MsBuildExeBuildModelWithParameters(isMsBuild, solutionFileName, events, output, buildDone, projectFinished, projectStarted);
    };
    
    public static CtxWriteDelegate<MsBuildExeBuildModelWithParameters> Write = (ctx, writer, value) => 
    {
      writer.Write(value.IsMsBuild);
      writer.Write(value.SolutionFileName);
      RdSignal<MsBuildExeBuildEvent>.Write(ctx, writer, value._Events);
      RdSignal<MsBuildExeBuildOutputMessage>.Write(ctx, writer, value._Output);
      RdSignal<MsBuildExeBuildResult>.Write(ctx, writer, value._BuildDone);
      RdSignal<string>.Write(ctx, writer, value._ProjectFinished);
      RdSignal<string>.Write(ctx, writer, value._ProjectStarted);
    };
    //init method
    protected override void Init(Lifetime lifetime) {
      _Events.BindEx(lifetime, this, "events");
      _Output.BindEx(lifetime, this, "output");
      _BuildDone.BindEx(lifetime, this, "buildDone");
      _ProjectFinished.BindEx(lifetime, this, "projectFinished");
      _ProjectStarted.BindEx(lifetime, this, "projectStarted");
    }
    //identify method
    public override void Identify(IIdentities ids) {
      _Events.IdentifyEx(ids);
      _Output.IdentifyEx(ids);
      _BuildDone.IdentifyEx(ids);
      _ProjectFinished.IdentifyEx(ids);
      _ProjectStarted.IdentifyEx(ids);
    }
    //equals trait
    //hash code trait
    //pretty print
    public override void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildModelWithParameters (");
      using (printer.IndentCookie()) {
        printer.Print("isMsBuild = "); IsMsBuild.PrintEx(printer); printer.Println();
        printer.Print("solutionFileName = "); SolutionFileName.PrintEx(printer); printer.Println();
        printer.Print("events = "); _Events.PrintEx(printer); printer.Println();
        printer.Print("output = "); _Output.PrintEx(printer); printer.Println();
        printer.Print("buildDone = "); _BuildDone.PrintEx(printer); printer.Println();
        printer.Print("projectFinished = "); _ProjectFinished.PrintEx(printer); printer.Println();
        printer.Print("projectStarted = "); _ProjectStarted.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildOutputMessage : IPrintable, IEquatable<MsBuildExeBuildOutputMessage> {
    //fields
    [NotNull] public string Message {get; private set;}
    public MsBuildExeEventKind Kind {get; private set;}
    public int Indent {get; private set;}
    
    //primary constructor
    public MsBuildExeBuildOutputMessage(
      [NotNull] string message,
      MsBuildExeEventKind kind,
      int indent
    )
    {
      Message = message;
      Kind = kind;
      Indent = indent;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildOutputMessage> Read = (ctx, reader) => 
    {
      var message = reader.ReadString();
      var kind = (MsBuildExeEventKind)reader.ReadInt();
      var indent = reader.ReadInt();
      return new MsBuildExeBuildOutputMessage(message, kind, indent);
    };
    
    public static CtxWriteDelegate<MsBuildExeBuildOutputMessage> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Message);
      writer.Write((int)value.Kind);
      writer.Write(value.Indent);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeBuildOutputMessage) obj);
    }
    public bool Equals(MsBuildExeBuildOutputMessage other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Message == other.Message && Kind == other.Kind && Indent == other.Indent;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Message.GetHashCode();
        __r = __r*31 + (int) Kind;
        __r = __r*31 + Indent.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildOutputMessage (");
      using (printer.IndentCookie()) {
        printer.Print("message = "); Message.PrintEx(printer); printer.Println();
        printer.Print("kind = "); Kind.PrintEx(printer); printer.Println();
        printer.Print("indent = "); Indent.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public class MsBuildExeBuildResult : IPrintable, IEquatable<MsBuildExeBuildResult> {
    //fields
    public bool Success {get; private set;}
    
    //primary constructor
    public MsBuildExeBuildResult(
      bool success
    )
    {
      Success = success;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MsBuildExeBuildResult> Read = (ctx, reader) => 
    {
      var success = reader.ReadBool();
      return new MsBuildExeBuildResult(success);
    };
    
    public static CtxWriteDelegate<MsBuildExeBuildResult> Write = (ctx, writer, value) => 
    {
      writer.Write(value.Success);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeBuildResult) obj);
    }
    public bool Equals(MsBuildExeBuildResult other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return Success == other.Success;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + Success.GetHashCode();
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeBuildResult (");
      using (printer.IndentCookie()) {
        printer.Print("success = "); Success.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MsBuildExeEventKind {
    Error,
    Warning,
    Other
  }
  
  
  public class MsBuildExeLogEntry : IPrintable, IEquatable<MsBuildExeLogEntry> {
    //fields
    [NotNull] public string LogMessage {get; private set;}
    public MsBuildExeLogEntryType Severity {get; private set;}
    
    //primary constructor
    public MsBuildExeLogEntry(
      [NotNull] string logMessage,
      MsBuildExeLogEntryType severity
    )
    {
      LogMessage = logMessage;
      Severity = severity;
    }
    //secondary constructor
    //statics
    
    public static CtxReadDelegate<MsBuildExeLogEntry> Read = (ctx, reader) => 
    {
      var logMessage = reader.ReadString();
      var severity = (MsBuildExeLogEntryType)reader.ReadInt();
      return new MsBuildExeLogEntry(logMessage, severity);
    };
    
    public static CtxWriteDelegate<MsBuildExeLogEntry> Write = (ctx, writer, value) => 
    {
      writer.Write(value.LogMessage);
      writer.Write((int)value.Severity);
    };
    //init method
    //identify method
    //equals trait
    public override bool Equals(object obj)
    {
      if (ReferenceEquals(null, obj)) return false;
      if (ReferenceEquals(this, obj)) return true;
      if (obj.GetType() != GetType()) return false;
      return Equals((MsBuildExeLogEntry) obj);
    }
    public bool Equals(MsBuildExeLogEntry other)
    {
      if (ReferenceEquals(null, other)) return false;
      if (ReferenceEquals(this, other)) return true;
      return LogMessage == other.LogMessage && Severity == other.Severity;
    }
    //hash code trait
    public override int GetHashCode()
    {
      unchecked {
        var __r = 0;
        __r = __r*31 + LogMessage.GetHashCode();
        __r = __r*31 + (int) Severity;
        return __r;
      }
    }
    //pretty print
    public void Print(PrettyPrinter printer)
    {
      printer.Println("MsBuildExeLogEntry (");
      using (printer.IndentCookie()) {
        printer.Print("logMessage = "); LogMessage.PrintEx(printer); printer.Println();
        printer.Print("severity = "); Severity.PrintEx(printer); printer.Println();
      }
      printer.Print(")");
    }
    //toString
    public override string ToString()
    {
      var printer = new SingleLinePrettyPrinter();
      Print(printer);
      return printer.ToString();
    }
  }
  
  
  public enum MsBuildExeLogEntryType {
    ERROR,
    WARN,
    INFO,
    VERBOSE,
    TRACE
  }
}
